/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dx.text;

import com.borland.dx.dataset.Variant;
import com.borland.dx.text.InvalidFormatException;
import com.borland.dx.text.Res;
import com.borland.dx.text.VariantFormatter;
import java.io.Serializable;

public class IntegerFormatter
extends VariantFormatter
implements Serializable {
    protected int type;

    public int getVariantType() {
        return this.type;
    }

    public void parse(Variant variant, char[] cArray, int n2, int n3) throws InvalidFormatException {
        if (cArray == null || n3 == 0 || cArray.length == 0) {
            variant.setUnassignedNull();
            return;
        }
        boolean bl = cArray[n2] == '-';
        int n4 = 0;
        if (bl) {
            ++n2;
            --n3;
        }
        int n5 = n2;
        while (n3 > 0) {
            int n6 = cArray[n5];
            if (n6 >= 48 && n6 <= 57) {
                n6 -= 48;
            } else if ((n6 = Character.digit((char)n6, 10)) < 0) {
                throw new InvalidFormatException(new String(cArray, n2, n3));
            }
            n4 = n4 * 10 + n6;
            ++n5;
            --n3;
        }
        VariantFormatter.setFromInt(variant, this.type, bl ? -n4 : n4);
    }

    public void parse(String string, Variant variant) throws InvalidFormatException {
        if (string == null || (string = string.trim()).length() == 0) {
            variant.setUnassignedNull();
            return;
        }
        try {
            VariantFormatter.setFromInt(variant, this.type, Integer.parseInt(string, 10));
        }
        catch (NumberFormatException numberFormatException) {
            if (!string.equals(numberFormatException.getMessage())) {
                throw new InvalidFormatException(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Res.bundle.getString(9)))).append(": ").append(string).append(": ").append(numberFormatException.getMessage()))));
            }
            throw new InvalidFormatException(string);
        }
    }

    public final String format(Variant variant) {
        return variant == null || variant.isNull() ? "" : new Integer(variant.getAsInt()).toString();
    }

    public IntegerFormatter(int n2) {
        this.type = n2;
    }
}

