/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.AspectPicker;
import com.borland.jbcl.control.BevelPanel;
import com.borland.jbcl.control.ButtonDialog;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.control.ShapeControl;
import com.borland.jbcl.layout.PaneConstraints;
import com.borland.jbcl.layout.PaneLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ColorChooserPanel
extends BevelPanel
implements AdjustmentListener,
KeyListener,
ItemListener,
Serializable {
    public static final String CUSTOM_TAG = Res._CustomColorTag;
    private boolean showColorList = true;
    boolean changing;
    public static final String[][] colorNames = new String[][]{{Res._White, Res._LightGray, Res._Gray, Res._DarkGray, Res._Black, Res._Red, Res._Pink, Res._Orange, Res._Yellow, Res._Green, Res._Magenta, Res._Cyan, Res._Blue, Res._Desktop, Res._ActiveCaption, Res._ActiveCaptionText, Res._ActiveCaptionBorder, Res._InactiveCaption, Res._InactiveCaptionText, Res._InactiveCaptionBorder, Res._Window, Res._WindowBorder, Res._WindowText, Res._Menu, Res._MenuText, Res._Text, Res._TextText, Res._Highlight, Res._HighlightText, Res._InactiveText, Res._Control, Res._ControlText, Res._ControlHighlight, Res._ControlLtHighlight, Res._ControlShadow, Res._ControlDkShadow, Res._Scrollbar, Res._Info, Res._InfoText}, {"Color.white", "Color.lightGray", "Color.gray", "Color.darkGray", "Color.black", "Color.red", "Color.pink", "Color.orange", "Color.yellow", "Color.green", "Color.magenta", "Color.cyan", "Color.blue", "SystemColor.desktop", "SystemColor.activeCaption", "SystemColor.activeCaptionText", "SystemColor.activeCaptionBorder", "SystemColor.inactiveCaption", "SystemColor.inactiveCaptionText", "SystemColor.inactiveCaptionBorder", "SystemColor.window", "SystemColor.windowBorder", "SystemColor.windowText", "SystemColor.menu", "SystemColor.menuText", "SystemColor.text", "SystemColor.textText", "SystemColor.textHighlight", "SystemColor.textHighlightText", "SystemColor.textInactiveText", "SystemColor.control", "SystemColor.controlText", "SystemColor.controlHighlight", "SystemColor.controlLtHighlight", "SystemColor.controlShadow", "SystemColor.controlDkShadow", "SystemColor.scrollbar", "SystemColor.info", "SystemColor.infoText"}};
    static final Color[] colorValues = new Color[]{Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue, SystemColor.desktop, SystemColor.activeCaption, SystemColor.activeCaptionText, SystemColor.activeCaptionBorder, SystemColor.inactiveCaption, SystemColor.inactiveCaptionText, SystemColor.inactiveCaptionBorder, SystemColor.window, SystemColor.windowBorder, SystemColor.windowText, SystemColor.menu, SystemColor.menuText, SystemColor.text, SystemColor.textText, SystemColor.textHighlight, SystemColor.textHighlightText, SystemColor.textInactiveText, SystemColor.control, SystemColor.controlText, SystemColor.controlHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlDkShadow, SystemColor.scrollbar, SystemColor.info, SystemColor.infoText};
    static Hashtable textToValueMap;
    static Hashtable localizedTextToValueMap;
    private Color value;
    private ShapeControl sample = new ShapeControl(1);
    private JRadioButton[] checkbox = new JRadioButton[2];
    private String[] rgbLabels = new String[]{Res._RedLabel, Res._GreenLabel, Res._BlueLabel};
    private String[] hsbLabels = new String[]{Res._Hue, Res._Saturation, Res._Brightness};
    private int[] comp = new int[3];
    private boolean hsbMode = false;
    private boolean changed = false;
    private String[] text = new String[3];
    private JComboBox choice = new JComboBox();
    private AspectPicker[] pickers = new AspectPicker[3];

    public ColorChooserPanel() {
        this(true);
    }

    public ColorChooserPanel(boolean showColorList) {
        this.showColorList = showColorList;
        this.setBevelInner(0);
        this.setMargins(new Insets(0, 5, 5, 5));
        try {
            this.jbInit();
            this.hsbMode = true;
            this.setHsbMode(false);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.value = Color.white;
    }

    public ColorChooserPanel(Color value, boolean showColorList) {
        this(showColorList);
        this.value = value;
    }

    public ColorChooserPanel(Color value) {
        this(true);
        this.value = value;
    }

    ButtonDialog findButtonDialog() {
        Container c2;
        for (c2 = this.getParent(); c2 != null && !(c2 instanceof ButtonDialog); c2 = c2.getParent()) {
        }
        if (c2 instanceof ButtonDialog) {
            return (ButtonDialog)c2;
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        ButtonDialog bd = this.findButtonDialog();
        if (bd != null) {
            bd.setEnterOK(true);
            bd.setEscapeCancel(true);
        }
    }

    void jbInit() throws Exception {
        JPanel choicePan = new JPanel();
        choicePan.setLayout(new GridLayout(2, 0));
        choicePan.add(new JLabel(Res._StandardColors));
        this.fillChoice();
        this.choice.addItemListener(this);
        choicePan.add(this.choice);
        JPanel pickPan = new JPanel();
        pickPan.setLayout(new GridLayout(0, 3));
        for (int i2 = 0; i2 < 3; ++i2) {
            this.pickers[i2] = new AspectPicker();
            this.pickers[i2].text.addKeyListener(this);
            this.pickers[i2].scrollbar.addAdjustmentListener(this);
            pickPan.add(this.pickers[i2]);
        }
        JPanel checkPan = new JPanel();
        ButtonGroup g2 = new ButtonGroup();
        this.checkbox[0] = new JRadioButton("RGB", true);
        checkPan.add(this.checkbox[0]);
        this.checkbox[1] = new JRadioButton("HSB", false);
        checkPan.add(this.checkbox[1]);
        g2.add(this.checkbox[0]);
        g2.add(this.checkbox[1]);
        this.checkbox[0].addItemListener(this);
        this.checkbox[1].addItemListener(this);
        JPanel customPan = new JPanel();
        customPan.setBorder(BorderFactory.createTitledBorder(Res._CustomColorGroupBox));
        customPan.setLayout(new BorderLayout());
        customPan.add((Component)pickPan, "Center");
        customPan.add((Component)checkPan, "South");
        JPanel samplePan = new JPanel();
        samplePan.setLayout(new BorderLayout());
        samplePan.add((Component)new JLabel(Res._Sample), "North");
        samplePan.add((Component)this.sample, "Center");
        PaneConstraints pc = new PaneConstraints();
        pc.position = "Root";
        JPanel split = new JPanel();
        split.setLayout(new PaneLayout());
        split.add((Component)customPan, pc);
        pc.position = "Right";
        pc.proportion = 0.3f;
        split.add((Component)samplePan, pc);
        this.setLayout(new BorderLayout(0, 5));
        if (this.showColorList) {
            this.add((Component)choicePan, "North");
        }
        this.add((Component)split, "Center");
    }

    public Color getColorValue() {
        return this.value;
    }

    public void setColorValue(Color value) {
        this.changeColor(value);
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void colorChanged(Color newColor) {
        this.changed = true;
    }

    protected void changeColor(Color value) {
        this.changeColor(value, false, false);
    }

    protected void changeColor(Color value, boolean suppressText, boolean suppressScroll) {
        String oldText;
        if (value != null && value.equals(this.value)) {
            return;
        }
        this.value = value;
        if (value == null) {
            return;
        }
        if (!this.hsbMode) {
            this.comp[0] = value.getRed();
            this.comp[1] = value.getGreen();
            this.comp[2] = value.getBlue();
        } else {
            float[] hsbComp = Color.RGBtoHSB(value.getRed(), value.getGreen(), value.getBlue(), null);
            this.comp[0] = (int)(hsbComp[0] * 100.0f);
            this.comp[1] = (int)(hsbComp[1] * 100.0f);
            this.comp[2] = (int)(hsbComp[2] * 100.0f);
        }
        this.changing = true;
        for (int i2 = 0; i2 < 3; ++i2) {
            int max;
            if (!suppressText) {
                String t2 = Integer.toString(this.comp[i2]);
                if (this.text[i2] == null || !this.text[i2].equals(t2)) {
                    this.text[i2] = t2;
                    this.pickers[i2].text.setText(t2);
                }
            }
            int n2 = max = this.hsbMode ? 100 : 255;
            if (suppressScroll || this.pickers[i2].scrollbar.getValue() == this.comp[i2]) continue;
            this.pickers[i2].scrollbar.setValues(this.comp[i2], 0, 0, i2 == 0 && this.hsbMode ? max : max + 1);
        }
        String text = ColorChooserPanel.valueToText(value, true);
        if (text != null && this.showColorList && !text.equals(oldText = (String)this.choice.getSelectedItem())) {
            this.choice.setSelectedItem(text);
        }
        if (value != this.sample.getForeground()) {
            this.sample.setForeground(value);
        }
        if (!this.hsbMode) {
            this.pickers[0].sample.setForeground(new Color(255, 255 - this.comp[0], 255 - this.comp[0]));
            this.pickers[1].sample.setForeground(new Color(255 - this.comp[1], 255, 255 - this.comp[1]));
            this.pickers[2].sample.setForeground(new Color(255 - this.comp[2], 255 - this.comp[2], 255));
        }
        this.changing = false;
        this.colorChanged(value);
    }

    public void setHsbMode(boolean hsbMode) {
        if (this.hsbMode != hsbMode) {
            this.changing = true;
            this.hsbMode = hsbMode;
            int max = hsbMode ? 100 : 255;
            for (int i2 = 0; i2 < 3; ++i2) {
                this.pickers[i2].label.setText(hsbMode ? this.hsbLabels[i2] : this.rgbLabels[i2]);
                this.pickers[i2].scrollbar.setValues(this.comp[i2], 0, 0, i2 == 0 && hsbMode ? max : max + 1);
                this.pickers[i2].sample.setVisible(!hsbMode);
            }
            this.changing = false;
            if (this.checkbox[1].isSelected() != hsbMode) {
                this.checkbox[1].setSelected(hsbMode);
            }
            Color newValue = this.value;
            this.value = null;
            this.changeColor(newValue);
        }
    }

    public boolean isHsbMode() {
        return this.hsbMode;
    }

    public void adjustmentValueChanged(AdjustmentEvent event) {
        if (this.changing) {
            return;
        }
        int[] cValue = new int[3];
        int[] max = new int[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            cValue[i2] = this.pickers[i2].scrollbar.getValue();
            max[i2] = this.pickers[i2].scrollbar.getMaximum() - 1;
            if (cValue[i2] < 0) {
                cValue[i2] = 0;
                continue;
            }
            if (cValue[i2] <= max[i2]) continue;
            cValue[i2] = max[i2];
        }
        Color c2 = this.hsbMode ? Color.getHSBColor(Math.min((float)cValue[0] / 100.0f, 0.999999f), (float)cValue[1] / 100.0f, (float)cValue[2] / 100.0f) : new Color(cValue[0], cValue[1], cValue[2]);
        if (!c2.equals(this.value)) {
            this.changeColor(c2, false, false);
        }
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
        try {
            Color c2;
            int[] t2 = new int[3];
            boolean bad = false;
            int max = this.hsbMode ? 100 : 255;
            for (int i2 = 0; i2 < 3; ++i2) {
                t2[i2] = Integer.parseInt(this.pickers[i2].text.getText());
                if (t2[i2] >= 0 && t2[i2] <= max) continue;
                bad = true;
            }
            if (!bad && !(c2 = this.hsbMode ? Color.getHSBColor(Math.min((float)t2[0] / 100.0f, 0.999999f), (float)t2[1] / 100.0f, (float)t2[2] / 100.0f) : new Color(t2[0], t2[1], t2[2])).equals(this.value)) {
                this.changeColor(c2, true, false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void itemStateChanged(ItemEvent e2) {
        if (e2.getStateChange() == 2 || this.changing) {
            return;
        }
        if (e2.getSource() == this.choice) {
            Color c2 = ColorChooserPanel.textToValue((String)this.choice.getSelectedItem(), true);
            if (c2 != null) {
                this.changeColor(c2, false, false);
            }
        } else {
            this.setHsbMode(e2.getItemSelectable() == this.checkbox[1]);
        }
    }

    void fillChoice() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.choice.getModel();
        model.addElement(CUSTOM_TAG);
        for (int i2 = 0; i2 < colorValues.length; ++i2) {
            model.addElement(colorNames[0][i2]);
        }
    }

    public static String valueToText(Color c2, boolean localized) {
        int i2;
        for (i2 = 0; i2 < colorValues.length; ++i2) {
            if (c2 != colorValues[i2]) continue;
            return localized ? colorNames[0][i2] : colorNames[1][i2];
        }
        for (i2 = 0; i2 < colorValues.length; ++i2) {
            if (!c2.equals(colorValues[i2])) continue;
            return localized ? colorNames[0][i2] : colorNames[1][i2];
        }
        return CUSTOM_TAG;
    }

    public static Color textToValue(String text, boolean localized) {
        return localized ? (Color)localizedTextToValueMap.get(text) : (Color)textToValueMap.get(text);
    }

    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        ps.width += 40;
        return ps;
    }

    static {
        int i2 = 0;
        try {
            textToValueMap = new Hashtable();
            localizedTextToValueMap = new Hashtable();
            for (i2 = 0; i2 < colorValues.length; ++i2) {
                if (colorValues[i2] == null) continue;
                localizedTextToValueMap.put(colorNames[0][i2], colorValues[i2]);
                textToValueMap.put(colorNames[1][i2], colorValues[i2]);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.err.println("color values len " + i2 + " " + colorValues[i2] + colorNames[0][i2] + colorNames[1][i2]);
        }
    }
}

