/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.ButtonDialog;
import com.borland.jbcl.control.Res;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooserPanel
extends JPanel
implements ItemListener,
KeyListener,
Serializable,
ListSelectionListener {
    private Font font;
    private boolean changed;
    private JPanel groupBox1 = new JPanel();
    private JList nameList = new JList();
    private JTextField sizeField = new JTextField();
    private JLabel previewField = new JLabel();
    private JPanel previewFiller = new JPanel();
    private JCheckBox boldBox = new JCheckBox();
    private JCheckBox italicBox = new JCheckBox();
    private JPanel jPanel1 = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JScrollPane listPane = new JScrollPane();
    private DefaultListModel nameModel = new DefaultListModel();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();

    public FontChooserPanel() {
        try {
            this.jbInit();
        }
        catch (Exception x2) {
            x2.printStackTrace();
        }
    }

    public FontChooserPanel(Font font) {
        this();
        this.setFontValue(font);
    }

    ButtonDialog findButtonDialog() {
        Container c2;
        for (c2 = this.getParent(); c2 != null && !(c2 instanceof ButtonDialog); c2 = c2.getParent()) {
        }
        if (c2 instanceof ButtonDialog) {
            return (ButtonDialog)c2;
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        ButtonDialog bd = this.findButtonDialog();
        if (bd != null) {
            bd.setEnterOK(true);
            bd.setEscapeCancel(true);
        }
        this.sizeField.requestDefaultFocus();
    }

    private void jbInit() {
        this.nameList.setModel(this.nameModel);
        this.setLayout(this.gridBagLayout2);
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.boldBox.setText(Res._Bold);
        this.boldBox.setMnemonic(Res._BoldMnemonic.charAt(0));
        this.italicBox.setText(Res._Italic);
        this.italicBox.setMnemonic(Res._ItalicMnemonic.charAt(0));
        this.groupBox1.setBorder(BorderFactory.createTitledBorder(Res._Size));
        this.previewField.setText(Res._FontSample);
        this.listPane.getViewport().add(this.nameList);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.add((Component)this.previewFiller, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 80));
        this.add((Component)this.listPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.previewField, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.groupBox1.setLayout(new BorderLayout());
        this.add((Component)this.jPanel1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 6, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.boldBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.italicBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.groupBox1, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.groupBox1.add((Component)this.sizeField, "Center");
        String[] fontList = this.getFontList();
        for (int i2 = 0; i2 < fontList.length; ++i2) {
            this.nameModel.addElement(fontList[i2]);
        }
        this.nameList.addListSelectionListener(this);
        this.boldBox.addItemListener(this);
        this.italicBox.addItemListener(this);
        this.sizeField.addKeyListener(this);
    }

    private String[] getFontList() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    public Font getFontValue() {
        return this.font;
    }

    public void setFontValue(Font font) {
        if (font != null) {
            this.sizeField.setText(Integer.toString(font.getSize()));
            this.changeFont(font);
        } else {
            this.sizeField.setText("12");
            this.nameList.clearSelection();
        }
        this.sizeField.setEnabled(font != null);
        this.boldBox.setEnabled(font != null);
        this.italicBox.setEnabled(font != null);
        this.changed = false;
    }

    public boolean isChanged() {
        return this.changed;
    }

    protected void fontChanged(Font newFont) {
        this.changed = true;
    }

    protected void changeFont(Font font) {
        this.changeFont(font, false, false);
    }

    protected void changeFont(Font font, boolean suppressList, boolean suppressText) {
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        if (font == null) {
            return;
        }
        String[] fontList = this.getFontList();
        if (!suppressList && fontList != null && this.nameList != null) {
            for (int i2 = 0; i2 < fontList.length; ++i2) {
                if (!fontList[i2].equals(font.getName())) continue;
                this.nameList.setSelectedIndex(i2);
                this.nameList.scrollRectToVisible(this.nameList.getCellBounds(i2, i2));
                break;
            }
        }
        if (this.boldBox != null) {
            this.boldBox.setSelected(font.isBold());
        }
        if (this.italicBox != null) {
            this.italicBox.setSelected(font.isItalic());
        }
        this.previewField.setFont(font);
        this.fontChanged(font);
    }

    int getFontSize() {
        try {
            int sz = Integer.parseInt(this.sizeField.getText());
            if (sz > 3000) {
                this.sizeField.setText(String.valueOf(3000));
            }
            return sz < 3000 ? sz : 3000;
        }
        catch (NumberFormatException numberFormatException) {
            return 1;
        }
    }

    public void itemStateChanged(ItemEvent e2) {
        String name = (String)this.nameList.getSelectedValue();
        this.sizeField.setEnabled(true);
        this.boldBox.setEnabled(true);
        this.italicBox.setEnabled(true);
        Font f2 = new Font(name != null ? name : "Dialog", (this.boldBox.isSelected() ? 1 : 0) + (this.italicBox.isSelected() ? 2 : 0), this.getFontSize());
        this.changeFont(f2, e2 != null && e2.getSource() instanceof JList, false);
    }

    public void valueChanged(ListSelectionEvent e2) {
        String name = (String)this.nameList.getSelectedValue();
        this.sizeField.setEnabled(true);
        this.boldBox.setEnabled(true);
        this.italicBox.setEnabled(true);
        Font f2 = new Font(name != null ? name : "Dialog", (this.boldBox.isSelected() ? 1 : 0) + (this.italicBox.isSelected() ? 2 : 0), this.getFontSize());
        this.changeFont(f2, true, false);
    }

    public void keyPressed(KeyEvent e2) {
    }

    public void keyTyped(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
        this.itemStateChanged(null);
    }

    public Dimension getPreferredSize() {
        Dimension d2 = super.getPreferredSize();
        d2.width += 8;
        d2.height += 8;
        return d2;
    }
}

