/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.jb.util.VetoException;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.BasicVectorContainer;
import com.borland.jbcl.model.BasicVectorSelection;
import com.borland.jbcl.model.BasicViewManager;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.SingleVectorSelection;
import com.borland.jbcl.model.VectorDataSetManager;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorSubfocusEvent;
import com.borland.jbcl.model.VectorSubfocusListener;
import com.borland.jbcl.model.WritableVectorModel;
import com.borland.jbcl.util.BlackBox;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.view.FocusableItemPainter;
import com.borland.jbcl.view.ListView;
import com.borland.jbcl.view.SelectableItemPainter;
import com.borland.jbcl.view.TextItemEditor;
import com.borland.jbcl.view.TextItemPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;

public class ListControl
extends ListView
implements NavigationListener,
DataChangeListener,
AccessListener,
VectorSubfocusListener,
VectorModel,
BlackBox,
ColumnAware,
Serializable {
    protected DataSet dataSet;
    protected String columnName;
    protected boolean navigateDataSet = false;
    protected boolean userSetNavigate = true;
    protected boolean dsNavigating = false;
    protected boolean multiSelect = false;
    protected boolean addNotifyCalled = false;
    protected boolean autoInsert = true;
    protected int topIndex = -1;
    protected String textureName;

    public ListControl() {
        this.buildStringList(null);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e2) {
                if (!ListControl.this.isReadOnly() && ListControl.this.getCount() == 0 && ListControl.this.isVariableSize() && ListControl.this.isAutoInsert()) {
                    ListControl.this.addItem(null);
                }
            }
        });
        this.addSubfocusListener(this);
    }

    public void setModel(VectorModel model) {
        if (model == this) {
            throw new IllegalArgumentException(Res._RecursiveModel);
        }
        super.setModel(model);
    }

    public synchronized String[] getItems() {
        VectorModel mod = this.getModel();
        if (mod == null || mod instanceof VectorDataSetManager) {
            return new String[0];
        }
        int count = mod.getCount();
        String[] items = new String[count];
        for (int i2 = 0; i2 < count; ++i2) {
            Object data = mod.get(i2);
            items[i2] = data != null ? data.toString() : "";
        }
        return items;
    }

    public synchronized void setItems(String[] newItems) {
        if (this.getModel() instanceof VectorDataSetManager) {
            throw new IllegalStateException(Res._ItemsAndDataSet);
        }
        this.buildStringList(newItems);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextureName(String path) {
        if (path != null && !path.equals("")) {
            Image i2 = ImageLoader.load(path, (Component)this);
            if (i2 == null) throw new IllegalArgumentException(path);
            ImageLoader.waitForImage(this, i2);
            this.textureName = path;
            this.setTexture(i2);
            return;
        } else {
            this.textureName = null;
            this.setTexture(null);
        }
    }

    public String getTextureName() {
        return this.textureName;
    }

    private void buildStringList(String[] newItems) {
        if (newItems == null) {
            newItems = new String[]{};
        }
        this.navigateDataSet = false;
        super.setModel(new BasicVectorContainer(newItems));
        super.setViewManager(new BasicViewManager(new FocusableItemPainter(new SelectableItemPainter(new TextItemPainter())), new TextItemEditor()));
        this.resetSelection();
        if (this.isShowing() && !this.isBatchMode()) {
            this.doLayout();
        }
        if (this.topIndex > -1) {
            super.setTopIndex(this.topIndex);
            this.topIndex = -1;
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
        if (this.topIndex > -1) {
            super.setTopIndex(this.topIndex);
            this.topIndex = -1;
        }
    }

    public void setTopIndex(int index) {
        if (!this.addNotifyCalled) {
            this.topIndex = index;
        } else {
            super.setTopIndex(index);
        }
    }

    public void accessChange(AccessEvent event) {
        switch (event.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception ex) {
                    event.appendException(ex);
                }
                break;
            }
            case 2: {
                this.safeEndEdit(false);
                this.buildStringList(null);
                break;
            }
        }
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean select) {
        this.multiSelect = select;
        this.resetSelection();
    }

    public void setAutoInsert(boolean auto) {
        this.autoInsert = auto;
    }

    public boolean isAutoInsert() {
        return this.autoInsert;
    }

    private void resetSelection() {
        if (this.multiSelect) {
            int[] selections = this.getSelection().getAll();
            this.setSelection(new BasicVectorSelection());
            this.getSelection().add(selections);
        } else {
            this.setSelection(new SingleVectorSelection());
            this.getSelection().add(this.getSubfocus());
        }
        this.repaint(50L);
    }

    public void setNavigateWithDataSet(boolean navigate) {
        this.userSetNavigate = navigate;
        if (this.userSetNavigate && this.navigateDataSet && this.dataSet != null && this.dataSet.isOpen()) {
            this.setSubfocus(this.dataSet.getRow());
        }
    }

    public boolean isNavigateWithDataSet() {
        return this.userSetNavigate;
    }

    public void subfocusChanging(VectorSubfocusEvent e2) throws VetoException {
        if (this.dataSet != null && this.dataSet.isOpen() && this.userSetNavigate && this.navigateDataSet) {
            if (this.dataSet.getRow() != e2.getLocation()) {
                try {
                    this.dsNavigating = true;
                    if (!this.dataSet.goToRow(e2.getLocation())) {
                        this.dsNavigating = false;
                        throw new VetoException();
                    }
                }
                catch (DataSetException ex) {
                    DataSetModel.handleException(this.dataSet, this, ex);
                    this.dsNavigating = false;
                    throw new VetoException();
                }
            }
            this.dsNavigating = false;
        }
    }

    public void subfocusChanged(VectorSubfocusEvent e2) {
    }

    public void navigated(NavigationEvent e2) {
        if (!this.dsNavigating && this.userSetNavigate && this.navigateDataSet && this.getSubfocus() != this.dataSet.getRow()) {
            this.setSubfocus(this.dataSet.getRow());
        }
    }

    public void dataChanged(DataChangeEvent e2) {
    }

    public void postRow(DataChangeEvent e2) throws Exception {
        this.endEdit();
    }

    public void setItems(DataSet dataSet, String columnName) {
        if (dataSet != null && columnName != null) {
            try {
                DataSetView clonedCursor = dataSet.cloneDataSetView();
                clonedCursor.open();
                clonedCursor.first();
                String[] s2 = new String[clonedCursor.getRowCount()];
                int i2 = 0;
                while (clonedCursor.inBounds()) {
                    s2[i2++] = clonedCursor.getString(columnName);
                    clonedCursor.next();
                }
                this.setItems(s2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet newDataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeDataChangeListener(this);
        }
        this.openDataSet(newDataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.dataSet.addDataChangeListener(this);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String newColumnName) {
        this.columnName = newColumnName;
        if (this.addNotifyCalled) {
            this.openDataSet(this.dataSet);
        }
    }

    private void openDataSet(DataSet newDataSet) {
        this.dataSet = newDataSet;
        if (this.dataSet == null) {
            this.buildStringList(null);
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.dataSet, this, ex);
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.bindDataSet();
        }
    }

    private boolean bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setBatchMode(true);
            VectorDataSetManager cursorManager = new VectorDataSetManager(this.dataSet, column, this);
            super.setModel(cursorManager);
            super.setViewManager(cursorManager);
            this.navigateDataSet = true;
            this.resetSelection();
            this.bindProperties(column);
            if (this.topIndex > -1) {
                super.setTopIndex(this.topIndex);
                this.topIndex = -1;
            }
            if (this.isShowing() && !this.isBatchMode()) {
                this.doLayout();
            }
            this.setBatchMode(false);
            return true;
        }
        this.buildStringList(this.getItems());
        return false;
    }

    private void bindProperties(Column column) {
        Color bg = column.getBackground();
        Color fg = column.getForeground();
        Font f2 = column.getFont();
        int a2 = column.getAlignment();
        if (bg != null) {
            this.setBackground(bg);
        }
        if (fg != null) {
            this.setForeground(fg);
        }
        if (f2 != null) {
            this.setFont(f2);
        }
        if (a2 != 0) {
            this.setAlignment(a2);
        }
    }

    public Object get(int index) {
        return this.getModel().get(index);
    }

    public int find(Object index) {
        return this.getModel().find(index);
    }

    public int getCount() {
        return this.getModel().getCount();
    }

    public boolean canSet(int index, boolean startEdit) {
        WritableVectorModel wm = this.getWriteModel();
        return wm != null && wm.canSet(index, startEdit);
    }

    public void set(int index, Object object) {
        WritableVectorModel wm = this.getWriteModel();
        if (wm != null && wm.canSet(index, true)) {
            wm.set(index, object);
        }
    }

    public void touched(int index) {
        WritableVectorModel wm = this.getWriteModel();
        if (wm != null) {
            wm.touched(index);
        }
    }

    public boolean isVariableSize() {
        WritableVectorModel wm = this.getWriteModel();
        return wm != null && wm.isVariableSize();
    }

    public void addItem(Object object) {
        WritableVectorModel wm = this.getWriteModel();
        if (wm != null && wm.isVariableSize()) {
            wm.addItem(object);
        }
    }

    public void addItem(int aheadOf, Object object) {
        WritableVectorModel wm = this.getWriteModel();
        if (wm != null && wm.isVariableSize() && wm.getCount() >= aheadOf) {
            wm.addItem(aheadOf, object);
        }
    }

    public void remove(int index) {
        super.remove(index);
    }

    public void removeItem(int index) {
        WritableVectorModel wm = this.getWriteModel();
        if (wm != null && wm.isVariableSize() && wm.getCount() > index) {
            wm.remove(index);
        }
    }

    public void removeAll() {
        super.removeAll();
    }

    public void removeAllItems() {
        WritableVectorModel wm = this.getWriteModel();
        if (wm != null && wm.isVariableSize()) {
            wm.removeAll();
        }
    }

    public void enableModelEvents(boolean enable) {
        WritableVectorModel wm = this.getWriteModel();
        if (wm != null && wm.isVariableSize()) {
            wm.enableModelEvents(enable);
        }
    }
}

