/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.model.BasicTreeContainer;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import java.io.Serializable;
import java.util.Vector;

public class TreeItems
implements Serializable {
    private BasicTreeContainer model = new BasicTreeContainer();
    private String[] items;
    private final String CR = "\n";
    private final String TAB = "\t";
    Vector itemArray;
    int depth = 0;

    public TreeItems(String[] items) {
        String text = "";
        if (items != null && items.length > 0) {
            text = items[0];
            for (int i2 = 1; i2 < items.length; ++i2) {
                text = text + "\n" + items[i2];
            }
        }
        this.processItems(text);
    }

    public TreeItems(String text) {
        this.processItems(text);
    }

    public TreeItems(GraphModel model) {
        if (model.getRoot() != null) {
            this.itemArray = new Vector();
            this.processChildren(model.getRoot());
            this.items = new String[this.itemArray.size()];
            for (int i2 = 0; i2 < this.items.length; ++i2) {
                this.items[i2] = this.itemArray.elementAt(i2) != null ? this.itemArray.elementAt(i2).toString() : "";
            }
        }
    }

    public String[] getItems() {
        return this.items;
    }

    public GraphModel getModel() {
        return this.model;
    }

    private void processItems(String text) {
        if (text.length() > 0) {
            GraphLocation lastNode;
            int begin = 0;
            int end = text.indexOf("\n", begin) > 0 ? text.indexOf("\n", begin) : text.length();
            this.model = new BasicTreeContainer(text.substring(begin, end));
            GraphLocation parent = lastNode = this.model.getRoot();
            int lastTabs = 0;
            begin = end + 1;
            int n2 = end = text.indexOf("\n", begin) > 0 ? text.indexOf("\n", begin) : text.length();
            while (end > begin) {
                String thisText = text.substring(begin, end);
                int thisTabs = this.getTabCount(thisText);
                if (thisTabs > lastTabs) {
                    parent = lastNode;
                } else if (thisTabs < lastTabs) {
                    int tabDiff = lastTabs - thisTabs;
                    for (int i2 = 0; i2 < tabDiff; ++i2) {
                        parent = parent.getParent();
                    }
                }
                thisText = thisText.substring(thisTabs);
                lastNode = this.model.addChild(parent, thisText);
                lastTabs = thisTabs;
                begin = end > 0 ? end + 1 : end;
                end = text.indexOf("\n", begin) > 0 ? text.indexOf("\n", begin) : text.length();
            }
        }
    }

    private int getTabCount(String text) {
        char[] chars = text.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (new Character(chars[i2]).equals(new Character("\t".charAt(0)))) continue;
            return i2;
        }
        return 0;
    }

    private void processChildren(GraphLocation node) {
        String tabs = "";
        for (int t2 = 0; t2 < this.depth; ++t2) {
            tabs = tabs + "\t";
        }
        this.itemArray.addElement(tabs + this.model.get(node));
        if (node.hasChildren() != 0) {
            ++this.depth;
            GraphLocation[] children = node.getChildren();
            for (int i2 = 0; i2 < children.length; ++i2) {
                this.processChildren(node.getChildren()[i2]);
            }
            --this.depth;
        }
    }
}

