/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Serializable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class LookAndFeelEditor
implements PropertyEditor,
Serializable {
    protected LookAndFeel lookAndFeel;
    protected UIManager.LookAndFeelInfo[] list = UIManager.getInstalledLookAndFeels();
    protected PropertyChangeSupport propertyChanges = new PropertyChangeSupport(this);

    public LookAndFeelEditor() {
        this.lookAndFeel = UIManager.getLookAndFeel();
    }

    public void setValue(Object value) {
        if (value instanceof LookAndFeel) {
            this.lookAndFeel = (LookAndFeel)value;
        }
    }

    public Object getValue() {
        return this.lookAndFeel;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g2, Rectangle rect) {
    }

    public String getJavaInitializationString() {
        return "new " + this.lookAndFeel.getClass().getName() + "()";
    }

    public String getAsText() {
        return this.lookAndFeel.getName();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        try {
            String className = this.getClassNameFromLAFName(text);
            this.lookAndFeel = (LookAndFeel)Class.forName(className).newInstance();
        }
        catch (Exception x2) {
            throw new IllegalArgumentException(x2.getMessage());
        }
    }

    public String[] getTags() {
        String[] tags = new String[this.list.length];
        for (int i2 = 0; i2 < this.list.length; ++i2) {
            tags[i2] = this.list[i2].getName();
        }
        return tags;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.propertyChanges.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.propertyChanges.removePropertyChangeListener(l2);
    }

    protected String getClassNameFromLAFName(String text) {
        for (int i2 = 0; i2 < this.list.length; ++i2) {
            String name = this.list[i2].getName();
            if (name != text && !(name != null & name.equals(text))) continue;
            return this.list[i2].getClassName();
        }
        return text;
    }
}

