/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.layout;

import com.borland.jbcl.layout.PaneConstraints;
import com.borland.jbcl.layout.PaneNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class PaneLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 200L;
    PaneNode rootNode;
    PaneNode lastSelected;
    private PaneNode lastDeletion;
    int gap = 0;
    private String lastComponentAdded;
    private int addCount = 0;

    public void setGap(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public void setConstraints(Component child, PaneConstraints constraints) {
        this.setComponentConstraints(child, constraints);
        this.lastDeletion = null;
    }

    private boolean setComponentConstraints(Component child, PaneConstraints constraints) {
        if (this.rootNode != null) {
            PaneNode node = this.rootNode.getParentNode(child, null);
            if (node != null) {
                node.setConstraints(child, constraints);
                return true;
            }
            return false;
        }
        this.rootNode = new PaneNode(constraints.name, child, "Root");
        return true;
    }

    public PaneConstraints getConstraints(Component comp) {
        PaneNode node;
        PaneConstraints constraints = null;
        if (this.rootNode != null && (node = this.rootNode.getParentNode(comp, null)) != null) {
            if (node.childComponent == comp) {
                constraints = new PaneConstraints(node.name, node.name, "Root", 0.5f);
            } else {
                float proportion = node.heightDivide * node.widthDivide;
                String splitComponentName = node.childNodeA.getNodeAComponent();
                String name = node.childNodeB.getNodeAComponent();
                if (node.childNodeA.childComponent == comp) {
                    name = node.childNodeB.name;
                }
                constraints = node.horizontal ? (node.reverse ? new PaneConstraints(name, splitComponentName, "Top", 1.0f - proportion) : new PaneConstraints(name, splitComponentName, "Bottom", 1.0f - proportion)) : (node.reverse ? new PaneConstraints(name, splitComponentName, "Left", 1.0f - proportion) : new PaneConstraints(name, splitComponentName, "Right", 1.0f - proportion));
                if (name.equals(splitComponentName)) {
                    constraints.position = "Root";
                }
            }
        }
        return constraints;
    }

    public String toString() {
        return "PaneLayout";
    }

    public void removeLayoutComponent(Component comp) {
        if (comp == null) {
            this.lastDeletion = null;
            return;
        }
        if (this.rootNode != null) {
            if (this.rootNode.childComponent == comp) {
                this.rootNode = null;
            } else {
                PaneNode parent = this.rootNode.getImmediateParent(comp);
                if (parent != null) {
                    this.lastDeletion = parent.removeChild(comp);
                }
            }
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets insets = parent.getInsets();
        if (this.rootNode != null) {
            Dimension d2 = this.rootNode.getPreferredSize(this.gap);
            d2.width += insets.right + insets.left;
            d2.height += insets.top + insets.bottom;
            return d2;
        }
        return new Dimension(10, 10);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        if (this.rootNode != null) {
            Dimension d2 = parent.getSize();
            Insets insets = parent.getInsets();
            Rectangle location = new Rectangle(insets.left, insets.top, d2.width - insets.left - insets.right, d2.height - insets.top - insets.bottom);
            this.rootNode.assertLocation(location, this.gap);
        }
    }

    public String[] getAddOrder(Container parent) {
        Component[] componentArray = parent.getComponents();
        String[] componentNames = new String[componentArray.length];
        Point subscript = new Point(0, 0);
        if (this.rootNode != null) {
            if (this.rootNode.childComponent == null) {
                this.rootNode.getComponents(subscript, componentNames, true);
            } else {
                componentNames[0] = this.rootNode.name;
            }
        }
        return componentNames;
    }

    void addChild(Component c2, float proportion) {
        ++this.addCount;
        String name = "component" + this.addCount;
        if (this.rootNode == null) {
            this.rootNode = new PaneNode(name, c2, "Top");
        } else {
            this.rootNode.addChild(name, c2, "Bottom", proportion);
        }
        this.lastComponentAdded = name;
    }

    public void dragDivider(int x2, int y2) {
        if (this.lastSelected != null) {
            this.lastSelected.drag(x2, y2);
        }
    }

    public Rectangle getDividerBounds() {
        if (this.lastSelected != null) {
            return this.lastSelected.location;
        }
        return null;
    }

    public Rectangle getDividerRect(int x2, int y2) {
        if (this.rootNode != null) {
            this.lastSelected = this.rootNode.hitTest(x2, y2, this.gap * 2);
        }
        if (this.lastSelected != null) {
            return this.lastSelected.getDividerRect(this.gap * 2);
        }
        return null;
    }

    void addChild(String name, String splitComponentName, String position, Component newComponent, float proportion) {
        if (this.rootNode == null) {
            this.rootNode = new PaneNode(name, newComponent, "Top");
        } else {
            boolean foundSplitComponent = true;
            if (splitComponentName == null || splitComponentName.length() == 0) {
                if (position == null) {
                    this.rootNode.addChild(name, newComponent, null, proportion);
                } else {
                    foundSplitComponent = this.rootNode.addChildSplit(name, this.lastComponentAdded, position, newComponent, proportion);
                }
            } else if (!this.rootNode.addChildSplit(name, splitComponentName, position, newComponent, proportion)) {
                foundSplitComponent = this.rootNode.addChildSplit(name, this.lastComponentAdded, position, newComponent, proportion);
            }
            if (!foundSplitComponent) {
                this.rootNode.addChild(name, newComponent, position, proportion);
            }
        }
    }

    public void addLayoutComponent(String name, Component comp) {
        PaneConstraints pc = new PaneConstraints(name, "", "", 0.5f);
        this.addLayoutComponent(comp, pc);
    }

    public void addLayoutComponent(Component newComponent, Object constraints) {
        if (constraints == null && newComponent.getName() != null && newComponent.getName().equals("SplitPanel.splitter")) {
            return;
        }
        if (constraints instanceof PaneConstraints) {
            if (!this.justDeleted(newComponent, (PaneConstraints)constraints)) {
                if (((PaneConstraints)constraints).name == null) {
                    ++this.addCount;
                    String name = "component" + this.addCount;
                }
                if (this.setComponentConstraints(newComponent, (PaneConstraints)constraints)) {
                    this.lastDeletion = null;
                    return;
                }
                PaneConstraints paneConstraints = (PaneConstraints)constraints;
                this.addChild(paneConstraints.name, paneConstraints.splitComponentName, paneConstraints.position, newComponent, paneConstraints.proportion);
                this.lastComponentAdded = paneConstraints.name;
            }
        } else {
            this.addChild(newComponent, 0.5f);
        }
        this.lastDeletion = null;
    }

    public Dimension maximumLayoutSize(Container parm1) {
        return new Dimension(500, 500);
    }

    public float getLayoutAlignmentX(Container parm1) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container parm1) {
        return 0.5f;
    }

    public void invalidateLayout(Container parm1) {
    }

    boolean justDeleted(Component newComponent, PaneConstraints constraints) {
        if (this.lastDeletion == null || constraints == null) {
            return false;
        }
        if (this.lastDeletion.childComponent == newComponent) {
            if (this.lastDeletion.childNodeA == null) {
                PaneNode node = this.lastDeletion.childNodeB;
                if (node == null) {
                    return false;
                }
                if (constraints.splitComponentName != null && constraints.splitComponentName.equals(node.getNodeAComponent()) || !this.lastDeletion.name.equals(constraints.name)) {
                    PaneNode newNode = new PaneNode(node.childNodeA, node.childNodeB, "", 0.5f);
                    newNode.widthDivide = node.widthDivide;
                    newNode.heightDivide = node.heightDivide;
                    newNode.name = node.name;
                    this.lastDeletion.name = constraints.name;
                    newNode.childComponent = node.childComponent;
                    if (newNode.childComponent != null) {
                        newNode.childNodeA = null;
                        newNode.childNodeB = null;
                    }
                    newNode.reverse = node.reverse;
                    newNode.horizontal = node.horizontal;
                    node.childNodeA = newNode;
                    node.childNodeB = this.lastDeletion;
                    node.name = null;
                    node.childComponent = null;
                    node.widthDivide = this.lastDeletion.widthDivide;
                    node.heightDivide = this.lastDeletion.heightDivide;
                    node.reverse = this.lastDeletion.reverse;
                    node.horizontal = this.lastDeletion.horizontal;
                    this.lastDeletion = null;
                    this.setConstraints(newComponent, constraints);
                    return true;
                }
            } else {
                PaneNode node = this.lastDeletion.childNodeA;
                PaneNode newNode = new PaneNode(node.childNodeA, node.childNodeB, "", 0.5f);
                newNode.widthDivide = node.widthDivide;
                newNode.heightDivide = node.heightDivide;
                newNode.name = node.name;
                this.lastDeletion.name = constraints.name;
                newNode.childComponent = node.childComponent;
                if (newNode.childComponent != null) {
                    newNode.childNodeA = null;
                    newNode.childNodeB = null;
                }
                newNode.reverse = node.reverse;
                newNode.horizontal = node.horizontal;
                node.childNodeA = this.lastDeletion;
                node.childNodeB = newNode;
                node.name = null;
                node.childComponent = null;
                node.widthDivide = this.lastDeletion.widthDivide;
                node.heightDivide = this.lastDeletion.heightDivide;
                node.reverse = this.lastDeletion.reverse;
                node.horizontal = this.lastDeletion.horizontal;
                this.lastDeletion = null;
                this.setConstraints(newComponent, constraints);
                return true;
            }
            this.lastDeletion = null;
        }
        return false;
    }
}

