/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorModelListener;
import java.io.Serializable;

public abstract class AbstractVectorModel
implements VectorModel,
Serializable {
    private transient EventMulticaster modelListeners = new EventMulticaster();
    private boolean events = true;

    public int find(Object data) {
        return -1;
    }

    public void touched(int index) {
        this.fireItemTouched(index);
    }

    public boolean canSet(int index, boolean startEdit) {
        return true;
    }

    public boolean isVariableSize() {
        return true;
    }

    public void addModelListener(VectorModelListener listener) {
        this.modelListeners.add(listener);
    }

    public void removeModelListener(VectorModelListener listener) {
        this.modelListeners.remove(listener);
    }

    public void enableModelEvents(boolean enable) {
        if (this.events != enable) {
            this.events = enable;
            if (enable) {
                this.fireStructureChanged();
            }
        }
    }

    protected void fireContentChanged() {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(new VectorModelEvent(this, 1));
        }
    }

    protected void fireStructureChanged() {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(new VectorModelEvent(this, 2));
        }
    }

    protected void fireItemChanged(int index) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(new VectorModelEvent(this, 17, index));
        }
    }

    protected void fireItemTouched(int index) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(new VectorModelEvent(this, 33, index));
        }
    }

    protected void fireItemAdded(int index) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(new VectorModelEvent(this, 18, index));
        }
    }

    protected void fireItemRemoved(int index) {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch(new VectorModelEvent(this, 34, index));
        }
    }
}

