/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import com.borland.jbcl.model.GraphModelListener;
import com.borland.jbcl.model.ModelEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;

public class GraphModelEvent
extends ModelEvent
implements Serializable {
    private static final long serialVersionUID = 200L;
    public static final int CONTENT_CHANGED = 1;
    public static final int STRUCTURE_CHANGED = 2;
    public static final int ITEM_CHANGED = 17;
    public static final int ITEM_TOUCHED = 33;
    public static final int NODE_ADDED = 18;
    public static final int NODE_REMOVED = 34;
    public static final int NODE_REPLACED = 50;
    private transient GraphModel model;
    private transient GraphLocation location;
    private int change;

    public GraphModelEvent(GraphModel model, int change) {
        super(model, change);
        this.model = model;
        this.change = change;
    }

    public GraphModelEvent(GraphModel model, int change, GraphLocation location) {
        this(model, change);
        this.location = location;
    }

    public GraphModel getModel() {
        return this.model;
    }

    public int getChange() {
        return this.change;
    }

    public GraphLocation getLocation() {
        return this.location;
    }

    public void dispatch(EventListener listener) {
        switch (this.getID()) {
            case 1: {
                ((GraphModelListener)listener).modelContentChanged(this);
                break;
            }
            case 2: {
                ((GraphModelListener)listener).modelStructureChanged(this);
                break;
            }
        }
    }

    protected String paramString() {
        String changeString;
        switch (this.change) {
            case 1: {
                changeString = "CONTENT_CHANGED";
                break;
            }
            case 2: {
                changeString = "STRUCTURE_CHANGED";
                break;
            }
            case 17: {
                changeString = "ITEM_CHANGED";
                break;
            }
            case 33: {
                changeString = "ITEM_TOUCHED";
                break;
            }
            case 18: {
                changeString = "NODE_ADDED";
                break;
            }
            case 34: {
                changeString = "NODE_REMOVED";
                break;
            }
            case 50: {
                changeString = "NODE_REPLACED";
                break;
            }
            default: {
                changeString = "<INVALID>";
            }
        }
        return super.paramString() + ",model=" + this.model + ",change=" + changeString + ",location=" + this.location;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Hashtable<String, Object> hash = new Hashtable<String, Object>(2);
        if (this.model instanceof Serializable) {
            hash.put("m", this.model);
        }
        if (this.location instanceof Serializable) {
            hash.put("l", this.location);
        }
        s2.writeObject(hash);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        Hashtable hash = (Hashtable)s2.readObject();
        Object data = hash.get("m");
        if (data instanceof GraphModel) {
            this.model = (GraphModel)data;
        }
        if ((data = hash.get("l")) instanceof GraphLocation) {
            this.location = (GraphLocation)data;
        }
    }
}

