/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelection;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.SelectionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class MatrixSelectionEvent
extends SelectionEvent
implements Serializable {
    private static final long serialVersionUID = 200L;
    private transient MatrixSelection selection;
    private MatrixLocation location;
    private MatrixLocation rangeStart;
    private MatrixLocation rangeEnd;

    public MatrixSelectionEvent(MatrixSelection selection, int change) {
        super(selection, change);
        this.selection = selection;
    }

    public MatrixSelectionEvent(MatrixSelection selection, int change, MatrixLocation location) {
        this(selection, change);
        this.rangeEnd = this.location = location;
        this.rangeStart = this.location;
    }

    public MatrixSelectionEvent(MatrixSelection selection, int change, MatrixLocation rangeStart, MatrixLocation rangeEnd) {
        this(selection, change);
        this.location = this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    public MatrixSelection getSelection() {
        return this.selection;
    }

    public MatrixLocation getLocation() {
        return this.location;
    }

    public MatrixLocation getRangeStart() {
        return this.rangeStart;
    }

    public MatrixLocation getRangeEnd() {
        return this.rangeEnd;
    }

    public void dispatch(EventListener listener) {
        switch (this.getID()) {
            case 4096: {
                ((MatrixSelectionListener)listener).selectionItemChanged(this);
                break;
            }
            case 8192: {
                ((MatrixSelectionListener)listener).selectionRangeChanged(this);
                break;
            }
            case 12288: {
                ((MatrixSelectionListener)listener).selectionChanged(this);
                break;
            }
        }
    }

    protected String paramString() {
        return super.paramString() + ",selection=" + this.selection + ",location=" + this.location + ",rangeStart=" + this.rangeStart + ",rangeEnd=" + this.rangeEnd;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.selection instanceof Serializable ? this.selection : null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        Object data = s2.readObject();
        if (data instanceof MatrixSelection) {
            this.selection = (MatrixSelection)data;
        }
    }
}

