/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.WritableMatrixSelection;
import java.io.Serializable;
import java.util.Vector;

public class MultiRowMatrixSelection
implements WritableMatrixSelection,
Serializable {
    private Vector cellRows = new Vector();
    private int columns;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private boolean events = true;

    public MultiRowMatrixSelection() {
    }

    public MultiRowMatrixSelection(int maxColumns) {
        this.columns = maxColumns;
    }

    public MultiRowMatrixSelection(int maxColumns, int[] rows) {
        this.columns = maxColumns;
        for (int i2 = 0; i2 < rows.length; ++i2) {
            Integer integer = new Integer(rows[i2]);
            if (this.cellRows.contains(integer)) continue;
            this.cellRows.addElement(integer);
        }
    }

    public MultiRowMatrixSelection(int maxColumns, MatrixLocation[] selection) {
        this.columns = maxColumns;
        for (int i2 = 0; i2 < selection.length; ++i2) {
            Integer integer = new Integer(selection[i2].row);
            if (this.cellRows.contains(integer)) continue;
            this.cellRows.addElement(integer);
        }
    }

    public int getMaxColumns() {
        return this.columns;
    }

    public void setMaxColumns(int maxColumns) {
        this.columns = maxColumns;
        this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
    }

    public boolean contains(MatrixLocation location) {
        return this.contains(location.row, location.column);
    }

    public boolean contains(int row, int column) {
        Integer integer = new Integer(row);
        return this.cellRows.contains(integer);
    }

    public int getCount() {
        return this.cellRows.size() * this.columns;
    }

    public MatrixLocation[] getAll() {
        MatrixLocation[] contents = new MatrixLocation[this.cellRows.size() * this.columns];
        int i2 = 0;
        for (int r2 = 0; r2 < this.cellRows.size(); ++r2) {
            for (int c2 = 0; c2 < this.columns; ++c2) {
                contents[i2++] = new MatrixLocation((Integer)this.cellRows.elementAt(r2), c2);
            }
        }
        return contents;
    }

    public void addSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(MatrixSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void set(MatrixLocation[] locations) {
        this.cellRows.removeAllElements();
        this.add(locations);
    }

    public void add(MatrixLocation location) {
        this.add(location.row, location.column);
    }

    public void add(int row, int column) {
        Integer integer = new Integer(row);
        if (!this.cellRows.contains(integer)) {
            this.cellRows.addElement(integer);
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void add(MatrixLocation[] locations) {
        boolean changed = false;
        for (int i2 = 0; i2 < locations.length; ++i2) {
            Integer integer = new Integer(locations[i2].row);
            if (this.cellRows.contains(integer)) continue;
            changed = true;
            this.cellRows.addElement(integer);
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void addRange(MatrixLocation begin, MatrixLocation end) {
        this.addRange(begin.row, begin.column, end.row, end.column);
    }

    public void addRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        int loRow = beginRow < endRow ? beginRow : endRow;
        int hiRow = beginRow > endRow ? beginRow : endRow;
        boolean changed = false;
        for (int r2 = loRow; r2 <= hiRow; ++r2) {
            Integer integer = new Integer(r2);
            if (this.cellRows.contains(integer)) continue;
            changed = true;
            this.cellRows.addElement(integer);
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation location) {
        this.remove(location.row, location.column);
    }

    public void remove(int row, int column) {
        Integer integer = new Integer(row);
        if (this.cellRows.contains(integer)) {
            this.cellRows.removeElement(integer);
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void remove(MatrixLocation[] locations) {
        boolean changed = false;
        for (int i2 = 0; i2 < locations.length; ++i2) {
            Integer integer = new Integer(locations[i2].row);
            if (!this.cellRows.contains(integer)) continue;
            changed = true;
            this.cellRows.removeElement(integer);
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeRange(MatrixLocation begin, MatrixLocation end) {
        this.removeRange(begin.row, begin.column, end.row, end.column);
    }

    public void removeRange(int beginRow, int beginColumn, int endRow, int endColumn) {
        int loRow = beginRow < endRow ? beginRow : endRow;
        int hiRow = beginRow > endRow ? beginRow : endRow;
        boolean changed = false;
        for (int r2 = loRow; r2 <= hiRow; ++r2) {
            Integer integer = new Integer(r2);
            if (!this.cellRows.contains(integer)) continue;
            changed = true;
            this.cellRows.removeElement(integer);
        }
        if (changed) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    public void removeAll() {
        if (this.cellRows.size() > 0) {
            this.cellRows.removeAllElements();
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12289));
        }
    }

    public void enableSelectionEvents(boolean enable) {
        this.events = enable;
        if (this.events) {
            this.processSelectionEvent(new MatrixSelectionEvent(this, 12290));
        }
    }

    protected void processSelectionEvent(MatrixSelectionEvent e2) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch(e2);
        }
    }
}

