/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphViewManager;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.MatrixViewManager;
import com.borland.jbcl.model.SingletonViewManager;
import com.borland.jbcl.model.VectorViewManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class TypedViewManager
implements SingletonViewManager,
VectorViewManager,
MatrixViewManager,
GraphViewManager,
Serializable {
    private static final long serialVersionUID = 200L;
    transient ItemPainter defaultPainter;
    transient ItemEditor defaultEditor;
    transient Hashtable painters = new Hashtable();
    transient Hashtable editors = new Hashtable();

    public boolean add(Class itemClass, ItemPainter painter, ItemEditor editor) {
        if (painter != null) {
            if (itemClass == null) {
                this.defaultPainter = painter;
            } else {
                this.painters.put(itemClass, painter);
            }
        }
        if (editor != null) {
            if (itemClass == null) {
                this.defaultEditor = editor;
            } else {
                this.editors.put(itemClass, editor);
            }
        }
        return true;
    }

    public ItemPainter getPainter(Object data, int state) {
        try {
            ItemPainter painter = (ItemPainter)this.painters.get(data.getClass());
            if (painter != null) {
                return painter;
            }
            Enumeration i2 = this.painters.keys();
            while (i2.hasMoreElements()) {
                Class c2 = (Class)i2.nextElement();
                if (!c2.isInstance(data)) continue;
                return (ItemPainter)this.painters.get(c2);
            }
            return this.defaultPainter;
        }
        catch (Exception e2) {
            System.err.println(e2);
            return null;
        }
    }

    public ItemEditor getEditor(Object data, int state) {
        try {
            ItemEditor editor = (ItemEditor)this.editors.get(data.getClass());
            if (editor != null) {
                return editor;
            }
            Enumeration i2 = this.editors.keys();
            while (i2.hasMoreElements()) {
                Class c2 = (Class)i2.nextElement();
                if (!c2.isInstance(data)) continue;
                return (ItemEditor)this.editors.get(c2);
            }
            return this.defaultEditor;
        }
        catch (Exception e2) {
            System.err.println(e2);
            return null;
        }
    }

    public ItemPainter getPainter(int index, Object data, int state) {
        return this.getPainter(data, state);
    }

    public ItemEditor getEditor(int index, Object data, int state) {
        return this.getEditor(data, state);
    }

    public ItemPainter getPainter(int row, int col, Object data, int state) {
        return this.getPainter(data, state);
    }

    public ItemEditor getEditor(int row, int col, Object data, int state) {
        return this.getEditor(data, state);
    }

    public ItemPainter getPainter(GraphLocation node, Object data, int state) {
        return this.getPainter(data, state);
    }

    public ItemEditor getEditor(GraphLocation node, Object data, int state) {
        return this.getEditor(data, state);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Hashtable<String, Object> hash = new Hashtable<String, Object>(8);
        if (this.defaultPainter instanceof Serializable) {
            hash.put("dp", this.defaultPainter);
        }
        if (this.defaultEditor instanceof Serializable) {
            hash.put("de", this.defaultEditor);
        }
        Enumeration pe = this.painters.keys();
        while (pe.hasMoreElements()) {
            Object key = pe.nextElement();
            if (this.painters.get(key) instanceof Serializable) continue;
            this.painters.remove(key);
        }
        Enumeration ee = this.editors.keys();
        while (ee.hasMoreElements()) {
            Object key = ee.nextElement();
            if (this.editors.get(key) instanceof Serializable) continue;
            this.editors.remove(key);
        }
        s2.writeObject(hash);
        s2.writeObject(this.painters);
        s2.writeObject(this.editors);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        Hashtable hash = (Hashtable)s2.readObject();
        Object data = hash.get("dp");
        if (data instanceof ItemPainter) {
            this.defaultPainter = (ItemPainter)data;
        }
        if ((data = hash.get("de")) instanceof ItemEditor) {
            this.defaultEditor = (ItemEditor)data;
        }
        this.painters = (Hashtable)s2.readObject();
        this.editors = (Hashtable)s2.readObject();
    }
}

