/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.SelectionEvent;
import com.borland.jbcl.model.VectorSelection;
import com.borland.jbcl.model.VectorSelectionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class VectorSelectionEvent
extends SelectionEvent
implements Serializable {
    private static final long serialVersionUID = 200L;
    private transient VectorSelection selection;
    private int location;
    private int rangeStart;
    private int rangeEnd;

    public VectorSelectionEvent(VectorSelection selection, int change) {
        super(selection, change);
        this.selection = selection;
    }

    public VectorSelectionEvent(VectorSelection selection, int change, int location) {
        this(selection, change);
        this.rangeEnd = this.location = location;
        this.rangeStart = this.location;
    }

    public VectorSelectionEvent(VectorSelection selection, int change, int rangeStart, int rangeEnd) {
        this(selection, change);
        this.location = this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    public VectorSelection getSelection() {
        return this.selection;
    }

    public int getLocation() {
        return this.location;
    }

    public int getRangeStart() {
        return this.rangeStart;
    }

    public int getRangeEnd() {
        return this.rangeEnd;
    }

    public void dispatch(EventListener listener) {
        switch (this.getID()) {
            case 4096: {
                ((VectorSelectionListener)listener).selectionItemChanged(this);
                break;
            }
            case 8192: {
                ((VectorSelectionListener)listener).selectionRangeChanged(this);
                break;
            }
            case 12288: {
                ((VectorSelectionListener)listener).selectionChanged(this);
                break;
            }
        }
    }

    protected String paramString() {
        return super.paramString() + ",selection=" + this.selection + ",location=" + this.location + ",rangeStart=" + this.rangeStart + ",rangeEnd=" + this.rangeEnd;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.selection instanceof Serializable ? this.selection : null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        Object data = s2.readObject();
        if (data instanceof VectorSelection) {
            this.selection = (VectorSelection)data;
        }
    }
}

