/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.util;

import com.borland.jbcl.util.ImageLoader;
import java.awt.Component;
import java.awt.Image;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

class ImageCache
implements Serializable {
    private transient Hashtable map = new Hashtable();
    private transient Vector list = new Vector();
    int limit;

    ImageCache() {
        this(10);
    }

    ImageCache(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException();
        }
        this.limit = limit;
    }

    void setLimit(int newLimit) {
        int size;
        if (newLimit <= 0) {
            throw new IllegalArgumentException();
        }
        while ((size = this.list.size()) > newLimit) {
            Object lastKey = this.list.elementAt(size - 1);
            this.list.removeElementAt(size - 1);
            this.map.remove(lastKey);
        }
        this.limit = newLimit;
    }

    int getLimit() {
        return this.limit;
    }

    void put(Object key, Image image, Component component) {
        if (this.limit > 0 && this.list.size() >= this.limit) {
            Object lastKey = this.list.elementAt(this.list.size() - 1);
            this.list.removeElementAt(this.list.size() - 1);
            if (lastKey != null) {
                Image last = (Image)this.map.get(lastKey);
                ImageLoader.waitForImage(component, last);
            }
            this.map.remove(lastKey);
        }
        this.map.put(key, image);
        this.list.insertElementAt(key, 0);
    }

    Image get(Object key) {
        Image image = (Image)this.map.get(key);
        if (image != null) {
            this.list.removeElement(key);
            this.list.insertElementAt(key, 0);
        }
        return image;
    }
}

