/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.util.DottedLine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FocusableItemPainter
implements ItemPainter,
Serializable {
    private static final long serialVersionUID = 200L;
    protected transient ItemPainter painter;
    protected boolean showRollover = true;
    protected Color rollColor = SystemColor.textHighlight;

    public FocusableItemPainter() {
        this.painter = null;
    }

    public FocusableItemPainter(ItemPainter painter) {
        this.painter = painter;
    }

    public FocusableItemPainter(ItemPainter painter, boolean showRollover) {
        this.painter = painter;
        this.showRollover = showRollover;
    }

    public void setPainter(ItemPainter painter) {
        this.painter = painter;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public void setShowRollover(boolean showRollover) {
        this.showRollover = showRollover;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setRolloverColor(Color rollColor) {
        this.rollColor = rollColor;
    }

    public Color getRollColor() {
        return this.rollColor;
    }

    public Dimension getPreferredSize(Object object, Graphics g2, int state, ItemPaintSite site) {
        return this.painter != null ? this.painter.getPreferredSize(object, g2, state, site) : new Dimension(0, 0);
    }

    public void paint(Object object, Graphics g2, Rectangle r2, int state, ItemPaintSite site) {
        Color c2 = g2.getColor();
        if (this.painter != null) {
            this.painter.paint(object, g2, r2, state, site);
        }
        if ((state & 2) != 0) {
            g2.setColor(Color.black);
            g2.setXORMode(Color.white);
            DottedLine.drawRect(g2, r2.x, r2.y, r2.width, r2.height);
            g2.setPaintMode();
        } else if (this.showRollover && (state & 0x40) != 0) {
            g2.setColor(this.rollColor);
            g2.drawRect(r2.x, r2.y, r2.width - 1, r2.height - 1);
        }
        g2.setColor(c2);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.painter instanceof Serializable ? this.painter : null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        Object data = s2.readObject();
        if (data instanceof ItemPainter) {
            this.painter = (ItemPainter)data;
        }
    }
}

