/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.util.SerializableImage;
import com.borland.jbcl.view.ImageItemPainter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class ImageArrayItemPainter
extends ImageItemPainter
implements Serializable {
    private static final long serialVersionUID = 200L;
    protected transient Image[] images;
    protected transient int imageCount;

    public ImageArrayItemPainter() {
        this.images = new Image[0];
    }

    public ImageArrayItemPainter(Image[] images) {
        this.images = images;
        this.imageCount = 0;
        while (this.imageCount < images.length && images[this.imageCount] != null) {
            ++this.imageCount;
        }
    }

    public ImageArrayItemPainter(Component component, int alignment, Image[] images) {
        super(component, alignment);
        this.images = images;
        this.imageCount = 0;
        while (this.imageCount < images.length && images[this.imageCount] != null) {
            ++this.imageCount;
        }
    }

    public int add(Image image) {
        this.assureSpace(this.imageCount + 1);
        this.images[this.imageCount] = image;
        return this.imageCount++;
    }

    public int insert(Image image, int index) {
        if (index < 0 || index > this.imageCount) {
            return -1;
        }
        this.assureSpace(this.imageCount + 1);
        if (index < this.imageCount) {
            System.arraycopy(this.images, index, this.images, index + 1, this.imageCount - index);
        }
        ++this.imageCount;
        this.images[index] = image;
        return index;
    }

    public boolean remove(Image image) {
        return this.remove(this.find(image));
    }

    public boolean remove(int index) {
        if (index < 0 || index >= this.imageCount) {
            return false;
        }
        if (index < this.imageCount - 1) {
            System.arraycopy(this.images, index + 1, this.images, index, this.imageCount - index);
        } else {
            this.images[index] = null;
        }
        --this.imageCount;
        return true;
    }

    public int find(Image image) {
        for (int i2 = 0; i2 < this.imageCount; ++i2) {
            if (image != this.images[i2] && !image.equals(this.images[i2])) continue;
            return i2;
        }
        return -1;
    }

    public Dimension getPreferredSize(Object object, Graphics g2, int state, ItemPaintSite site) {
        return super.getPreferredSize(this.images[((Number)object).intValue()], g2, state, site);
    }

    public void paint(Object object, Graphics g2, Rectangle bounds, int state, ItemPaintSite site) {
        super.paint(this.images[((Number)object).intValue()], g2, bounds, state, site);
    }

    protected void assureSpace(int count) {
        if (count >= this.images.length) {
            Image[] newImages = new Image[Math.max(this.images.length * 2, count + 4)];
            System.arraycopy(this.images, 0, newImages, 0, this.images.length);
            this.images = newImages;
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Vector<SerializableImage> array = new Vector<SerializableImage>();
        for (int i2 = 0; i2 < this.images.length; ++i2) {
            array.addElement(SerializableImage.create(this.images[i2]));
        }
        s2.writeObject(array);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        Vector array = (Vector)s2.readObject();
        this.images = new Image[array.size()];
        for (int i2 = 0; i2 < this.images.length; ++i2) {
            this.images[i2] = ((SerializableImage)array.elementAt(i2)).getImage();
        }
        this.imageCount = this.images.length;
    }
}

