/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.CustomPaintSite;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.BasicVectorSelection;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.NullVectorSelection;
import com.borland.jbcl.model.ToggleItemEditor;
import com.borland.jbcl.model.VectorModel;
import com.borland.jbcl.model.VectorModelEvent;
import com.borland.jbcl.model.VectorModelListener;
import com.borland.jbcl.model.VectorModelMulticaster;
import com.borland.jbcl.model.VectorSelectionEvent;
import com.borland.jbcl.model.VectorSelectionListener;
import com.borland.jbcl.model.VectorSelectionMulticaster;
import com.borland.jbcl.model.VectorSubfocusEvent;
import com.borland.jbcl.model.VectorSubfocusListener;
import com.borland.jbcl.model.VectorViewManager;
import com.borland.jbcl.model.WritableVectorModel;
import com.borland.jbcl.model.WritableVectorSelection;
import com.borland.jbcl.util.ImageTexture;
import com.borland.jbcl.util.KeyMulticaster;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.CustomItemEditor;
import com.borland.jbcl.view.CustomItemListener;
import com.borland.jbcl.view.CustomItemPainter;
import com.borland.jbcl.view.DataToolTip;
import com.borland.jbcl.view.GridCore;
import com.borland.jbcl.view.VectorView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

class ListCore
extends BeanPanel
implements ItemEditSite,
KeyListener,
FocusListener,
VectorModelListener,
VectorSelectionListener,
VectorView,
Serializable {
    private static final long serialVersionUID = 200L;
    boolean doStartEdit = false;
    private boolean lockSubfocus = false;
    private transient VectorModel model;
    private transient WritableVectorModel writeModel;
    private transient VectorViewManager viewManager;
    private transient WritableVectorSelection selection = new NullVectorSelection();
    private transient int[] oldSelected = new int[0];
    private boolean readOnly = false;
    private boolean showFocus = true;
    private boolean hasFocus = false;
    private boolean rangeSelecting = false;
    private boolean dumpingRange = false;
    private boolean postOnEndEdit = true;
    private boolean uniformWidth = false;
    private boolean uniformHeight = true;
    private int itemWidth = 0;
    private int itemHeight = 0;
    private int subfocus = 0;
    private boolean snapOrigin = true;
    private int selectAnchor = -1;
    private int rollover = -1;
    private int mouseDown = -1;
    private transient ItemEditor editor;
    private int editorLocation;
    private Point editClickPoint;
    private transient JScrollPane scroller;
    private Insets itemMargins = new Insets(2, 2, 2, 2);
    private int alignment = 33;
    private boolean editInPlace = true;
    private boolean autoEdit = true;
    private boolean growEditor = true;
    private boolean autoAppend = false;
    private boolean dragSubfocus = true;
    private boolean debugPaint = false;
    private boolean batchMode = false;
    private boolean showRollover = false;
    private DataToolTip toolTip = new DataToolTip(this);
    private transient CustomItemPainter customPainter = new CustomItemPainter();
    private transient CustomItemEditor customEditor = new CustomItemEditor();
    private transient Vector customizeListeners;
    private transient EventMulticaster subfocusListeners = new EventMulticaster();
    private transient KeyMulticaster keyMulticaster = new KeyMulticaster();
    private transient VectorModelMulticaster modelMulticaster = new VectorModelMulticaster();
    private transient VectorSelectionMulticaster selectionMulticaster = new VectorSelectionMulticaster();

    public ListCore(JScrollPane host) {
        this.setLayout(null);
        this.scroller = host;
        super.addKeyListener(this.keyMulticaster);
        this.scroller.getVerticalScrollBar().setUnitIncrement(20);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(10);
        super.setBackground(UIManager.getColor("List.background"));
        super.setForeground(UIManager.getColor("List.foreground"));
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("List.background"));
        this.setForeground(UIManager.getColor("List.foreground"));
    }

    public boolean isPostOnEndEdit() {
        return this.postOnEndEdit;
    }

    public void setPostOnEndEdit(boolean post) {
        this.postOnEndEdit = post;
    }

    public void setAutoEdit(boolean edit) {
        this.autoEdit = edit;
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public void setGrowEditor(boolean growEditor) {
        this.growEditor = growEditor;
    }

    public boolean isGrowEditor() {
        return this.growEditor;
    }

    public void setAutoAppend(boolean autoAppend) {
        this.autoAppend = autoAppend;
    }

    public boolean isAutoAppend() {
        return this.autoAppend;
    }

    public VectorModel getModel() {
        return this.model;
    }

    public WritableVectorModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(VectorModel vm) {
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = vm;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableVectorModel ? (WritableVectorModel)this.model : null;
        this.invalidate();
        this.repaintItems();
        if (this.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public void addModelListener(VectorModelListener l2) {
        this.modelMulticaster.add(l2);
    }

    public void removeModelListener(VectorModelListener l2) {
        this.modelMulticaster.remove(l2);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public void setShowFocus(boolean focus) {
        this.showFocus = focus;
        this.repaintItem(this.subfocus);
    }

    public void setShowRollover(boolean showRollover) {
        this.showRollover = showRollover;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setDataToolTip(boolean dataTip) {
        this.toolTip.active = dataTip;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        if (this.toolTip.active) {
            ttm.registerComponent(this);
        } else if (this.getToolTipText() == null) {
            ttm.unregisterComponent(this);
        }
    }

    public boolean isDataToolTip() {
        return this.toolTip.active;
    }

    public boolean isSnapOrigin() {
        return this.snapOrigin;
    }

    public void setSnapOrigin(boolean snapOrigin) {
        this.snapOrigin = snapOrigin;
    }

    public boolean isEditInPlace() {
        return this.editInPlace;
    }

    public void setEditInPlace(boolean editInPlace) {
        this.editInPlace = editInPlace;
    }

    public boolean isEditing() {
        return this.editor != null;
    }

    public ItemEditor getEditor() {
        return this.editor;
    }

    public void setBatchMode(boolean batchMode) {
        if (this.batchMode != batchMode) {
            this.batchMode = batchMode;
            if (!this.batchMode) {
                this.repaintItems();
                if (this.isShowing()) {
                    this.scroller.validate();
                }
            }
        }
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public void setDragSubfocus(boolean dragSubfocus) {
        this.dragSubfocus = dragSubfocus;
    }

    public boolean isDragSubfocus() {
        return this.dragSubfocus;
    }

    public boolean isUniformWidth() {
        return this.uniformWidth;
    }

    public void setUniformWidth(boolean newUniformWidth) {
        this.uniformWidth = newUniformWidth;
        this.invalidate();
        if (this.scroller.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public int getItemWidth() {
        return this.itemWidth;
    }

    public void setItemWidth(int newWidth) {
        this.uniformWidth = newWidth > 0;
        this.itemWidth = newWidth;
        this.invalidate();
        if (this.scroller.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public boolean isUniformHeight() {
        return this.uniformHeight;
    }

    public void setUniformHeight(boolean newUniformHeight) {
        this.uniformHeight = newUniformHeight;
        this.invalidate();
        if (this.scroller.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeight(int newHeight) {
        this.uniformHeight = newHeight > 0;
        this.itemHeight = newHeight;
        this.invalidate();
        if (this.scroller.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public VectorViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(VectorViewManager vvm) {
        this.viewManager = vvm;
        this.invalidate();
        this.repaintItems();
        if (this.isShowing() && !this.batchMode) {
            this.scroller.validate();
        }
    }

    public WritableVectorSelection getSelection() {
        return this.selection;
    }

    public void setSelection(WritableVectorSelection vs) {
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
            this.selection.removeSelectionListener(this.selectionMulticaster);
        }
        this.selection = vs;
        if (this.selection != null) {
            this.selection.addSelectionListener(this);
            this.selection.addSelectionListener(this.selectionMulticaster);
        }
        this.repaintItems();
    }

    public void addSelectionListener(VectorSelectionListener l2) {
        this.selectionMulticaster.add(l2);
    }

    public void removeSelectionListener(VectorSelectionListener l2) {
        this.selectionMulticaster.remove(l2);
    }

    public Insets getItemMargins() {
        return this.itemMargins;
    }

    public void setItemMargins(Insets margins) {
        this.itemMargins = margins;
        this.invalidate();
        this.repaintItems();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int align) {
        this.alignment = align;
        this.repaintItems();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaintItems();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaintItems();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.invalidate();
        this.repaintItems();
    }

    public int getTopIndex() {
        return this.hitTest(this.scroller.getViewport().getViewPosition().y);
    }

    public void setTopIndex(int index) {
        if (index < 0 || index >= this.getCount()) {
            return;
        }
        Rectangle vRect = this.getVisibleScrollRect();
        Rectangle fRect = this.getItemRect(this.subfocus);
        if (this.uniformHeight) {
            this.checkItemHeight();
            Object data = this.model.get(0);
            ItemPainter painter = this.getPainter(0, data, 0);
            Graphics g2 = this.getSiteGraphics();
            int height = this.itemHeight > 0 ? this.itemHeight : (painter != null ? painter.getPreferredSize((Object)data, (Graphics)g2, (int)0, (ItemPaintSite)this).height : 0);
            int heightAfterIndex = (this.getCount() - index) * height;
            if (vRect.height <= heightAfterIndex) {
                this.scroller.getViewport().setViewPosition(new Point(vRect.x, index * height));
            } else if (vRect.height <= this.getCount() * height) {
                this.scroller.getViewport().setViewPosition(new Point(vRect.x, this.getCount() * height - vRect.height));
            } else {
                this.scroller.getViewport().setViewPosition(new Point(vRect.x, 0));
            }
        }
        this.scroller.getVerticalScrollBar().setUnitIncrement(fRect.height);
    }

    private void scrollView() {
        if (this.scroller.getViewport() == null) {
            return;
        }
        Rectangle vRect = this.getVisibleScrollRect();
        Rectangle fRect = this.getItemRect(this.subfocus);
        if (fRect != null) {
            if (fRect.y < vRect.y) {
                this.scroller.getViewport().setViewPosition(new Point(vRect.x, fRect.y));
            } else if (fRect.y + fRect.height > vRect.y + vRect.height) {
                int y2;
                int h2 = this.getSize().height;
                int n2 = y2 = h2 - vRect.height < fRect.y + fRect.height - vRect.height ? h2 - vRect.height : fRect.y + fRect.height - vRect.height;
                if (this.snapOrigin) {
                    Rectangle oRect;
                    int o2 = this.hitTest(y2);
                    if ((oRect = this.getItemRect(++o2)) != null) {
                        y2 = oRect.y;
                    }
                }
                this.scroller.getViewport().setViewPosition(new Point(vRect.x, y2));
            }
            this.scroller.getVerticalScrollBar().setUnitIncrement(fRect.height);
        }
    }

    public int getSubfocus() {
        return this.subfocus;
    }

    public void setSubfocus(int index) {
        this.setSubfocus(index, 67);
    }

    protected void setSubfocus(int index, int flags) {
        int count = this.getCount();
        if (count <= 0) {
            return;
        }
        if (index < 0) {
            index = 0;
        } else if (index >= count) {
            index = count - 1;
        }
        if (this.editor != null) {
            if (this.lockSubfocus) {
                return;
            }
            this.safeEndEdit();
        }
        if (index >= count || index < 0 || this.subfocus == index || !this.preprocessSubfocusEvent(new VectorSubfocusEvent(this, 1, index))) {
            return;
        }
        if (this.selectAnchor < 0) {
            this.selectAnchor = index;
        }
        int oldFocus = this.subfocus;
        this.subfocus = index;
        if ((flags & 1) != 0) {
            this.selection.removeAll();
        }
        if ((flags & 2) != 0) {
            this.selection.add(this.subfocus);
        }
        if ((flags & 8) != 0) {
            if (this.selection.contains(this.subfocus)) {
                this.selection.remove(this.subfocus);
            } else {
                this.selection.add(this.subfocus);
            }
        }
        if ((flags & 0x10) != 0) {
            this.dumpingRange = true;
            this.selection.removeRange(this.selectAnchor, oldFocus);
            this.selection.addRange(this.selectAnchor, this.subfocus);
        }
        if ((flags & 0x40) != 0) {
            this.selectAnchor = index;
        }
        this.repaintItem(oldFocus);
        this.repaintItem(this.subfocus);
        this.scrollView();
        this.processSubfocusEvent(new VectorSubfocusEvent(this, 2, this.subfocus));
    }

    public void modelContentChanged(VectorModelEvent e2) {
        switch (e2.getChange()) {
            case 1: {
                this.repaintItems();
                break;
            }
            case 17: 
            case 33: {
                if (this.editor != null && this.editorLocation == e2.getLocation()) {
                    this.safeEndEdit(false);
                }
                this.repaintItem(e2.getLocation());
            }
        }
    }

    public void modelStructureChanged(VectorModelEvent e2) {
        if (this.editor != null) {
            this.safeEndEdit(false);
        }
        this.invalidate();
        if (this.getCount() <= this.subfocus) {
            this.setSubfocus(this.getCount() - 1);
        }
        this.repaintItems();
        if (this.isShowing() && !this.batchMode) {
            this.scroller.validate();
            this.scrollView();
        }
    }

    public void selectionItemChanged(VectorSelectionEvent e2) {
        this.repaintItem(e2.getLocation());
        this.oldSelected = e2.getSelection().getAll();
    }

    public void selectionRangeChanged(VectorSelectionEvent e2) {
        for (int i2 = e2.getRangeStart(); i2 < e2.getRangeEnd(); ++i2) {
            this.repaintItem(i2);
        }
        this.oldSelected = e2.getSelection().getAll();
    }

    public void selectionChanged(VectorSelectionEvent e2) {
        int i2;
        int[] sels = e2.getSelection().getAll();
        BasicVectorSelection old = new BasicVectorSelection(this.oldSelected);
        for (i2 = 0; i2 < sels.length; ++i2) {
            if (!old.contains(sels[i2])) {
                this.repaintItem(sels[i2]);
                continue;
            }
            old.remove(sels[i2]);
        }
        this.oldSelected = old.getAll();
        for (i2 = 0; i2 < this.oldSelected.length; ++i2) {
            this.repaintItem(this.oldSelected[i2]);
        }
        this.oldSelected = e2.getSelection().getAll();
    }

    protected void processMousePressed(MouseEvent e2) {
        boolean hadFocus = this.hasFocus;
        this.hasFocus = true;
        super.processMousePressed(e2);
        int index = this.hitTest(e2.getY());
        if (index == -1) {
            return;
        }
        this.rollover = -1;
        this.mouseDown = index;
        boolean shift = e2.isShiftDown();
        boolean control = e2.isControlDown();
        boolean alt = e2.isAltDown();
        boolean right = e2.isMetaDown();
        int flags = shift && control ? 16 : (shift ? 17 : (control ? 72 : 67));
        if (this.selectAnchor < 0) {
            this.selectAnchor = this.subfocus;
        }
        if (this.editor != null) {
            if (this.editorLocation == index) {
                return;
            }
            this.safeEndEdit();
        }
        if (index == this.subfocus) {
            if (!right && e2.getClickCount() == 2) {
                this.fireActionEvent();
            }
            if (!(control || shift || alt)) {
                if (hadFocus && !this.selection.contains(index)) {
                    this.selection.removeAll();
                    this.selection.add(index);
                } else if (!hadFocus) {
                    this.selection.removeAll();
                    this.selection.add(index);
                }
            } else if (control && !shift) {
                if (this.selection.contains(index)) {
                    this.selection.remove(index);
                } else {
                    this.selection.add(index);
                }
            }
            if (hadFocus && !right && !control && !shift && !this.isToggleItem(index) && this.canSet(index, false)) {
                this.doStartEdit = true;
                return;
            }
        }
        this.rangeSelecting = true;
        this.setSubfocus(index, flags);
    }

    protected void processMouseDragged(MouseEvent e2) {
        int index;
        this.rollover = -1;
        if (this.dragSubfocus && !e2.isMetaDown() && this.rangeSelecting && (index = this.hitTest(e2.getY())) != -1) {
            int flags = e2.isControlDown() ? 64 : 16;
            this.setSubfocus(index, flags);
        }
    }

    protected void processMouseReleased(MouseEvent e2) {
        int index;
        int y2 = e2.getY();
        boolean shift = e2.isShiftDown();
        boolean control = e2.isControlDown();
        boolean right = e2.isMetaDown();
        this.rollover = -1;
        this.rangeSelecting = false;
        if (this.editor != null && this.subfocus == this.editorLocation && this.editor.getComponent() != null) {
            this.editor.getComponent().requestFocus();
        }
        if ((index = this.hitTest(y2)) >= 0 && index == this.mouseDown) {
            if (!right && (this.doStartEdit || this.isToggleItem(index))) {
                this.editClickPoint = new Point(e2.getX(), e2.getY());
                this.startEdit(index);
                this.doStartEdit = false;
            } else if (!(right || shift || control || this.selection.getCount() <= 1)) {
                this.selection.removeAll();
                this.selection.add(index);
            }
        }
        this.mouseDown = -1;
    }

    protected Dimension getPreferredItemSize(int index, Object data) {
        int state = this.getState(index);
        ItemPainter painter = this.getPainter(index, data, state);
        Dimension size = new Dimension(0, 0);
        if (painter != null) {
            size = painter.getPreferredSize(data, this.getSiteGraphics(), state, this);
        }
        return size;
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    protected void processMouseMoved(MouseEvent e2) {
        int hit;
        if (this.showRollover && (hit = this.hitTestAbs(e2.getY())) != this.rollover) {
            int oldRollover = this.rollover;
            this.rollover = hit;
            if (oldRollover >= 0) {
                this.repaintItem(oldRollover);
            }
            if (this.rollover >= 0) {
                this.repaintItem(this.rollover);
            }
        }
    }

    public JToolTip createToolTip() {
        return this.toolTip;
    }

    public String getToolTipText(MouseEvent e2) {
        if (this.toolTip.active) {
            Object data;
            int hit = this.hitTestAbs(e2.getY());
            if (hit != -1 && this.model != null && this.viewManager != null && (data = this.model.get(hit)) != null) {
                Rectangle r2 = this.getItemRect(hit);
                Dimension size = this.getPreferredItemSize(hit, data);
                Rectangle vRect = this.getVisibleScrollRect();
                if (!(r2 == null || r2.contains(r2.x + size.width - 1, r2.y + size.height - 1) && vRect.contains(r2.x, r2.y) && vRect.contains(r2.x + size.width - 1, r2.y + size.width - 1))) {
                    int state = this.getState(hit);
                    this.toolTip.data = data;
                    this.toolTip.painter = this.getPainter(hit, data, state);
                    this.toolTip.state = state;
                    return data.toString();
                }
            }
            return null;
        }
        this.toolTip.painter = null;
        return this.getToolTipText();
    }

    public Point getToolTipLocation(MouseEvent e2) {
        Rectangle r2;
        int hit;
        if (this.toolTip.active && this.getToolTipText(e2) != null && (hit = this.hitTestAbs(e2.getY())) != -1 && (r2 = this.getItemRect(hit)) != null && this.model != null) {
            Object data = this.model.get(hit);
            int state = this.getState(hit);
            this.toolTip.data = data;
            this.toolTip.painter = this.getPainter(hit, data, state);
            this.toolTip.state = state;
            return new Point(r2.x - 1, r2.y - 1);
        }
        this.toolTip.painter = null;
        return null;
    }

    protected void processMouseExited(MouseEvent e2) {
        if (this.showRollover) {
            int oldRollover = this.rollover;
            this.rollover = -1;
            this.repaintItem(oldRollover);
        }
    }

    protected void startEdit(int newEditorLocation) {
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.batchMode || !this.canSet(newEditorLocation, true)) {
            return;
        }
        this.rollover = -1;
        this.editorLocation = newEditorLocation;
        this.selection.removeAll();
        this.selection.add(this.editorLocation);
        Object data = this.model.get(this.editorLocation);
        this.editor = this.getEditor(this.editorLocation, data, 0);
        if (this.editor != null) {
            Component editorComponent = this.editor.getComponent();
            if (editorComponent != null) {
                editorComponent.setVisible(false);
                this.add(editorComponent);
            }
            Rectangle r2 = this.getEditorRect();
            this.editor.addKeyListener(this);
            this.editor.addKeyListener(this.keyMulticaster);
            data = this.model.get(this.editorLocation);
            this.editor.startEdit(data, r2, this);
            this.resyncEditor();
            if (this.editor != null && this.editor.getComponent() != null) {
                this.editor.getComponent().addFocusListener(this);
            }
            this.editClickPoint = null;
        }
    }

    protected Rectangle getEditorRect() {
        Component c2;
        Rectangle rect = null;
        if (this.editorLocation >= 0 && this.editor != null && (rect = this.getItemRect(this.editorLocation)) != null && this.growEditor && (c2 = this.editor.getComponent()) != null) {
            Dimension ps = c2.getPreferredSize();
            if (ps.height > rect.height) {
                rect.height = ps.height;
            }
        }
        return rect;
    }

    protected void resyncEditor() {
        if (this.editorLocation >= 0 && this.editor != null) {
            Rectangle er = this.getEditorRect();
            this.editor.changeBounds(er != null ? er : new Rectangle());
        }
    }

    private boolean isToggleItem(int index) {
        int state;
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.batchMode) {
            return false;
        }
        Object data = this.model.get(index);
        ItemEditor ie = this.getEditor(index, data, state = this.getState(index));
        if (ie instanceof ToggleItemEditor) {
            Rectangle rect = this.getItemRect(index);
            return ((ToggleItemEditor)ie).isToggle(data, rect, this) && this.canSet(index, false);
        }
        return false;
    }

    public void endEdit() throws Exception {
        this.endEdit(this.postOnEndEdit);
    }

    public void endEdit(boolean post) throws Exception {
        ItemEditor editor = this.editor;
        this.editor = null;
        if (editor != null) {
            try {
                boolean okToEnd = editor.canPost();
                if (!okToEnd) {
                    this.lockSubfocus = true;
                }
                if (okToEnd || !post) {
                    this.lockSubfocus = false;
                    if (post && okToEnd && this.writeModel.canSet(this.editorLocation, true)) {
                        this.writeModel.set(this.editorLocation, editor.getValue());
                        this.fireActionEvent();
                    }
                    Component editorComponent = editor.getComponent();
                    editor.endEdit(post);
                    editor.removeKeyListener(this);
                    editor.removeKeyListener(this.keyMulticaster);
                    if (editorComponent != null) {
                        this.remove(editorComponent);
                        editorComponent.removeFocusListener(this);
                    }
                    this.repaintItem(this.editorLocation);
                    this.editorLocation = -1;
                    this.editClickPoint = null;
                    editor = null;
                    this.requestFocus();
                } else {
                    this.lockSubfocus = true;
                }
            }
            catch (Exception x2) {
                this.lockSubfocus = true;
                this.editor = editor;
                throw x2;
            }
        }
        this.editor = editor;
    }

    public void safeEndEdit() {
        this.safeEndEdit(this.postOnEndEdit);
    }

    public void safeEndEdit(boolean post) {
        try {
            this.endEdit(post);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doLayout() {
        if (this.editorLocation > -1 && this.editor != null) {
            Rectangle r2 = this.getItemRect(this.editorLocation);
            if (r2 != null) {
                this.editor.changeBounds(new Rectangle(r2.x, r2.y, r2.width, r2.height));
            } else {
                this.editor.changeBounds(new Rectangle(0, 0, 0, 0));
            }
        }
    }

    private void repaintSelection() {
        for (int i2 = 0; i2 < this.oldSelected.length; ++i2) {
            this.repaintItem(this.oldSelected[i2]);
        }
    }

    public void addSubfocusListener(VectorSubfocusListener l2) {
        this.subfocusListeners.add(l2);
    }

    public void removeSubfocusListener(VectorSubfocusListener l2) {
        this.subfocusListeners.remove(l2);
    }

    protected void processSubfocusEvent(VectorSubfocusEvent e2) {
        if (this.subfocusListeners.hasListeners()) {
            this.subfocusListeners.dispatch(e2);
        }
    }

    protected boolean preprocessSubfocusEvent(VectorSubfocusEvent e2) {
        return this.subfocusListeners.hasListeners() ? this.subfocusListeners.vetoableDispatch(e2) : true;
    }

    public void windowActiveChanged(boolean active) {
        super.windowActiveChanged(active);
        this.repaintSelection();
    }

    public void focusGained(FocusEvent e2) {
    }

    public void focusLost(FocusEvent e2) {
        if (this.hasFocus) {
            this.hasFocus = false;
            this.repaintItem(this.subfocus);
        }
    }

    protected void processFocusEvent(FocusEvent e2) {
        super.processFocusEvent(e2);
        switch (e2.getID()) {
            case 1004: {
                if (this.selectAnchor < 0) {
                    this.selectAnchor = this.subfocus;
                }
                if (this.editor != null && this.editor.getComponent() != null) {
                    this.editor.getComponent().requestFocus();
                }
                if (this.hasFocus) break;
                this.hasFocus = true;
                break;
            }
            case 1005: {
                if (this.editor != null) break;
                this.hasFocus = false;
            }
        }
        this.repaintItem(this.subfocus);
    }

    public void keyPressed(KeyEvent e2) {
        boolean alt = e2.isAltDown();
        if (this.editor == null || e2.isConsumed()) {
            return;
        }
        switch (e2.getKeyCode()) {
            case 10: {
                this.safeEndEdit(true);
                if (this.lockSubfocus) break;
                e2.consume();
                this.fireActionEvent();
                break;
            }
            case 27: {
                this.safeEndEdit(false);
                e2.consume();
                break;
            }
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                if (alt) break;
                this.safeEndEdit();
                this.processKeyPressed(e2);
            }
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void keyTyped(KeyEvent e2) {
    }

    protected void processKeyPressed(KeyEvent e2) {
        int key = e2.getKeyCode();
        boolean control = e2.isControlDown();
        boolean shift = e2.isShiftDown();
        boolean alt = e2.isAltDown();
        int flags = shift && control ? 16 : (shift ? 16 : (control ? 64 : 67));
        switch (key) {
            case 40: {
                if (alt) break;
                if ((this.autoAppend || control) && this.subfocus == this.getCount() - 1 && !this.isReadOnly() && this.writeModel.isVariableSize()) {
                    this.writeModel.addItem(null);
                    this.setSubfocus(this.getCount() - 1, 67);
                    e2.consume();
                    break;
                }
                if (this.subfocus == this.getCount() - 1) break;
                this.setSubfocus(this.subfocus + 1, flags);
                e2.consume();
                break;
            }
            case 38: {
                if (alt || this.subfocus <= 0) break;
                this.setSubfocus(this.subfocus - 1, flags);
                e2.consume();
                break;
            }
            case 33: {
                if (alt || this.subfocus <= 0) break;
                this.pageJump(false, flags);
                e2.consume();
                break;
            }
            case 34: {
                if (alt || this.subfocus == this.getCount() - 1) break;
                this.pageJump(true, flags);
                e2.consume();
                break;
            }
            case 36: {
                if (alt || this.subfocus <= 0) break;
                if (control && !shift) {
                    this.setSubfocus(0, 67);
                } else {
                    this.setSubfocus(0, flags);
                }
                e2.consume();
                break;
            }
            case 35: {
                if (alt || this.subfocus == this.getCount() - 1) break;
                if (control && !shift) {
                    this.setSubfocus(this.getCount() - 1, 67);
                } else {
                    this.setSubfocus(this.getCount() - 1, flags);
                }
                e2.consume();
                break;
            }
            case 32: {
                if (alt || shift) break;
                if (control && this.selection.contains(this.subfocus)) {
                    this.selection.remove(this.subfocus);
                } else {
                    this.selection.add(this.subfocus);
                }
                if (this.isToggleItem(this.subfocus)) {
                    this.startEdit(this.subfocus);
                }
                e2.consume();
                break;
            }
            case 155: {
                if (alt || this.isReadOnly() || !this.writeModel.isVariableSize()) break;
                this.writeModel.addItem(this.subfocus, null);
                e2.consume();
                break;
            }
            case 127: {
                if (alt || !control || this.isReadOnly() || !this.writeModel.isVariableSize() || this.getCount() <= 0) break;
                this.writeModel.remove(this.subfocus);
                if (this.subfocus == this.getCount()) {
                    this.setSubfocus(this.getCount() - 1);
                }
                e2.consume();
                break;
            }
            case 10: {
                if (control && this.editor == null && this.canSet(this.subfocus, false)) {
                    this.startEdit(this.subfocus);
                } else {
                    this.fireActionEvent();
                }
                e2.consume();
                break;
            }
            case 113: {
                if (this.editor != null || this.isToggleItem(this.subfocus) || !this.canSet(this.subfocus, false)) break;
                this.startEdit(this.subfocus);
                e2.consume();
                break;
            }
            case 74: {
                if (!shift || !control || !alt) break;
                this.debugPaint = !this.debugPaint;
                break;
            }
            case 25: 
            case 229: {
                this.startEdit(this.subfocus);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void processKeyTyped(KeyEvent e2) {
        char kChar = e2.getKeyChar();
        if (this.editor != null || !this.autoEdit || e2.isConsumed() || this.isReadOnly() || kChar == '\u0000' || kChar == '\t' || kChar == '\r' || kChar == '\n' || kChar == ' ' || kChar == '\u001b' || this.isToggleItem(this.subfocus) || e2.isAltDown() ^ e2.isControlDown() || !this.canSet(this.subfocus, false)) {
            return;
        }
        this.startEdit(this.subfocus);
        Component eComp = null;
        if (this.editor != null && (eComp = this.editor.getComponent()) != null) {
            eComp.dispatchEvent(e2);
        }
    }

    private void pageJump(boolean pageDown, int flags) {
        int avHeight;
        int count = this.getCount();
        if (count == 0) {
            ++count;
        }
        if ((avHeight = this.getSize().height / count) == 0) {
            ++avHeight;
        }
        Rectangle vRect = this.getVisibleScrollRect();
        int jump = vRect.height / avHeight - 1;
        jump = pageDown ? jump : -jump;
        this.setSubfocus(this.subfocus + jump, flags);
    }

    public void repaintItem(int index) {
        if (this.batchMode) {
            return;
        }
        Rectangle dirty = this.getItemRect(index);
        if (dirty != null) {
            this.repaint(dirty.x, dirty.y, dirty.width, dirty.height);
        }
    }

    public void repaintItems() {
        if (this.batchMode) {
            return;
        }
        this.repaint(100L);
    }

    public Point getEditClickPoint() {
        return this.editClickPoint;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public Graphics getSiteGraphics() {
        Graphics g2 = this.getGraphics();
        if (g2 != null) {
            g2.setFont(this.getFont());
        }
        return g2;
    }

    public Component getSiteComponent() {
        return this;
    }

    private int getCount() {
        return this.model != null ? this.model.getCount() : 0;
    }

    private boolean canSet(int index, boolean startingEdit) {
        return !this.isReadOnly() ? this.writeModel.canSet(index, startingEdit) : false;
    }

    public void update(Graphics g2) {
        this.paint(g2);
    }

    private int getState(int index) {
        int state;
        int n2 = state = this.isEnabled() ? 0 : 1;
        if (this.selection.contains(index)) {
            state |= 4;
        }
        if (!this.isEnabled()) {
            state |= 0x21;
        } else {
            if (this.showFocus && (this.focusState & 2) != 0 && this.subfocus == index) {
                state |= 2;
            }
            if ((this.focusState & 0x20) != 0) {
                state |= 0x20;
            }
            if (this.showRollover && this.rollover >= 0 && this.rollover == index) {
                state |= 0x40;
            }
        }
        if (!this.hasFocus) {
            state |= 0x80;
        }
        return state;
    }

    public int hitTest(int yPos) {
        int y2 = 0;
        int count = this.getCount();
        if (this.getCount() < 1) {
            return -1;
        }
        Graphics g2 = this.getSiteGraphics();
        if (this.uniformHeight) {
            int height;
            this.checkItemHeight();
            Object data = this.model.get(0);
            ItemPainter painter = this.getPainter(0, data, 0);
            int n2 = this.itemHeight > 0 ? this.itemHeight : (height = painter != null ? painter.getPreferredSize((Object)data, (Graphics)g2, (int)0, (ItemPaintSite)this).height : 0);
            if (height == 0) {
                return -1;
            }
            int itemIndex = yPos / height;
            if (itemIndex < count) {
                return itemIndex;
            }
            return count - 1;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            Object data = this.model.get(i2);
            ItemPainter painter = this.getPainter(i2, data, 0);
            if ((y2 += painter != null ? painter.getPreferredSize((Object)data, (Graphics)g2, (int)0, (ItemPaintSite)this).height : 0) < yPos) continue;
            return i2;
        }
        if (yPos >= y2) {
            return count - 1;
        }
        return 0;
    }

    public int hitTestAbs(int yPos) {
        int y2 = 0;
        int count = this.getCount();
        if (this.getCount() < 1) {
            return -1;
        }
        Graphics g2 = this.getSiteGraphics();
        if (this.uniformHeight) {
            int height;
            this.checkItemHeight();
            Object data = this.model.get(0);
            ItemPainter painter = this.getPainter(0, data, 0);
            int n2 = this.itemHeight > 0 ? this.itemHeight : (height = painter != null ? painter.getPreferredSize((Object)data, (Graphics)g2, (int)0, (ItemPaintSite)this).height : 0);
            if (height == 0) {
                return -1;
            }
            int itemIndex = yPos / height;
            if (itemIndex < count) {
                return itemIndex;
            }
            return -1;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            Object data = this.model.get(i2);
            ItemPainter painter = this.getPainter(i2, data, 0);
            if ((y2 += painter != null ? painter.getPreferredSize((Object)data, (Graphics)g2, (int)0, (ItemPaintSite)this).height : 0) < yPos) continue;
            return i2;
        }
        return -1;
    }

    public Rectangle getItemRect(int index) {
        if (index >= 0 && index < this.getCount()) {
            int count = this.getCount();
            if (this.scroller.getViewport() == null) {
                return null;
            }
            Rectangle vRect = this.getVisibleScrollRect();
            Rectangle rect = new Rectangle(0, 0, vRect.width, 0);
            Graphics g2 = this.getSiteGraphics();
            if (this.uniformHeight) {
                Dimension size;
                this.checkItemHeight();
                Object data = this.model.get(0);
                ItemPainter painter = this.getPainter(0, data, 0);
                Dimension dimension = size = painter != null ? painter.getPreferredSize(data, g2, 0, this) : new Dimension(0, 0);
                if (this.itemHeight > 0) {
                    rect.y = this.itemHeight * index;
                    rect.height = this.itemHeight;
                } else {
                    rect.y = size.height * index;
                    rect.height = size.height;
                }
                rect.width = this.getSize().width;
                return rect;
            }
            for (int i2 = 0; i2 < count; ++i2) {
                Object data = this.model.get(i2);
                ItemPainter painter = this.getPainter(i2, data, 0);
                Dimension size = painter != null ? painter.getPreferredSize(data, g2, 0, this) : new Dimension(0, 0);
                rect.height = size.height;
                rect.width = this.getSize().width;
                if (i2 == index) {
                    return rect;
                }
                rect.y += size.height;
            }
        }
        return null;
    }

    void checkItemHeight() {
        int state;
        Object data;
        ItemPainter painter;
        if (this.uniformHeight && this.itemHeight < 1 && this.model != null && this.model.getCount() > 0 && (painter = this.getPainter(0, data = this.model.get(0), state = this.getState(0))) != null) {
            Dimension sz = painter.getPreferredSize(data, this.getSiteGraphics(), state, this);
            this.itemHeight = sz.height;
        }
    }

    public void paintComponent(Graphics g2) {
        if (this.batchMode) {
            return;
        }
        super.paintComponent(g2);
        g2.clipRect(0, 0, this.getSize().width, this.getSize().height);
        Rectangle vRect = this.getVisibleScrollRect();
        Rectangle c2 = g2.getClipBounds();
        if (c2 == null) {
            return;
        }
        this.checkItemHeight();
        Rectangle clip = c2.width > vRect.width || c2.height > vRect.height ? c2.intersection(vRect) : c2;
        if (clip.width <= 0 || clip.height <= 0 || vRect.width <= 0 || vRect.height <= 0) {
            return;
        }
        g2.setClip(clip.x, clip.y, clip.width, clip.height);
        int first = this.hitTest(clip.y);
        int last = this.hitTest(clip.y + clip.height);
        Rectangle r2 = this.getItemRect(first);
        if (r2 != null) {
            for (int i2 = first; i2 <= last; ++i2) {
                int state;
                Object data = this.model.get(i2);
                ItemPainter painter = this.getPainter(i2, data, state = this.getState(i2));
                if (painter == null) continue;
                Dimension prefSize = painter.getPreferredSize(data, g2, state, this);
                Rectangle rect = new Rectangle(r2.x, r2.y, r2.width, prefSize.height);
                if (this.uniformHeight && this.itemHeight > 0) {
                    rect.height = this.itemHeight;
                }
                g2.setFont(this.getFont());
                g2.setColor(this.getBackground());
                painter.paint(data, g2, rect, state, this);
                r2.y = r2.y + (this.uniformHeight && this.itemHeight > 0 ? this.itemHeight : prefSize.height);
            }
            if (r2.y < vRect.y + vRect.height) {
                if (this.texture != null) {
                    ImageTexture.texture(this.texture, g2, vRect.x, vRect.y + r2.y, vRect.width, vRect.y + vRect.height - r2.y);
                } else if (this.isOpaque()) {
                    g2.setColor(this.getBackground());
                    g2.fillRect(vRect.x, vRect.y + r2.y, vRect.width, vRect.y + vRect.height - r2.y);
                }
            }
        } else if (this.texture != null) {
            ImageTexture.texture(this.texture, g2, clip.x, clip.y, clip.width, clip.height);
        } else if (this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        if (this.debugPaint) {
            GridCore.debugRect(g2, clip.x, clip.y, clip.width, clip.height);
        }
    }

    public Rectangle getVisibleScrollRect() {
        if (this.scroller.getViewport() == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle vRect = this.scroller.getViewport().getViewRect();
        return vRect;
    }

    protected ItemPainter getPainter(int index, Object data, int state) {
        ItemPainter painter;
        ItemPainter itemPainter = painter = this.viewManager != null ? this.viewManager.getPainter(index, data, state) : null;
        if (painter != null && this.customizeListeners != null) {
            this.customPainter.setPainter(painter);
            this.fireCustomizeItemEvent(new Integer(index), data, state, this.customPainter);
            return this.customPainter;
        }
        return painter;
    }

    protected ItemEditor getEditor(int index, Object data, int state) {
        ItemEditor editor;
        ItemEditor itemEditor = editor = this.viewManager != null ? this.viewManager.getEditor(index, data, state) : null;
        if (editor != null && this.customizeListeners != null) {
            this.customEditor.setEditor(editor);
            this.fireCustomizeItemEvent(new Integer(index), data, state, this.customEditor);
            return this.customEditor;
        }
        return editor;
    }

    public Dimension getPreferredSize() {
        Dimension sz = new Dimension(0, 0);
        int count = this.getCount();
        if (count > 0) {
            Graphics g2 = this.getSiteGraphics();
            if (this.uniformHeight && this.uniformWidth) {
                this.checkItemHeight();
                Object data = this.model.get(0);
                ItemPainter painter = this.getPainter(0, data, 0);
                Dimension size = painter.getPreferredSize(data, g2, 0, this);
                sz.width = this.itemWidth > 0 ? this.itemWidth : size.width;
                sz.height = this.itemHeight > 0 ? this.itemHeight * count : size.height * count;
                this.scroller.getVerticalScrollBar().setUnitIncrement(this.itemHeight > 0 ? this.itemHeight : size.height);
            } else {
                boolean needSize = true;
                for (int i2 = 0; i2 < count; ++i2) {
                    Dimension size;
                    Object data = this.model.get(i2);
                    ItemPainter painter = this.getPainter(i2, data, 0);
                    Dimension dimension = size = painter != null ? painter.getPreferredSize(data, g2, 0, this) : new Dimension(0, 0);
                    if (needSize && size.height > 0) {
                        this.scroller.getVerticalScrollBar().setUnitIncrement(size.height);
                        needSize = false;
                    }
                    if (size.width > sz.width) {
                        sz.width = size.width;
                    }
                    sz.height += size.height;
                }
                if (this.uniformWidth || this.uniformHeight) {
                    Dimension size;
                    Object data = this.model.get(0);
                    ItemPainter painter = this.getPainter(0, data, 0);
                    Dimension dimension = size = painter != null ? painter.getPreferredSize(data, g2, 0, this) : new Dimension(0, 0);
                    if (this.uniformWidth) {
                        int n2 = sz.width = this.itemWidth > 0 ? this.itemWidth : size.width;
                    }
                    if (this.uniformHeight) {
                        int n3 = sz.height = this.itemHeight > 0 ? this.itemHeight * count : size.height * count;
                        if (this.scroller != null && this.scroller.getVerticalScrollBar() != null) {
                            this.scroller.getVerticalScrollBar().setUnitIncrement(this.itemHeight > 0 ? this.itemHeight : size.height);
                        }
                    }
                }
            }
        }
        return sz;
    }

    public void addKeyListener(KeyListener l2) {
        this.keyMulticaster.add(l2);
    }

    public void removeKeyListener(KeyListener l2) {
        this.keyMulticaster.remove(l2);
    }

    public void checkParentWindow() {
        this.findParentWindow();
    }

    private void fireActionEvent() {
        Object item = this.model != null ? this.model.get(this.subfocus) : null;
        String action = item != null ? item.toString() : "";
        this.processActionEvent(new ActionEvent(this.scroller, 1001, action));
    }

    protected void fireCustomizeItemEvent(Object address, Object data, int state, CustomPaintSite cps) {
        if (this.customizeListeners != null) {
            cps.reset();
            for (int i2 = 0; i2 < this.customizeListeners.size(); ++i2) {
                ((CustomItemListener)this.customizeListeners.elementAt(i2)).customizeItem(address, data, state, cps);
            }
        }
    }

    public synchronized void addCustomItemListener(CustomItemListener l2) {
        if (this.customizeListeners == null) {
            this.customizeListeners = new Vector();
        }
        this.customizeListeners.addElement(l2);
    }

    public synchronized void removeCustomItemListener(CustomItemListener l2) {
        if (this.customizeListeners != null) {
            this.customizeListeners.removeElement(l2);
        }
        if (this.customizeListeners.size() == 0) {
            this.customizeListeners = null;
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Hashtable<String, Object> hash = new Hashtable<String, Object>(3);
        if (this.model instanceof Serializable) {
            hash.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hash.put("v", this.viewManager);
        }
        if (this.selection instanceof Serializable) {
            hash.put("s", this.selection);
        }
        s2.writeObject(hash);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        Hashtable hash = (Hashtable)s2.readObject();
        Object data = hash.get("m");
        if (data instanceof VectorModel) {
            this.model = (VectorModel)data;
        }
        if (this.model instanceof WritableVectorModel) {
            this.writeModel = (WritableVectorModel)this.model;
        }
        if ((data = hash.get("v")) instanceof VectorViewManager) {
            this.viewManager = (VectorViewManager)data;
        }
        if ((data = hash.get("s")) instanceof WritableVectorSelection) {
            this.selection = (WritableVectorSelection)data;
        }
    }
}

