/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.LinkedTreeNode;
import com.borland.jbcl.view.TreeCore;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class NodeState
implements Serializable {
    transient GraphLocation node;
    TreeCore core;
    boolean expanded;
    boolean selected;
    int level;
    int lineNumber;
    Rectangle boxRect = new Rectangle();
    Rectangle itemRect = new Rectangle();
    NodeState prevVisible;
    NodeState nextVisible;
    boolean inUse = true;

    NodeState(TreeCore core, GraphLocation node, int level, boolean expanded) {
        this.core = core;
        this.node = node;
        this.level = level;
        this.expanded = node.hasChildren() != 0 ? expanded : false;
        this.boxRect.width = core.getBoxSize().width;
        this.boxRect.height = core.getBoxSize().height;
        this.inUse = true;
    }

    GraphLocation getNextSibling() {
        if (this.node instanceof LinkedTreeNode) {
            return ((LinkedTreeNode)this.node).getNextSibling();
        }
        GraphLocation p2 = this.node.getParent();
        if (p2 != null) {
            GraphLocation[] children = p2.getChildren();
            for (int i2 = 0; i2 < children.length; ++i2) {
                if (children[i2] != this.node || i2 >= children.length - 1) continue;
                return children[i2 + 1];
            }
        }
        return null;
    }

    void update(int level) {
        this.level = level;
        this.inUse = true;
    }

    boolean isDescendentOf(GraphLocation root) {
        for (GraphLocation gl = this.node; gl != null; gl = gl.getParent()) {
            if (gl != root) continue;
            return true;
        }
        return false;
    }

    int hitTest(int x2, int y2) {
        if (this.itemRect.contains(x2, y2)) {
            return 1;
        }
        if (this.boxRect.contains(x2, y2)) {
            if (this.node.hasChildren() != 0) {
                return 2;
            }
            return 0;
        }
        return 0;
    }

    public String toString() {
        if (this.node == null) {
            return "null";
        }
        String prev = this.prevVisible == null ? "null" : this.prevVisible.node.toString();
        String next = this.nextVisible == null ? "null" : this.nextVisible.node.toString();
        return "#" + this.lineNumber + " " + this.itemRect + " " + this.node.toString() + "  prev:" + prev + ", next:" + next + (this.expanded ? " exp" : "") + (this.selected ? " sel" : "");
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeObject(this.node instanceof Serializable ? this.node : null);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        Object data = s2.readObject();
        if (data instanceof GraphLocation) {
            this.node = (GraphLocation)data;
        }
    }
}

