/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.CustomPaintSite;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphModel;
import com.borland.jbcl.model.GraphModelEvent;
import com.borland.jbcl.model.GraphModelListener;
import com.borland.jbcl.model.GraphModelMulticaster;
import com.borland.jbcl.model.GraphSelectionEvent;
import com.borland.jbcl.model.GraphSelectionListener;
import com.borland.jbcl.model.GraphSelectionMulticaster;
import com.borland.jbcl.model.GraphSubfocusEvent;
import com.borland.jbcl.model.GraphSubfocusListener;
import com.borland.jbcl.model.GraphViewManager;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.NullGraphSelection;
import com.borland.jbcl.model.ToggleItemEditor;
import com.borland.jbcl.model.WritableGraphModel;
import com.borland.jbcl.model.WritableGraphSelection;
import com.borland.jbcl.util.DottedLine;
import com.borland.jbcl.util.ImageLoader;
import com.borland.jbcl.util.ImageTexture;
import com.borland.jbcl.util.KeyMulticaster;
import com.borland.jbcl.util.SerializableImage;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.CustomItemEditor;
import com.borland.jbcl.view.CustomItemListener;
import com.borland.jbcl.view.CustomItemPainter;
import com.borland.jbcl.view.DataToolTip;
import com.borland.jbcl.view.GraphView;
import com.borland.jbcl.view.GridCore;
import com.borland.jbcl.view.NodeState;
import com.borland.jbcl.view.TreeEvent;
import com.borland.jbcl.view.TreeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

class TreeCore
extends BeanPanel
implements GraphSelectionListener,
GraphModelListener,
GraphView,
KeyListener,
FocusListener,
ItemEditSite,
Serializable {
    private static final long serialVersionUID = 200L;
    boolean doStartEdit = false;
    private transient GraphModel model;
    private transient WritableGraphModel writeModel;
    private transient GraphViewManager viewManager;
    private transient WritableGraphSelection selection = new NullGraphSelection();
    private transient Image expandedArrow;
    private transient Image contractedArrow;
    private boolean readOnly;
    private NodeState selectAnchor;
    private NodeState subfocus;
    private NodeState rollover;
    private NodeState mouseDown;
    private boolean subfocusChecked = false;
    private transient ItemEditor editor;
    private NodeState editorNode;
    private Point editClickPoint;
    private boolean snapOrigin = true;
    private boolean postOnEndEdit = true;
    private boolean expandByDefault = false;
    private boolean hasFocus = false;
    private boolean showFocus = true;
    private boolean showRoot = true;
    private transient Hashtable cache = new Hashtable();
    private NodeState firstNode;
    private NodeState lastCalc;
    private int style = 1;
    private JScrollPane scroller;
    private int canvasWidth;
    private int canvasHeight;
    private int lineCount;
    private int lastClickPosition;
    private boolean initialized = false;
    private Vector presetExpandList = new Vector();
    private Vector presetCollapseList = new Vector();
    private boolean editInPlace = true;
    private boolean autoEdit = true;
    private boolean growEditor = true;
    private boolean hSnap = false;
    private boolean lockSubfocus = false;
    private boolean dragSubfocus = true;
    private boolean debugPaint = false;
    private boolean batchMode = false;
    private boolean showRollover = false;
    private transient DataToolTip toolTip = new DataToolTip(this);
    private Insets margins = new Insets(2, 2, 2, 2);
    private int leftMargin = 2;
    private int topMargin = 0;
    private int alignment = 33;
    private Dimension boxSize = new Dimension(9, 9);
    private int vgap = 0;
    private int hIndent = 19;
    private int itemOffset = 14;
    private transient CustomItemPainter customPainter = new CustomItemPainter();
    private transient CustomItemEditor customEditor = new CustomItemEditor();
    private transient Vector customizeListeners;
    private boolean customizeEditors = false;
    transient EventMulticaster treeListeners = new EventMulticaster();
    transient EventMulticaster subfocusListeners = new EventMulticaster();
    private transient KeyMulticaster keyMulticaster = new KeyMulticaster();
    private transient GraphModelMulticaster modelMulticaster = new GraphModelMulticaster();
    private transient GraphSelectionMulticaster selectionMulticaster = new GraphSelectionMulticaster();

    public TreeCore(JScrollPane hostScroller) {
        this.scroller = hostScroller;
        this.setFocusAware(true);
        super.addKeyListener(this.keyMulticaster);
        this.scroller.getVerticalScrollBar().setUnitIncrement(20);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(10);
        super.setBackground(UIManager.getColor("Tree.background"));
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor("Tree.background"));
    }

    public void refresh() {
        this.updateViewState();
        Graphics g2 = this.getSiteGraphics();
        if (g2 != null) {
            this.updateNodeRects(this.firstNode, g2);
            this.recalcVisible(true);
        }
        this.repaintNodes();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
        if (style == 2 && this.expandedArrow == null) {
            this.contractedArrow = ImageLoader.loadFromResource("image/contractedArrow.gif", this);
            this.expandedArrow = ImageLoader.loadFromResource("image/expandedArrow.gif", this);
        }
        if (style == 2) {
            this.setBoxSize(new Dimension(12, 12));
        } else {
            this.setBoxSize(new Dimension(9, 9));
        }
        this.repaintNodes();
    }

    public boolean isExpandByDefault() {
        return this.expandByDefault;
    }

    public void setExpandByDefault(boolean expandByDefault) {
        this.expandByDefault = expandByDefault;
    }

    public Insets getItemMargins() {
        return this.margins;
    }

    public void setItemMargins(Insets margins) {
        this.margins = margins;
        this.invalidate();
        this.repaintNodes();
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setLeftMargin(int leftMargin) {
        this.leftMargin = leftMargin;
        this.refresh();
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setTopMargin(int topMargin) {
        this.topMargin = topMargin;
        this.refresh();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaintNodes();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaintNodes();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.refresh();
        if (this.isVisible() && !this.batchMode) {
            this.validate();
        }
    }

    public Dimension getBoxSize() {
        return this.boxSize;
    }

    public void setBoxSize(Dimension boxSize) {
        if (boxSize != null) {
            this.boxSize = boxSize;
            this.repaintNodes();
        }
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
        this.repaintNodes();
    }

    public int getHIndent() {
        return this.hIndent;
    }

    public void setHIndent(int hIndent) {
        this.hIndent = hIndent;
        this.repaintNodes();
    }

    public int getItemOffset() {
        return this.itemOffset;
    }

    public void setItemOffset(int itemOffset) {
        this.itemOffset = itemOffset;
        this.repaintNodes();
    }

    public boolean isSnapOrigin() {
        return this.snapOrigin;
    }

    public void setSnapOrigin(boolean snapOrigin) {
        this.snapOrigin = snapOrigin;
    }

    public void setDragSubfocus(boolean dragSubfocus) {
        this.dragSubfocus = dragSubfocus;
    }

    public boolean isDragSubfocus() {
        return this.dragSubfocus;
    }

    public boolean isHSnap() {
        return this.hSnap;
    }

    public void setHSnap(boolean hSnap) {
        this.hSnap = hSnap;
    }

    public void setShowRollover(boolean showRollover) {
        this.showRollover = showRollover;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setDataToolTip(boolean dataTip) {
        this.toolTip.active = dataTip;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        if (this.toolTip.active) {
            ttm.registerComponent(this);
        } else if (this.getToolTipText() == null) {
            ttm.unregisterComponent(this);
        }
    }

    public boolean isDataToolTip() {
        return this.toolTip.active;
    }

    public boolean isEditInPlace() {
        return this.editInPlace;
    }

    public void setEditInPlace(boolean editInPlace) {
        this.editInPlace = editInPlace;
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public void setAutoEdit(boolean autoEdit) {
        this.autoEdit = autoEdit;
    }

    public void setGrowEditor(boolean growEditor) {
        this.growEditor = growEditor;
    }

    public boolean isGrowEditor() {
        return this.growEditor;
    }

    public boolean isEditing() {
        return this.editor != null;
    }

    public ItemEditor getEditor() {
        return this.editor;
    }

    public void setBatchMode(boolean batchMode) {
        if (this.batchMode != batchMode) {
            this.batchMode = batchMode;
            if (!this.batchMode) {
                this.repaintNodes();
                if (this.isShowing()) {
                    this.scroller.validate();
                }
            }
        }
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public GraphModel getModel() {
        return this.model;
    }

    public WritableGraphModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(GraphModel model) {
        if (model != this.model) {
            if (this.model != null) {
                this.model.removeModelListener(this);
                this.model.removeModelListener(this.modelMulticaster);
            }
            this.model = model;
            if (this.model != null) {
                this.model.addModelListener(this);
                this.model.addModelListener(this.modelMulticaster);
            }
            this.writeModel = model instanceof WritableGraphModel ? (WritableGraphModel)model : null;
            this.cache.clear();
            this.firstNode = null;
            this.subfocus = null;
            this.selectAnchor = null;
            this.updateViewState();
            Graphics g2 = this.getSiteGraphics();
            if (g2 != null) {
                this.updateNodeRects(this.firstNode, g2);
                this.recalcVisible(true);
            }
            if (model != null) {
                this.setSubfocus(model.getRoot());
            }
        }
    }

    public Rectangle getNodeRect(GraphLocation node) {
        NodeState ns = this.getViewState(node);
        if (ns != null) {
            return new Rectangle(ns.itemRect);
        }
        return null;
    }

    public void addModelListener(GraphModelListener l2) {
        this.modelMulticaster.add(l2);
    }

    public void removeModelListener(GraphModelListener l2) {
        this.modelMulticaster.remove(l2);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public boolean isPostOnEndEdit() {
        return this.postOnEndEdit;
    }

    public void setPostOnEndEdit(boolean post) {
        this.postOnEndEdit = post;
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public void setShowFocus(boolean show) {
        this.showFocus = show;
    }

    public boolean isShowRoot() {
        return this.showRoot;
    }

    public void setShowRoot(boolean showRoot) {
        this.showRoot = showRoot;
        this.repaintNodes();
        this.recalcVisible(true);
    }

    public GraphViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(GraphViewManager newManager) {
        this.viewManager = newManager;
        this.repaintNodes();
    }

    public GraphLocation getSubfocus() {
        return this.subfocus != null ? this.subfocus.node : null;
    }

    public void setSubfocus(GraphLocation subfocus) {
        NodeState momnode;
        if (this.editor != null) {
            if (this.lockSubfocus) {
                return;
            }
            this.safeEndEdit();
        }
        if (this.lockSubfocus || this.editor != null) {
            return;
        }
        NodeState sf = this.getViewState(subfocus);
        if (sf == null) {
            return;
        }
        if (!this.preProcessSubfocusEvent(new GraphSubfocusEvent(this, 1, subfocus))) {
            return;
        }
        GraphLocation mom = sf.node.getParent();
        if (mom != null && this.makeExpanded(momnode = this.getViewState(mom))) {
            this.updateNodeRects(momnode, this.getSiteGraphics());
            this.recalcVisible(true);
        }
        this.subfocusChecked = true;
        this.setSubfocus(sf, 67);
    }

    protected void setSubfocus(NodeState nState, int flags) {
        if (nState == null || this.subfocus == nState) {
            return;
        }
        if (this.editor != null) {
            if (this.lockSubfocus) {
                return;
            }
            this.safeEndEdit();
        }
        if (this.lockSubfocus || this.editor != null) {
            return;
        }
        if (this.subfocusChecked) {
            this.subfocusChecked = false;
        } else if (!this.preProcessSubfocusEvent(new GraphSubfocusEvent(this, 1, nState.node))) {
            return;
        }
        if (this.subfocus == null) {
            this.subfocus = nState;
            this.selectAnchor = nState;
            if ((flags & 2) != 0) {
                this.selection.add(this.subfocus.node);
            }
            this.scrollView();
            this.processSubfocusEvent(new GraphSubfocusEvent(this, 2, this.subfocus.node));
            return;
        }
        if (this.selectAnchor == null) {
            this.selectAnchor = nState;
        }
        NodeState oldFocus = this.subfocus;
        this.subfocus = nState;
        boolean eventsOff = false;
        if ((flags & 1) != 0) {
            eventsOff = true;
            this.selection.enableSelectionEvents(false);
            this.selection.removeAll();
        }
        if ((flags & 2) != 0) {
            this.selection.add(this.subfocus.node);
        }
        if ((flags & 8) != 0) {
            if (this.selection.contains(this.subfocus.node)) {
                this.selection.remove(this.subfocus.node);
            } else {
                this.selection.add(this.subfocus.node);
            }
        }
        if ((flags & 0x40) != 0) {
            this.selectAnchor = this.subfocus;
        }
        if (eventsOff) {
            this.selection.enableSelectionEvents(true);
        }
        this.scrollView();
        this.repaintNode(oldFocus);
        this.repaintNode(this.subfocus);
        this.processSubfocusEvent(new GraphSubfocusEvent(this, 2, nState.node));
    }

    private void scrollView() {
        if (this.subfocus == null) {
            return;
        }
        Rectangle vRect = this.scroller.getViewport().getViewRect();
        Rectangle fRect = this.subfocus.itemRect;
        int x2 = vRect.x;
        int y2 = vRect.y;
        if (fRect != null) {
            if (fRect.width > vRect.width || fRect.x < vRect.x) {
                x2 = fRect.x;
            } else if (fRect.x + fRect.width > vRect.x + vRect.width) {
                int n2 = x2 = this.getSize().width - vRect.width < fRect.x + fRect.width - vRect.width ? this.getSize().width - vRect.width : fRect.x + fRect.width - vRect.width;
            }
            if (fRect.y < vRect.y) {
                y2 = fRect.y;
            } else if (fRect.y + fRect.height > vRect.y + vRect.height) {
                NodeState o2;
                int n3 = y2 = this.getSize().height - vRect.height < fRect.y + fRect.height - vRect.height ? this.getSize().height - vRect.height : fRect.y + fRect.height - vRect.height;
                if (this.snapOrigin && (o2 = this.hitTestAbsY(y2)) != null && o2.nextVisible != null) {
                    y2 = o2.nextVisible.itemRect.y;
                }
            }
            if (x2 > 0 && fRect.width < vRect.width) {
                int n4 = x2 = 0 > fRect.x + fRect.width - vRect.width ? 0 : fRect.x + fRect.width - vRect.width;
            }
            if (this.hSnap) {
                if (vRect.x != x2 || vRect.y != y2) {
                    this.scroller.getViewport().setViewPosition(new Point(x2, y2));
                }
            } else if (vRect.y != y2) {
                this.scroller.getViewport().setViewPosition(new Point(vRect.x, y2));
            }
            this.scroller.getHorizontalScrollBar().setUnitIncrement(fRect.width);
            this.scroller.getVerticalScrollBar().setUnitIncrement(fRect.height);
        }
    }

    public GraphLocation hitTest(int xPos, int yPos) {
        NodeState nState = this.hitTestY(yPos);
        if (nState != null && nState.hitTest(xPos, yPos) == 1) {
            return nState.node;
        }
        return null;
    }

    NodeState hitTestXY(int xPos, int yPos) {
        NodeState nState = this.hitTestY(yPos);
        if (nState != null && nState.hitTest(xPos, yPos) == 1) {
            return nState;
        }
        return null;
    }

    NodeState hitTestY(int y2) {
        NodeState nState = this.firstNode;
        while (nState != null && nState.itemRect.y + nState.itemRect.height <= y2) {
            nState = nState.nextVisible;
        }
        if (nState == null) {
            nState = this.lastCalc;
        }
        return nState;
    }

    NodeState hitTestAbsY(int y2) {
        NodeState nState = this.firstNode;
        while (nState != null && nState.itemRect.y + nState.itemRect.height <= y2) {
            nState = nState.nextVisible;
        }
        return nState;
    }

    public void addNotify() {
        super.addNotify();
        Graphics g2 = this.getSiteGraphics();
        if (g2 != null) {
            this.updateViewState();
            this.updateNodeRects(this.firstNode, g2);
            this.recalcVisible(false);
        }
    }

    NodeState hitTestLine(int lineNumber) {
        NodeState nState = this.firstNode;
        while (nState != null && nState.lineNumber < lineNumber) {
            nState = nState.nextVisible;
        }
        return nState;
    }

    void initialize(Graphics g2) {
        if (!this.initialized) {
            NodeState nState;
            this.initialized = true;
            this.updateViewState();
            Enumeration i2 = this.presetExpandList.elements();
            while (i2.hasMoreElements()) {
                nState = this.getViewState((GraphLocation)i2.nextElement());
                if (nState == null) continue;
                this.expandNode(nState, true);
            }
            i2 = this.presetCollapseList.elements();
            while (i2.hasMoreElements()) {
                nState = this.getViewState((GraphLocation)i2.nextElement());
                if (nState == null) continue;
                this.expandNode(nState, false);
            }
            this.updateViewState();
            this.updateNodeRects(this.firstNode, g2);
            this.recalcVisible(false);
        }
    }

    public void paintComponent(Graphics g2) {
        int y2;
        if (this.batchMode) {
            return;
        }
        super.paintComponent(g2);
        g2.clipRect(0, 0, this.getSize().width, this.getSize().height);
        Rectangle vRect = this.scroller.getViewport().getViewRect();
        Rectangle c2 = g2.getClipBounds();
        if (c2 == null) {
            return;
        }
        Rectangle clip = c2.width > vRect.width || c2.height > vRect.height ? c2.intersection(vRect) : c2;
        if (clip.width <= 0 || clip.height <= 0 || vRect.width <= 0 || vRect.height <= 0) {
            return;
        }
        g2.setClip(clip.x, clip.y, clip.width, clip.height);
        NodeState first = this.hitTestY(clip.y);
        NodeState last = this.hitTestY(clip.y + clip.height - 1);
        NodeState nState = first;
        if (first == last) {
            this.paintNode(g2, first);
        } else {
            nState = first;
            while (last != null && nState != last.nextVisible) {
                this.paintNode(g2, nState);
                if (nState.nextVisible == null) break;
                nState = nState.nextVisible;
            }
        }
        if (this.style == 1) {
            nState = first;
            while (nState != null) {
                NodeState next = this.getViewState(nState.getNextSibling());
                if (next != null) {
                    this.paintLink(g2, next);
                }
                if (nState.nextVisible == null) break;
                nState = nState.nextVisible;
            }
        }
        int n2 = y2 = nState != null ? nState.itemRect.y + nState.itemRect.height : 0;
        if (y2 < vRect.y + vRect.height) {
            if (this.texture != null) {
                ImageTexture.texture(this.texture, g2, vRect.x, y2, vRect.width, vRect.height - y2);
            } else if (this.isOpaque()) {
                g2.setColor(this.getBackground());
                g2.fillRect(vRect.x, y2, vRect.width, vRect.height - y2);
            }
        }
        if (this.debugPaint) {
            GridCore.debugRect(g2, clip.x, clip.y, clip.width, clip.height);
        }
    }

    protected void paintNode(Graphics g2, NodeState nState) {
        if (g2 != null && nState != null) {
            Dimension vp = this.scroller.getViewport().getExtentSize();
            if (this.texture != null) {
                ImageTexture.texture(this.texture, g2, 0, nState.itemRect.y, vp.width, nState.itemRect.height + this.vgap);
            } else if (this.isOpaque()) {
                g2.setColor(this.getBackground());
                g2.fillRect(0, nState.itemRect.y, vp.width, nState.itemRect.height + this.vgap);
            }
            if (this.style == 1) {
                this.paintBox(g2, nState);
                this.paintItem(g2, nState);
                this.paintLink(g2, nState);
                this.paintVLines(g2, nState);
            } else if (this.style == 2) {
                this.paintArrow(g2, nState);
                this.paintItem(g2, nState);
            }
        }
    }

    protected void paintBox(Graphics g2, NodeState nState) {
        if (nState.node != null && nState.node.hasChildren() != 0) {
            int x2 = nState.boxRect.x;
            int y2 = nState.boxRect.y;
            if (this.texture != null) {
                ImageTexture.texture(this.texture, g2, x2, y2, this.boxSize.width - 1, this.boxSize.height - 1);
            } else if (this.isOpaque()) {
                g2.setColor(SystemColor.window);
                g2.fillRect(x2, y2, this.boxSize.width - 1, this.boxSize.height - 1);
            }
            g2.setColor(this.isEnabled() ? SystemColor.controlShadow : SystemColor.controlShadow.brighter());
            DottedLine.drawHLine(g2, x2 + this.boxSize.width + 1, x2 + this.itemOffset, y2 + this.boxSize.width / 2);
            g2.drawRect(x2, y2, this.boxSize.width - 1, this.boxSize.height - 1);
            g2.setColor(this.isEnabled() ? SystemColor.controlText : SystemColor.controlText.brighter());
            if (!nState.expanded) {
                g2.drawLine(x2 + this.boxSize.width / 2, y2 + 2, x2 + this.boxSize.width / 2, y2 + this.boxSize.height - 3);
            }
            g2.drawLine(x2 + 2, y2 + this.boxSize.height / 2, x2 + this.boxSize.width - 3, y2 + this.boxSize.height / 2);
        }
    }

    protected void paintArrow(Graphics g2, NodeState nState) {
        if (nState.node != null && nState.node.hasChildren() != 0) {
            Image arrow;
            Image image = arrow = nState.expanded ? this.expandedArrow : this.contractedArrow;
            if (arrow != null) {
                g2.drawImage(arrow, nState.boxRect.x, nState.boxRect.y, this);
            }
        }
    }

    protected void paintItem(Graphics g2, NodeState nState) {
        if (this.viewManager != null) {
            int state = this.getState(nState);
            Object data = this.model.get(nState.node);
            ItemPainter itemPainter = this.getPainter(nState, data, state);
            if (itemPainter != null) {
                Dimension dim = itemPainter.getPreferredSize(data, g2, state, this);
                nState.itemRect.width = dim.width;
                nState.itemRect.height = dim.height;
                g2.setColor(this.getBackground());
                Rectangle itemRect = new Rectangle(nState.itemRect.x, nState.itemRect.y, dim.width, dim.height);
                itemPainter.paint(data, g2, itemRect, state, this);
            }
        }
    }

    protected void paintLink(Graphics g2, NodeState nState) {
        int y1;
        int x2 = this.boxSize.width / 2 + this.hIndent * nState.level + this.leftMargin;
        int y0 = y1 = nState.node.hasChildren() != 0 ? nState.boxRect.y : nState.itemRect.y + nState.itemRect.height / 2;
        NodeState prev = nState.prevVisible;
        if (prev != null) {
            if (prev.level >= nState.level) {
                while (prev.level > nState.level && prev != null) {
                    prev = prev.prevVisible;
                }
                y0 = prev.node.hasChildren() == 0 ? prev.itemRect.y + prev.itemRect.height / 2 : prev.boxRect.y + prev.boxRect.height;
            } else if (prev.expanded || prev.node.hasChildren() != -1) {
                GraphLocation[] kids = prev.node.getChildren();
                if (kids.length > 0 && kids[0] == nState.node) {
                    y0 = prev.itemRect.y + prev.itemRect.height;
                } else {
                    if (nState.node.getParent() == null) {
                        return;
                    }
                    NodeState parent = this.getViewState(nState.node.getParent());
                    if (parent == null) {
                        return;
                    }
                    y0 = parent.boxRect.y + parent.boxRect.height;
                }
            }
        } else {
            y0 = y1;
        }
        g2.setColor(this.isEnabled() ? SystemColor.controlShadow : SystemColor.controlShadow.brighter());
        DottedLine.drawVLine(g2, x2, y0, y1);
        if (nState.node.hasChildren() == 0) {
            int x22 = nState.itemRect.x;
            int y2 = nState.itemRect.y + nState.itemRect.height / 2;
            DottedLine.drawHLine(g2, x2, x22, y2);
        }
    }

    protected void paintVLines(Graphics g2, NodeState nState) {
        if (g2 == null || nState == null) {
            return;
        }
        NodeState parent = nState;
        for (int lev = nState.level - 1; lev > 0 && parent != null; --lev) {
            parent = this.getViewState(parent.node.getParent());
            if (parent == null || parent.getNextSibling() == null) continue;
            int x2 = this.boxSize.width / 2 + this.hIndent * lev + this.leftMargin;
            g2.setColor(this.isEnabled() ? SystemColor.controlShadow : SystemColor.controlShadow.brighter());
            DottedLine.drawVLine(g2, x2, nState.itemRect.y, nState.itemRect.y + nState.itemRect.height + 1);
        }
    }

    protected NodeState getViewState(GraphLocation gl) {
        if (gl == null) {
            return null;
        }
        NodeState nState = null;
        try {
            nState = (NodeState)this.cache.get(gl);
            return nState;
        }
        catch (Exception e2) {
            this.updateViewState();
            try {
                nState = (NodeState)this.cache.get(gl);
                return nState;
            }
            catch (Exception x2) {
                return null;
            }
        }
    }

    protected void putViewState(GraphLocation gl, NodeState state) {
        if (gl != null && this.cache.get(gl) == null) {
            this.cache.put(gl, state);
        }
    }

    protected void updateViewState() {
        GraphLocation root;
        if (this.initialized && this.model != null && (root = this.model.getRoot()) != null) {
            this.markViewState(root);
            this.updateViewState(root, this.showRoot ? 0 : -1);
            this.cleanViewState(root);
            if (this.firstNode == null || !this.firstNode.inUse) {
                this.firstNode = this.getViewState(root);
            }
        }
    }

    protected void markViewState(GraphLocation gl) {
        Enumeration i2 = this.cache.elements();
        while (i2.hasMoreElements()) {
            ((NodeState)i2.nextElement()).inUse = false;
        }
    }

    protected void cleanViewState(GraphLocation gl) {
        Object key = null;
        Enumeration i2 = this.cache.keys();
        while (i2.hasMoreElements()) {
            key = i2.nextElement();
            NodeState viewState = (NodeState)this.cache.get(key);
            if (viewState.inUse || this.model.get(viewState.node) != null) continue;
            this.cache.remove(key);
        }
    }

    protected void updateViewState(GraphLocation gl, int level) {
        if (gl != null) {
            NodeState nState = this.getViewState(gl);
            if (nState == null || !nState.isDescendentOf(this.model.getRoot())) {
                nState = new NodeState(this, gl, level, this.expandByDefault && gl.hasChildren() == 1);
                this.putViewState(gl, nState);
            } else {
                nState.update(level);
            }
            if (!nState.expanded) {
                return;
            }
            GraphLocation[] children = nState.node.getChildren();
            for (int i2 = 0; i2 < children.length; ++i2) {
                if (children[i2] == null) continue;
                NodeState childNodeState = this.getViewState(children[i2]);
                if (childNodeState == null) {
                    childNodeState = new NodeState(this, children[i2], level + 1, this.expandByDefault && children[i2].hasChildren() == 1);
                    this.putViewState(children[i2], childNodeState);
                } else {
                    childNodeState.update(level + 1);
                }
                if (!nState.expanded) continue;
                this.updateViewState(children[i2], level + 1);
            }
        }
    }

    protected void updateNodeRects(NodeState nState, Graphics g2) {
        if (nState != null) {
            this.updateNodeRect(nState, g2);
            if (!nState.expanded) {
                return;
            }
            GraphLocation[] children = nState.node.getChildren();
            for (int i2 = 0; i2 < children.length; ++i2) {
                NodeState childNodeState;
                if (children[i2] == null || (childNodeState = this.getViewState(children[i2])) == null) continue;
                this.updateNodeRects(childNodeState, g2);
            }
        }
    }

    protected void updateNodeRect(NodeState nState, Graphics g2) {
        if (nState == null || this.model == null || this.viewManager == null) {
            return;
        }
        int state = this.getState(nState);
        Object data = this.model.get(nState.node);
        ItemPainter itemPainter = this.getPainter(nState, data, state);
        if (itemPainter != null) {
            Dimension dim = itemPainter.getPreferredSize(data, g2, state, this);
            nState.itemRect.width = dim.width;
            nState.itemRect.height = dim.height;
        }
    }

    protected void repaintNode(NodeState nState) {
        if (!this.batchMode && nState != null && this.isVisible(nState)) {
            int x2 = nState.node.hasChildren() == 0 ? nState.itemRect.x : nState.boxRect.x;
            this.repaint(x2, nState.itemRect.y, this.getSize().width - x2, nState.itemRect.height);
        }
    }

    public void repaintNode(GraphLocation location) {
        this.repaintNode(this.getViewState(location));
    }

    public void repaintNodes() {
        if (this.batchMode) {
            return;
        }
        this.repaint(100L);
    }

    protected void repaintToEnd(NodeState nState) {
        if (this.batchMode || nState == null) {
            return;
        }
        int y2 = nState.itemRect.y;
        this.repaint(0, y2, this.getSize().width, this.getSize().height - y2);
    }

    public Dimension getPreferredSize() {
        if (!this.initialized) {
            this.initialize(this.getGraphics());
        }
        return new Dimension(this.leftMargin + this.canvasWidth, this.topMargin + this.canvasHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(20, 20);
    }

    private boolean canSet(GraphLocation node) {
        return this.isReadOnly() ? false : this.writeModel.canSet(node);
    }

    protected void processMousePressed(MouseEvent e2) {
        boolean hadFocus = this.hasFocus;
        this.hasFocus = true;
        super.processMousePressed(e2);
        int x2 = e2.getX();
        int y2 = e2.getY();
        boolean shift = e2.isShiftDown();
        boolean control = e2.isControlDown();
        boolean alt = e2.isAltDown();
        boolean right = e2.isMetaDown();
        NodeState current = this.hitTestY(y2);
        if (current == null) {
            return;
        }
        this.rollover = null;
        if (this.subfocus == null) {
            this.setSubfocus(current.node);
        }
        this.lastClickPosition = current.hitTest(x2, y2);
        switch (this.lastClickPosition) {
            case 2: {
                this.mouseDown = null;
                boolean expand = !current.expanded;
                Point sp = this.scroller.getViewport().getViewPosition();
                this.expandNode(current, expand);
                this.recalcVisible(true);
                this.repaintToEnd(current);
                this.scroller.getViewport().setViewPosition(sp);
                if (expand || this.subfocus == null || !this.subfocus.isDescendentOf(current.node)) break;
                this.setSubfocus(current, 67);
                break;
            }
            case 1: {
                this.mouseDown = current;
                if (this.editor != null) {
                    if (this.editorNode.equals(current)) {
                        return;
                    }
                    this.safeEndEdit();
                }
                if (current == this.subfocus) {
                    if (!right && e2.getClickCount() == 2) {
                        this.fireActionEvent();
                    }
                    if (!(control || shift || alt)) {
                        if (hadFocus && !this.selection.contains(current.node)) {
                            this.selection.removeAll();
                            this.selection.add(current.node);
                        } else if (!hadFocus) {
                            this.selection.removeAll();
                            this.selection.add(current.node);
                        }
                    } else if (control && !shift) {
                        if (this.selection.contains(current.node)) {
                            this.selection.remove(current.node);
                        } else {
                            this.selection.add(current.node);
                        }
                    }
                    if (hadFocus && !right && !control && !shift && !this.isToggleItem(current) && this.canSet(current.node)) {
                        this.doStartEdit = true;
                        return;
                    }
                }
                int flags = shift && control ? 2 : (shift ? 2 : (control ? 72 : 67));
                this.setSubfocus(current, flags);
            }
        }
    }

    protected void processMouseDragged(MouseEvent e2) {
        NodeState current;
        this.rollover = null;
        if (this.dragSubfocus && !e2.isMetaDown() && (current = this.hitTestY(e2.getY())) != null) {
            int flags = e2.isControlDown() ? 64 : 3;
            this.setSubfocus(current, flags);
        }
    }

    protected void processMouseReleased(MouseEvent e2) {
        int x2 = e2.getX();
        int y2 = e2.getY();
        boolean shift = e2.isShiftDown();
        boolean control = e2.isControlDown();
        boolean right = e2.isMetaDown();
        NodeState current = this.hitTestY(y2);
        if (current != null && current == this.mouseDown && current.hitTest(x2, y2) == 1) {
            this.editClickPoint = new Point(x2, y2);
            if (!right && (this.doStartEdit || this.isToggleItem(current))) {
                this.startEdit(current);
                this.doStartEdit = false;
            } else if (!(right || shift || control || this.selection.getCount() <= 1)) {
                this.selection.removeAll();
                this.selection.add(current.node);
            }
            this.editClickPoint = null;
        }
        this.mouseDown = null;
    }

    protected void processMouseMoved(MouseEvent e2) {
        NodeState hit;
        if (this.showRollover && (hit = this.hitTestXY(e2.getX(), e2.getY())) != this.rollover) {
            NodeState oldRollover = this.rollover;
            this.rollover = hit;
            this.repaintNode(oldRollover);
            this.repaintNode(this.rollover);
        }
    }

    public JToolTip createToolTip() {
        return this.toolTip;
    }

    public String getToolTipText(MouseEvent e2) {
        if (this.toolTip.active) {
            Object data;
            NodeState hit = this.hitTestXY(e2.getX(), e2.getY());
            if (hit != null && this.model != null && this.viewManager != null && (data = this.model.get(hit.node)) != null) {
                Rectangle r2 = this.getNodeRect(hit.node);
                Rectangle vp = this.scroller.getViewport().getViewRect();
                if (!(r2 == null || vp.contains(r2.x, r2.y) && vp.contains(r2.x + r2.width - 1, r2.y + r2.width - 1))) {
                    int state = this.getState(hit);
                    this.toolTip.data = data;
                    this.toolTip.painter = this.getPainter(hit, data, state);
                    this.toolTip.state = state;
                    return data.toString();
                }
            }
            return null;
        }
        this.toolTip.painter = null;
        return this.getToolTipText();
    }

    public Point getToolTipLocation(MouseEvent e2) {
        Rectangle r2;
        NodeState hit;
        if (this.toolTip.active && this.getToolTipText(e2) != null && (hit = this.hitTestXY(e2.getX(), e2.getY())) != null && (r2 = this.getNodeRect(hit.node)) != null && this.model != null && this.viewManager != null) {
            Object data = this.model.get(hit.node);
            int state = this.getState(hit);
            this.toolTip.data = data;
            this.toolTip.painter = this.getPainter(hit, data, state);
            this.toolTip.state = state;
            return new Point(r2.x - 1, r2.y - 1);
        }
        this.toolTip.painter = null;
        return null;
    }

    protected void processMouseExited(MouseEvent e2) {
        if (this.showRollover) {
            NodeState oldRollover = this.rollover;
            this.rollover = null;
            this.repaintNode(oldRollover);
        }
    }

    public void keyPressed(KeyEvent e2) {
        if (this.editor == null || e2.isConsumed()) {
            return;
        }
        switch (e2.getKeyCode()) {
            case 10: {
                this.safeEndEdit(true);
                if (this.lockSubfocus) break;
                e2.consume();
                break;
            }
            case 27: {
                this.safeEndEdit(false);
                e2.consume();
                break;
            }
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                this.safeEndEdit();
                this.processKeyPressed(e2);
                break;
            }
            case 37: 
            case 39: {
                if (!e2.isControlDown()) break;
                this.safeEndEdit();
                this.processKeyPressed(e2);
            }
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void keyTyped(KeyEvent e2) {
    }

    protected void processKeyPressed(KeyEvent e2) {
        int key = e2.getKeyCode();
        boolean control = e2.isControlDown();
        boolean shift = e2.isShiftDown();
        boolean alt = e2.isAltDown();
        if (this.subfocus == null && this.model != null) {
            this.setSubfocus(this.model.getRoot());
        }
        int flags = shift && control ? 2 : (shift ? 2 : (control ? 64 : 67));
        if (this.subfocus == null) {
            this.subfocus = this.firstNode;
        }
        switch (key) {
            case 36: {
                this.setSubfocus(this.hitTestLine(0), flags);
                e2.consume();
                break;
            }
            case 35: {
                this.setSubfocus(this.hitTestLine(this.lineCount - 1), flags);
                e2.consume();
                break;
            }
            case 38: {
                if (this.subfocus == null) break;
                this.setSubfocus(this.subfocus.prevVisible, flags);
                e2.consume();
                break;
            }
            case 40: {
                if (this.subfocus == null) break;
                this.setSubfocus(this.subfocus.nextVisible, flags);
                e2.consume();
                break;
            }
            case 33: {
                if (this.subfocus == null || this.lineCount <= 0 || this.canvasHeight <= 0) break;
                int avgheight = this.canvasHeight / this.lineCount;
                int pageHeight = this.scroller.getViewport().getExtentSize().height / avgheight;
                NodeState item = this.subfocus;
                while (item.prevVisible != null && --pageHeight > 0) {
                    item = item.prevVisible;
                }
                this.setSubfocus(item, flags);
                e2.consume();
                break;
            }
            case 34: {
                if (this.subfocus == null || this.lineCount <= 0 || this.canvasHeight <= 0) break;
                int avgheight = this.canvasHeight / this.lineCount;
                int pageHeight = this.scroller.getViewport().getExtentSize().height / avgheight;
                NodeState item = this.subfocus;
                while (item.nextVisible != null && --pageHeight > 0) {
                    item = item.nextVisible;
                }
                this.setSubfocus(item, flags);
                e2.consume();
                break;
            }
            case 37: {
                if (!(this.subfocus == null || this.subfocus.expanded && this.subfocus.node.hasChildren() != 0)) {
                    GraphLocation n2 = this.subfocus.node.getParent();
                    this.setSubfocus(this.getViewState(n2), flags);
                    e2.consume();
                    break;
                }
            }
            case 109: {
                if (alt || shift || control || this.subfocus == null || !this.subfocus.expanded) break;
                this.expandNode(this.subfocus, false);
                this.recalcVisible(true);
                this.repaintToEnd(this.subfocus);
                e2.consume();
                break;
            }
            case 39: {
                if (this.subfocus != null && this.subfocus.expanded && this.subfocus.node.hasChildren() != 0) {
                    this.setSubfocus(this.subfocus.nextVisible, flags);
                    e2.consume();
                    break;
                }
            }
            case 107: {
                if (alt || shift || control || this.subfocus == null || this.subfocus.expanded || this.subfocus.node.hasChildren() == 0) break;
                this.expandNode(this.subfocus, true);
                this.recalcVisible(true);
                this.repaintToEnd(this.subfocus);
                e2.consume();
                break;
            }
            case 32: {
                if (this.subfocus == null || shift || alt) break;
                if (control && this.selection.contains(this.subfocus.node)) {
                    this.selection.remove(this.subfocus.node);
                } else {
                    this.selection.add(this.subfocus.node);
                }
                if (this.isToggleItem(this.subfocus)) {
                    this.startEdit(this.subfocus);
                }
                e2.consume();
                break;
            }
            case 10: {
                if (control && this.editor == null && this.canSet(this.subfocus.node)) {
                    this.startEdit(this.subfocus);
                } else {
                    this.fireActionEvent();
                }
                e2.consume();
                break;
            }
            case 113: {
                if (this.editor != null || this.isToggleItem(this.subfocus) || !this.canSet(this.subfocus.node)) break;
                this.startEdit(this.subfocus);
                e2.consume();
                break;
            }
            case 74: {
                if (!shift || !control || !alt) break;
                this.debugPaint = !this.debugPaint;
                break;
            }
            default: {
                return;
            }
        }
    }

    protected void processKeyTyped(KeyEvent e2) {
        char kChar = e2.getKeyChar();
        if (this.editor != null || !this.autoEdit || e2.isConsumed() || this.isReadOnly() || kChar == '\u0000' || kChar == '\t' || kChar == '\r' || kChar == '\n' || kChar == ' ' || kChar == '\u001b' || kChar == '+' || kChar == '-' || this.isToggleItem(this.subfocus) || e2.isAltDown() || e2.isControlDown() || !this.writeModel.canSet(this.subfocus.node)) {
            return;
        }
        this.startEdit(this.subfocus);
        Component eComp = null;
        if (this.editor != null && (eComp = this.editor.getComponent()) != null) {
            eComp.dispatchEvent(e2);
        }
    }

    public void addTreeListener(TreeListener l2) {
        this.treeListeners.add(l2);
    }

    public void removeTreeListener(TreeListener l2) {
        this.treeListeners.remove(l2);
    }

    protected void processTreeEvent(TreeEvent e2) {
        if (this.treeListeners.hasListeners()) {
            this.treeListeners.dispatch(e2);
        }
    }

    public void windowActiveChanged(boolean active) {
        super.windowActiveChanged(active);
        this.repaintSelection();
    }

    public void focusGained(FocusEvent e2) {
    }

    public void focusLost(FocusEvent e2) {
        if (this.hasFocus) {
            this.hasFocus = false;
            this.repaintNode(this.subfocus);
        }
    }

    protected void processFocusEvent(FocusEvent e2) {
        super.processFocusEvent(e2);
        switch (e2.getID()) {
            case 1004: {
                if (this.editor != null && this.editor.getComponent() != null) {
                    this.editor.getComponent().requestFocus();
                }
                if (this.hasFocus) break;
                this.hasFocus = true;
                break;
            }
            case 1005: {
                if (this.editor != null) break;
                this.hasFocus = false;
            }
        }
        if (this.model != null && this.subfocus == null) {
            this.setSubfocus(this.model.getRoot());
        }
        this.repaintNode(this.subfocus);
    }

    public void addSubfocusListener(GraphSubfocusListener l2) {
        this.subfocusListeners.add(l2);
    }

    public void removeSubfocusListener(GraphSubfocusListener l2) {
        this.subfocusListeners.remove(l2);
    }

    protected boolean preProcessSubfocusEvent(GraphSubfocusEvent e2) {
        if (this.subfocusListeners.hasListeners()) {
            return this.subfocusListeners.vetoableDispatch(e2);
        }
        return true;
    }

    protected void processSubfocusEvent(GraphSubfocusEvent e2) {
        if (this.subfocusListeners.hasListeners()) {
            this.subfocusListeners.dispatch(e2);
        }
    }

    private ItemPainter getPainter(NodeState ns, Object data, int state) {
        ItemPainter painter;
        ItemPainter itemPainter = painter = this.viewManager != null ? this.viewManager.getPainter(ns.node, data, state) : null;
        if (painter != null && this.customizeListeners != null) {
            this.customPainter.setPainter(painter);
            this.fireCustomizeItemEvent(ns.node, data, state, this.customPainter);
            return this.customPainter;
        }
        return painter;
    }

    private ItemEditor getEditor(NodeState ns, Object data, int state) {
        ItemEditor editor;
        ItemEditor itemEditor = editor = this.viewManager != null ? this.viewManager.getEditor(ns.node, data, state) : null;
        if (editor != null && this.customizeEditors && this.customizeListeners != null) {
            this.customEditor.setEditor(editor);
            this.fireCustomizeItemEvent(ns.node, data, state, this.customEditor);
            return this.customEditor;
        }
        return editor;
    }

    protected void repaintSelection() {
        Enumeration i2 = this.cache.elements();
        while (i2.hasMoreElements()) {
            NodeState n2 = (NodeState)i2.nextElement();
            boolean selected = this.selection.contains(n2.node);
            if (n2.selected != selected) {
                n2.selected = selected;
                this.repaintNode(n2);
                continue;
            }
            if (!n2.selected) continue;
            this.repaintNode(n2);
        }
    }

    public void selectionItemChanged(GraphSelectionEvent e2) {
        NodeState n2 = this.getViewState(e2.getLocation());
        if (n2 != null) {
            if (this.subfocus == null) {
                this.subfocus = n2;
            }
            n2.selected = this.selection.contains(n2.node);
            this.repaintNode(n2);
        }
    }

    public void selectionChanged(GraphSelectionEvent e2) {
        this.repaintSelection();
    }

    void recalcVisible(boolean shouldValidate) {
        NodeState root;
        int oldCanvasWidth = this.canvasWidth;
        int oldCanvasHeight = this.canvasHeight;
        this.lastCalc = null;
        this.lineCount = 0;
        this.canvasWidth = 0;
        this.canvasHeight = 0;
        if (this.model != null && (root = this.getViewState(this.model.getRoot())) != null) {
            if (this.showRoot) {
                this.recalcVisible(root.node, this.topMargin);
            } else if (root.nextVisible != null) {
                this.recalcVisible(root.nextVisible.node, this.topMargin);
            }
        }
        this.scroller.getVerticalScrollBar().setUnitIncrement(this.lineCount > 0 ? this.canvasHeight / this.lineCount : 0);
        if (this.canvasWidth != oldCanvasWidth || this.canvasHeight != oldCanvasHeight) {
            this.invalidate();
            this.repaintNodes();
            if (shouldValidate && this.isShowing() && !this.batchMode) {
                this.scroller.validate();
                this.scrollView();
            }
        }
    }

    int recalcVisible(GraphLocation location, int y2) {
        NodeState nState;
        while (location != null && (nState = this.getViewState(location)) != null) {
            GraphLocation[] ns;
            int x2 = this.leftMargin + nState.level * this.hIndent;
            nState.prevVisible = this.lastCalc;
            nState.nextVisible = null;
            ++this.lineCount;
            nState.lineNumber = nState.lineNumber;
            if (this.lastCalc != null) {
                this.lastCalc.nextVisible = nState;
            }
            this.lastCalc = nState;
            if (location.hasChildren() != 0) {
                nState.boxRect.x = x2;
                nState.boxRect.y = y2 + (nState.itemRect.height - nState.boxRect.height) / 2;
            }
            nState.boxRect.width = this.boxSize.width;
            nState.boxRect.height = this.boxSize.height;
            nState.itemRect.x = x2 += this.itemOffset;
            nState.itemRect.y = y2;
            this.canvasHeight += nState.itemRect.height + this.vgap;
            if (nState.itemRect.x + nState.itemRect.width > this.canvasWidth) {
                this.canvasWidth = nState.itemRect.x + nState.itemRect.width;
            }
            y2 += nState.itemRect.height + this.vgap;
            if (nState.expanded && nState.node.hasChildren() != 0 && (ns = nState.node.getChildren()).length > 0) {
                y2 = this.recalcVisible(ns[0], y2);
            }
            location = nState.getNextSibling();
        }
        return y2;
    }

    public void setSelection(WritableGraphSelection s2) {
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
            this.selection.removeSelectionListener(this.selectionMulticaster);
        }
        this.selection = s2;
        if (this.selection != null) {
            this.selection.addSelectionListener(this);
            this.selection.addSelectionListener(this.selectionMulticaster);
        }
    }

    public WritableGraphSelection getSelection() {
        return this.selection;
    }

    public void addSelectionListener(GraphSelectionListener l2) {
        this.selectionMulticaster.add(l2);
    }

    public void removeSelectionListener(GraphSelectionListener l2) {
        this.selectionMulticaster.remove(l2);
    }

    protected boolean expandNode(NodeState nState, boolean expand) {
        if (nState.node.hasChildren() == 0) {
            return false;
        }
        if (nState.expanded != expand) {
            this.processTreeEvent(new TreeEvent(this, expand ? 1000 : 1001, nState.node));
            nState.expanded = expand;
            if (expand) {
                this.updateViewState(nState.node, nState.level);
                this.updateNodeRects(nState, this.getSiteGraphics());
            }
            return true;
        }
        return false;
    }

    public boolean isExpanded(GraphLocation location) {
        NodeState nState = this.getViewState(location);
        if (nState != null) {
            return nState.expanded;
        }
        return false;
    }

    public void expand(GraphLocation location) {
        if (!this.initialized) {
            this.presetExpandList.addElement(location);
            return;
        }
        NodeState nState = this.getViewState(location);
        if (nState != null && this.expandNode(nState, true)) {
            this.recalcVisible(true);
            this.repaintToEnd(nState);
        }
    }

    public void collapse(GraphLocation location) {
        if (!this.initialized) {
            this.presetCollapseList.addElement(location);
            return;
        }
        NodeState nState = this.getViewState(location);
        if (nState != null) {
            if (this.expandNode(nState, false)) {
                this.recalcVisible(true);
                this.repaintToEnd(nState);
            }
            if (this.subfocus != null && this.subfocus.isDescendentOf(location)) {
                this.setSubfocus(nState, 66);
            }
        }
    }

    public void toggleExpanded(GraphLocation location) {
        if (!this.initialized || location == null) {
            return;
        }
        NodeState nState = this.getViewState(location);
        if (nState != null && nState.node.hasChildren() != 0) {
            boolean wasExpanded = false;
            wasExpanded = !nState.expanded ? this.expandNode(nState, true) : this.expandNode(nState, false);
            if (wasExpanded) {
                this.recalcVisible(true);
                this.repaintToEnd(nState);
            }
        }
    }

    public void expandAll(GraphLocation location) {
        if (location == null) {
            return;
        }
        this.expandChildNodes(location);
        NodeState nState = this.getViewState(location);
        if (nState != null) {
            this.recalcVisible(true);
            this.repaintToEnd(nState);
        }
    }

    public void collapseAll(GraphLocation location) {
        if (location == null) {
            return;
        }
        this.collapseChildNodes(location);
        NodeState nState = this.getViewState(location);
        if (nState != null) {
            this.recalcVisible(true);
            this.repaintToEnd(nState);
        }
        if (this.subfocus != null && this.subfocus.isDescendentOf(location)) {
            this.setSubfocus(nState, 66);
        }
    }

    private void expandChildNodes(GraphLocation location) {
        NodeState nState = this.getViewState(location);
        if (nState != null && nState.node.hasChildren() != 0) {
            this.expandNode(nState, true);
            GraphLocation[] children = location.getChildren();
            for (int i2 = 0; i2 < children.length; ++i2) {
                this.expandChildNodes(children[i2]);
            }
        }
    }

    private void collapseChildNodes(GraphLocation location) {
        NodeState nState = this.getViewState(location);
        if (nState != null && nState.node.hasChildren() != 0) {
            this.expandNode(nState, false);
            GraphLocation[] children = location.getChildren();
            for (int i2 = 0; i2 < children.length; ++i2) {
                this.collapseChildNodes(children[i2]);
            }
        }
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public Graphics getSiteGraphics() {
        Graphics g2 = this.getGraphics();
        if (g2 != null) {
            g2.setFont(this.getFont());
        }
        return g2;
    }

    public Component getSiteComponent() {
        return this;
    }

    private int getState(NodeState nState) {
        int state = 0;
        if (nState == null) {
            return 0;
        }
        if (this.selection != null && this.selection.contains(nState.node)) {
            state |= 4;
        }
        if (!this.isEnabled()) {
            state |= 0x21;
        } else {
            if (this.showFocus && this.hasFocus && this.subfocus == nState) {
                state |= 2;
            }
            if ((this.focusState & 0x20) != 0) {
                state |= 0x20;
            }
            if (nState.expanded) {
                state |= 0x10;
            }
            if (this.showRollover && this.rollover != null && this.rollover == nState) {
                state |= 0x40;
            }
        }
        if (!this.hasFocus) {
            state |= 0x80;
        }
        return state;
    }

    void dump(NodeState nState) {
    }

    boolean isVisible(NodeState s2) {
        NodeState ps;
        if (!this.isVisible()) {
            return false;
        }
        Rectangle vRect = this.scroller.getViewport().getViewRect();
        if (s2 == null || s2.itemRect.y < vRect.y || s2.itemRect.y - vRect.y > vRect.height) {
            return false;
        }
        do {
            if ((ps = this.getViewState(s2.node.getParent())) != s2) continue;
            return false;
        } while ((s2 = ps) != null && s2.expanded);
        return s2 == null;
    }

    protected boolean makeExpanded(NodeState s2) {
        boolean didExpand = false;
        do {
            if (s2.expanded) continue;
            didExpand = true;
            s2.expanded = true;
        } while ((s2 = this.getViewState(s2.node.getParent())) != null);
        return didExpand;
    }

    public void modelContentChanged(GraphModelEvent e2) {
        GraphLocation gl = e2.getLocation();
        NodeState nState = this.getViewState(gl);
        if (!this.initialized || gl == null || nState == null) {
            return;
        }
        this.updateNodeRects(nState, this.getSiteGraphics());
        switch (e2.getChange()) {
            case 33: {
                if (this.editor != null && this.editorNode != null && this.editorNode.equals(e2.getLocation())) {
                    this.safeEndEdit(false);
                }
                this.repaintToEnd(nState);
                break;
            }
            default: {
                if (this.editor != null && this.editorNode != null && this.editorNode.equals(e2.getLocation())) {
                    this.safeEndEdit(false);
                }
                this.repaintNode(nState);
            }
        }
        this.recalcVisible(true);
    }

    public void modelStructureChanged(GraphModelEvent e2) {
        if (!this.initialized) {
            return;
        }
        GraphLocation loc = e2.getLocation();
        switch (e2.getChange()) {
            case 18: {
                this.updateViewState();
                NodeState nState = this.getViewState(loc.getParent());
                if (nState == null) {
                    nState = this.firstNode;
                }
                if (this.expandByDefault && !nState.expanded && nState.node.hasChildren() == 1) {
                    this.expandNode(nState, true);
                    break;
                }
                this.updateNodeRects(nState, this.getSiteGraphics());
                this.repaintToEnd(nState);
                break;
            }
            case 34: {
                NodeState jump;
                NodeState ns = this.getViewState(loc);
                if (ns != null && ns.nextVisible != null && ns.nextVisible.level == ns.level) {
                    jump = ns.nextVisible;
                } else if (ns != null && ns.prevVisible != null) {
                    jump = ns.prevVisible;
                } else if (ns != this.firstNode) {
                    jump = this.firstNode;
                } else {
                    jump = null;
                    this.subfocus = null;
                }
                if (this.selection != null && ns != null && this.selection.contains(ns.node)) {
                    this.selection.remove(ns.node);
                }
                if (ns == this.subfocus || this.subfocus != null && this.subfocus.isDescendentOf(loc)) {
                    this.setSubfocus(jump, 66);
                }
                this.updateViewState();
                this.updateNodeRects(jump, this.getSiteGraphics());
                break;
            }
            case 50: {
                this.updateViewState();
                NodeState rn = this.getViewState(loc);
                this.updateNodeRects(rn, this.getSiteGraphics());
                break;
            }
            case 2: {
                this.updateViewState();
                this.updateNodeRects(this.firstNode, this.getSiteGraphics());
                break;
            }
            default: {
                this.updateViewState();
                this.updateNodeRects(this.firstNode, this.getSiteGraphics());
            }
        }
        this.recalcVisible(true);
    }

    public void startEdit(GraphLocation node) {
        this.startEdit(this.getViewState(node));
    }

    protected void startEdit(NodeState newEditorNode) {
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.batchMode) {
            return;
        }
        this.rollover = null;
        this.editorNode = newEditorNode;
        if (newEditorNode == this.subfocus) {
            if (this.selection.getCount() != 1 || !this.selection.contains(newEditorNode.node)) {
                this.selection.removeAll();
                this.selection.add(newEditorNode.node);
            }
        } else {
            this.setSubfocus(this.editorNode, 67);
        }
        Object data = this.model.get(this.editorNode.node);
        int state = this.getState(this.editorNode);
        this.editor = this.getEditor(this.editorNode, data, state);
        if (this.editor == null) {
            this.editorNode = null;
            return;
        }
        Component editorComponent = this.editor.getComponent();
        if (editorComponent != null) {
            editorComponent.setVisible(false);
            this.add(editorComponent);
        }
        Rectangle r2 = this.getEditorRect();
        this.editor.addKeyListener(this);
        this.editor.addKeyListener(this.keyMulticaster);
        this.editor.startEdit(data, r2, this);
        this.resyncEditor();
        if (this.editor != null && this.editor.getComponent() != null) {
            this.editor.getComponent().addFocusListener(this);
        }
        this.editClickPoint = null;
    }

    protected Rectangle getEditorRect() {
        Component c2;
        Rectangle rect = null;
        if (this.editorNode != null && this.editor != null && (rect = this.editorNode.itemRect) != null && this.growEditor && (c2 = this.editor.getComponent()) != null) {
            Dimension ps = c2.getPreferredSize();
            if (ps.height > rect.height) {
                rect.height = ps.height;
            }
        }
        return rect;
    }

    protected void resyncEditor() {
        if (this.editorNode != null && this.editor != null) {
            Rectangle er = this.getEditorRect();
            this.editor.changeBounds(er != null ? er : new Rectangle());
        }
    }

    private boolean isToggleItem(NodeState item) {
        int state;
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.batchMode) {
            return false;
        }
        Object data = this.model.get(item.node);
        ItemEditor ie = this.getEditor(item, data, state = this.getState(item));
        if (ie instanceof ToggleItemEditor) {
            Rectangle rect = new Rectangle(item.itemRect);
            return ((ToggleItemEditor)ie).isToggle(data, rect, this) && this.canSet(item.node);
        }
        return false;
    }

    public void endEdit() throws Exception {
        this.endEdit(this.postOnEndEdit);
    }

    public void endEdit(boolean post) throws Exception {
        this.lockSubfocus = false;
        ItemEditor editor = this.editor;
        this.editor = null;
        if (editor != null) {
            boolean okToEnd = true;
            try {
                if (!post || (okToEnd = editor.canPost())) {
                    if (post && okToEnd) {
                        this.writeModel.set(this.editorNode.node, editor.getValue());
                    }
                    this.repaintNode(this.editorNode);
                    if (okToEnd) {
                        Component editorComponent = editor.getComponent();
                        editor.endEdit(post);
                        editor.removeKeyListener(this);
                        editor.removeKeyListener(this.keyMulticaster);
                        if (editorComponent != null) {
                            this.remove(editorComponent);
                            editorComponent.removeFocusListener(this);
                        }
                        this.updateViewState(this.editorNode.node, this.editorNode.level);
                        this.editClickPoint = null;
                        this.editorNode = null;
                        editor = null;
                        this.requestFocus();
                    }
                }
            }
            catch (Exception x2) {
                this.lockSubfocus = true;
                this.editor = editor;
                throw x2;
            }
        }
        this.editor = editor;
    }

    public void safeEndEdit() {
        this.safeEndEdit(this.postOnEndEdit);
    }

    public void safeEndEdit(boolean post) {
        try {
            this.endEdit(post);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doLayout() {
        if (this.editorNode != null && this.editor != null) {
            Rectangle r2 = this.editorNode.itemRect;
            if (r2 != null) {
                this.editor.changeBounds(new Rectangle(r2.x, r2.y, r2.width, r2.height));
            } else {
                this.editor.changeBounds(new Rectangle(0, 0, 0, 0));
            }
        }
    }

    public Point getEditClickPoint() {
        return this.editClickPoint;
    }

    public void addKeyListener(KeyListener l2) {
        this.keyMulticaster.add(l2);
    }

    public void removeKeyListener(KeyListener l2) {
        this.keyMulticaster.remove(l2);
    }

    public void checkParentWindow() {
        this.findParentWindow();
    }

    private void fireActionEvent() {
        Object item = this.model != null ? this.model.get(this.subfocus.node) : null;
        String action = item != null ? item.toString() : "";
        this.processActionEvent(new ActionEvent(this.scroller, 1001, action));
    }

    protected void fireCustomizeItemEvent(Object address, Object data, int state, CustomPaintSite cps) {
        if (this.customizeListeners != null) {
            cps.reset();
            for (int i2 = 0; i2 < this.customizeListeners.size(); ++i2) {
                ((CustomItemListener)this.customizeListeners.elementAt(i2)).customizeItem(address, data, state, cps);
            }
        }
    }

    public synchronized void addCustomItemListener(CustomItemListener l2) {
        if (this.customizeListeners == null) {
            this.customizeListeners = new Vector();
        }
        this.customizeListeners.addElement(l2);
    }

    public synchronized void removeCustomItemListener(CustomItemListener l2) {
        if (this.customizeListeners != null) {
            this.customizeListeners.removeElement(l2);
        }
        if (this.customizeListeners.size() == 0) {
            this.customizeListeners = null;
        }
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        Hashtable<String, Object> hash = new Hashtable<String, Object>(5);
        if (this.model instanceof Serializable) {
            hash.put("m", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hash.put("v", this.viewManager);
        }
        if (this.selection instanceof Serializable) {
            hash.put("s", this.selection);
        }
        if (this.expandedArrow != null) {
            hash.put("e", SerializableImage.create(this.expandedArrow));
        }
        if (this.contractedArrow != null) {
            hash.put("c", SerializableImage.create(this.contractedArrow));
        }
        s2.writeObject(hash);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        Hashtable hash = (Hashtable)s2.readObject();
        Object data = hash.get("m");
        if (data instanceof GraphModel) {
            this.model = (GraphModel)data;
        }
        if (this.model instanceof WritableGraphModel) {
            this.writeModel = (WritableGraphModel)this.model;
        }
        if ((data = hash.get("v")) instanceof GraphViewManager) {
            this.viewManager = (GraphViewManager)data;
        }
        if ((data = hash.get("s")) instanceof WritableGraphSelection) {
            this.selection = (WritableGraphSelection)data;
        }
        if ((data = hash.get("e")) instanceof SerializableImage) {
            this.expandedArrow = ((SerializableImage)data).getImage();
        }
        if ((data = hash.get("c")) instanceof SerializableImage) {
            this.contractedArrow = ((SerializableImage)data).getImage();
        }
    }
}

