/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.codecs;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;

public class SmokeCodec {
    private static final int IDX_TYPE = 0;
    private static final int IDX_WIDTH = 1;
    private static final int IDX_HEIGHT = 3;
    private static final int IDX_FPS_NUM = 5;
    private static final int IDX_FPS_DENOM = 9;
    private static final int IDX_FLAGS = 13;
    private static final int IDX_NUM_BLOCKS = 14;
    private static final int IDX_SIZE = 16;
    private static final int IDX_BLOCKS = 18;
    private static final int OFFS_PICT = 18;
    private Image reference;
    private MediaTracker mt;
    private Component component;
    private Toolkit toolkit;
    public static final int KEYFRAME = 1;
    public int type;
    public int width;
    public int height;
    public int fps_num;
    public int fps_denom;
    public int flags;
    public int size;
    public int blocks;

    public SmokeCodec(Component comp, MediaTracker tracker) {
        this.component = comp;
        this.toolkit = comp.getToolkit();
        this.mt = tracker;
    }

    public int parseHeader(byte[] in, int offset, int length) {
        short b4;
        short b3;
        short b2;
        this.type = in[0 + offset];
        short b1 = in[1 + offset];
        if (b1 < 0) {
            b1 = (short)(b1 + 256);
        }
        if ((b2 = (short)in[2 + offset]) < 0) {
            b2 = (short)(b2 + 256);
        }
        this.width = b1 << 8 | b2;
        b1 = in[3 + offset];
        if (b1 < 0) {
            b1 = (short)(b1 + 256);
        }
        if ((b2 = (short)in[4 + offset]) < 0) {
            b2 = (short)(b2 + 256);
        }
        this.height = b1 << 8 | b2;
        b1 = in[5 + offset];
        if (b1 < 0) {
            b1 = (short)(b1 + 256);
        }
        if ((b2 = (short)in[6 + offset]) < 0) {
            b2 = (short)(b2 + 256);
        }
        if ((b3 = (short)in[7 + offset]) < 0) {
            b3 = (short)(b3 + 256);
        }
        if ((b4 = (short)in[8 + offset]) < 0) {
            b4 = (short)(b4 + 256);
        }
        this.fps_num = b1 << 24 | b2 << 16 | b3 << 8 | b4;
        b1 = in[9 + offset];
        if (b1 < 0) {
            b1 = (short)(b1 + 256);
        }
        if ((b2 = (short)in[10 + offset]) < 0) {
            b2 = (short)(b2 + 256);
        }
        if ((b3 = (short)in[11 + offset]) < 0) {
            b3 = (short)(b3 + 256);
        }
        if ((b4 = (short)in[12 + offset]) < 0) {
            b4 = (short)(b4 + 256);
        }
        this.fps_denom = b1 << 24 | b2 << 16 | b3 << 8 | b4;
        this.flags = in[13 + offset];
        b1 = in[16 + offset];
        if (b1 < 0) {
            b1 = (short)(b1 + 256);
        }
        if ((b2 = (short)in[16 + offset]) < 0) {
            b2 = (short)(b2 + 256);
        }
        this.size = b1 << 8 | b2;
        b1 = in[14 + offset];
        if (b1 < 0) {
            b1 = (short)(b1 + 256);
        }
        if ((b2 = (short)in[15 + offset]) < 0) {
            b2 = (short)(b2 + 256);
        }
        this.blocks = b1 << 8 | b2;
        return 0;
    }

    public Image decode(byte[] in, int offset, int length) {
        boolean keyframe;
        this.parseHeader(in, offset, length);
        boolean bl = keyframe = (this.flags & 1) != 0;
        if (this.reference == null && !keyframe) {
            return null;
        }
        int imgoff = this.blocks * 2 + 18;
        Image src = null;
        try {
            src = this.toolkit.createImage(in, imgoff + offset, length - imgoff);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (src == null) {
            System.out.println("failed");
            return null;
        }
        try {
            this.mt.addImage(src, 0);
            this.mt.waitForID(0);
            this.mt.removeImage(src, 0);
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        if (this.reference == null || keyframe) {
            this.reference = src;
        } else if (this.blocks > 0) {
            int src_w = src.getWidth(null);
            int src_h = src.getHeight(null);
            int blockptr = 0;
            offset += 18;
            Image newref = this.component.createImage(this.width, this.height);
            Graphics refgfx = newref.getGraphics();
            refgfx.drawImage(this.reference, 0, 0, null);
            this.reference = newref;
            block4: for (int i2 = 0; i2 < src_h; i2 += 16) {
                for (int j2 = 0; j2 < src_w; j2 += 16) {
                    int b2;
                    int pos = blockptr * 2 + offset;
                    int b1 = in[pos];
                    if (b1 < 0) {
                        b1 += 256;
                    }
                    if ((b2 = in[pos + 1]) < 0) {
                        b2 += 256;
                    }
                    pos = b1 << 8 | b2;
                    int x2 = pos % (this.width / 16) * 16;
                    int y2 = pos / (this.width / 16) * 16;
                    refgfx.drawImage(src, x2, y2, x2 + 16, y2 + 16, j2, i2, j2 + 16, i2 + 16, null);
                    if (++blockptr >= this.blocks) continue block4;
                }
            }
        }
        return this.reference;
    }
}

