/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.examples;

import com.fluendo.jheora.Comment;
import com.fluendo.jheora.Info;
import com.fluendo.jheora.State;
import com.fluendo.jheora.YUVBuffer;
import com.fluendo.utils.Debug;
import com.fluendo.utils.MemUtils;
import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;

public class DumpVideo {
    public static final Integer OK = new Integer(0);
    public static final Integer ERROR = new Integer(-5);
    private static final byte[] signature = new byte[]{-128, 116, 104, 101, 111, 114, 97};

    public boolean isTheora(Packet op) {
        return this.typeFind(op.packet_base, op.packet, op.bytes) > 0;
    }

    public int typeFind(byte[] data, int offset, int length) {
        if (MemUtils.startsWith(data, offset, length, signature)) {
            return 10;
        }
        return -1;
    }

    public void dumpVideo(File videofile, List outfiles, boolean raw) throws IOException {
        FileInputStream is = new FileInputStream(videofile);
        boolean onlytime = outfiles.size() == 0;
        SyncState oy = new SyncState();
        Page og = new Page();
        Packet op = new Packet();
        byte[] buf = new byte[512];
        Hashtable<Integer, StreamState> streamstates = new Hashtable<Integer, StreamState>();
        Hashtable<Integer, TheoraDecoderWrapper> theoradecoders = new Hashtable<Integer, TheoraDecoderWrapper>();
        Hashtable<Integer, YUVWriter> yuvwriters = new Hashtable<Integer, YUVWriter>();
        HashSet<Integer> hasdecoder = new HashSet<Integer>();
        int read = ((InputStream)is).read(buf);
        while (read > 0) {
            int offset = oy.buffer(read);
            System.arraycopy(buf, 0, oy.data, offset, read);
            oy.wrote(read);
            while (oy.pageout(og) == 1) {
                Integer serialno = new Integer(og.serialno());
                StreamState state = (StreamState)streamstates.get(serialno);
                if (state == null) {
                    state = new StreamState();
                    state.init(serialno);
                    streamstates.put(serialno, state);
                    Debug.info("created StreamState for stream no. " + og.serialno());
                }
                state.pagein(og);
                while (state.packetout(op) == 1) {
                    TheoraDecoderWrapper theoradec;
                    if (!hasdecoder.contains(serialno) && this.isTheora(op)) {
                        theoradec = (TheoraDecoderWrapper)theoradecoders.get(serialno);
                        if (theoradec == null) {
                            theoradec = new TheoraDecoderWrapper();
                            theoradecoders.put(serialno, theoradec);
                            hasdecoder.add(serialno);
                        }
                        Debug.info("is Theora: " + serialno);
                    }
                    if ((theoradec = (TheoraDecoderWrapper)theoradecoders.get(serialno)) == null) continue;
                    Object result = theoradec.decode(op);
                    if (onlytime || !(result instanceof YUVBuffer)) continue;
                    YUVWriter yuvwriter = (YUVWriter)yuvwriters.get(serialno);
                    if (yuvwriter == null && !outfiles.isEmpty()) {
                        yuvwriter = new YUVWriter((File)outfiles.get(0), raw);
                        yuvwriters.put(serialno, yuvwriter);
                        outfiles.remove(0);
                    }
                    if (yuvwriter == null) continue;
                    YUVBuffer yuvbuf = (YUVBuffer)result;
                    yuvwriter.writeYUVFrame(theoradec.ti, yuvbuf);
                }
            }
            read = ((InputStream)is).read(buf);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("usage: DumpVideo <videofile> [<outfile_1> ... <outfile_n>} [--raw>]");
            System.exit(1);
        }
        boolean raw = false;
        File infile = new File(args[0]);
        LinkedList<File> outfiles = new LinkedList<File>();
        for (int i2 = 1; i2 < args.length; ++i2) {
            if (args[i2].equals("--raw")) {
                raw = true;
                break;
            }
            outfiles.add(new File(args[i2]));
        }
        if (outfiles.size() == 0) {
            System.out.println("no output files given, will only time decode");
        }
        DumpVideo dv = new DumpVideo();
        Date start = new Date();
        dv.dumpVideo(infile, outfiles, raw);
        Date end = new Date();
        System.out.println("time: " + (end.getTime() - start.getTime()) + " milliseconds");
    }

    private class YUVWriter {
        private OutputStream os;
        private boolean wroteHeader = false;
        private byte[] ybytes;
        private byte[] uvbytes;
        private boolean raw;

        public YUVWriter(File outfile, boolean raw) {
            this.raw = raw;
            try {
                this.os = new FileOutputStream(outfile);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }

        public void writeYUVFrame(Info ti, YUVBuffer yuv) {
            try {
                int start;
                int j2;
                int i2;
                if (!this.raw) {
                    if (!this.wroteHeader) {
                        String headerstring = "YUV4MPEG2 W" + ti.width + " H" + ti.height + " F" + ti.fps_numerator + ":" + ti.fps_denominator + " Ip A" + ti.aspect_numerator + ":" + ti.aspect_denominator + "\n";
                        this.os.write(headerstring.getBytes());
                        this.wroteHeader = true;
                    }
                    this.os.write("FRAME\n".getBytes());
                }
                if (this.ybytes == null || this.ybytes.length != yuv.y_width * yuv.y_height) {
                    this.ybytes = new byte[yuv.y_width * yuv.y_height];
                }
                int offset = 0;
                for (i2 = 0; i2 < yuv.y_height; ++i2) {
                    for (j2 = start = yuv.y_offset + i2 * yuv.y_stride; j2 < start + yuv.y_width; ++j2) {
                        this.ybytes[offset++] = (byte)yuv.data[j2];
                    }
                }
                this.os.write(this.ybytes);
                if (this.uvbytes == null || this.uvbytes.length != yuv.uv_width * yuv.uv_height) {
                    this.uvbytes = new byte[yuv.uv_width * yuv.uv_height];
                }
                offset = 0;
                for (i2 = 0; i2 < yuv.uv_height; ++i2) {
                    for (j2 = start = yuv.u_offset + i2 * yuv.uv_stride; j2 < start + yuv.uv_width; ++j2) {
                        this.uvbytes[offset++] = (byte)yuv.data[j2];
                    }
                }
                this.os.write(this.uvbytes);
                offset = 0;
                for (i2 = 0; i2 < yuv.uv_height; ++i2) {
                    for (j2 = start = yuv.v_offset + i2 * yuv.uv_stride; j2 < start + yuv.uv_width; ++j2) {
                        this.uvbytes[offset++] = (byte)yuv.data[j2];
                    }
                }
                this.os.write(this.uvbytes);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private class TheoraDecoderWrapper {
        private Info ti = new Info();
        private Comment tc = new Comment();
        private State ts = new State();
        private YUVBuffer yuv = new YUVBuffer();
        private int packet;
        private int frame;
        private boolean needKeyframe;

        public int takeHeader(Packet op) {
            int ret = this.ti.decodeHeader(this.tc, op);
            byte header = op.packet_base[op.packet];
            if (header == -126) {
                this.ts.decodeInit(this.ti);
            }
            return ret;
        }

        public boolean isHeader(Packet op) {
            return (op.packet_base[op.packet] & 0x80) == 128;
        }

        public boolean isKeyFrame(Packet op) {
            return this.ts.isKeyframe(op);
        }

        public Object decode(Packet op) {
            Integer result = OK;
            if (this.packet < 3) {
                if (this.takeHeader(op) < 0) {
                    Debug.log(1, "does not contain Theora video data.");
                    return ERROR;
                }
                if (this.packet == 2) {
                    this.ts.decodeInit(this.ti);
                    Debug.log(3, "theora dimension: " + this.ti.width + "x" + this.ti.height);
                    if (this.ti.aspect_denominator == 0) {
                        this.ti.aspect_numerator = 1;
                        this.ti.aspect_denominator = 1;
                    }
                    Debug.log(3, "theora offset: " + this.ti.offset_x + "," + this.ti.offset_y);
                    Debug.log(3, "theora frame: " + this.ti.frame_width + "," + this.ti.frame_height);
                    Debug.log(3, "theora aspect: " + this.ti.aspect_numerator + "/" + this.ti.aspect_denominator);
                    Debug.log(3, "theora framerate: " + this.ti.fps_numerator + "/" + this.ti.fps_denominator);
                }
                ++this.packet;
                return OK;
            }
            if ((op.packet_base[op.packet] & 0x80) == 128) {
                Debug.log(3, "ignoring header");
                return OK;
            }
            if (this.needKeyframe && this.ts.isKeyframe(op)) {
                this.needKeyframe = false;
            }
            if (!this.needKeyframe) {
                try {
                    if (this.ts.decodePacketin(op) != 0) {
                        Debug.log(1, "Bad Theora packet. Most likely not fatal, hoping for better luck next packet.");
                    }
                    if (this.ts.decodeYUVout(this.yuv) != 0) {
                        Debug.log(1, "Error getting the picture.");
                        return ERROR;
                    }
                    System.out.println("Decoded frame: " + ++this.frame);
                    return this.yuv.getObject(this.ti.offset_x, this.ti.offset_y, this.ti.frame_width, this.ti.frame_height);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    result = ERROR;
                }
            } else {
                result = OK;
            }
            ++this.packet;
            return result;
        }
    }
}

