/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.examples;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;

public class OggPerf {
    private static final int BUFFSIZE = 8192;
    private InputStream inputStream;
    private SyncState oy;
    private Vector streams;
    private boolean stopping;

    public OggPerf(InputStream is) {
        this.inputStream = is;
        this.oy = new SyncState();
        this.streams = new Vector();
        this.stopping = false;
    }

    public static void main(String[] args) {
        try {
            int run = 10;
            long start = System.currentTimeMillis();
            while (run-- > 0) {
                OggPerf perf = new OggPerf(new FileInputStream(args[0]));
                perf.start();
            }
            long end = System.currentTimeMillis();
            System.out.println("ellapsed: " + (end - start));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void start() {
        System.out.println("started ogg reader");
        Page og = new Page();
        Packet op = new Packet();
        try {
            int index;
            int read;
            while (!this.stopping && (read = this.inputStream.read(this.oy.data, index = this.oy.buffer(8192), 8192)) >= 0) {
                int res;
                this.oy.wrote(read);
                while (!this.stopping && (res = this.oy.pageout(og)) != 0) {
                    if (res == -1) continue;
                    int serial = og.serialno();
                    OggStream stream = null;
                    for (int i2 = 0; i2 < this.streams.size(); ++i2) {
                        stream = (OggStream)this.streams.elementAt(i2);
                        if (stream.serialno == serial) break;
                        stream = null;
                    }
                    if (stream == null) {
                        System.out.println("new stream " + serial);
                        stream = new OggStream(serial);
                        this.streams.addElement(stream);
                    }
                    if ((res = stream.os.pagein(og)) < 0) {
                        System.err.println("Error reading first page of Ogg bitstream data.");
                        return;
                    }
                    while (!this.stopping && (res = stream.os.packetout(op)) != 0) {
                        if (res == -1 || !stream.bos) continue;
                        if (op.packet_base[op.packet + 1] == 118) {
                            System.out.println("found vorbis audio");
                        } else if (op.packet_base[op.packet + 1] == 115) {
                            System.out.println("found smoke video");
                        } else if (op.packet_base[op.packet + 1] == 116) {
                            System.out.println("found theora video");
                        }
                        stream.bos = false;
                    }
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.stopping = true;
        }
        System.out.println("ogg reader done");
    }

    public void stop() {
        this.stopping = true;
    }

    class OggStream {
        public int serialno;
        public StreamState os;
        public boolean bos;

        public OggStream(int serial) {
            this.serialno = serial;
            this.os = new StreamState();
            this.os.init(serial);
            this.os.reset();
            this.bos = true;
        }
    }
}

