/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

public final class BlockMapping {
    private int[][][] blockMap;
    private static final int[] mbOrderMap = new int[]{0, 2, 3, 1};
    private static final int[][] blockOrderMap1 = new int[][]{{0, 1, 3, 2}, {0, 2, 3, 1}, {0, 2, 3, 1}, {3, 2, 0, 1}};

    public final int quadMapToIndex1(int sb, int mb, int b2) {
        return this.blockMap[sb][mbOrderMap[mb]][blockOrderMap1[mb][b2]];
    }

    public final int quadMapToMBTopLeft(int sb, int mb) {
        return this.blockMap[sb][mbOrderMap[mb]][0];
    }

    private void CreateMapping(int firstSB, int firstFrag, int hFrags, int vFrags) {
        int i2 = 0;
        int j2 = 0;
        int sb = firstSB;
        int fragIndex = firstFrag;
        int sBRows = (vFrags >> 2) + ((vFrags & 3) != 0 ? 1 : 0);
        int sBCols = (hFrags >> 2) + ((hFrags & 3) != 0 ? 1 : 0);
        for (int sBRow = 0; sBRow < sBRows; ++sBRow) {
            for (int sBCol = 0; sBCol < sBCols; ++sBCol) {
                int ypos = sBRow << 2;
                for (i2 = 0; i2 < 4 && ypos < vFrags; ++i2, ++ypos) {
                    int xpos = sBCol << 2;
                    for (j2 = 0; j2 < 4 && xpos < hFrags; ++j2, ++xpos) {
                        int mb = (i2 & 2) + ((j2 & 2) >> 1);
                        int B = ((i2 & 1) << 1) + (j2 & 1);
                        this.blockMap[sb][mb][B] = fragIndex++;
                    }
                    fragIndex += hFrags - j2;
                }
                ++sb;
                fragIndex -= i2 * hFrags - j2;
            }
            fragIndex += 3 * hFrags;
        }
    }

    public BlockMapping(int ySuperBlocks, int uvSuperBlocks, int hFrags, int vFrags, int shiftx, int shifty) {
        this.blockMap = new int[ySuperBlocks + uvSuperBlocks * 2][4][4];
        for (int i2 = 0; i2 < ySuperBlocks + uvSuperBlocks * 2; ++i2) {
            for (int j2 = 0; j2 < 4; ++j2) {
                this.blockMap[i2][j2][0] = -1;
                this.blockMap[i2][j2][1] = -1;
                this.blockMap[i2][j2][2] = -1;
                this.blockMap[i2][j2][3] = -1;
            }
        }
        this.CreateMapping(0, 0, hFrags, vFrags);
        this.CreateMapping(ySuperBlocks, hFrags * vFrags, hFrags >> shiftx, vFrags >> shifty);
        this.CreateMapping(ySuperBlocks + uvSuperBlocks, hFrags * vFrags + (hFrags >> shiftx) * (vFrags >> shifty), hFrags >> shiftx, vFrags >> shifty);
    }
}

