/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.Info;
import com.fluendo.jheora.Playback;
import com.fluendo.utils.MemUtils;

public final class Filter {
    private static final byte[] LoopFilterLimitValuesV1 = new byte[]{30, 25, 20, 20, 15, 15, 14, 14, 13, 13, 12, 12, 11, 11, 10, 10, 9, 9, 8, 8, 7, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] LoopFilterLimits = new byte[64];
    private int[] FiltBoundingValue = new int[512];

    private void SetupBoundingValueArray_Generic(int FLimit) {
        MemUtils.set(this.FiltBoundingValue, 0, 0, 512);
        for (int i2 = 0; i2 < FLimit; ++i2) {
            this.FiltBoundingValue[256 - i2 - FLimit] = -FLimit + i2;
            this.FiltBoundingValue[256 - i2] = -i2;
            this.FiltBoundingValue[256 + i2] = i2;
            this.FiltBoundingValue[256 + i2 + FLimit] = FLimit - i2;
        }
    }

    public void copyFilterTables(Info ci) {
        System.arraycopy(ci.LoopFilterLimitValues, 0, this.LoopFilterLimits, 0, 64);
    }

    public void InitFilterTables() {
        System.arraycopy(LoopFilterLimitValuesV1, 0, this.LoopFilterLimits, 0, 64);
    }

    public void SetupLoopFilter(int FrameQIndex) {
        byte FLimit = this.LoopFilterLimits[FrameQIndex];
        this.SetupBoundingValueArray_Generic(FLimit);
    }

    private static final short clamp255(int val) {
        return (short)(~(val >> 31) & 0xFF & (val | 255 - val >> 31));
    }

    private void FilterHoriz(short[] PixelPtr, int idx, int LineLength, int[] BoundingValuePtr) {
        for (int j2 = 0; j2 < 8; ++j2) {
            int FiltVal = PixelPtr[0 + idx] - PixelPtr[1 + idx] * 3 + PixelPtr[2 + idx] * 3 - PixelPtr[3 + idx];
            FiltVal = BoundingValuePtr[256 + (FiltVal + 4 >> 3)];
            PixelPtr[1 + idx] = Filter.clamp255(PixelPtr[1 + idx] + FiltVal);
            PixelPtr[2 + idx] = Filter.clamp255(PixelPtr[2 + idx] - FiltVal);
            idx += LineLength;
        }
    }

    private void FilterVert(short[] PixelPtr, int idx, int LineLength, int[] BoundingValuePtr) {
        idx -= 2 * LineLength;
        for (int j2 = 0; j2 < 8; ++j2) {
            int FiltVal = PixelPtr[idx + 0] - PixelPtr[idx + LineLength] * 3 + PixelPtr[idx + 2 * LineLength] * 3 - PixelPtr[idx + 3 * LineLength];
            FiltVal = BoundingValuePtr[256 + (FiltVal + 4 >> 3)];
            PixelPtr[idx + LineLength] = Filter.clamp255(PixelPtr[idx + LineLength] + FiltVal);
            PixelPtr[idx + 2 * LineLength] = Filter.clamp255(PixelPtr[idx + 2 * LineLength] - FiltVal);
            ++idx;
        }
    }

    public void LoopFilter(Playback pbi) {
        int FragsAcross = pbi.HFragments;
        int FragsDown = pbi.VFragments;
        int QIndex = pbi.frameQIS[0];
        byte FLimit = this.LoopFilterLimits[QIndex];
        if (FLimit == 0) {
            return;
        }
        this.SetupBoundingValueArray_Generic(FLimit);
        for (int j2 = 0; j2 < 3; ++j2) {
            int index;
            int n2;
            int LineFragments;
            int LineLength;
            int FromFragment;
            switch (j2) {
                case 0: {
                    FromFragment = 0;
                    FragsAcross = pbi.HFragments;
                    FragsDown = pbi.VFragments;
                    LineLength = pbi.YStride;
                    LineFragments = pbi.HFragments;
                    break;
                }
                case 1: {
                    FromFragment = pbi.YPlaneFragments;
                    FragsAcross = pbi.HFragments >> 1;
                    FragsDown = pbi.VFragments >> 1;
                    LineLength = pbi.UVStride;
                    LineFragments = pbi.HFragments / 2;
                    break;
                }
                default: {
                    FromFragment = pbi.YPlaneFragments + pbi.UVPlaneFragments;
                    FragsAcross = pbi.HFragments >> 1;
                    FragsDown = pbi.VFragments >> 1;
                    LineLength = pbi.UVStride;
                    LineFragments = pbi.HFragments / 2;
                }
            }
            int i2 = FromFragment;
            if (pbi.display_fragments[i2] != 0) {
                if (pbi.display_fragments[i2 + 1] == 0) {
                    this.FilterHoriz(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i2] + 6, LineLength, this.FiltBoundingValue);
                }
                if (pbi.display_fragments[i2 + LineFragments] == 0) {
                    this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i2 + LineFragments], LineLength, this.FiltBoundingValue);
                }
            }
            ++i2;
            for (n2 = 1; n2 < FragsAcross - 1; ++n2) {
                if (pbi.display_fragments[i2] != 0) {
                    index = pbi.recon_pixel_index_table[i2];
                    this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i2 + 1] == 0) {
                        this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                    }
                    if (pbi.display_fragments[i2 + LineFragments] == 0) {
                        this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i2 + LineFragments], LineLength, this.FiltBoundingValue);
                    }
                }
                ++i2;
            }
            if (pbi.display_fragments[i2] != 0) {
                this.FilterHoriz(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i2] - 2, LineLength, this.FiltBoundingValue);
                if (pbi.display_fragments[i2 + LineFragments] == 0) {
                    this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i2 + LineFragments], LineLength, this.FiltBoundingValue);
                }
            }
            ++i2;
            for (int m2 = 1; m2 < FragsDown - 1; ++m2) {
                if (pbi.display_fragments[i2] != 0) {
                    index = pbi.recon_pixel_index_table[i2];
                    this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i2 + 1] == 0) {
                        this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                    }
                    if (pbi.display_fragments[i2 + LineFragments] == 0) {
                        this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i2 + LineFragments], LineLength, this.FiltBoundingValue);
                    }
                }
                ++i2;
                n2 = 1;
                while (n2 < FragsAcross - 1) {
                    if (pbi.display_fragments[i2] != 0) {
                        index = pbi.recon_pixel_index_table[i2];
                        this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                        this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                        if (pbi.display_fragments[i2 + 1] == 0) {
                            this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                        }
                        if (pbi.display_fragments[i2 + LineFragments] == 0) {
                            this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i2 + LineFragments], LineLength, this.FiltBoundingValue);
                        }
                    }
                    ++n2;
                    ++i2;
                }
                if (pbi.display_fragments[i2] != 0) {
                    index = pbi.recon_pixel_index_table[i2];
                    this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                    this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i2 + LineFragments] == 0) {
                        this.FilterVert(pbi.LastFrameRecon, pbi.recon_pixel_index_table[i2 + LineFragments], LineLength, this.FiltBoundingValue);
                    }
                }
                ++i2;
            }
            if (pbi.display_fragments[i2] != 0) {
                index = pbi.recon_pixel_index_table[i2];
                this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                if (pbi.display_fragments[i2 + 1] == 0) {
                    this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                }
            }
            ++i2;
            n2 = 1;
            while (n2 < FragsAcross - 1) {
                if (pbi.display_fragments[i2] != 0) {
                    index = pbi.recon_pixel_index_table[i2];
                    this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
                    this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
                    if (pbi.display_fragments[i2 + 1] == 0) {
                        this.FilterHoriz(pbi.LastFrameRecon, index + 6, LineLength, this.FiltBoundingValue);
                    }
                }
                ++n2;
                ++i2;
            }
            if (pbi.display_fragments[i2] == 0) continue;
            index = pbi.recon_pixel_index_table[i2];
            this.FilterHoriz(pbi.LastFrameRecon, index - 2, LineLength, this.FiltBoundingValue);
            this.FilterVert(pbi.LastFrameRecon, index, LineLength, this.FiltBoundingValue);
        }
    }
}

