/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;

public class YUVBuffer
implements ImageProducer {
    public int y_width;
    public int y_height;
    public int y_stride;
    public int uv_width;
    public int uv_height;
    public int uv_stride;
    public short[] data;
    public int y_offset;
    public int u_offset;
    public int v_offset;
    private int[] pixels;
    private int pix_size;
    private boolean newPixels = true;
    private ColorModel colorModel = ColorModel.getRGBdefault();
    private ImageProducer filteredThis;
    private int crop_x;
    private int crop_y;
    private int crop_w;
    private int crop_h;

    public void addConsumer(ImageConsumer ic) {
    }

    public boolean isConsumer(ImageConsumer ic) {
        return false;
    }

    public void removeConsumer(ImageConsumer ic) {
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    public void startProduction(ImageConsumer ic) {
        ic.setColorModel(this.colorModel);
        ic.setHints(30);
        ic.setDimensions(this.y_width, this.y_height);
        this.prepareRGBData(0, 0, this.y_width, this.y_height);
        ic.setPixels(0, 0, this.y_width, this.y_height, this.colorModel, this.pixels, 0, this.y_width);
        ic.imageComplete(3);
    }

    private synchronized void prepareRGBData(int x2, int y2, int width, int height) {
        if (!this.newPixels) {
            return;
        }
        int size = width * height;
        try {
            if (size != this.pix_size) {
                this.pixels = new int[size];
                this.pix_size = size;
            }
            if (this.uv_height < this.y_height) {
                this.YUV420toRGB(x2, y2, width, height);
            } else if (this.uv_width == this.y_width) {
                this.YUV444toRGB(x2, y2, width, height);
            } else {
                this.YUV422toRGB(x2, y2, width, height);
            }
        }
        catch (Throwable t2) {
            // empty catch block
        }
        this.newPixels = false;
    }

    public synchronized void newPixels() {
        this.newPixels = true;
    }

    public Object getObject(int x2, int y2, int width, int height) {
        if (x2 == 0 && y2 == 0 && width == this.y_width && height == this.y_height) {
            return this;
        }
        if (x2 != this.crop_x || y2 != this.crop_y || width != this.crop_w || height != this.crop_h) {
            this.crop_x = x2;
            this.crop_y = y2;
            this.crop_w = width;
            this.crop_h = height;
            CropImageFilter cropFilter = new CropImageFilter(this.crop_x, this.crop_y, this.crop_w, this.crop_h);
            this.filteredThis = new FilteredImageSource(this, cropFilter);
        }
        return this.filteredThis;
    }

    private void YUV420toRGB(int x2, int y2, int width, int height) {
        int YPtr = this.y_offset + x2 + y2 * this.y_stride;
        int YPtr2 = YPtr + this.y_stride;
        int UPtr = this.u_offset + x2 / 2 + y2 / 2 * this.uv_stride;
        int VPtr = this.v_offset + x2 / 2 + y2 / 2 * this.uv_stride;
        int RGBPtr = 0;
        int RGBPtr2 = width;
        int width2 = width / 2;
        int height2 = height / 2;
        int YStep = this.y_stride * 2 - width2 * 2;
        int UVStep = this.uv_stride - width2;
        int RGBStep = width;
        for (int i2 = 0; i2 < height2; ++i2) {
            for (int j2 = 0; j2 < width2; ++j2) {
                short D = this.data[UPtr++];
                short E = this.data[VPtr++];
                int t1 = 298 * (this.data[YPtr] - 16);
                int t2 = 409 * E - 52352 + 128;
                int t3 = 100 * D + 208 * E - 12800 - 26624 - 128;
                int t4 = 516 * D - 66048 + 128;
                int r2 = t1 + t2;
                int g2 = t1 - t3;
                int b2 = t1 + t4;
                t1 = 298 * (this.data[YPtr + 1] - 16);
                this.pixels[RGBPtr] = YUVBuffer.clamp65280(r2) << 8 | YUVBuffer.clamp65280(g2) | YUVBuffer.clamp65280(b2) >> 8 | 0xFF000000;
                r2 = t1 + t2;
                g2 = t1 - t3;
                b2 = t1 + t4;
                t1 = 298 * (this.data[YPtr2] - 16);
                this.pixels[RGBPtr + 1] = YUVBuffer.clamp65280(r2) << 8 | YUVBuffer.clamp65280(g2) | YUVBuffer.clamp65280(b2) >> 8 | 0xFF000000;
                r2 = t1 + t2;
                g2 = t1 - t3;
                b2 = t1 + t4;
                t1 = 298 * (this.data[YPtr2 + 1] - 16);
                this.pixels[RGBPtr2] = YUVBuffer.clamp65280(r2) << 8 | YUVBuffer.clamp65280(g2) | YUVBuffer.clamp65280(b2) >> 8 | 0xFF000000;
                r2 = t1 + t2;
                g2 = t1 - t3;
                b2 = t1 + t4;
                this.pixels[RGBPtr2 + 1] = YUVBuffer.clamp65280(r2) << 8 | YUVBuffer.clamp65280(g2) | YUVBuffer.clamp65280(b2) >> 8 | 0xFF000000;
                YPtr += 2;
                YPtr2 += 2;
                RGBPtr += 2;
                RGBPtr2 += 2;
            }
            YPtr += YStep;
            YPtr2 += YStep;
            UPtr += UVStep;
            VPtr += UVStep;
            RGBPtr += RGBStep;
            RGBPtr2 += RGBStep;
        }
    }

    private static final int clamp65280(int val) {
        return ~(val >> 31) & 0xFF00 & (val | 65280 - val >> 31);
    }

    private void YUV444toRGB(int x2, int y2, int width, int height) {
        for (int j2 = 0; j2 < height; ++j2) {
            for (int i2 = 0; i2 < width; ++i2) {
                int p2 = x2 + i2 + (j2 + y2) * this.y_stride;
                short D = this.data[this.u_offset + p2];
                short E = this.data[this.v_offset + p2];
                int t1 = 298 * (this.data[this.y_offset + p2] - 16);
                int t2 = 409 * E - 52352 + 128;
                int t3 = 100 * D + 208 * E - 12800 - 26624 - 128;
                int t4 = 516 * D - 66048 + 128;
                int r2 = t1 + t2;
                int g2 = t1 - t3;
                int b2 = t1 + t4;
                this.pixels[i2 + j2 * width] = YUVBuffer.clamp65280(r2) << 8 | YUVBuffer.clamp65280(g2) | YUVBuffer.clamp65280(b2) >> 8 | 0xFF000000;
            }
        }
    }

    private void YUV422toRGB(int x2, int y2, int width, int height) {
        int x22 = x2 / 2;
        int width2 = width / 2;
        for (int j2 = 0; j2 < height; ++j2) {
            for (int i2 = 0; i2 < width2; ++i2) {
                int p2 = x22 + i2 + (y2 + j2) * this.uv_stride;
                short D = this.data[this.u_offset + p2];
                short E = this.data[this.v_offset + p2];
                p2 = this.y_offset + 2 * (x22 + i2) + (y2 + j2) * this.y_stride;
                int t1 = 298 * (this.data[p2] - 16);
                int t2 = 409 * E - 52352 + 128;
                int t3 = 100 * D + 208 * E - 12800 - 26624 - 128;
                int t4 = 516 * D - 66048 + 128;
                int r2 = t1 + t2;
                int g2 = t1 - t3;
                int b2 = t1 + t4;
                t1 = 298 * (this.data[++p2] - 16);
                p2 = 2 * i2 + j2 * width;
                this.pixels[p2] = YUVBuffer.clamp65280(r2) << 8 | YUVBuffer.clamp65280(g2) | YUVBuffer.clamp65280(b2) >> 8 | 0xFF000000;
                r2 = t1 + t2;
                g2 = t1 - t3;
                b2 = t1 + t4;
                this.pixels[++p2] = YUVBuffer.clamp65280(r2) << 8 | YUVBuffer.clamp65280(g2) | YUVBuffer.clamp65280(b2) >> 8 | 0xFF000000;
            }
        }
    }
}

