/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jkate;

import com.jcraft.jogg.Buffer;

public class Bitwise {
    private static final int fp_bits = 32;
    private static final int fp_cuts_bits_bits = 4;

    static void readbuf(Buffer opb, byte[] buf, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            buf[i2] = (byte)opb.read(8);
        }
    }

    static int read32(Buffer opb) {
        int value = opb.read(8);
        value |= opb.read(8) << 8;
        value |= opb.read(8) << 16;
        return value |= opb.read(8) << 24;
    }

    static int read32v(Buffer opb) {
        int value = opb.read(4);
        if (value == 15) {
            int sign = opb.read(1);
            int bits = opb.read(5) + 1;
            value = opb.read(bits);
            if (sign != 0) {
                value = -value;
            }
        }
        return value;
    }

    static long read64(Buffer opb) {
        long vl = Bitwise.read32(opb);
        long vh = Bitwise.read32(opb);
        return vl | vh << 32;
    }

    static int skipWarp(Buffer opb) {
        int bits;
        while ((bits = Bitwise.read32v(opb)) != 0) {
            if (bits < 0) {
                return -6;
            }
            opb.adv(bits);
        }
        return 0;
    }

    private static int[] readFixed(Buffer opb, int count) {
        int head = opb.read(4);
        int tail = opb.read(4);
        int bits = 32 - head - tail;
        int[] values = new int[count];
        int n2 = 0;
        while (count-- > 0) {
            int sign = 0;
            if (head > 0) {
                sign = opb.read1();
            }
            int v2 = opb.read(bits);
            v2 <<= tail;
            if (sign != 0) {
                v2 = -v2;
            }
            values[n2++] = v2;
        }
        return values;
    }

    private static double fixedToFloat(int v2) {
        return (double)v2 / 65536.0;
    }

    static double[][] readFloats(Buffer opb, int count, int streams) {
        if (count * streams == 0) {
            return null;
        }
        if (streams > 1 && opb.read1() != 0) {
            count *= streams;
            streams = 1;
        }
        double[][] values = new double[streams][];
        for (int s2 = 0; s2 < streams; ++s2) {
            int[] ints = Bitwise.readFixed(opb, count);
            values[s2] = new double[count];
            for (int c2 = 0; c2 < count; ++c2) {
                values[s2][c2] = Bitwise.fixedToFloat(ints[c2]);
            }
        }
        return values;
    }
}

