/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jkate;

import com.jcraft.jogg.Buffer;

public class RLE {
    private static final int KATE_RLE_RUN_LENGTH_BITS_BASIC = 4;
    private static final int KATE_RLE_RUN_LENGTH_BITS_BASIC_IN_DELTA = 3;
    private static final int KATE_RLE_RUN_LENGTH_BITS_BASIC_STARTEND = 3;
    private static final int KATE_RLE_RUN_LENGTH_BITS_BASIC_STOP = 6;
    private static final int KATE_RLE_RUN_LENGTH_BITS_DELTA = 6;
    private static final int KATE_RLE_RUN_LENGTH_BITS_BASIC_STARTEND_START = 9;
    private static final int KATE_RLE_RUN_LENGTH_BITS_BASIC_STARTEND_END = 8;
    private static final int KATE_RLE_RUN_LENGTH_BITS_BASIC_STOP_START = 8;
    private static final int KATE_RLE_RUN_LENGTH_BITS_BASIC_IN_DELTA_STOP = 3;
    private static final int KATE_RLE_RUN_LENGTH_BITS_DELTA_STOP = 5;
    private static final int KATE_RLE_RUN_LENGTH_BITS_BASIC_ZERO = 8;
    private static final int KATE_RLE_RUN_LENGTH_BITS_BASIC_NON_ZERO = 3;
    private static final int KATE_RLE_TYPE_EMPTY = 0;
    private static final int KATE_RLE_TYPE_BASIC = 1;
    private static final int KATE_RLE_TYPE_DELTA = 2;
    private static final int KATE_RLE_TYPE_BASIC_STOP = 3;
    private static final int KATE_RLE_TYPE_BASIC_STARTEND = 4;
    private static final int KATE_RLE_TYPE_DELTA_STOP = 5;
    private static final int KATE_RLE_TYPE_BASIC_ZERO = 6;
    private static final int KATE_RLE_TYPE_BITS = 3;

    private static int decodeLineEmpty(Buffer opb, int width, byte[] pixels, int offset, int bits, byte zero) {
        for (int n2 = 0; n2 < width; ++n2) {
            pixels[offset + n2] = zero;
        }
        return 0;
    }

    private static int decodeLineBasic(Buffer opb, int width, byte[] pixels, int offset, int bits, byte zero) {
        int run_length;
        int run_length_bits = 4;
        int p2 = 0;
        for (int count = width; count > 0; count -= run_length) {
            run_length = 1 + opb.read(4);
            if (run_length == 0 || run_length > count) {
                return -1;
            }
            byte value = (byte)opb.read(bits);
            for (int n2 = 0; n2 < run_length; ++n2) {
                pixels[offset + p2++] = value;
            }
        }
        return 0;
    }

    private static int decodeLineDelta(Buffer opb, int width, byte[] pixels, int offset, int bits, byte zero) {
        int run_length_delta_bits = 6;
        int run_length_basic_bits = 3;
        int p2 = 0;
        int count = width;
        while (count > 0) {
            int run_length;
            int type = opb.read1();
            if (type != 0) {
                int n2;
                run_length = 1 + opb.read(6);
                if (run_length == 0 || run_length > count) {
                    return -1;
                }
                if (offset > 0) {
                    for (n2 = 0; n2 < run_length; ++n2) {
                        pixels[offset + p2] = pixels[offset + p2 - width];
                        ++p2;
                    }
                } else {
                    for (n2 = 0; n2 < run_length; ++n2) {
                        pixels[offset + p2++] = zero;
                    }
                }
                count -= run_length;
                continue;
            }
            run_length = 1 + opb.read(3);
            if (run_length == 0 || run_length > count) {
                return -1;
            }
            byte value = (byte)opb.read(bits);
            for (int n3 = 0; n3 < run_length; ++n3) {
                pixels[offset + p2++] = value;
            }
            count -= run_length;
        }
        return 0;
    }

    private static int decodeLineBasicStartEnd(Buffer opb, int width, byte[] pixels, int offset, int bits, byte zero) {
        int n2;
        int run_length_bits = 3;
        int count = width;
        int p2 = 0;
        int run_length = opb.read(9);
        if (run_length > 0) {
            if (run_length > count) {
                return -1;
            }
            for (n2 = 0; n2 < run_length; ++n2) {
                pixels[offset + p2++] = zero;
            }
            count -= run_length;
        }
        if ((run_length = opb.read(8)) > 0) {
            if (run_length > count) {
                return -1;
            }
            for (n2 = 0; n2 < run_length; ++n2) {
                pixels[offset + width - 1 - n2] = zero;
            }
            count -= run_length;
        }
        while (count > 0) {
            run_length = 1 + opb.read(3);
            if (run_length == 0 || run_length > count) {
                return -1;
            }
            byte value = (byte)opb.read(bits);
            for (int n3 = 0; n3 < run_length; ++n3) {
                pixels[offset + p2++] = value;
            }
            count -= run_length;
        }
        return 0;
    }

    private static int decodeLineBasicStop(Buffer opb, int width, byte[] pixels, int offset, int bits, byte zero) {
        int n2;
        int run_length_bits = 6;
        int count = width;
        int p2 = 0;
        int run_length = opb.read(8);
        if (run_length > 0) {
            if (run_length > count) {
                return -1;
            }
            for (n2 = 0; n2 < run_length; ++n2) {
                pixels[offset + p2++] = zero;
            }
            count -= run_length;
        }
        while (count > 0) {
            run_length = opb.read(6);
            if (run_length > count) {
                return -1;
            }
            if (run_length == 0) {
                for (n2 = 0; n2 < run_length; ++n2) {
                    pixels[offset + p2++] = zero;
                }
                break;
            }
            byte value = (byte)opb.read(bits);
            for (int n3 = 0; n3 < run_length; ++n3) {
                pixels[offset + p2++] = value;
            }
            count -= run_length;
        }
        return 0;
    }

    private static int decodeLineDeltaStop(Buffer opb, int width, byte[] pixels, int offset, int bits, byte zero) {
        int run_length;
        int run_length_delta_bits = 5;
        int run_length_basic_bits = 3;
        int p2 = 0;
        for (int count = width; count > 0; count -= run_length) {
            int n2;
            int type = opb.read1();
            if (type != 0) {
                run_length = 1 + opb.read(5);
                if (run_length == 0 || run_length > count) {
                    return -1;
                }
                if (offset > 0) {
                    for (n2 = 0; n2 < run_length; ++n2) {
                        pixels[offset + p2] = pixels[offset + p2 - width];
                        ++p2;
                    }
                    continue;
                }
                for (n2 = 0; n2 < run_length; ++n2) {
                    pixels[offset + p2++] = zero;
                }
                continue;
            }
            run_length = opb.read(3);
            if (run_length == 0) {
                for (n2 = 0; n2 < run_length; ++n2) {
                    pixels[offset + p2++] = zero;
                }
                break;
            }
            if (run_length > count) {
                return -1;
            }
            byte value = (byte)opb.read(bits);
            for (int n3 = 0; n3 < run_length; ++n3) {
                pixels[offset + p2++] = value;
            }
        }
        return 0;
    }

    private static int decodeLineBasicZero(Buffer opb, int width, byte[] pixels, int offset, int bits, byte zero) {
        int run_length;
        int run_length_bits_zero = 8;
        int run_length_bits_non_zero = 3;
        int p2 = 0;
        for (int count = width; count > 0; count -= run_length) {
            byte value = (byte)opb.read(bits);
            run_length = value == zero ? 1 + opb.read(8) : 1 + opb.read(3);
            if (run_length == 0 || run_length > count) {
                return -1;
            }
            for (int n2 = 0; n2 < run_length; ++n2) {
                pixels[offset + p2++] = value;
            }
        }
        return 0;
    }

    public static byte[] decodeRLE(Buffer opb, int width, int height, int bpp) {
        byte[] pixels = new byte[width * height];
        int offset = 0;
        byte zero = (byte)opb.read(bpp);
        while (height > 0) {
            int ret;
            int type = opb.read(3);
            switch (type) {
                case 0: {
                    ret = RLE.decodeLineEmpty(opb, width, pixels, offset, bpp, zero);
                    break;
                }
                case 2: {
                    ret = RLE.decodeLineDelta(opb, width, pixels, offset, bpp, zero);
                    break;
                }
                case 1: {
                    ret = RLE.decodeLineBasic(opb, width, pixels, offset, bpp, zero);
                    break;
                }
                case 4: {
                    ret = RLE.decodeLineBasicStartEnd(opb, width, pixels, offset, bpp, zero);
                    break;
                }
                case 3: {
                    ret = RLE.decodeLineBasicStop(opb, width, pixels, offset, bpp, zero);
                    break;
                }
                case 5: {
                    ret = RLE.decodeLineDeltaStop(opb, width, pixels, offset, bpp, zero);
                    break;
                }
                case 6: {
                    ret = RLE.decodeLineBasicZero(opb, width, pixels, offset, bpp, zero);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (ret != 0) {
                return null;
            }
            offset += width;
            --height;
        }
        return pixels;
    }
}

