/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Bus;
import com.fluendo.jst.Clock;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Object;
import com.fluendo.jst.Pad;
import com.fluendo.jst.PadListener;
import com.fluendo.jst.Query;
import com.fluendo.utils.Debug;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Element
extends Object {
    public static final int FLAG_IS_SINK = 32;
    public static final int ELEMENT_FLAG_LAST = 0x100000;
    protected Vector pads = new Vector();
    protected java.lang.Object stateLock = new java.lang.Object();
    private Vector padListeners = new Vector();
    protected Clock clock;
    protected Bus bus;
    protected long baseTime;
    public static final int NONE = 0;
    public static final int STOP = 1;
    public static final int PAUSE = 2;
    public static final int PLAY = 3;
    protected static String[] stateNames = new String[]{"none", "stop", "pause", "play"};
    private static final int SHIFT = 4;
    private static final int MASK = 15;
    public static final int STOP_PAUSE = 18;
    public static final int PAUSE_PLAY = 35;
    public static final int PLAY_PAUSE = 50;
    public static final int PAUSE_STOP = 33;
    public static final int FAILURE = 0;
    public static final int SUCCESS = 1;
    public static final int ASYNC = 2;
    public static final int NO_PREROLL = 3;
    public static String[] stateReturnNames = new String[]{"FAILURE", "SUCCESS", "ASYNC", "NO_PREROLL"};
    protected int currentState = 1;
    protected int nextState = 0;
    protected int pendingState = 0;
    protected int lastReturn = 1;

    public static String getStateName(int state) {
        return stateNames[state];
    }

    public static String getStateReturnName(int ret) {
        return stateReturnNames[ret];
    }

    public String getMime() {
        return null;
    }

    public abstract String getFactoryName();

    public int typeFind(byte[] data, int offset, int length) {
        return -1;
    }

    public Element() {
        this(null);
    }

    public Element(String name) {
        super(name);
    }

    public String toString() {
        return "Element: [" + this.getName() + "]";
    }

    public synchronized void setClock(Clock newClock) {
        Debug.debug(this + ".setClock(" + newClock + ")");
        this.clock = newClock;
    }

    public synchronized Clock getClock() {
        return this.clock;
    }

    public synchronized void setBus(Bus newBus) {
        this.bus = newBus;
    }

    public synchronized Bus getBus() {
        return this.bus;
    }

    public synchronized void addPadListener(PadListener listener) {
        this.padListeners.addElement(listener);
    }

    public synchronized void removePadListener(PadListener listener) {
        this.padListeners.removeElement(listener);
    }

    private synchronized void doPadListeners(int method, Pad pad) {
        Enumeration e2 = this.padListeners.elements();
        while (e2.hasMoreElements()) {
            PadListener listener = (PadListener)e2.nextElement();
            switch (method) {
                case 0: {
                    listener.padAdded(pad);
                    break;
                }
                case 1: {
                    listener.padRemoved(pad);
                    break;
                }
                case 2: {
                    listener.noMorePads();
                }
            }
        }
    }

    public synchronized Pad getPad(String name) {
        Enumeration e2 = this.pads.elements();
        while (e2.hasMoreElements()) {
            Pad pad = (Pad)e2.nextElement();
            if (!name.equals(pad.getName())) continue;
            return pad;
        }
        return null;
    }

    public synchronized boolean addPad(Pad newPad) {
        if (!newPad.setParent(this)) {
            return false;
        }
        this.pads.addElement(newPad);
        this.doPadListeners(0, newPad);
        return true;
    }

    public synchronized boolean removePad(Pad aPad) {
        if (aPad.getParent() != this) {
            return false;
        }
        aPad.unParent();
        this.pads.removeElement(aPad);
        this.doPadListeners(1, aPad);
        return true;
    }

    public synchronized void noMorePads() {
        this.doPadListeners(2, null);
    }

    public Enumeration enumPads() {
        return this.pads.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMessage(Message message) {
        Bus myBus;
        Element element = this;
        synchronized (element) {
            myBus = this.bus;
        }
        if (myBus != null) {
            myBus.post(message);
        }
    }

    public synchronized int getState(int[] resState, int[] resPending, long timeout) {
        if (this.lastReturn == 2 && this.pendingState != 0) {
            long t2 = timeout == 0L ? 0L : (timeout < 1000L ? 1L : timeout / 1000L);
            try {
                this.wait(t2);
            }
            catch (InterruptedException e2) {
                // empty catch block
            }
        }
        if (resState != null) {
            resState[0] = this.currentState;
        }
        if (resPending != null) {
            resPending[0] = this.pendingState;
        }
        return this.lastReturn;
    }

    private boolean padsActivate(boolean active) {
        int mode = active ? 1 : 0;
        boolean res = true;
        Enumeration e2 = this.pads.elements();
        while (e2.hasMoreElements()) {
            Pad pad = (Pad)e2.nextElement();
            if (res &= pad.activate(mode)) continue;
            return res;
        }
        return res;
    }

    public int getStateNext(int current, int pending) {
        int sign = pending - current;
        sign = sign > 0 ? 1 : (sign < 0 ? -1 : 0);
        return current + sign;
    }

    public int getTransition(int current, int next) {
        return current << 4 | next;
    }

    public int getTransitionCurrent(int transition) {
        return transition >> 4;
    }

    public int getTransitionNext(int transition) {
        return transition & 0xF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int continueState(int result) {
        Message message = null;
        int transition = 0;
        Element element = this;
        synchronized (element) {
            int oldRet = this.lastReturn;
            this.lastReturn = result;
            int pending = this.pendingState;
            if (pending == 0) {
                return result;
            }
            int oldState = this.currentState;
            int oldNext = this.nextState;
            this.currentState = oldNext;
            int current = this.currentState;
            if (pending == current) {
                this.pendingState = 0;
                this.nextState = 0;
                transition = 0;
                if (oldState != oldNext || oldRet == 2) {
                    message = Message.newStateChanged(this, oldState, oldNext, pending);
                }
            } else {
                int next = this.getStateNext(current, pending);
                transition = this.getTransition(current, next);
                this.nextState = next;
                this.lastReturn = 2;
                message = Message.newStateChanged(this, oldState, oldNext, pending);
            }
        }
        if (message != null) {
            this.postMessage(message);
        }
        if (transition != 0) {
            result = this.doChangeState(transition);
        } else {
            element = this;
            synchronized (element) {
                this.notifyAll();
            }
        }
        return result;
    }

    public synchronized void abortState() {
        if (this.pendingState != 0 && this.lastReturn != 0) {
            this.lastReturn = 0;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lostState() {
        boolean post = false;
        int current = 0;
        Element element = this;
        synchronized (element) {
            if (this.pendingState == 0 && this.lastReturn != 0) {
                current = this.currentState;
                this.pendingState = this.nextState = this.currentState;
                this.lastReturn = 2;
                post = true;
            }
        }
        if (post) {
            this.postMessage(Message.newStateChanged(this, current, current, current));
            this.postMessage(Message.newStateDirty(this));
        }
    }

    protected int changeState(int transition) {
        boolean res;
        int current = this.getTransitionCurrent(transition);
        int next = this.getTransitionNext(transition);
        if (next == 0 || current == next) {
            return this.lastReturn;
        }
        switch (transition) {
            case 18: {
                res = this.padsActivate(true);
                break;
            }
            case 35: {
                res = true;
                break;
            }
            case 50: {
                res = true;
                break;
            }
            case 33: {
                res = this.padsActivate(false);
                break;
            }
            default: {
                res = false;
            }
        }
        if (res) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doChangeState(int transition) {
        int current = this.getTransitionCurrent(transition);
        int next = this.getTransitionNext(transition);
        int result = this.changeState(transition);
        switch (result) {
            case 0: {
                this.abortState();
                break;
            }
            case 1: 
            case 3: {
                result = this.continueState(result);
                break;
            }
            case 2: {
                if (current < next) {
                    Element element = this;
                    synchronized (element) {
                        if (this.pendingState != 0) {
                            this.lastReturn = result;
                        }
                        break;
                    }
                }
                result = this.continueState(1);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int setState(int newState) {
        int result;
        java.lang.Object object = this.stateLock;
        synchronized (object) {
            int transition;
            Element element = this;
            synchronized (element) {
                if (this.lastReturn == 0) {
                    this.nextState = 0;
                    this.pendingState = 0;
                    this.lastReturn = 1;
                }
                int oldPending = this.pendingState;
                this.pendingState = newState;
                if (oldPending != 0) {
                    if (oldPending <= newState) {
                        this.lastReturn = 2;
                        return 2;
                    }
                    if (this.nextState == newState) {
                        this.lastReturn = 2;
                        return 2;
                    }
                    if (this.nextState > newState && this.lastReturn == 2) {
                        this.currentState = this.nextState;
                    }
                }
                this.nextState = this.getStateNext(this.currentState, newState);
                transition = this.getTransition(this.currentState, this.nextState);
            }
            result = this.doChangeState(transition);
        }
        return result;
    }

    public boolean sendEvent(Event event) {
        return false;
    }

    public boolean query(Query query) {
        return false;
    }

    public Pad requestSinkPad(Pad peer) {
        return null;
    }
}

