/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

public class Event {
    public static final int FLUSH_START = 1;
    public static final int FLUSH_STOP = 2;
    public static final int EOS = 3;
    public static final int NEWSEGMENT = 4;
    public static final int SEEK = 5;
    private static String[] typeNames = new String[]{"NULL", "FLUSH_START", "FLUSH_STOP", "EOS", "NEWSEGMENT", "SEEK"};
    private int type;
    private int format;
    private boolean update;
    private long start;
    private long stop;
    private long position = -1L;

    private Event(int type) {
        this.type = type;
    }

    public String toString() {
        String typeName = typeNames[this.type];
        switch (this.type) {
            case 5: {
                return "[Event] type: " + typeName + ", format: " + this.format + ", position: " + this.position;
            }
            case 4: {
                return "[Event] type: " + typeName + (this.update ? ", update" : ", non-update") + ", format: " + this.format + ", start: " + this.start + ", stop: " + this.stop + ", position: " + this.position;
            }
        }
        return "[Event] type: " + typeName;
    }

    public int getType() {
        return this.type;
    }

    public static Event newEOS() {
        return new Event(3);
    }

    public static Event newFlushStart() {
        return new Event(1);
    }

    public static Event newFlushStop() {
        return new Event(2);
    }

    public static Event newSeek(int format, long position) {
        Event e2 = new Event(5);
        e2.format = format;
        e2.position = position;
        return e2;
    }

    public long parseSeekPosition() {
        return this.position;
    }

    public int parseSeekFormat() {
        return this.format;
    }

    public static Event newNewsegment(boolean update, int format, long start, long stop, long position) {
        Event e2 = new Event(4);
        e2.update = update;
        e2.format = format;
        e2.start = start;
        e2.stop = stop;
        e2.position = position;
        return e2;
    }

    public boolean parseNewsegmentUpdate() {
        return this.update;
    }

    public int parseNewsegmentFormat() {
        return this.format;
    }

    public long parseNewsegmentStart() {
        return this.start;
    }

    public long parseNewsegmentStop() {
        return this.stop;
    }

    public long parseNewsegmentPosition() {
        return this.position;
    }
}

