/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Bus;
import com.fluendo.jst.BusSyncHandler;
import com.fluendo.jst.Clock;
import com.fluendo.jst.ClockProvider;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Object;
import com.fluendo.jst.Pad;
import com.fluendo.jst.Query;
import com.fluendo.jst.SystemClock;
import com.fluendo.utils.Debug;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class Pipeline
extends Element
implements BusSyncHandler {
    protected Vector elements = new Vector();
    protected Clock defClock;
    protected Clock fixedClock = null;
    protected Element clockProvider = null;
    protected Vector messages = new Vector();
    protected Bus internalBus;
    private BusThread busThread;
    private StateThread stateThread;
    private boolean stateDirty = false;
    private boolean polling = false;
    protected long streamTime;

    public Pipeline() {
        this(null);
    }

    public String getFactoryName() {
        return "pipeline";
    }

    public Pipeline(String name) {
        super(name);
        this.defClock = new SystemClock();
        this.internalBus = new Bus();
        this.internalBus.setSyncHandler(this);
        this.bus = new Bus();
        this.busThread = new BusThread(this.bus);
        this.busThread.start();
        this.stateThread = new StateThread();
        this.stateThread.start();
    }

    public synchronized void shutDown() {
        if (this.stateThread != null) {
            this.stateThread.shutDown();
            this.stateThread = null;
        }
        if (this.busThread != null) {
            this.busThread.shutDown();
            this.busThread = null;
        }
    }

    public void useClock(Clock clock) {
        this.fixedClock = clock;
    }

    public boolean add(Element elem) {
        if (elem == null) {
            return false;
        }
        if (elem instanceof ClockProvider) {
            this.defClock = ((ClockProvider)((java.lang.Object)elem)).provideClock();
            this.clockProvider = elem;
        }
        this.elements.addElement(elem);
        elem.baseTime = this.baseTime;
        elem.setBus(this.internalBus);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Element elem) {
        if (elem == null) {
            return false;
        }
        boolean res = this.elements.removeElement(elem);
        if (res) {
            if (elem == this.clockProvider) {
                this.defClock = new SystemClock();
                this.clockProvider = null;
            }
            elem.setBus(null);
            elem.setClock(null);
            Pipeline pipeline = this;
            synchronized (pipeline) {
                this.stateDirty = true;
            }
        }
        return res;
    }

    public Enumeration enumElements() {
        return this.elements.elements();
    }

    public Enumeration enumSorted() {
        return new SortedEnumerator();
    }

    public Enumeration enumSinks() {
        return new SinkEnumerator();
    }

    private void replaceMessage(Message message, int type) {
        int len = this.messages.size();
        Object src = message.getSrc();
        for (int i2 = 0; i2 < len; ++i2) {
            Message msg = (Message)this.messages.elementAt(i2);
            if (msg.getType() != type || msg.getSrc() != src) continue;
            this.messages.setElementAt(message, i2);
            return;
        }
        this.messages.addElement(message);
    }

    private boolean findMessage(Object obj, int type) {
        int len = this.messages.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Message msg = (Message)this.messages.elementAt(i2);
            if (msg.getType() != type || msg.getSrc() != obj) continue;
            return true;
        }
        return false;
    }

    protected boolean isEOS() {
        Enumeration e2 = this.enumSinks();
        while (e2.hasMoreElements()) {
            Object obj = (Object)e2.nextElement();
            if (this.findMessage(obj, 1)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handleSyncMessage(Message message) {
        switch (message.getType()) {
            case 1: {
                boolean isEOS;
                Pipeline pipeline = this;
                synchronized (pipeline) {
                    Debug.log(3, this + " got EOS from sink: " + message.getSrc());
                    this.replaceMessage(message, 1);
                    isEOS = this.isEOS();
                }
                if (!isEOS) break;
                Debug.log(3, "all sinks posted EOS " + this);
                this.postMessage(Message.newEOS(this));
                break;
            }
            case 128: {
                this.scheduleReCalcState();
                break;
            }
            default: {
                this.postMessage(message);
            }
        }
        return 0;
    }

    public int getState(int[] resState, int[] resPending, long timeout) {
        this.reCalcState(false);
        return super.getState(resState, resPending, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleReCalcState() {
        Pipeline pipeline = this;
        synchronized (pipeline) {
            this.stateDirty = true;
            this.stateThread.stateDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reCalcState(boolean force) {
        boolean haveNoPreroll;
        boolean haveAsync;
        int res = 1;
        Debug.debug("Pipeline.reCalcState");
        Pipeline pipeline = this;
        synchronized (pipeline) {
            if (force) {
                this.stateDirty = true;
            }
            if (!this.stateDirty) {
                return;
            }
            if (this.polling) {
                return;
            }
            this.polling = true;
            this.stateDirty = false;
            haveAsync = false;
            haveNoPreroll = false;
        }
        Enumeration e2 = this.elements.elements();
        while (e2.hasMoreElements()) {
            Element elem = (Element)e2.nextElement();
            res = elem.getState(null, null, 1L);
            switch (res) {
                case 2: {
                    haveAsync = true;
                    break;
                }
                case 3: {
                    haveNoPreroll = true;
                }
            }
            if (res != 0) continue;
            break;
        }
        if (res != 0) {
            if (haveNoPreroll) {
                res = 3;
            }
            if (haveAsync) {
                res = 2;
            }
        }
        pipeline = this;
        synchronized (pipeline) {
            this.polling = false;
        }
        switch (res) {
            case 1: 
            case 3: {
                res = this.continueState(res);
                break;
            }
            case 2: {
                this.lostState();
                break;
            }
            case 0: {
                this.abortState();
                break;
            }
        }
    }

    protected int doChildStateChange(int transition) {
        int result;
        int next = this.getTransitionNext(transition);
        boolean haveAsync = false;
        boolean haveNoPreroll = false;
        Enumeration e2 = this.enumSorted();
        while (e2.hasMoreElements()) {
            Element elem = (Element)e2.nextElement();
            elem.setBus(this.internalBus);
            elem.setClock(this.defClock);
            elem.baseTime = this.baseTime;
            Debug.log(4, this + " setting state " + Pipeline.getStateName(next) + " on " + elem);
            result = elem.setState(next);
            Debug.log(4, this + " " + elem + " changed state, result = " + Pipeline.getStateReturnName(result));
            switch (result) {
                case 2: {
                    haveAsync = true;
                    break;
                }
                case 3: {
                    haveNoPreroll = true;
                    break;
                }
                case 0: {
                    return result;
                }
            }
        }
        result = super.changeState(transition);
        if (result == 0) {
            return result;
        }
        if (haveNoPreroll) {
            result = 3;
        } else if (haveAsync) {
            result = 2;
        }
        return result;
    }

    protected int changeState(int transition) {
        long now;
        switch (transition) {
            case 18: {
                this.messages.setSize(0);
                break;
            }
            case 35: {
                now = this.defClock.getTime();
                this.baseTime = now - this.streamTime;
                break;
            }
        }
        int result = this.doChildStateChange(transition);
        switch (transition) {
            case 18: {
                this.streamTime = 0L;
                break;
            }
            case 50: {
                now = this.defClock.getTime();
                this.streamTime = now - this.baseTime;
                this.messages.setSize(0);
                break;
            }
            case 33: {
                this.messages.setSize(0);
                break;
            }
        }
        return result;
    }

    protected boolean doSendEvent(Event event) {
        boolean res = true;
        Enumeration e2 = this.enumSinks();
        while (e2.hasMoreElements()) {
            Element elem = (Element)e2.nextElement();
            res &= elem.sendEvent(event);
        }
        return res;
    }

    private boolean doSeek(Event event) {
        boolean ret;
        boolean wasPlaying;
        int[] state = new int[1];
        this.getState(state, null, 0L);
        boolean bl = wasPlaying = state[0] == 3;
        if (wasPlaying) {
            this.setState(2);
        }
        if (ret = this.doSendEvent(event)) {
            this.streamTime = 0L;
        }
        if (wasPlaying) {
            this.setState(3);
        }
        return ret;
    }

    public boolean sendEvent(Event event) {
        switch (event.getType()) {
            case 5: {
                return this.doSeek(event);
            }
        }
        return this.doSendEvent(event);
    }

    public boolean query(Query query) {
        Element elem;
        boolean res = true;
        Enumeration e2 = this.enumSinks();
        while (e2.hasMoreElements() && !(res = (elem = (Element)e2.nextElement()).query(query))) {
        }
        return res;
    }

    private class SinkEnumerator
    implements Enumeration {
        private Enumeration e;
        private java.lang.Object next;

        public SinkEnumerator() {
            this.e = Pipeline.this.enumElements();
            this.queueNextElement();
        }

        private void queueNextElement() {
            this.next = null;
            while (this.e.hasMoreElements()) {
                Element elem = (Element)this.e.nextElement();
                if (!elem.isFlagSet(32)) continue;
                this.next = elem;
                break;
            }
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public java.lang.Object nextElement() throws NoSuchElementException {
            java.lang.Object result = this.next;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.queueNextElement();
            return result;
        }
    }

    private class SortedEnumerator
    implements Enumeration {
        private Vector queue = new Vector();
        private Hashtable hash = new Hashtable();
        private java.lang.Object next;
        private int mode;

        private void addToQueue(Element elem) {
            this.queue.addElement(elem);
            this.hash.put(elem, new Integer(-1));
        }

        private void updateDegree(Element elem) {
            Enumeration p2 = elem.enumPads();
            while (p2.hasMoreElements()) {
                Element peerParent;
                Pad peer;
                Pad pad = (Pad)p2.nextElement();
                if (pad.direction != 2 || (peer = pad.peer) == null || (peerParent = (Element)peer.parent) == null) continue;
                int oldDeg = (Integer)this.hash.get(peerParent);
                int newDeg = oldDeg + this.mode;
                if (newDeg == 0) {
                    this.addToQueue(peerParent);
                    continue;
                }
                this.hash.put(peerParent, new Integer(newDeg));
            }
        }

        public SortedEnumerator() {
            Enumeration e2 = Pipeline.this.enumElements();
            while (e2.hasMoreElements()) {
                Element elem = (Element)e2.nextElement();
                if (elem.isFlagSet(32)) {
                    this.addToQueue(elem);
                    continue;
                }
                this.hash.put(elem, new Integer(0));
            }
            this.mode = 1;
            e2 = Pipeline.this.enumElements();
            while (e2.hasMoreElements()) {
                this.updateDegree((Element)e2.nextElement());
            }
            this.mode = -1;
            this.queueNextElement();
        }

        private void queueNextElement() {
            if (this.queue.isEmpty()) {
                int bestDeg = Integer.MAX_VALUE;
                Element bestElem = null;
                Enumeration e2 = Pipeline.this.enumElements();
                while (e2.hasMoreElements()) {
                    Element elem = (Element)e2.nextElement();
                    int deg = (Integer)this.hash.get(elem);
                    if (deg < 0 || bestElem != null && bestDeg <= deg) continue;
                    bestElem = elem;
                    bestDeg = deg;
                }
                if (bestElem != null) {
                    if (bestDeg != 0) {
                        System.out.println(this + " loop detected in pipeline!!");
                    }
                    this.next = bestElem;
                    this.hash.put(this.next, new Integer(-1));
                } else {
                    this.next = null;
                }
            } else {
                this.next = this.queue.elementAt(0);
                this.queue.removeElementAt(0);
            }
            if (this.next != null) {
                this.updateDegree((Element)this.next);
            }
        }

        public boolean hasMoreElements() {
            return this.next != null;
        }

        public java.lang.Object nextElement() throws NoSuchElementException {
            java.lang.Object result = this.next;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.queueNextElement();
            return result;
        }
    }

    private class StateThread
    extends Thread {
        private boolean stopping;
        private boolean stateDirty;

        public StateThread() {
            super("cortado-StateThread-" + Debug.genId());
            this.stopping = false;
            this.stateDirty = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stopping) {
                java.lang.Object object = this;
                synchronized (object) {
                    while (!this.stateDirty && !this.stopping) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.stateDirty = false;
                }
                if (this.stopping) continue;
                object = Pipeline.this.stateLock;
                synchronized (object) {
                    Pipeline.this.reCalcState(false);
                }
            }
        }

        public synchronized void stateDirty() {
            this.stateDirty = true;
            this.notifyAll();
        }

        public synchronized void shutDown() {
            this.stopping = true;
            this.notifyAll();
        }
    }

    private class BusThread
    extends Thread {
        private Bus bus;
        private boolean stopping;

        public BusThread(Bus bus) {
            super("cortado-BusThread-" + Debug.genId());
            this.bus = bus;
            this.stopping = false;
        }

        public void run() {
            while (!this.stopping) {
                this.bus.waitAndDispatch();
            }
        }

        public void shutDown() {
            this.stopping = true;
            this.bus.setFlushing(true);
        }
    }
}

