/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Clock;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.jst.Query;
import com.fluendo.jst.WaitStatus;
import com.fluendo.utils.Debug;

public abstract class Sink
extends Element {
    private Object prerollLock = new Object();
    private boolean isEOS;
    private boolean flushing;
    private boolean havePreroll;
    private boolean needPreroll;
    private Clock.ClockID clockID;
    protected boolean discont;
    protected long segStart = 0L;
    protected long segStop;
    protected long segPosition;
    protected long pauseTime;
    protected long lastTime;
    protected long maxLateness = -1L;
    protected Pad sinkpad = new Pad(2, "sink"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int finishPreroll(Buffer buf) {
            Object object = Sink.this.prerollLock;
            synchronized (object) {
                int res = 0;
                Sink sink = (Sink)this.parent;
                if (this.isFlushing()) {
                    return -2;
                }
                if (Sink.this.needPreroll) {
                    int postPending;
                    int pending;
                    int next;
                    int current;
                    Sink.this.havePreroll = true;
                    try {
                        res = Sink.this.preroll(buf);
                    }
                    catch (Throwable t2) {
                        Sink.this.postMessage(Message.newError(this, "preroll exception: " + t2.getMessage()));
                        return -5;
                    }
                    boolean postPause = false;
                    boolean postPlaying = false;
                    Sink sink2 = sink;
                    synchronized (sink2) {
                        current = Sink.this.currentState;
                        next = Sink.this.nextState;
                        postPending = pending = Sink.this.pendingState;
                        block8 : switch (pending) {
                            case 3: {
                                Sink.this.needPreroll = false;
                                postPlaying = true;
                                if (current != 1) break;
                                postPause = true;
                                break;
                            }
                            case 2: {
                                Sink.this.needPreroll = true;
                                postPause = true;
                                postPending = 0;
                                break;
                            }
                            case 1: {
                                Sink.this.havePreroll = false;
                                Sink.this.needPreroll = false;
                                return -2;
                            }
                            case 0: {
                                switch (current) {
                                    case 3: {
                                        Sink.this.needPreroll = false;
                                        break block8;
                                    }
                                    case 2: {
                                        Sink.this.needPreroll = true;
                                        break block8;
                                    }
                                }
                                Sink.this.havePreroll = false;
                                Sink.this.needPreroll = false;
                                return -2;
                            }
                        }
                        if (pending != 0) {
                            Sink.this.currentState = pending;
                            Sink.this.nextState = 0;
                            Sink.this.pendingState = 0;
                            Sink.this.lastReturn = 1;
                        }
                    }
                    if (postPause) {
                        Sink.this.postMessage(Message.newStateChanged(this, current, next, postPending));
                    }
                    if (postPlaying) {
                        Sink.this.postMessage(Message.newStateChanged(this, next, pending, 0));
                    }
                    if (postPause || postPlaying) {
                        Sink.this.postMessage(Message.newStateDirty(this));
                    }
                    sink2 = sink;
                    synchronized (sink2) {
                        sink.notifyAll();
                    }
                    if (Sink.this.needPreroll) {
                        Sink.this.needPreroll = false;
                        try {
                            Sink.this.prerollLock.wait();
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        Sink.this.havePreroll = false;
                    }
                }
                if (this.isFlushing()) {
                    return -2;
                }
                return res;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean eventFunc(Event event) {
            Sink sink = (Sink)this.parent;
            Sink.this.doEvent(event);
            switch (event.getType()) {
                case 1: {
                    Object object = sink;
                    synchronized (object) {
                        sink.flushing = true;
                        if (Sink.this.clockID != null) {
                            Sink.this.clockID.unschedule();
                        }
                    }
                    object = Sink.this.prerollLock;
                    synchronized (object) {
                        sink.isEOS = false;
                        Sink.this.needPreroll = true;
                        Sink.this.prerollLock.notify();
                        Sink.this.havePreroll = false;
                    }
                    object = this.streamLock;
                    synchronized (object) {
                        Debug.debug(this + " synced " + Sink.this.havePreroll + " " + Sink.this.needPreroll);
                        Sink.this.lostState();
                        break;
                    }
                }
                case 2: {
                    Sink sink2 = sink;
                    synchronized (sink2) {
                        sink.flushing = false;
                        Sink.this.pauseTime = 0L;
                        break;
                    }
                }
                case 4: {
                    int segFmt = event.parseNewsegmentFormat();
                    if (segFmt != 3) break;
                    Sink.this.segStart = event.parseNewsegmentStart();
                    Sink.this.segStop = event.parseNewsegmentStop();
                    Sink.this.lastTime = Sink.this.segPosition = event.parseNewsegmentPosition();
                    break;
                }
                case 3: {
                    Object object = Sink.this.prerollLock;
                    synchronized (object) {
                        Sink.this.isEOS = true;
                        Debug.log(3, this + " got EOS");
                        Sink.this.postMessage(Message.newEOS(this.parent));
                        break;
                    }
                }
            }
            return true;
        }

        protected int chainFunc(Buffer buf) {
            if (buf.isFlagSet(1)) {
                Sink.this.discont = true;
            }
            long time = buf.timestamp;
            Debug.debug(this.parent.getName() + " <<< " + time);
            if (time != -1L) {
                if (time < Sink.this.segStart) {
                    Debug.debug(this.parent.getName() + " " + time + " >>> PRE-SEGMENT DROP");
                    buf.free();
                    return 0;
                }
                Sink.this.lastTime = time - Sink.this.segStart + Sink.this.segPosition;
            }
            buf.setFlag(1, Sink.this.discont);
            Sink.this.discont = false;
            int res = this.finishPreroll(buf);
            if (res != 0) {
                Debug.debug(this.parent.getName() + " " + time + " >>> PREROLL DROP");
                return res;
            }
            Debug.debug(this.parent.getName() + " sync " + time);
            WaitStatus status = Sink.this.doSync(time);
            switch (status.status) {
                case 1: {
                    if (Sink.this.maxLateness != -1L && status.jitter > Sink.this.maxLateness) {
                        Debug.debug(this.parent.getName() + " " + time + " >>> LATE, DROPPED");
                        break;
                    }
                }
                case 0: {
                    try {
                        Debug.debug(this.parent.getName() + " >>> " + time);
                        res = Sink.this.render(buf);
                    }
                    catch (Throwable t2) {
                        Sink.this.postMessage(Message.newError(this, "render exception: " + t2.getMessage()));
                        res = -5;
                    }
                    break;
                }
                default: {
                    Debug.debug(this.parent.getName() + " " + time + " >>> SYNC DROP");
                    res = 0;
                }
            }
            buf.free();
            return res;
        }

        protected boolean setCapsFunc(Caps caps) {
            Sink sink = (Sink)this.parent;
            boolean res = sink.setCapsFunc(caps);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean activateFunc(int mode) {
            if (mode == 0) {
                Object object = Sink.this.prerollLock;
                synchronized (object) {
                    if (Sink.this.havePreroll) {
                        Sink.this.prerollLock.notify();
                    }
                    Sink.this.needPreroll = false;
                    Sink.this.havePreroll = false;
                    this.flushing = true;
                }
                Sink.this.isEOS = false;
            } else {
                this.flushing = false;
            }
            return true;
        }
    };

    protected int preroll(Buffer buf) {
        return 0;
    }

    protected boolean doEvent(Event event) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WaitStatus doSync(long time) {
        WaitStatus ret = new WaitStatus();
        Clock.ClockID id = null;
        Sink sink = this;
        synchronized (sink) {
            if (this.flushing) {
                ret.status = 2;
                return ret;
            }
            if (time == -1L) {
                ret.status = 0;
                return ret;
            }
            time = time - this.segStart + this.baseTime;
            if (this.clock != null) {
                id = this.clockID = this.clock.newSingleShotID(time);
            }
        }
        if (id != null) {
            ret = id.waitID();
        } else {
            ret.status = 0;
        }
        sink = this;
        synchronized (sink) {
            this.clockID = null;
        }
        return ret;
    }

    protected boolean setCapsFunc(Caps caps) {
        return true;
    }

    protected int render(Buffer buf) {
        return 0;
    }

    public Sink() {
        this.addPad(this.sinkpad);
        this.setFlag(32);
    }

    public boolean sendEvent(Event event) {
        return this.sinkpad.pushEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean query(Query query) {
        switch (query.getType()) {
            case 2: {
                return this.sinkpad.getPeer().query(query);
            }
            case 1: {
                long position = -1L;
                if (query.parsePositionFormat() == 3) {
                    Sink sink = this;
                    synchronized (sink) {
                        if (this.currentState == 3) {
                            if (this.clock != null) {
                                position = this.clock.getTime() - this.baseTime + this.segPosition + this.segStart;
                            }
                        } else {
                            position = this.pauseTime + this.segPosition + this.segStart;
                        }
                    }
                    query.setPosition(3, position);
                    break;
                }
                return this.sinkpad.getPeer().query(query);
            }
            default: {
                return this.sinkpad.getPeer().query(query);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int changeState(int transition) {
        int result = 1;
        switch (transition) {
            case 18: {
                this.isEOS = false;
                Object object = this.prerollLock;
                synchronized (object) {
                    this.needPreroll = true;
                    this.havePreroll = false;
                }
                result = 2;
                break;
            }
            case 35: {
                Object object = this.prerollLock;
                synchronized (object) {
                    if (this.havePreroll) {
                        this.needPreroll = false;
                        this.prerollLock.notify();
                    } else {
                        this.needPreroll = false;
                    }
                    break;
                }
            }
            case 50: {
                Object object = this;
                synchronized (object) {
                    this.pauseTime = this.clock.getTime() - this.baseTime;
                    break;
                }
            }
        }
        int presult = super.changeState(transition);
        if (presult == 0) {
            Debug.debug(this + " super state change failed");
            return presult;
        }
        switch (transition) {
            case 50: {
                boolean checkEOS;
                Debug.debug(this + " play->paused");
                Object object = this;
                synchronized (object) {
                    if (this.clockID != null) {
                        Debug.debug(this + " unschedule clockID: " + this.clockID);
                        this.clockID.unschedule();
                    }
                    checkEOS = this.isEOS;
                    Debug.debug(this + " checkEOS: " + checkEOS);
                }
                object = this.prerollLock;
                synchronized (object) {
                    Debug.debug(this + " havePreroll: " + this.havePreroll);
                    if (!this.havePreroll && !checkEOS && this.pendingState == 2) {
                        this.needPreroll = true;
                        result = 2;
                    }
                    break;
                }
            }
            case 33: {
                break;
            }
        }
        return result;
    }

    public synchronized boolean setProperty(String name, Object value) {
        boolean res = true;
        if (name.equals("max-lateness")) {
            this.maxLateness = Long.parseLong((String)value);
        } else {
            res = false;
        }
        return res;
    }
}

