/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jtiger;

import com.fluendo.jtiger.TextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

class FancyTextRenderer
implements TextRenderer {
    FancyTextRenderer() {
    }

    public void renderText(Graphics g2, Rectangle region, Font font, String text) {
        Graphics2D g22 = (Graphics2D)g2;
        g22.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AttributedString atext = new AttributedString(text, font.getAttributes());
        AttributedCharacterIterator text_it = atext.getIterator();
        int text_end = text_it.getEndIndex();
        FontRenderContext frc = g22.getFontRenderContext();
        LineBreakMeasurer lbm = new LineBreakMeasurer(text_it, frc);
        float dy = 0.0f;
        boolean shadow_dx = true;
        boolean shadow_dy = true;
        while (lbm.getPosition() < text_end) {
            TextLayout layout = lbm.nextLayout(region.width);
            float tw = layout.getAdvance();
            float tx = (float)region.x + ((float)region.width - tw) / 2.0f;
            g22.setColor(Color.black);
            layout.draw(g22, tx + (float)shadow_dx, (float)region.y + (dy += layout.getAscent()));
            layout.draw(g22, tx - (float)shadow_dx, (float)region.y + dy);
            layout.draw(g22, tx, (float)region.y + dy - (float)shadow_dy);
            layout.draw(g22, tx, (float)region.y + dy + (float)shadow_dy);
            g22.setColor(Color.white);
            layout.draw(g22, tx, (float)region.y + dy);
            dy += layout.getDescent() + layout.getLeading();
        }
    }
}

