/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jtiger;

import com.fluendo.jkate.Event;
import com.fluendo.jtiger.Item;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

public class Renderer {
    private Vector items = new Vector();
    private boolean dirty = true;

    public synchronized void add(Event ev) {
        this.items.addElement(new Item(ev));
        this.dirty = true;
    }

    public synchronized int update(Component c2, Dimension d2, double t2) {
        int nactive = 0;
        for (int n2 = 0; n2 < this.items.size(); ++n2) {
            Item item = (Item)this.items.elementAt(n2);
            boolean ret = item.update(c2, d2, t2);
            if (!ret) {
                this.items.removeElementAt(n2);
                this.dirty = true;
                --n2;
                continue;
            }
            if (item.isDirty()) {
                this.dirty = true;
            }
            if (!item.isActive()) continue;
            ++nactive;
        }
        if (nactive == 0) {
            return 1;
        }
        return 0;
    }

    public synchronized Image render(Component c2, Image img) {
        Image copy = c2.createImage(img.getWidth(null), img.getHeight(null));
        Graphics g2 = copy.getGraphics();
        g2.drawImage(img, 0, 0, null);
        g2.dispose();
        img = copy;
        for (int n2 = 0; n2 < this.items.size(); ++n2) {
            ((Item)this.items.elementAt(n2)).render(c2, img);
        }
        this.dirty = false;
        return img;
    }

    public synchronized void flush() {
        this.items.removeAllElements();
        this.dirty = true;
    }

    public synchronized boolean isDirty() {
        return this.dirty;
    }
}

