/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jtiger;

import com.fluendo.jkate.Bitmap;
import com.fluendo.jkate.Palette;
import com.fluendo.utils.Debug;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public class TigerBitmap {
    private Image image;
    private Image scaled_image;

    public TigerBitmap(Component c2, Bitmap kb, Palette kp) {
        this.image = kb == null ? null : (kb.bpp == 0 ? this.createPNGBitmap(c2, kb, kp) : (kp == null ? null : this.createPalettedBitmap(c2, kb, kp)));
        if (this.image == null) {
            this.image = c2.getToolkit().createImage(new MemoryImageSource(1, 1, new int[]{0}, 0, 1));
        }
    }

    public Image getScaled(int width, int height) {
        if (this.scaled_image == null || width != this.scaled_image.getWidth(null) || height != this.scaled_image.getHeight(null)) {
            this.scaled_image = this.image.getScaledInstance(width, height, 4);
        }
        return this.scaled_image;
    }

    private Image createPNGBitmap(Component c2, Bitmap kb, Palette kp) {
        Debug.warning("PNG bitmaps not supported yet");
        return null;
    }

    private Image createPalettedBitmap(Component c2, Bitmap kb, Palette kp) {
        byte[] cmap = new byte[4 * kp.colors.length];
        for (int n2 = 0; n2 < kp.colors.length; ++n2) {
            cmap[n2 * 4 + 0] = kp.colors[n2].r;
            cmap[n2 * 4 + 1] = kp.colors[n2].g;
            cmap[n2 * 4 + 2] = kp.colors[n2].b;
            cmap[n2 * 4 + 3] = kp.colors[n2].a;
        }
        IndexColorModel icm = new IndexColorModel(kb.bpp, kp.colors.length, cmap, 0, true);
        return c2.createImage(new MemoryImageSource(kb.width, kb.height, (ColorModel)icm, kb.pixels, 0, kb.width));
    }
}

