/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.jst.BusHandler;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.player.AboutFrame;
import com.fluendo.player.CortadoPipeline;
import com.fluendo.player.DurationScanner;
import com.fluendo.player.Status;
import com.fluendo.player.StatusListener;
import com.fluendo.utils.Debug;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;

public class Cortado
extends Applet
implements Runnable,
MouseMotionListener,
MouseListener,
ComponentListener,
BusHandler,
StatusListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private Cortado cortado;
    private CortadoPipeline pipeline;
    private String urlString;
    private boolean audio;
    private boolean video;
    private int kateIndex;
    private String kateLanguage;
    private String kateCategory;
    private boolean showSpeaker;
    private boolean showSubtitles;
    private boolean keepAspect;
    private boolean ignoreAspect;
    private boolean autoPlay;
    private int bufferSize;
    private String userId;
    private String password;
    private int bufferLow;
    private int bufferHigh;
    private int debug;
    private double durationParam;
    private double startTimeParam;
    private boolean statusRunning;
    private Thread statusThread;
    public Status status;
    private int statusHeight = 20;
    private boolean inStatus;
    private boolean isBuffering;
    private int desiredState;
    private boolean started = false;
    private boolean isEOS;
    private boolean isError;
    private static final String[] autoBoolVals = new String[]{"auto", "true", "false"};
    private static final int BOOL_AUTO = 0;
    private static final int BOOL_TRUE = 1;
    private static final int BOOL_FALSE = 2;
    private int seekable;
    private int live;
    private int showStatus;
    private static final String[] showStatusVals = new String[]{"auto", "show", "hide"};
    public static final int STATUS_AUTO = 0;
    public static final int STATUS_SHOW = 1;
    public static final int STATUS_HIDE = 2;
    private int hideTimeout;
    private int hideCounter;
    private boolean mayHide;
    public double currentTime = 0.0;
    private double _currentTime;
    public double duration = -1.0;
    public boolean paused;
    public String src;
    private PopupMenu menu;
    private Menu subtitlesMenu;
    private Hashtable params = new Hashtable();
    private Dimension appletDimension;

    public String getAppletInfo() {
        return "Title: Fluendo media player \nAuthor: Wim Taymans \nA Java based network multimedia player.";
    }

    public String getRevision() {
        return "$Revision$";
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"url", "URL", "The media file to play"}, {"seekable", "enum", "Can you seek in this file (auto|true|false) (default auto)"}, {"live", "enum", "Is this a live stream (disabled PAUSE) (auto|true|false) (default auto)"}, {"duration", "float", "Total duration of the file in seconds (default unknown)"}, {"startTime", "float", "Start time of the file in seconds (default unknown)"}, {"audio", "boolean", "Enable audio playback (default true)"}, {"video", "boolean", "Enable video playback (default true)"}, {"kateIndex", "boolean", "Enable playback of a particular Kate stream (default -1 (none))"}, {"kateLanguage", "string", "Enable playback of a Kate stream from a language (default empty)"}, {"kateCategory", "string", "Enable playback of a Kate stream from a category (default empty)"}, {"statusHeight", "int", "The height of the status area (default 12)"}, {"autoPlay", "boolean", "Automatically start playback (default true)"}, {"showStatus", "enum", "Show status area (auto|show|hide) (default auto)"}, {"hideTimeout", "int", "Timeout in seconds to hide the status area when showStatus is auto (default 0)"}, {"showSpeaker", "boolean", "Show a speaker icon when audio is available (default true)"}, {"showSubtitles", "boolean", "Show a subtitles icon when subtitles are available (default true)"}, {"keepAspect", "boolean", "Use aspect ratio of video (default true)"}, {"ignoreAspect", "boolean", "Ignore the aspect ratio as signalled by the video, always assume square pixels (default false)"}, {"bufferSize", "int", "The size of the prebuffer in Kbytes (default 100)"}, {"bufferLow", "int", "Percent of empty buffer (default 10)"}, {"bufferHigh", "int", "Percent of full buffer (default 70)"}, {"userId", "string", "userId for basic authentication (default null)"}, {"password", "string", "password for basic authentication (default null)"}, {"debug", "int", "Debug level 0 - 4 (default = 3)"}};
        return info;
    }

    public void setParam(String name, String value) {
        this.params.put(name, value);
    }

    public void restart() {
        this.stop();
        this.init();
        this.start();
    }

    public String getParam(String name, String def) {
        String result = (String)this.params.get(name);
        if (result == null) {
            try {
                result = this.getParameter(name);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        if (result == null) {
            result = def;
        }
        return result;
    }

    public int getEnumParam(String name, String[] vals, String def) {
        int res = -1;
        String val = this.getParam(name, def);
        for (int i2 = 0; i2 < vals.length; ++i2) {
            if (!vals[i2].equals(val)) continue;
            res = i2;
            break;
        }
        if (res != -1) {
            Debug.info("param \"" + name + "\" has enum value \"" + res + "\" (" + vals[res] + ")");
        } else {
            Debug.info("param \"" + name + "\" has invalid enum value");
        }
        return res;
    }

    public String getStringParam(String name, String def) {
        String res = this.getParam(name, def);
        Debug.info("param \"" + name + "\" has string value \"" + res + "\"");
        return res;
    }

    public boolean getBoolParam(String name, boolean def) {
        String defStr = def ? "true" : "false";
        String paramVal = String.valueOf(this.getParam(name, defStr));
        boolean res = paramVal.equals("true");
        Debug.info("param \"" + name + "\" has boolean value \"" + (res |= paramVal.equals("1")) + "\"");
        return res;
    }

    public double getDoubleParam(String name, double def) {
        double res = Double.valueOf(this.getParam(name, "" + def));
        Debug.info("param \"" + name + "\" has double value \"" + res + "\"");
        return res;
    }

    public int getIntParam(String name, int def) {
        int res = Integer.valueOf(this.getParam(name, "" + def));
        Debug.info("param \"" + name + "\" has int value \"" + res + "\"");
        return res;
    }

    public void shutDown(Throwable error) {
        Debug.log(3, "shutting down: reason: " + error.getMessage());
        error.printStackTrace();
        this.stop();
    }

    public synchronized void init() {
        URL documentBase;
        this.cortado = this;
        Debug.info("init()");
        if (this.pipeline != null) {
            this.stop();
        }
        this.pipeline = new CortadoPipeline(this);
        this.src = this.urlString = this.getStringParam("url", null);
        this.seekable = this.getEnumParam("seekable", autoBoolVals, "auto");
        this.live = this.getEnumParam("live", autoBoolVals, "auto");
        this.durationParam = this.getDoubleParam("duration", -1.0);
        this.startTimeParam = this.getDoubleParam("startTime", -1.0);
        this.audio = this.getBoolParam("audio", true);
        this.video = this.getBoolParam("video", true);
        this.kateIndex = this.getIntParam("kateIndex", -1);
        this.kateLanguage = this.getStringParam("kateLanguage", "");
        this.kateCategory = this.getStringParam("kateCategory", "");
        this.statusHeight = this.getIntParam("statusHeight", 12);
        this.autoPlay = this.getBoolParam("autoPlay", true);
        this.showStatus = this.getEnumParam("showStatus", showStatusVals, "auto");
        this.hideTimeout = this.getIntParam("hideTimeout", 3);
        this.showSpeaker = this.getBoolParam("showSpeaker", true);
        this.showSubtitles = this.getBoolParam("showSubtitles", true);
        this.keepAspect = this.getBoolParam("keepAspect", true);
        this.ignoreAspect = this.getBoolParam("ignoreAspect", false);
        this.bufferSize = this.getIntParam("bufferSize", 200);
        this.bufferLow = this.getIntParam("bufferLow", 10);
        this.bufferHigh = this.getIntParam("bufferHigh", 70);
        this.debug = this.getIntParam("debug", 3);
        this.userId = this.getStringParam("userId", null);
        this.password = this.getStringParam("password", null);
        if (!this.video) {
            this.hideTimeout = Integer.MAX_VALUE;
        }
        Debug.level = this.debug;
        Debug.log(3, "build info: ");
        Debug.log(3, "revision: " + this.getRevision());
        if (System.getProperty("java.vendor").toUpperCase().startsWith("MICROSOFT", 0)) {
            Debug.log(2, "Found MS JVM, disable seeking.");
            this.seekable = 2;
        }
        this.pipeline.setUrl(this.urlString);
        this.pipeline.setUserId(this.userId);
        this.pipeline.setPassword(this.password);
        this.pipeline.enableAudio(this.audio);
        this.pipeline.enableVideo(this.video);
        this.pipeline.setKeepAspect(this.keepAspect);
        this.pipeline.setIgnoreAspect(this.ignoreAspect);
        this.pipeline.enableKateStream(this.kateIndex, this.kateLanguage, this.kateCategory);
        this.pipeline.setBufferSize(this.bufferSize);
        this.pipeline.setBufferLow(this.bufferLow);
        this.pipeline.setBufferHigh(this.bufferHigh);
        try {
            documentBase = this.getDocumentBase();
            Debug.log(3, "Document base: " + documentBase);
        }
        catch (Throwable t2) {
            documentBase = null;
        }
        this.pipeline.setDocumentBase(documentBase);
        this.pipeline.setComponent(this);
        this.pipeline.getBus().addHandler(this);
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.status = new Status(this);
        this.status.setShowSpeaker(this.showSpeaker);
        this.status.setShowSubtitles(this.showSubtitles);
        this.status.setHaveAudio(this.audio);
        this.status.setHaveSubtitles(false);
        this.status.setHavePercent(true);
        if (this.live == 2) {
            this.status.setLive(false);
        } else {
            this.status.setLive(true);
        }
        if (this.seekable == 1) {
            this.status.setSeekable(true);
        } else {
            this.status.setSeekable(false);
        }
        if (this.durationParam < 0.0 || this.startTimeParam < 0.0) {
            try {
                String base = documentBase != null ? documentBase.toString().substring(0, documentBase.toString().lastIndexOf("/")) : "";
                String docurlstring = this.urlString.indexOf("://") >= 0 ? this.urlString : base + "/" + this.urlString;
                Debug.log(3, "trying to determine duration for " + docurlstring);
                URL url = new URL(docurlstring);
                DurationScanner dscanner = new DurationScanner();
                DurationScanner.TimingInfo tinfo = dscanner.scanURL(url, this.userId, this.password);
                if (this.durationParam < 0.0) {
                    this.duration = this.durationParam = (double)tinfo.duration;
                }
                if (this.startTimeParam < 0.0) {
                    this.startTimeParam = tinfo.startTime;
                }
                Debug.log(3, "Determined stream duration to be approx. " + this.durationParam + ", starting at " + this.startTimeParam);
            }
            catch (Exception ex) {
                Debug.log(2, "Couldn't determine duration for stream.");
            }
        }
        this.status.setStartTime(this.startTimeParam);
        this.status.setDuration(this.durationParam);
        this.inStatus = false;
        this.mayHide = this.hideTimeout == 0;
        this.hideCounter = 0;
        if (this.showStatus != 2) {
            this.status.setVisible(true);
        } else {
            this.status.setVisible(false);
        }
        this.createMenu();
    }

    public void createMenu() {
        this.subtitlesMenu = new Menu("Subtitles");
        this.subtitlesMenu.addActionListener(this);
        this.menu = new PopupMenu();
        this.menu.add(this.subtitlesMenu);
        this.menu.addSeparator();
        this.menu.add("About...");
        this.menu.addActionListener(this);
        this.add(this.menu);
        this.populateMenu(this.subtitlesMenu);
    }

    public String getCategoryName(String code) {
        String[] names = new String[]{"CC", "closed captions", "SUB", "subtitles", "TAD", "text audio descriptions", "KTV", "karaoke", "TIK", "ticker text", "AR", "active regions", "NB", "semantic annotations", "META", "metadata", "TRX", "transcript", "LRC", "lyrics", "LIN", "linguistic markup", "CUE", "cue points", "subtitles", "subtitles", "spu-subtitles", "subtitles (images)", "lyrics", "lyrics", "K-SPU", "subtitles (images)"};
        for (int n2 = 0; n2 < names.length; n2 += 2) {
            if (!names[n2].equals(code)) continue;
            return names[n2 + 1];
        }
        return "\"" + code + "\"";
    }

    public Locale getLocale(String rfc3066) {
        int sep = (rfc3066 = rfc3066.replace('-', '_')).indexOf("_");
        if (sep >= 0) {
            String language = rfc3066.substring(0, sep);
            String country = rfc3066.substring(sep + 1);
            return new Locale(language, country);
        }
        return new Locale(rfc3066, "");
    }

    public void populateMenu(Menu subtitlesMenu) {
        subtitlesMenu.removeAll();
        int nstreams = this.pipeline.getNumKateStreams();
        if (nstreams > 0) {
            subtitlesMenu.setEnabled(true);
            subtitlesMenu.add("Off");
            subtitlesMenu.addSeparator();
            for (int n2 = 0; n2 < nstreams; ++n2) {
                Locale locale = this.getLocale(this.pipeline.getKateStreamLanguage(n2));
                String displayLanguage = locale.getDisplayLanguage();
                String displayCountry = locale.getDisplayCountry();
                String displayLC = displayLanguage;
                if (displayCountry != null && !displayCountry.equals("")) {
                    displayLC = displayLC + " (" + displayCountry + ")";
                }
                String label = n2 + 1 + " - " + displayLC + " " + this.getCategoryName(this.pipeline.getKateStreamCategory(n2));
                subtitlesMenu.add(label);
            }
        } else {
            subtitlesMenu.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e2) {
        String command = e2.getActionCommand();
        if (command.equals("About...")) {
            AboutFrame about = new AboutFrame(this.pipeline);
            about.d.setVisible(true);
        } else if (command.equals("Off")) {
            Debug.log(2, "Switching subtitles off");
            this.setParam("kateIndex", "-1");
            this.setParam("kateLanguage", "");
            this.setParam("kateCategory", "");
            this.pipeline.enableKateStream(-1, "", "");
        } else {
            int idx = Integer.valueOf(command.substring(0, command.indexOf(" ")));
            if (idx >= 1 && idx <= this.pipeline.getNumKateStreams()) {
                String sidx = new String("" + (idx - 1));
                Debug.log(2, "Switching to subtitles stream " + sidx);
                this.setParam("kateIndex", sidx);
                this.setParam("kateLanguage", "");
                this.setParam("kateCategory", "");
                this.pipeline.enableKateStream(idx + 1, "", "");
            } else {
                Debug.log(2, "Failed to parse subtitle selection command string: " + command);
            }
        }
    }

    public Graphics getGraphics() {
        Dimension dim = this.getSize();
        Graphics g2 = super.getGraphics();
        if (this.status != null && this.status.isVisible()) {
            g2.setClip(0, 0, dim.width, dim.height - this.statusHeight);
        } else {
            g2.setClip(0, 0, dim.width, dim.height);
        }
        return g2;
    }

    public void componentHidden(ComponentEvent e2) {
    }

    public void componentMoved(ComponentEvent e2) {
    }

    public void componentResized(ComponentEvent e2) {
        this.appletDimension = super.getSize();
        if (this.pipeline != null) {
            this.pipeline.resize(this.appletDimension);
        }
    }

    public void componentShown(ComponentEvent e2) {
        this.appletDimension = super.getSize();
        Debug.debug("Component shown, size = " + this.appletDimension);
        if (this.pipeline != null) {
            this.pipeline.resize(this.appletDimension);
        }
    }

    public Dimension getSize() {
        if (this.appletDimension == null) {
            this.appletDimension = super.getSize();
        }
        return this.appletDimension;
    }

    public void update(Graphics g2) {
        this.paint(g2);
    }

    public void run() {
        try {
            this.realRun();
        }
        catch (Throwable t2) {
            this.shutDown(t2);
        }
    }

    private void realRun() {
        Debug.log(3, "entering status thread");
        while (this.statusRunning) {
            try {
                if (this._currentTime != this.currentTime && this.currentTime >= 0.0 && this.duration > this.currentTime) {
                    this.doSeek(this.currentTime / this.duration);
                }
                this.currentTime = this._currentTime = (double)this.pipeline.getPosition() / 1000000.0;
                long now = this.pipeline.getPosition() / 1000000L;
                this.status.setTime(now);
                Thread.sleep(1000L);
                if (this.hideCounter > 0) {
                    --this.hideCounter;
                    if (this.hideCounter == 0) {
                        this.mayHide = true;
                        this.setStatusVisible(false, false);
                    }
                }
                this.pipeline.enableKateStream(Integer.valueOf(this.getParam("kateIndex", "-1")), this.getParam("kateLanguage", ""), this.getParam("kateCategory", ""));
            }
            catch (Exception e2) {
                if (!this.statusRunning) continue;
                Debug.log(1, "Exception in status thread:");
                e2.printStackTrace();
            }
        }
        Debug.log(3, "exit status thread");
    }

    public void paint(Graphics g2) {
        Dimension dim = this.getSize();
        int dwidth = dim.width;
        int dheight = dim.height;
        if (dwidth <= 0 || dheight < this.statusHeight) {
            this.appletDimension = null;
            Debug.log(2, "paint aborted: appletDimension wrong; dwidth " + dwidth + ", dheight " + dheight + ", statusHeight " + this.statusHeight);
            return;
        }
        if (this.status != null) {
            this.status.setBounds(0, dheight - this.statusHeight, dwidth, this.statusHeight);
            this.status.paint(g2);
        }
    }

    private void setStatusVisible(boolean b2, boolean force) {
        if (this.status.isVisible() == b2) {
            return;
        }
        if (!b2 && !this.mayHide) {
            return;
        }
        if (!force) {
            if (this.showStatus == 1 && !b2) {
                return;
            }
            if (this.showStatus == 2 && b2) {
                return;
            }
        }
        if (this.isError && !b2) {
            return;
        }
        if (this.inStatus && !b2) {
            b2 = true;
        }
        if (b2 != this.status.isVisible()) {
            Debug.log(3, "Status: " + (b2 ? "Show" : "Hide"));
        }
        if (b2) {
            this.hideCounter = this.hideTimeout;
        }
        this.status.setVisible(b2);
        this.repaint();
    }

    private boolean intersectStatus(MouseEvent e2) {
        int max;
        int top;
        int y2 = e2.getY();
        this.inStatus = y2 > (top = (max = this.getSize().height) - this.statusHeight) && y2 < max;
        return this.inStatus;
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
        this.inStatus = false;
    }

    public void mousePressed(MouseEvent e2) {
        if (this.intersectStatus(e2)) {
            int y2 = this.getSize().height - this.statusHeight;
            e2.translatePoint(0, -y2);
            this.status.mousePressed(e2);
        } else if ((e2.getModifiers() & 4) == 4) {
            this.populateMenu(this.subtitlesMenu);
            this.menu.show(this, e2.getX(), e2.getY());
        }
    }

    public void mouseReleased(MouseEvent e2) {
        if (this.intersectStatus(e2)) {
            int y2 = this.getSize().height - this.statusHeight;
            e2.translatePoint(0, -y2);
            this.status.mouseReleased(e2);
        } else {
            this.status.cancelMouseOperation();
        }
    }

    public void mouseDragged(MouseEvent e2) {
        if (this.intersectStatus(e2)) {
            int y2 = this.getSize().height - this.statusHeight;
            this.setStatusVisible(true, false);
            e2.translatePoint(0, -y2);
            this.status.mouseDragged(e2);
        }
    }

    public void mouseMoved(MouseEvent e2) {
        if (this.intersectStatus(e2)) {
            int y2 = this.getSize().height - this.statusHeight;
            this.setStatusVisible(true, false);
            e2.translatePoint(0, -y2);
            this.status.mouseMoved(e2);
        }
        this.setStatusVisible(true, false);
    }

    public void handleMessage(Message msg) {
        switch (msg.getType()) {
            case 4: {
                Debug.info(msg.toString());
                break;
            }
            case 2: {
                Debug.info(msg.toString());
                if (this.isError) break;
                this.status.setMessage(msg.parseErrorString());
                this.status.setState(0);
                this.pipeline.setState(1);
                this.setStatusVisible(true, true);
                this.isError = true;
                break;
            }
            case 1: {
                Debug.log(3, "EOS: playback ended");
                if (this.isError) break;
                this.status.setState(0);
                this.status.setMessage("Playback ended");
                this.isEOS = true;
                this.pipeline.setState(1);
                this.setStatusVisible(true, false);
                break;
            }
            case 8192: {
                Debug.info(msg.toString());
                break;
            }
            case 524288: {
                if (this.isError) break;
                this.status.setMessage(msg.parseResourceString());
                this.setStatusVisible(true, false);
                break;
            }
            case 262144: {
                long duration = msg.parseDurationValue();
                this.status.setByteDuration(duration);
                Debug.log(4, "got duration: " + duration);
                if (duration == -1L) break;
                if (this.seekable == 0) {
                    this.status.setSeekable(true);
                }
                if (this.live != 0) break;
                this.status.setLive(false);
                break;
            }
            case 32: {
                if (this.isError) break;
                boolean busy = msg.parseBufferingBusy();
                int percent = msg.parseBufferingPercent();
                if (busy) {
                    if (!this.isBuffering) {
                        Debug.log(3, "PAUSE: we are buffering");
                        if (this.desiredState == 3) {
                            this.pipeline.setState(2);
                        }
                        this.isBuffering = true;
                        this.setStatusVisible(true, false);
                    }
                    this.status.setBufferPercent(busy, percent);
                    break;
                }
                if (this.isBuffering) {
                    Debug.log(3, "PLAY: we finished buffering");
                    if (this.desiredState == 3) {
                        this.pipeline.setState(3);
                    }
                    this.isBuffering = false;
                    this.setStatusVisible(false, false);
                }
                this.status.setBufferPercent(busy, percent);
                break;
            }
            case 64: {
                if (msg.getSrc() != this.pipeline) break;
                int old = msg.parseStateChangedOld();
                int next = msg.parseStateChangedNext();
                switch (next) {
                    case 2: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Paused");
                        }
                        this.status.setState(1);
                        break;
                    }
                    case 3: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Playing");
                            this.setStatusVisible(false, false);
                            if (!this.mayHide) {
                                this.hideCounter = this.hideTimeout;
                            }
                        }
                        this.status.setState(2);
                        break;
                    }
                    case 1: {
                        if (!this.isError && !this.isEOS) {
                            this.status.setMessage("Stopped");
                            this.setStatusVisible(true, false);
                        }
                        this.status.setState(0);
                    }
                }
                break;
            }
            case 0x100000: {
                this.status.setBytePosition(msg.parseBytePosition());
                break;
            }
        }
    }

    public void doPause() {
        this.isError = false;
        this.isEOS = false;
        this.paused = true;
        this.status.setMessage("Pause");
        this.desiredState = 2;
        this.pipeline.setState(this.desiredState);
    }

    public void doPlay() {
        this.isError = false;
        this.isEOS = false;
        this.paused = false;
        this.status.setMessage("Play");
        this.desiredState = 3;
        this.pipeline.setState(this.desiredState);
    }

    public void doStop() {
        this.status.setMessage("Stop");
        this.desiredState = 1;
        this.pipeline.setState(this.desiredState);
    }

    public void doSeek(double aPos) {
        Event event = Event.newSeek(5, (int)(aPos * 100.0 * 10000.0));
        boolean res = this.pipeline.sendEvent(event);
        if (!res) {
            Debug.log(2, "seek failed");
        }
    }

    public double getPlayPosition() {
        return (double)this.pipeline.getPosition() / 1000000.0;
    }

    public void onState(int aState) {
        switch (aState) {
            case 1: {
                this.doPause();
                break;
            }
            case 2: {
                this.doPlay();
                break;
            }
            case 0: {
                this.doStop();
                break;
            }
        }
    }

    public void onSeek(double aPos) {
        this.doSeek(aPos);
    }

    public void onAudio() {
    }

    public void onSubtitles(int x2, int y2) {
        Dimension dim = this.getSize();
        PopupMenu subtitlesPopupMenu = new PopupMenu();
        this.populateMenu(subtitlesPopupMenu);
        subtitlesPopupMenu.addActionListener(this);
        this.add(subtitlesPopupMenu);
        subtitlesPopupMenu.show(this, x2, y2 + dim.height - this.statusHeight);
    }

    public synchronized void start() {
        Debug.info("Application starting");
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.status.addStatusListener(this);
        this.desiredState = this.autoPlay ? 3 : 2;
        int res = this.pipeline.setState(this.desiredState);
        if (this.statusThread != null) {
            throw new RuntimeException("invalid state");
        }
        this.statusThread = new Thread((Runnable)this, "cortado-StatusThread-" + Debug.genId());
        this.statusRunning = true;
        this.statusThread.start();
    }

    public synchronized void stop() {
        Debug.info("Application stopping...");
        this.status.removeStatusListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
        this.removeComponentListener(this);
        this.statusRunning = false;
        this.desiredState = 1;
        if (this.pipeline != null) {
            try {
                this.pipeline.setState(this.desiredState);
            }
            catch (Throwable e2) {
                // empty catch block
            }
            try {
                this.pipeline.shutDown();
            }
            catch (Throwable e3) {
                // empty catch block
            }
            this.pipeline = null;
        }
        if (this.statusThread != null) {
            try {
                this.statusThread.interrupt();
            }
            catch (Throwable e4) {
                // empty catch block
            }
            try {
                this.statusThread.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.statusThread = null;
        }
        Debug.info("Application stopped");
    }

    public int getStatusHeight() {
        return this.statusHeight;
    }

    public int getShowStatus() {
        return this.showStatus;
    }

    public synchronized void play() {
        this.doPlay();
    }

    public synchronized void pause() {
        this.doPause();
    }
}

