/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.jst.Caps;
import com.fluendo.jst.CapsListener;
import com.fluendo.jst.Element;
import com.fluendo.jst.ElementFactory;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.jst.PadListener;
import com.fluendo.jst.Pipeline;
import com.fluendo.jst.Query;
import com.fluendo.player.Cortado;
import com.fluendo.plugin.AudioSink;
import com.fluendo.utils.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Vector;

public class CortadoPipeline
extends Pipeline
implements PadListener,
CapsListener {
    private String url;
    private String userId;
    private String password;
    private boolean enableAudio = true;
    private boolean enableVideo = true;
    private boolean keepAspect;
    private boolean ignoreAspect;
    private int enableKate;
    private String enableKateLanguage = "";
    private String enableKateCategory = "";
    private Component component;
    private int bufferSize = -1;
    private int bufferLow = -1;
    private int bufferHigh = -1;
    private URL documentBase = null;
    private Cortado application;
    private Element httpsrc;
    private Element buffer;
    private Element demux;
    private Element videodec;
    private Element audiodec;
    private Element videosink;
    private Element audiosink;
    private Element v_queue;
    private Element v_queue2;
    private Element a_queue = null;
    private Element overlay;
    private Pad asinkpad;
    private Pad ovsinkpad;
    private Pad oksinkpad;
    private Pad apad;
    private Pad vpad;
    private Vector katedec = new Vector();
    private Vector k_queue = new Vector();
    private Element kselector = null;
    public boolean usingJavaX = false;

    private boolean setupVideoDec(String name) {
        this.videodec = ElementFactory.makeByName(name, "videodec");
        if (this.videodec == null) {
            this.noSuchElement(name);
            return false;
        }
        this.add(this.videodec);
        return true;
    }

    public void padAdded(Pad pad) {
        Caps caps = pad.getCaps();
        if (caps == null) {
            Debug.log(3, "pad added without caps: " + pad);
            return;
        }
        Debug.log(3, "pad added " + pad);
        String mime = caps.getMime();
        if (this.enableAudio && mime.equals("audio/x-vorbis")) {
            if (this.a_queue != null) {
                Debug.log(3, "More than one audio stream detected, ignoring all except first one");
                return;
            }
            this.a_queue = ElementFactory.makeByName("queue", "a_queue");
            if (this.a_queue == null) {
                this.noSuchElement("queue");
                return;
            }
            if (this.v_queue != null) {
                this.v_queue.setProperty("leaky", "2");
            }
            this.audiodec = ElementFactory.makeByName("vorbisdec", "audiodec");
            if (this.audiodec == null) {
                this.noSuchElement("vorbisdec");
                return;
            }
            this.a_queue.setProperty("maxBuffers", "100");
            this.add(this.a_queue);
            this.add(this.audiodec);
            pad.link(this.a_queue.getPad("sink"));
            this.a_queue.getPad("src").link(this.audiodec.getPad("sink"));
            if (!this.audiodec.getPad("src").link(this.asinkpad)) {
                this.postMessage(Message.newError(this, "audiosink already linked"));
                return;
            }
            this.apad = pad;
            this.audiodec.setState(2);
            this.a_queue.setState(2);
        } else if (this.enableVideo && mime.equals("video/x-theora")) {
            this.v_queue = ElementFactory.makeByName("queue", "v_queue");
            this.v_queue2 = ElementFactory.makeByName("queue", "v_queue2");
            if (this.v_queue == null) {
                this.noSuchElement("queue");
                return;
            }
            if (!this.setupVideoDec("theoradec")) {
                return;
            }
            if (this.a_queue != null) {
                this.v_queue.setProperty("leaky", "2");
            }
            this.v_queue.setProperty("maxBuffers", "175");
            this.v_queue2.setProperty("maxBuffers", "1");
            this.add(this.v_queue);
            this.add(this.v_queue2);
            pad.link(this.v_queue.getPad("sink"));
            this.v_queue.getPad("src").link(this.videodec.getPad("sink"));
            this.videodec.getPad("src").link(this.v_queue2.getPad("sink"));
            if (!this.v_queue2.getPad("src").link(this.ovsinkpad)) {
                this.postMessage(Message.newError(this, "videosink already linked"));
                return;
            }
            this.vpad = pad;
            this.videodec.setState(2);
            this.v_queue.setState(2);
            this.v_queue2.setState(2);
        } else if (this.enableVideo && mime.equals("image/jpeg")) {
            if (!this.setupVideoDec("jpegdec")) {
                return;
            }
            this.videodec.setProperty("component", this.component);
            pad.link(this.videodec.getPad("sink"));
            if (!this.videodec.getPad("src").link(this.ovsinkpad)) {
                this.postMessage(Message.newError(this, "videosink already linked"));
                return;
            }
            this.videodec.setState(2);
        } else if (this.enableVideo && mime.equals("video/x-smoke")) {
            if (!this.setupVideoDec("smokedec")) {
                return;
            }
            this.videodec.setProperty("component", this.component);
            pad.link(this.videodec.getPad("sink"));
            if (!this.videodec.getPad("src").link(this.ovsinkpad)) {
                this.postMessage(Message.newError(this, "videosink already linked"));
                return;
            }
            this.vpad = pad;
            this.videodec.setState(2);
        } else if (this.enableVideo && mime.equals("application/x-kate")) {
            int kate_index = this.katedec.size();
            Debug.debug("Found Kate stream, setting up pipeline branch");
            Element tmp_k_queue = ElementFactory.makeByName("queue", "k_queue" + kate_index);
            if (tmp_k_queue == null) {
                this.noSuchElement("queue");
                return;
            }
            Element tmp_katedec = ElementFactory.makeByName("katedec", "katedec" + kate_index);
            if (tmp_katedec == null) {
                this.noSuchElement("katedec");
                return;
            }
            if (this.kselector == null) {
                Debug.debug("No Kate selector yet, creating one");
                if (this.videodec != null) {
                    this.ovsinkpad.unlink();
                    this.videodec.getPad("src").unlink();
                    this.overlay = ElementFactory.makeByName("kateoverlay", "overlay");
                    if (this.overlay == null) {
                        this.noSuchElement("overlay");
                        return;
                    }
                    this.ovsinkpad = this.overlay.getPad("videosink");
                    this.oksinkpad = this.overlay.getPad("katesink");
                    if (!this.videodec.getPad("src").link(this.ovsinkpad)) {
                        this.postMessage(Message.newError(this, "Failed linking video decoder to overlay"));
                        return;
                    }
                    this.add(this.overlay);
                    this.overlay.setProperty("component", this.component);
                    this.overlay.getPad("videosrc").link(this.videosink.getPad("sink"));
                } else {
                    Element fakesink = ElementFactory.makeByName("fakesink", "fakesink");
                    if (fakesink == null) {
                        this.noSuchElement("fakesink");
                        return;
                    }
                    this.oksinkpad = fakesink.getPad("sink");
                    this.add(fakesink);
                    fakesink.setState(2);
                }
                this.kselector = ElementFactory.makeByName("selector", "selector");
                if (this.kselector == null) {
                    this.noSuchElement("selector");
                    return;
                }
                this.add(this.kselector);
                if (!this.kselector.getPad("src").link(this.oksinkpad)) {
                    this.postMessage(Message.newError(this, "Failed linking Kate selector to overlay"));
                    return;
                }
                this.kselector.setState(2);
                ((Cortado)this.component).status.setHaveSubtitles(true);
            }
            Element tmp_katesink = this.kselector;
            this.add(tmp_k_queue);
            this.add(tmp_katedec);
            Pad tmp_kpad = pad;
            Pad tmp_ksinkpad = tmp_katesink.getPad("sink");
            if (!pad.link(tmp_k_queue.getPad("sink"))) {
                this.postMessage(Message.newError(this, "Failed to link new Kate stream to queue"));
                return;
            }
            if (!tmp_k_queue.getPad("src").link(tmp_katedec.getPad("sink"))) {
                this.postMessage(Message.newError(this, "Failed to link new Kate queue to decoder"));
                return;
            }
            Pad new_selector_pad = this.kselector.requestSinkPad(tmp_katedec.getPad("src"));
            if (!tmp_katedec.getPad("src").link(new_selector_pad)) {
                this.postMessage(Message.newError(this, "kate sink already linked"));
                return;
            }
            tmp_katedec.setState(2);
            tmp_k_queue.setState(2);
            this.katedec.addElement(tmp_katedec);
            this.k_queue.addElement(tmp_k_queue);
            if (this.enableKate == this.katedec.size() - 1) {
                this.doEnableKateIndex(this.enableKate);
            } else if (!(this.enableKate >= 0 || this.enableKateLanguage.equals("") && this.enableKateCategory.equals(""))) {
                boolean matching_category;
                String language = caps.getFieldString("language", "");
                String category = caps.getFieldString("category", "");
                boolean matching_language = this.enableKateLanguage.equals("") || this.enableKateLanguage.equals(language);
                boolean bl = matching_category = this.enableKateCategory.equals("") || this.enableKateCategory.equals(category);
                if (matching_language && matching_category) {
                    this.doEnableKateIndex(this.katedec.size() - 1);
                }
            }
        }
    }

    public void padRemoved(Pad pad) {
        pad.unlink();
        if (pad == this.vpad) {
            Debug.log(3, "video pad removed " + pad);
            this.ovsinkpad.unlink();
            this.vpad = null;
        } else if (pad == this.apad) {
            Debug.log(3, "audio pad removed " + pad);
            this.asinkpad.unlink();
            this.apad = null;
        }
    }

    public void noMorePads() {
        boolean changed = false;
        Debug.log(3, "all streams detected");
        if (this.apad == null && this.enableAudio) {
            Debug.log(3, "file has no audio, remove audiosink");
            this.audiosink.setState(1);
            this.remove(this.audiosink);
            this.audiosink = null;
            changed = true;
            if (this.videosink != null) {
                this.videosink.setProperty("max-lateness", Long.toString(Long.MAX_VALUE));
            }
        }
        if (this.vpad == null && this.enableVideo) {
            Debug.log(3, "file has no video, remove videosink");
            this.videosink.setState(1);
            if (this.overlay != null) {
                this.overlay.setState(1);
            }
            this.remove(this.videosink);
            this.remove(this.overlay);
            this.videosink = null;
            this.overlay = null;
            changed = true;
        }
        if (changed) {
            this.scheduleReCalcState();
        }
    }

    public CortadoPipeline(Cortado cortado) {
        super("pipeline");
        this.application = cortado;
        this.enableKate = -1;
    }

    public void setUrl(String anUrl) {
        this.url = anUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUserId(String aUserId) {
        this.userId = aUserId;
    }

    public void setKeepAspect(boolean keep) {
        this.keepAspect = keep;
    }

    public void setIgnoreAspect(boolean ignore) {
        this.ignoreAspect = ignore;
    }

    public void setPassword(String aPassword) {
        this.password = aPassword;
    }

    public void enableAudio(boolean b2) {
        this.enableAudio = b2;
    }

    public boolean isAudioEnabled() {
        return this.enableAudio;
    }

    public void enableVideo(boolean b2) {
        this.enableVideo = b2;
    }

    public boolean isVideoEnabled() {
        return this.enableVideo;
    }

    private int findKateStream(String language, String category) {
        boolean has_category;
        int idx = -1;
        boolean has_language = !language.equals("");
        boolean bl = has_category = !category.equals("");
        if (has_language || has_category) {
            for (int n2 = 0; n2 < this.katedec.size(); ++n2) {
                Element e2 = (Element)this.katedec.elementAt(n2);
                if (e2 == null) continue;
                String e_language = String.valueOf(e2.getProperty("language"));
                String e_category = String.valueOf(e2.getProperty("category"));
                if (!language.equalsIgnoreCase(e_language) || has_category && !category.equals(e_category)) continue;
                idx = n2;
            }
        }
        return idx;
    }

    public void enableKateStream(int idx, String language, String category) {
        if (idx < 0) {
            this.enableKateLanguage = language;
            this.enableKateCategory = category;
            idx = this.findKateStream(language, category);
        }
        if (idx == this.enableKate) {
            return;
        }
        this.doEnableKateIndex(idx);
    }

    private void doEnableKateIndex(int idx) {
        if (this.kselector != null) {
            Debug.info("Switching Kate streams from " + this.enableKate + " to " + idx);
            this.kselector.setProperty("selected", new Integer(idx));
        } else {
            Debug.warning("Switching Kate stream request, but no Kate selector exists");
        }
        this.enableKate = idx;
    }

    public int getEnabledKateIndex() {
        return this.enableKate;
    }

    public void setComponent(Component c2) {
        this.component = c2;
    }

    public Component getComponent() {
        return this.component;
    }

    public void setDocumentBase(URL base) {
        this.documentBase = base;
    }

    public URL getDocumentBase() {
        return this.documentBase;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferLow(int size) {
        this.bufferLow = size;
    }

    public int getBufferLow() {
        return this.bufferLow;
    }

    public void setBufferHigh(int size) {
        this.bufferHigh = size;
    }

    public int getBufferHigh() {
        return this.bufferHigh;
    }

    public void resize(Dimension d2) {
        if (this.videosink == null || d2 == null) {
            return;
        }
        Rectangle bounds = new Rectangle(d2);
        if (this.application.getShowStatus() == 1) {
            bounds.height -= this.application.getStatusHeight();
        }
        if (bounds.height < 0) {
            bounds.height = 0;
        }
        this.videosink.setProperty("bounds", bounds);
    }

    public boolean buildOgg() {
        this.demux = ElementFactory.makeByName("oggdemux", "demux");
        if (this.demux == null) {
            this.noSuchElement("oggdemux");
            return false;
        }
        this.buffer = ElementFactory.makeByName("queue", "buffer");
        if (this.buffer == null) {
            this.demux = null;
            this.noSuchElement("queue");
            return false;
        }
        this.buffer.setProperty("isBuffer", Boolean.TRUE);
        if (this.bufferSize != -1) {
            this.buffer.setProperty("maxSize", new Integer(this.bufferSize * 1024));
        }
        if (this.bufferLow != -1) {
            this.buffer.setProperty("lowPercent", new Integer(this.bufferLow));
        }
        if (this.bufferHigh != -1) {
            this.buffer.setProperty("highPercent", new Integer(this.bufferHigh));
        }
        this.add(this.demux);
        this.add(this.buffer);
        this.httpsrc.getPad("src").link(this.buffer.getPad("sink"));
        this.buffer.getPad("src").link(this.demux.getPad("sink"));
        this.demux.addPadListener(this);
        this.buffer.setState(2);
        this.demux.setState(2);
        return true;
    }

    public boolean buildMultipart() {
        this.demux = ElementFactory.makeByName("multipartdemux", "demux");
        if (this.demux == null) {
            this.noSuchElement("multipartdemux");
            return false;
        }
        this.add(this.demux);
        this.httpsrc.getPad("src").link(this.demux.getPad("sink"));
        this.demux.addPadListener(this);
        return true;
    }

    public void capsChanged(Caps caps) {
        String mime = caps.getMime();
        if (mime.equals("application/ogg")) {
            this.buildOgg();
        } else if (mime.equals("multipart/x-mixed-replace")) {
            this.buildMultipart();
        } else {
            this.postMessage(Message.newError(this, "unknown type: " + mime));
        }
    }

    private void noSuchElement(String elemName) {
        this.postMessage(Message.newError(this, "no such element: " + elemName + " (check plugins.ini)"));
    }

    private boolean build() {
        String vendor = System.getProperty("java.vendor");
        this.httpsrc = ElementFactory.makeByName("httpsrc", "httpsrc");
        if (this.httpsrc == null) {
            this.noSuchElement("httpsrc");
            return false;
        }
        this.httpsrc.setProperty("url", this.url);
        this.httpsrc.setProperty("userId", this.userId);
        this.httpsrc.setProperty("password", this.password);
        String userAgent = "Cortado/ " + vendor.substring(0, vendor.indexOf(" ")) + "/" + System.getProperty("java.version");
        String extra = "(" + System.getProperty("os.name") + " " + System.getProperty("os.version") + ")";
        try {
            String agent = System.getProperty("http.agent");
            if (agent != null) {
                extra = agent;
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        userAgent = userAgent + " " + extra;
        Debug.log(3, "setting User-Agent " + userAgent);
        this.httpsrc.setProperty("userAgent", userAgent);
        this.httpsrc.setProperty("documentBase", this.documentBase);
        this.add(this.httpsrc);
        this.httpsrc.getPad("src").addCapsListener(this);
        if (this.enableAudio) {
            this.audiosink = this.newAudioSink();
            if (this.audiosink == null) {
                this.enableAudio = false;
                ((Cortado)this.component).status.setHaveAudio(false);
                this.component.repaint();
            } else {
                this.asinkpad = this.audiosink.getPad("sink");
                this.add(this.audiosink);
            }
        }
        if (this.enableVideo) {
            this.videosink = ElementFactory.makeByName("videosink", "videosink");
            if (this.videosink == null) {
                this.noSuchElement("videosink");
                return false;
            }
            this.videosink.setProperty("keep-aspect", this.keepAspect ? "true" : "false");
            this.videosink.setProperty("ignore-aspect", this.ignoreAspect ? "true" : "false");
            this.videosink.setProperty("component", this.component);
            this.resize(this.component.getSize());
            this.videosink.setProperty("max-lateness", Long.toString(this.enableAudio ? 20000L : Long.MAX_VALUE));
            this.add(this.videosink);
            this.ovsinkpad = this.videosink.getPad("sink");
        }
        if (this.audiosink == null && this.videosink == null) {
            this.postMessage(Message.newError(this, "Both audio and video are disabled, can't play anything"));
            return false;
        }
        return true;
    }

    protected Element newAudioSink() {
        AudioSink s2;
        try {
            Class.forName("javax.sound.sampled.AudioSystem");
            Class.forName("javax.sound.sampled.DataLine");
            this.usingJavaX = true;
            s2 = (AudioSink)ElementFactory.makeByName("audiosinkj2", "audiosink");
            Debug.log(3, "using high quality javax.sound backend");
        }
        catch (Throwable e2) {
            try {
                Class.forName("sun.audio.AudioStream");
                Class.forName("sun.audio.AudioPlayer");
                s2 = (AudioSink)ElementFactory.makeByName("audiosinksa", "audiosink");
                Debug.log(3, "using low quality sun.audio backend");
            }
            catch (Throwable e22) {
                s2 = null;
                Debug.log(3, "No audio backend available");
            }
        }
        if (s2 == null) {
            Debug.warn("Failed to create an audio sink, continuing anyway");
            return null;
        }
        if (!s2.test()) {
            return null;
        }
        return s2;
    }

    private boolean cleanup() {
        Debug.log(3, "cleanup");
        if (this.httpsrc != null) {
            this.remove(this.httpsrc);
            this.httpsrc = null;
        }
        if (this.audiosink != null) {
            this.remove(this.audiosink);
            this.audiosink = null;
            this.asinkpad = null;
        }
        if (this.videosink != null) {
            this.remove(this.videosink);
            this.videosink = null;
        }
        if (this.overlay != null) {
            this.remove(this.overlay);
            this.overlay = null;
            this.ovsinkpad = null;
            this.oksinkpad = null;
        }
        if (this.buffer != null) {
            this.remove(this.buffer);
            this.buffer = null;
        }
        if (this.demux != null) {
            this.demux.removePadListener(this);
            this.remove(this.demux);
            this.demux = null;
        }
        if (this.v_queue != null) {
            this.remove(this.v_queue);
            this.v_queue = null;
        }
        if (this.v_queue2 != null) {
            this.remove(this.v_queue2);
            this.v_queue2 = null;
        }
        if (this.a_queue != null) {
            this.remove(this.a_queue);
            this.a_queue = null;
        }
        if (this.videodec != null) {
            this.remove(this.videodec);
            this.videodec = null;
        }
        if (this.audiodec != null) {
            this.remove(this.audiodec);
            this.audiodec = null;
        }
        for (int n2 = 0; n2 < this.katedec.size(); ++n2) {
            if (this.k_queue.elementAt(n2) != null) {
                this.remove((Element)this.k_queue.elementAt(n2));
            }
            if (this.katedec.elementAt(n2) == null) continue;
            this.remove((Element)this.katedec.elementAt(n2));
        }
        this.k_queue.removeAllElements();
        this.katedec.removeAllElements();
        if (this.kselector != null) {
            this.remove(this.kselector);
            this.kselector = null;
        }
        return true;
    }

    protected int changeState(int transition) {
        switch (transition) {
            case 18: {
                if (this.build()) break;
                return 0;
            }
        }
        int res = super.changeState(transition);
        switch (transition) {
            case 33: {
                this.cleanup();
                break;
            }
        }
        return res;
    }

    protected boolean doSendEvent(Event event) {
        if (event.getType() != 5) {
            return false;
        }
        if (event.parseSeekFormat() != 5) {
            return false;
        }
        if (this.httpsrc == null) {
            return false;
        }
        boolean res = this.httpsrc.getPad("src").sendEvent(event);
        this.getState(null, null, -1L);
        return res;
    }

    protected long getPosition() {
        long result = 0L;
        Query q2 = Query.newPosition(3);
        if (super.query(q2)) {
            result = q2.parsePositionValue();
        }
        return result;
    }

    protected int getNumKateStreams() {
        return this.katedec.size();
    }

    protected String getKateStreamCategory(int idx) {
        if (idx < 0 || idx >= this.katedec.size()) {
            return "";
        }
        return String.valueOf(((Element)this.katedec.elementAt(idx)).getProperty("category"));
    }

    protected String getKateStreamLanguage(int idx) {
        if (idx < 0 || idx >= this.katedec.size()) {
            return "";
        }
        return String.valueOf(((Element)this.katedec.elementAt(idx)).getProperty("language"));
    }
}

