/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.plugin.OggPayload;
import com.fluendo.utils.Base64Converter;
import com.fluendo.utils.Debug;
import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;

public class DurationScanner {
    static final int NOTDETECTED = -1;
    static final int UNKNOWN = 0;
    static final int VORBIS = 1;
    static final int THEORA = 2;
    private long contentLength = -1L;
    private long responseOffset;
    private Hashtable streaminfo = new Hashtable();
    private SyncState oy = new SyncState();
    private Page og = new Page();
    private Packet op = new Packet();

    public DurationScanner() {
        this.oy.init();
    }

    private InputStream openWithConnection(URL url, String userId, String password, long offset) throws IOException {
        InputStream dis = null;
        String userAgent = "Cortado";
        URLConnection uc = url.openConnection();
        uc.setRequestProperty("Connection", "Keep-Alive");
        String range = offset != 0L && this.contentLength != -1L ? "bytes=" + offset + "-" + (this.contentLength - 1L) : (offset != 0L ? "bytes=" + offset + "-" : null);
        if (range != null) {
            Debug.info("doing range: " + range);
            uc.setRequestProperty("Range", range);
        }
        uc.setRequestProperty("User-Agent", userAgent);
        if (userId != null && password != null) {
            String userPassword = userId + ":" + password;
            String encoding = Base64Converter.encode(userPassword.getBytes());
            uc.setRequestProperty("Authorization", "Basic " + encoding);
        }
        uc.setRequestProperty("Content-Type", "application/octet-stream");
        dis = uc.getInputStream();
        String responseRange = uc.getHeaderField("Content-Range");
        if (responseRange == null) {
            Debug.info("Response contained no Content-Range field, assuming offset=0");
            this.responseOffset = 0L;
        } else {
            try {
                MessageFormat format = new MessageFormat("bytes {0,number}-{1,number}");
                format.setLocale(Locale.US);
                Object[] parts = format.parse(responseRange);
                this.responseOffset = ((Number)parts[0]).longValue();
                if (this.responseOffset < 0L) {
                    this.responseOffset = 0L;
                }
                Debug.debug("Stream successfully with offset " + this.responseOffset);
            }
            catch (Exception e2) {
                Debug.info("Error parsing Content-Range header");
                this.responseOffset = 0L;
            }
        }
        this.contentLength = (long)uc.getHeaderFieldInt("Content-Length", -1) + this.responseOffset;
        return dis;
    }

    private void determineType(Packet packet, StreamInfo info) {
        int ret;
        OggPayload pl;
        Class<?> c2;
        if (info.decoder != null) {
            int ret2 = info.decoder.takeHeader(packet);
            if (ret2 > 0) {
                info.ready = true;
            }
            return;
        }
        try {
            c2 = Class.forName("com.fluendo.plugin.TheoraDec");
            pl = (OggPayload)c2.newInstance();
            ret = pl.takeHeader(packet);
            if (ret >= 0) {
                info.decoder = pl;
                info.type = 2;
                return;
            }
        }
        catch (Throwable e2) {
            // empty catch block
        }
        try {
            c2 = Class.forName("com.fluendo.plugin.VorbisDec");
            pl = (OggPayload)c2.newInstance();
            ret = pl.takeHeader(packet);
            if (ret >= 0) {
                info.decoder = pl;
                info.type = 1;
                return;
            }
        }
        catch (Throwable e3) {
            // empty catch block
        }
        info.type = 0;
    }

    public TimingInfo scanBuffer(byte[] buffer, int bufbytes) {
        long start = -1L;
        long time = -1L;
        int offset = this.oy.buffer(bufbytes);
        System.arraycopy(buffer, 0, this.oy.data, offset, bufbytes);
        this.oy.wrote(bufbytes);
        while (this.oy.pageout(this.og) == 1) {
            Integer serialno = new Integer(this.og.serialno());
            StreamInfo info = (StreamInfo)this.streaminfo.get(serialno);
            if (info == null) {
                info = new StreamInfo();
                info.streamstate = new StreamState();
                info.streamstate.init(this.og.serialno());
                this.streaminfo.put(serialno, info);
                Debug.info("DurationScanner: created StreamState for stream no. " + serialno);
            }
            info.streamstate.pagein(this.og);
            block5: while (info.streamstate.packetout(this.op) == 1) {
                int type = info.type;
                if (type == -1 || !info.ready) {
                    this.determineType(this.op, info);
                } else if (type != -1 && type != 0 && info.ready && info.startgranule < 0L) {
                    info.startgranule = this.og.granulepos();
                    long thisStartTime = info.decoder.granuleToTime(info.startgranule);
                    if (start < 0L || thisStartTime < start) {
                        start = thisStartTime;
                    }
                    Debug.info("start granule for stream " + this.og.serialno() + ": " + info.startgranule);
                }
                if (!info.ready) continue;
                switch (type) {
                    case 1: {
                        OggPayload pl = info.decoder;
                        long t2 = pl.granuleToTime(this.og.granulepos()) - pl.granuleToTime(info.startgranule);
                        if (t2 <= time) continue block5;
                        time = t2;
                        break;
                    }
                    case 2: {
                        OggPayload pl = info.decoder;
                        long t2 = pl.granuleToTime(this.og.granulepos()) - pl.granuleToTime(info.startgranule);
                        if (t2 <= time) break;
                        time = t2;
                    }
                }
            }
        }
        return new TimingInfo((float)start / 1000000.0f, (float)time / 1000000.0f);
    }

    public TimingInfo scanURL(URL url, String user, String password) {
        try {
            TimingInfo tinfo;
            int headbytes = 65536;
            int tailbytes = 131072;
            float start = -1.0f;
            float time = 0.0f;
            byte[] buffer = new byte[1024];
            InputStream is = this.openWithConnection(url, user, password, 0L);
            int read = 0;
            long totalbytes = 0L;
            read = is.read(buffer);
            while (totalbytes < (long)headbytes && read > 0) {
                totalbytes += (long)read;
                tinfo = this.scanBuffer(buffer, read);
                if (tinfo.duration >= 0.0f) {
                    float t2 = tinfo.duration;
                    float f2 = time = t2 > time ? t2 : time;
                }
                if (tinfo.startTime >= 0.0f && start < 0.0f) {
                    start = tinfo.startTime;
                }
                read = is.read(buffer);
            }
            is.close();
            is = this.openWithConnection(url, user, password, Math.max(0L, this.contentLength - (long)tailbytes));
            if (this.responseOffset == 0L && (long)tailbytes < this.contentLength) {
                Debug.warning("DurationScanner: Couldn't complete duration scan due to failing range requests!");
                return new TimingInfo();
            }
            read = is.read(buffer);
            while (read > 0 && totalbytes < (long)((headbytes + tailbytes) * 2)) {
                totalbytes += (long)read;
                tinfo = this.scanBuffer(buffer, read);
                if (tinfo.duration >= 0.0f) {
                    time = tinfo.duration > time ? tinfo.duration : time;
                }
                read = is.read(buffer);
            }
            return new TimingInfo(start, time);
        }
        catch (IOException e2) {
            Debug.error(e2.toString());
            return new TimingInfo();
        }
    }

    public static void main(String[] args) throws IOException {
        URL url = new URL(args[0]);
        DurationScanner ds = new DurationScanner();
        TimingInfo tinfo = ds.scanURL(url, null, null);
        System.out.println(tinfo.duration);
    }

    private class StreamInfo {
        public OggPayload decoder = null;
        public int type = -1;
        public long startgranule = -1L;
        public StreamState streamstate;
        public boolean ready = false;

        private StreamInfo() {
        }
    }

    public class TimingInfo {
        public float startTime = -1.0f;
        public float duration = -1.0f;

        TimingInfo(float st, float d2) {
            this.startTime = st;
            this.duration = d2;
        }

        TimingInfo() {
            this.startTime = -1.0f;
            this.duration = -1.0f;
        }
    }
}

