/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.player.StatusListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;

public class Status
extends Component
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private int bufferPercent;
    private boolean buffering;
    private String message;
    private String error;
    private Rectangle r;
    private Component component;
    private Font font = new Font("SansSerif", 0, 10);
    private Font boldFont = null;
    private boolean haveAudio;
    private boolean haveSubtitles;
    private boolean havePercent;
    private boolean seekable;
    private boolean live;
    private boolean showSpeaker;
    private boolean showSubtitles;
    private boolean clearedScreen;
    private static final int NONE = -1;
    private static final int BUTTON1 = 0;
    private static final int BUTTON2 = 1;
    private static final int SEEKER = 2;
    private static final int SEEKBAR = 3;
    private static final int AUDIO = 4;
    private static final int SUBTITLES = 5;
    private int clicked = -1;
    private Color[] colors = new Color[]{Color.black, Color.black, Color.black, Color.black, Color.black, Color.black};
    private static final int SPEAKER_WIDTH = 12;
    private static final int SPEAKER_HEIGHT = 10;
    private static final int TIME_WIDTH = 38;
    private static final int SEEK_TIME_GAP = 10;
    private static final int THUMB_WIDTH = 9;
    public static final int STATE_STOPPED = 0;
    public static final int STATE_PAUSED = 1;
    public static final int STATE_PLAYING = 2;
    private int state = 0;
    private double position = 0.0;
    private long time;
    private double startTime = 0.0;
    private double duration;
    private long byteDuration;
    private long bytePosition;
    private String speaker = "\u0000\u0000\u0000\u0000\u0000\u00ef\u0000\u0000\u00efU\u0017\u001e\u0000\u0000\u0000\u0000\u00ef\u00ef\u0000\u0000\u0000\u00efU\u0018\u0000\u0000\u0000\u00ef\u0000\u00ef\u0000\u00ef\u0000\u0000\u00ef\u0013\u00ef\u00ef\u00ef\u0000\u001c\u00ef\u0000Z\u00ef\u0000\u00ef\\\u00ef\u0000)+F\u00ef\u0000\u0000\u00ef\u0000\u00efr\u00efIbz\u0091\u00ef\u0000\u0000\u00ef\u0000\u00efr\u00ef\u00ef\u00ef\u00be\u00d3\u00ef\u0000Z\u00ef\u0000\u00ef\\\u0000\u0000\u0000\u00ef\u00ef\u00ef\u0000\u00ef\u0000\u0000\u00ef\u0000\u0000\u0000\u0000\u0000\u00ef\u00ef\u0000\u0000\u0000\u00ef\\\u0000\u0000\u0000\u0000\u0000\u0000\u00ef\u0000\u0000\u00ef\\\u0000\u0000";
    private Image speakerImg;
    private int speakerWidth;
    private int subtitlesWidth;
    private Vector listeners = new Vector();

    public Image createImage(Component comp, String s2, int w2, int h2) {
        int[] pixels = new int[w2 * h2];
        for (int i2 = 0; i2 < w2 * h2; ++i2) {
            pixels[i2] = 0xFF000000 | s2.charAt(i2) << 16 | s2.charAt(i2) << 8 | s2.charAt(i2);
        }
        return comp.getToolkit().createImage(new MemoryImageSource(w2, h2, pixels, 0, w2));
    }

    public Status(Component comp) {
        this.component = comp;
        this.speakerImg = this.createImage(comp, this.speaker, 12, 10);
    }

    public void addStatusListener(StatusListener l2) {
        this.listeners.addElement(l2);
    }

    public void removeStatusListener(StatusListener l2) {
        this.listeners.removeElement(l2);
    }

    public void notifyNewState(int newState) {
        Enumeration e2 = this.listeners.elements();
        while (e2.hasMoreElements()) {
            ((StatusListener)e2.nextElement()).onState(newState);
        }
    }

    public void notifySeek(double position) {
        Enumeration e2 = this.listeners.elements();
        while (e2.hasMoreElements()) {
            ((StatusListener)e2.nextElement()).onSeek(position);
        }
    }

    public void notifyAudio() {
        Enumeration e2 = this.listeners.elements();
        while (e2.hasMoreElements()) {
            ((StatusListener)e2.nextElement()).onAudio();
        }
    }

    public void notifySubtitles(int x2, int y2) {
        Enumeration e2 = this.listeners.elements();
        while (e2.hasMoreElements()) {
            ((StatusListener)e2.nextElement()).onSubtitles(x2, y2);
        }
    }

    public void update(Graphics g2) {
        this.paint(g2);
    }

    private void paintBox(Graphics g2) {
        g2.setColor(Color.darkGray);
        g2.drawRect(0, 0, this.r.width - 1, this.r.height - 1);
        g2.setColor(Color.black);
        g2.fillRect(1, 1, this.r.width - 2, this.r.height - 2);
    }

    private void paintPercent(Graphics g2) {
        if (this.havePercent) {
            g2.setColor(Color.white);
            g2.drawString("" + this.bufferPercent + "%", this.r.width - 26 - this.speakerWidth - this.subtitlesWidth, this.r.height - 2);
        }
    }

    private void paintButton1(Graphics g2) {
        int x2 = 1;
        int y2 = 1;
        int w2 = this.r.height - 2;
        int h2 = this.r.height - 2;
        g2.setColor(Color.darkGray);
        g2.drawRect(x2, y2, w2, h2);
        g2.setColor(this.colors[0]);
        g2.fillRect(x2 + 1, y2 + 1, w2 - 1, h2 - 1);
        if (this.state == 2) {
            g2.setColor(Color.white);
            if (this.live) {
                g2.fillRect((int)((double)w2 * 0.4), (int)((double)w2 * 0.4), (int)((double)w2 * 0.5), (int)((double)w2 * 0.5));
            } else {
                g2.fillRect((int)((double)w2 * 0.4), (int)((double)h2 * 0.4), (int)((double)w2 * 0.2), (int)((double)h2 * 0.5));
                g2.fillRect((int)((double)w2 * 0.7), (int)((double)h2 * 0.4), (int)((double)w2 * 0.2), (int)((double)h2 * 0.5));
            }
        } else {
            int[] triangleX = new int[]{(int)((double)w2 * 0.4), (int)((double)w2 * 0.4), (int)((double)w2 * 0.9)};
            int[] triangleY = new int[]{(int)((double)w2 * 0.3), (int)((double)w2 * 0.9), (int)((double)w2 * 0.6)};
            g2.setColor(Color.white);
            g2.fillPolygon(triangleX, triangleY, 3);
        }
    }

    private void paintButton2(Graphics g2) {
        int x2 = this.r.height + 1;
        int y2 = 1;
        int w2 = this.r.height - 2;
        int h2 = this.r.height - 2;
        g2.setColor(Color.darkGray);
        g2.drawRect(x2, y2, w2, h2);
        g2.setColor(this.colors[1]);
        g2.fillRect(x2 + 1, y2 + 1, w2 - 1, h2 - 1);
        g2.setColor(Color.white);
        g2.fillRect(this.r.height + (int)((double)w2 * 0.4), (int)((double)w2 * 0.4), (int)((double)w2 * 0.5), (int)((double)w2 * 0.5));
    }

    private void paintMessage(Graphics g2, int pos) {
        if (this.message != null) {
            g2.setColor(Color.white);
            g2.drawString(this.message, pos, this.r.height - 2);
        }
    }

    private void paintBuffering(Graphics g2, int pos) {
        g2.setColor(Color.white);
        g2.drawString("Buffering", pos, this.r.height - 2);
    }

    private Rectangle getSeekBarRect() {
        return new Rectangle(this.r.height * 2 + 1, 2, this.r.width - 10 - 38 - this.speakerWidth - this.subtitlesWidth - this.r.height * 2, this.r.height - 4);
    }

    private Rectangle getThumbRect() {
        Rectangle seekRect = this.getSeekBarRect();
        int availableWidth = seekRect.width - 9;
        int pos = (int)((double)availableWidth * this.position);
        return new Rectangle(pos + seekRect.x, 1, 9, this.r.height - 2);
    }

    private void paintSeekBar(Graphics g2) {
        Rectangle sr = this.getSeekBarRect();
        Rectangle tr = this.getThumbRect();
        g2.setColor(Color.darkGray);
        g2.drawRect(sr.x, sr.y, sr.width, sr.height);
        g2.setColor(Color.gray);
        g2.fillRect(sr.x + 2, sr.y + 3, tr.x - (sr.x + 2), sr.height - 6);
        g2.setColor(Color.white);
        g2.drawLine(tr.x + 1, tr.y, tr.x + tr.width - 1, tr.y);
        g2.drawLine(tr.x + 1, tr.y + tr.height, tr.x + tr.width - 1, tr.y + tr.height);
        g2.drawLine(tr.x, tr.y + 1, tr.x, tr.y + tr.height - 1);
        g2.drawLine(tr.x + tr.width, tr.y + 1, tr.x + tr.width, tr.y + tr.height - 1);
        g2.setColor(this.colors[2]);
        g2.fillRect(tr.x + 1, tr.y + 1, tr.width - 1, tr.height - 1);
    }

    private void paintTime(Graphics g2) {
        if (this.time < 0L) {
            return;
        }
        long sec = this.time % 60L;
        long min = this.time / 60L;
        long hour = min / 60L;
        this.r = this.getBounds();
        int end = this.r.width - this.speakerWidth - this.subtitlesWidth - 38;
        g2.setColor(Color.white);
        g2.drawString("" + hour + ":" + ((min %= 60L) < 10L ? "0" + min : "" + min) + ":" + (sec < 10L ? "0" + sec : "" + sec), end, this.r.height - 2);
    }

    private void paintSpeaker(Graphics g2) {
        if (this.haveAudio) {
            g2.drawImage(this.speakerImg, this.r.width - 12 - this.subtitlesWidth, this.r.height - 10 - 1, null);
        }
    }

    private Rectangle getSubtitlesBounds() {
        int x2 = this.r.width - this.subtitlesWidth + 1;
        int y2 = 1;
        int w2 = this.r.height * 3 / 2 - 2;
        int h2 = this.r.height - 2;
        return new Rectangle(x2, y2, w2, h2);
    }

    private void paintSubtitles(Graphics g2) {
        if (this.haveSubtitles) {
            Rectangle sb = this.getSubtitlesBounds();
            int font_height = this.r.height - 2;
            g2.setColor(Color.darkGray);
            g2.drawRect(sb.x, sb.y, sb.width, sb.height);
            g2.setColor(this.colors[5]);
            g2.fillRect(sb.x + 1, sb.y + 1, sb.width - 1, sb.height - 1);
            if (this.boldFont == null) {
                this.boldFont = new Font("SansSerif", 1, font_height);
            }
            g2.setColor(Color.white);
            Font previousFont = g2.getFont();
            g2.setFont(this.boldFont);
            FontMetrics fm = g2.getFontMetrics();
            float cc_w = fm.stringWidth("CC");
            float cc_h = fm.getAscent() - fm.getDescent();
            float button_midx = (float)sb.x + (float)sb.width / 2.0f;
            float button_midy = (float)sb.y + (float)sb.height / 2.0f;
            g2.drawString("CC", (int)(button_midx - cc_w / 2.0f + 0.5f), (int)(button_midy + cc_h / 2.0f + 0.5f));
            g2.setFont(previousFont);
        }
    }

    public void paint(Graphics g2) {
        if (!this.isVisible() && this.clearedScreen) {
            return;
        }
        this.r = this.getBounds();
        if (!this.isVisible() && !this.clearedScreen) {
            g2.clearRect(this.r.x, this.r.y, this.r.width, this.r.height);
            this.clearedScreen = true;
            return;
        }
        this.clearedScreen = false;
        int pos = 0;
        Image img = this.component.createImage(this.r.width, this.r.height);
        if (img == null) {
            return;
        }
        Graphics g22 = img.getGraphics();
        if (g22 == null) {
            return;
        }
        g22.setFont(this.font);
        this.paintBox(g22);
        if (!this.buffering) {
            this.paintButton1(g22);
        }
        if (!this.live) {
            this.paintButton2(g22);
            pos = this.r.height * 2;
        } else {
            pos = this.r.height;
        }
        if (this.buffering) {
            this.paintPercent(g22);
            this.paintBuffering(g22, pos + 3);
        } else if (this.state == 0 || !this.seekable) {
            this.paintMessage(g22, pos + 3);
            this.paintTime(g22);
        } else if (this.seekable) {
            this.paintSeekBar(g22);
            this.paintTime(g22);
        }
        if (this.showSpeaker) {
            this.paintSpeaker(g22);
        }
        if (this.showSubtitles) {
            this.paintSubtitles(g22);
        }
        g2.drawImage(img, this.r.x, this.r.y, null);
        img.flush();
    }

    public void setBufferPercent(boolean buffering, int bp) {
        boolean changed = this.buffering != buffering;
        if (changed |= this.bufferPercent != bp) {
            this.buffering = buffering;
            this.bufferPercent = bp;
            this.component.repaint();
        }
    }

    public void setTime(double seconds) {
        if (this.clicked == -1) {
            this.time = seconds < this.duration || this.seekable ? (long)seconds : (long)this.duration;
            if (this.duration > -1.0) {
                double newPosition = ((double)this.time - this.startTime) / this.duration;
                if (newPosition != this.position) {
                    this.position = newPosition;
                    this.component.repaint();
                }
            } else {
                double newPosition;
                this.position = newPosition = (double)this.bytePosition / (double)this.byteDuration;
                this.component.repaint();
            }
        }
    }

    public void setStartTime(double seconds) {
        this.startTime = seconds >= 0.0 ? seconds : 0.0;
        this.component.repaint();
    }

    public void setDuration(double seconds) {
        this.duration = seconds;
        this.component.repaint();
    }

    public void setByteDuration(long bytes) {
        this.byteDuration = bytes;
        if (this.duration == -1.0) {
            this.position = (double)this.bytePosition / (double)this.byteDuration;
            this.component.repaint();
        }
    }

    public void setBytePosition(long bytes) {
        this.bytePosition = bytes;
        if (this.duration == -1.0) {
            this.position = (double)this.bytePosition / (double)this.byteDuration;
            this.component.repaint();
        }
    }

    public void setMessage(String m2) {
        this.message = m2;
        this.component.repaint();
    }

    public void setHaveAudio(boolean a2) {
        this.haveAudio = a2;
        this.component.repaint();
    }

    public void setHaveSubtitles(boolean a2) {
        this.haveSubtitles = a2;
        this.subtitlesWidth = this.showSubtitles && this.haveSubtitles ? this.r.height * 3 / 2 : 0;
        this.component.repaint();
    }

    public void setHavePercent(boolean p2) {
        this.havePercent = p2;
        this.component.repaint();
    }

    public void setSeekable(boolean s2) {
        this.seekable = s2;
        this.component.repaint();
    }

    public void setLive(boolean l2) {
        this.live = l2;
        this.component.repaint();
    }

    public void setShowSpeaker(boolean s2) {
        this.showSpeaker = s2;
        this.speakerWidth = s2 ? 12 : 0;
        this.component.repaint();
    }

    public void setShowSubtitles(boolean s2) {
        this.showSubtitles = s2;
        this.subtitlesWidth = this.showSubtitles && this.haveSubtitles ? this.r.height * 3 / 2 : 0;
        this.component.repaint();
    }

    public void setState(int aState) {
        if (this.state != aState) {
            this.state = aState;
            this.component.repaint();
        }
    }

    private boolean intersectButton1(MouseEvent e2) {
        if (this.r == null) {
            return false;
        }
        return e2.getX() >= 0 && e2.getX() <= this.r.height - 2 && e2.getY() > 0 && e2.getY() <= this.r.height - 2;
    }

    private boolean intersectButton2(MouseEvent e2) {
        if (this.r == null) {
            return false;
        }
        return e2.getX() >= this.r.height && e2.getX() <= this.r.height + this.r.height - 2 && e2.getY() > 0 && e2.getY() <= this.r.height - 2;
    }

    private boolean intersectAudio(MouseEvent e2) {
        return false;
    }

    private boolean intersectSubtitles(MouseEvent e2) {
        if (this.r == null) {
            return false;
        }
        Rectangle bounds = this.getSubtitlesBounds();
        return e2.getX() >= bounds.x && e2.getX() <= bounds.x + bounds.width - 2 && e2.getY() > 0 && e2.getY() <= bounds.height - 2;
    }

    private boolean intersectSeeker(MouseEvent e2) {
        this.r = this.getBounds();
        Rectangle tr = this.getThumbRect();
        return tr.contains(e2.getPoint());
    }

    private boolean intersectSeekbar(MouseEvent e2) {
        this.r = this.getBounds();
        Rectangle sr = this.getSeekBarRect();
        return sr.contains(e2.getPoint());
    }

    private int findComponent(MouseEvent e2) {
        if (!this.buffering && this.intersectButton1(e2)) {
            return 0;
        }
        if (this.intersectButton2(e2)) {
            return 1;
        }
        if (this.showSpeaker && this.haveAudio && this.intersectAudio(e2)) {
            return 4;
        }
        if (this.showSubtitles && this.haveSubtitles && this.intersectSubtitles(e2)) {
            return 5;
        }
        if (this.seekable && this.intersectSeeker(e2)) {
            return 2;
        }
        if (this.seekable && this.intersectSeekbar(e2)) {
            return 3;
        }
        return -1;
    }

    public void cancelMouseOperation() {
        for (int n2 = 0; n2 < this.colors.length; ++n2) {
            this.colors[n2] = Color.black;
        }
        this.clicked = -1;
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
        e2.translatePoint(-1, -1);
        this.clicked = this.findComponent(e2);
        if (this.clicked == 3 && this.state != 0) {
            this.clicked = 2;
            this.colors[2] = Color.gray;
            this.mouseDragged(e2);
        }
    }

    public void mouseReleased(MouseEvent e2) {
        e2.translatePoint(-1, -1);
        int comp = this.findComponent(e2);
        if (this.clicked != comp) {
            if (this.clicked == 2) {
                comp = this.clicked;
            } else {
                return;
            }
        }
        switch (comp) {
            case 0: {
                if (this.state == 2) {
                    this.state = this.live ? 0 : 1;
                    this.notifyNewState(this.state);
                    break;
                }
                this.state = 2;
                this.notifyNewState(this.state);
                break;
            }
            case 1: {
                this.state = 0;
                this.notifyNewState(this.state);
                break;
            }
            case 2: {
                if (this.state == 0) break;
                this.notifySeek(this.position);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.notifyAudio();
                break;
            }
            case 5: {
                this.notifySubtitles(e2.getX(), e2.getY());
                break;
            }
        }
        this.clicked = -1;
        this.component.repaint();
    }

    public void mouseDragged(MouseEvent e2) {
        if (this.seekable) {
            e2.translatePoint(-1, -1);
            if (this.clicked == 2) {
                Rectangle sr = this.getSeekBarRect();
                int availableWidth = sr.width - 9;
                int thumbLeft = e2.getX() - sr.x - 4;
                double newPosition = (double)thumbLeft / (double)availableWidth;
                if (newPosition < 0.0) {
                    newPosition = 0.0;
                } else if (newPosition > 1.0) {
                    newPosition = 1.0;
                }
                if (newPosition != this.position) {
                    this.position = newPosition;
                    this.time = (long)(this.startTime + this.duration * this.position);
                    this.component.repaint();
                }
            }
        }
    }

    private boolean testIntersection(boolean in, int idx) {
        if (in) {
            if (this.colors[idx] != Color.gray) {
                this.colors[idx] = Color.gray;
                return true;
            }
        } else if (this.colors[idx] != Color.black) {
            this.colors[idx] = Color.black;
            return true;
        }
        return false;
    }

    public void mouseMoved(MouseEvent e2) {
        boolean needRepaint = false;
        e2.translatePoint(-1, -1);
        if (!this.buffering && this.testIntersection(this.intersectButton1(e2), 0)) {
            needRepaint = true;
        }
        if (this.testIntersection(this.intersectButton2(e2), 1)) {
            needRepaint = true;
        }
        if (this.seekable && this.testIntersection(this.intersectSeeker(e2), 2)) {
            needRepaint = true;
        }
        if (this.haveAudio && this.showSpeaker && this.testIntersection(this.intersectAudio(e2), 4)) {
            needRepaint = true;
        }
        if (this.haveSubtitles && this.showSubtitles && this.testIntersection(this.intersectSubtitles(e2), 5)) {
            needRepaint = true;
        }
        if (needRepaint) {
            this.component.repaint();
        }
    }
}

