/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.borland.jbcl.layout.OverlayLayout2;
import com.fluendo.player.Cortado;
import com.fluendo.player.CortadoAppletStub;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class VideoPlayer
extends JFrame {
    private VideoPlayer videoPlayer = this;
    private Cortado applet = null;
    private int locationX;
    private int locationY;
    private int playerHeight;
    private int playerWidth;
    private int videoHeight;
    private int videoWidth;
    private int frameWidth;
    private int growEffectPct = 0;
    private boolean growing;
    private long workOrderTimeStamp = -1L;
    private String workOrderPath = null;
    private JPanel mainPanel = new JPanel();
    private OverlayLayout2 overlayLayout21 = new OverlayLayout2();
    private JPanel glassPane = new JPanel();
    private JPanel videoPane = new JPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private FrameComponent lblTop = new FrameComponent(this);
    private FrameComponent lblBottom = new FrameComponent(this);
    private FrameComponent lblLeft = new FrameComponent(this);
    private FrameComponent lblRight = new FrameComponent(this);
    private FrameComponent lblTopRight = new FrameComponent(this);
    private FrameComponent lblTopLeft = new FrameComponent(this);
    private FrameComponent lblBottomRight = new FrameComponent(this);
    private FrameComponent lblBottomLeft = new FrameComponent(this);
    private JPanel glassTop = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel glassBottom = new JPanel();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JPanel glassLeft = new JPanel();
    private BorderLayout borderLayout4 = new BorderLayout();
    private JPanel glassRight = new JPanel();
    private BorderLayout borderLayout5 = new BorderLayout();
    private Timer workOrderMonitor = new Timer(500, new ActionListener(){

        public void actionPerformed(ActionEvent e2) {
            File file = new File(VideoPlayer.this.workOrderPath);
            if (!file.exists()) {
                VideoPlayer.this.shutDown();
            } else if (file.lastModified() != VideoPlayer.this.workOrderTimeStamp) {
                VideoPlayer.this.setVisible(false);
            }
        }
    });
    private Timer growEffectTimer = new Timer(40, new ActionListener(){

        public void actionPerformed(ActionEvent e2) {
            VideoPlayer.this.growEffectPct = VideoPlayer.this.growEffectPct + 4;
            int pct = VideoPlayer.this.growEffectPct;
            if (!VideoPlayer.this.growing) {
                pct = 100 - pct;
            }
            VideoPlayer.this.setSize(new Dimension(VideoPlayer.this.playerWidth, VideoPlayer.this.playerHeight * pct / 100));
            if (VideoPlayer.this.growEffectPct == 100) {
                VideoPlayer.this.growEffectTimer.stop();
                VideoPlayer.this.growEffectPct = 0;
                if (!VideoPlayer.this.growing) {
                    VideoPlayer.this.shutDown();
                } else {
                    VideoPlayer.this.startVideo.start();
                }
            }
        }
    });
    private Timer startVideo = new Timer(200, new ActionListener(){

        public void actionPerformed(ActionEvent e2) {
            VideoPlayer.this.videoPane.add(VideoPlayer.this.applet);
            VideoPlayer.this.applet.init();
            VideoPlayer.this.applet.start();
            VideoPlayer.this.workOrderMonitor.start();
        }
    });

    public VideoPlayer() {
        try {
            System.out.println("Starting player...  (Java:" + System.getProperty("java.version") + ")");
            this.applet = new Cortado();
            this.readWorkOrder();
            this.jbInit();
            this.applet.setBounds(new Rectangle(this.frameWidth, this.frameWidth, this.videoWidth, this.videoHeight));
            this.applet.setStub(new CortadoAppletStub(new String[0], this.applet));
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    VideoPlayer.this.shutDown();
                }
            });
            this.decorate();
            this.growEffectTimer.setRepeats(true);
            this.startVideo.setRepeats(false);
            this.workOrderMonitor.setRepeats(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.setUndecorated(true);
        this.setAlwaysOnTop(true);
        this.glassTop.setLayout(this.borderLayout2);
        this.glassTop.setOpaque(false);
        this.glassTop.add((Component)this.lblTop, "Center");
        this.glassTop.add((Component)this.lblTopRight, "East");
        this.glassTop.add((Component)this.lblTopLeft, "West");
        this.glassBottom.setLayout(this.borderLayout3);
        this.glassBottom.setOpaque(false);
        this.glassBottom.add((Component)this.lblBottom, "Center");
        this.glassBottom.add((Component)this.lblBottomLeft, "West");
        this.glassBottom.add((Component)this.lblBottomRight, "East");
        this.glassLeft.setLayout(this.borderLayout4);
        this.glassLeft.setOpaque(false);
        this.glassLeft.add((Component)this.lblLeft, "Center");
        this.glassRight.setLayout(this.borderLayout5);
        this.glassRight.setOpaque(false);
        this.glassRight.add((Component)this.lblRight, "Center");
        this.glassPane.setOpaque(false);
        this.glassPane.setLayout(this.borderLayout1);
        this.glassPane.add((Component)this.glassBottom, "South");
        this.glassPane.add((Component)this.glassRight, "East");
        this.glassPane.add((Component)this.glassTop, "North");
        this.glassPane.add((Component)this.glassLeft, "West");
        this.videoPane.setOpaque(false);
        this.videoPane.setLayout(null);
        this.mainPanel.setBackground(Color.black);
        this.mainPanel.setLayout(this.overlayLayout21);
        this.mainPanel.add(this.videoPane);
        this.mainPanel.add(this.glassPane);
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    private boolean isMacintosh() {
        return System.getProperty("os.name").toLowerCase().indexOf("mac") != -1;
    }

    private boolean fileExists(String path) {
        return new File(path).exists();
    }

    private String workingDirPath() {
        return System.getProperty("user.dir", ".") + '/';
    }

    private String slashifyRel(String path, boolean isDirectory) {
        String p2 = path;
        if (File.separatorChar != '/') {
            p2 = p2.replace(File.separatorChar, '/');
        }
        if (!p2.endsWith("/") && isDirectory) {
            p2 = p2 + "/";
        }
        return p2;
    }

    private String pathToProgramDataFolders() {
        String programDataPath = this.isMacintosh() ? "/Library/Application Support/" : (this.fileExists("/ProgramData") ? "/ProgramData/" : (this.fileExists("/Documents and Settings/All Users") ? "/Documents and Settings/All Users/" : ""));
        return this.slashifyRel(programDataPath, true);
    }

    private String getWorkOrderPath() {
        String appPath = this.workingDirPath();
        String binName = new File(appPath).getParent();
        String appName = new File(binName).getName();
        String workOrderPath = this.pathToProgramDataFolders() + appName + "/bin/video_player.ini";
        return workOrderPath;
    }

    private void readWorkOrder() throws IOException {
        String line;
        this.workOrderPath = this.getWorkOrderPath();
        File file = new File(this.workOrderPath);
        if (!file.exists()) {
            this.workOrderPath = "video_player.ini";
            file = new File(this.workOrderPath);
            if (!file.exists()) {
                JOptionPane.showMessageDialog(null, "Unable to find video_player.ini.\n\nLocation: " + this.getWorkOrderPath());
            }
        }
        this.workOrderTimeStamp = file.lastModified();
        FileReader fileReader = new FileReader(file);
        BufferedReader reader = new BufferedReader(fileReader);
        boolean inSection = false;
        while ((line = reader.readLine()) != null) {
            int pos;
            if (line.equalsIgnoreCase("[Params]")) {
                inSection = true;
                continue;
            }
            if (line.startsWith("[")) {
                inSection = false;
                continue;
            }
            if (line.startsWith("//") || !inSection || (pos = line.indexOf("=")) == -1) continue;
            String key = line.substring(0, pos);
            String value = line.substring(pos + 1);
            this.applet.setParam(key, value);
        }
        reader.close();
        this.frameWidth = this.applet.getIntParam("frameThickness", 30);
        this.videoWidth = this.applet.getIntParam("videoWidth", 640);
        this.videoHeight = this.applet.getIntParam("videoHeight", 360);
        this.playerWidth = this.videoWidth + this.frameWidth * 2;
        this.playerHeight = this.videoHeight + this.frameWidth * 2;
        this.locationX = this.applet.getIntParam("locationX", 0);
        this.locationY = this.applet.getIntParam("locationY", 0);
    }

    private ImageIcon loadImage(String fullPath) {
        try {
            Image image = this.getToolkit().getImage(fullPath);
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
            return new ImageIcon(image);
        }
        catch (Exception e2) {
            JOptionPane.showMessageDialog(null, "Problem loading image: " + fullPath);
            return null;
        }
    }

    private void decorate() {
        String skinPath = this.applet.getParam("skinPath", null);
        this.lblTop.setIcon(this.loadImage(skinPath + "video.top.png"));
        this.lblBottom.setIcon(this.loadImage(skinPath + "video.bottom.png"));
        this.lblLeft.setIcon(this.loadImage(skinPath + "video.left.png"));
        this.lblRight.setIcon(this.loadImage(skinPath + "video.right.png"));
        this.lblTopLeft.setIcon(this.loadImage(skinPath + "video.topLeft.png"));
        this.lblTopRight.setIcon(this.loadImage(skinPath + "video.topRight.png"));
        this.lblBottomLeft.setIcon(this.loadImage(skinPath + "video.bottomLeft.png"));
        this.lblBottomRight.setIcon(this.loadImage(skinPath + "video.bottomRight.png"));
        this.lblTopRight.setRolloverIcon(this.loadImage(skinPath + "video.topRight.rollover.png"));
        this.lblBottomRight.setRolloverIcon(this.loadImage(skinPath + "video.bottomRight.rollover.png"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        VideoPlayer p2;
        VideoPlayer videoPlayer = p2 = new VideoPlayer();
        synchronized (videoPlayer) {
            try {
                p2.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        if (visible) {
            if (this.isMacintosh()) {
                this.setBounds(this.locationX, this.locationY, this.playerWidth, this.playerHeight);
                super.setVisible(true);
                this.startVideo.start();
            } else {
                this.setBounds(this.locationX, this.locationY, this.playerWidth, 0);
                super.setVisible(true);
                this.growing = true;
                this.growEffectTimer.start();
            }
        } else {
            if (this.isMacintosh()) {
                this.shutDown();
            }
            this.applet.pause();
            this.growing = false;
            this.growEffectTimer.start();
        }
    }

    public void shutDown() {
        if (this.applet != null) {
            this.applet.stop();
            this.applet.destroy();
        }
        System.exit(0);
    }

    private class FrameComponent
    extends JLabel {
        private Point startDragPoint;
        private Dimension startSize;
        private Window owner;
        private Icon rolloverIcon = null;
        private Icon icon = null;

        public FrameComponent(Window owner) {
            this.owner = owner;
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e2) {
                    FrameComponent.this.resize();
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e2) {
                    FrameComponent.this.doMousePressed(e2);
                }

                public void mouseEntered(MouseEvent e2) {
                    if (FrameComponent.this.rolloverIcon != null) {
                        FrameComponent.this.doSetIcon(FrameComponent.this.rolloverIcon);
                    }
                }

                public void mouseExited(MouseEvent e2) {
                    if (FrameComponent.this.rolloverIcon != null) {
                        FrameComponent.this.doSetIcon(FrameComponent.this.icon);
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseDragged(MouseEvent e2) {
                    FrameComponent.this.doMouseDragged(e2);
                }
            });
        }

        private void doMousePressed(MouseEvent e2) {
            this.startDragPoint = e2.getPoint();
            this.startSize = this.owner.getSize();
            if (this == VideoPlayer.this.lblTopRight) {
                VideoPlayer.this.videoPlayer.setVisible(false);
            }
        }

        private void doMouseDragged(MouseEvent e2) {
            if (this == VideoPlayer.this.lblBottomRight) {
                int width = this.startSize.width + e2.getX() - this.startDragPoint.x;
                int height = this.startSize.height + e2.getY() - this.startDragPoint.y;
                this.owner.setSize(new Dimension(width, height));
            } else {
                Point newPanelLocation = this.owner.getLocation();
                newPanelLocation.translate(e2.getX() - this.startDragPoint.x, e2.getY() - this.startDragPoint.y);
                this.owner.setLocation(newPanelLocation);
            }
        }

        private void resize() {
            int hLbl;
            int wLbl = this.getWidth();
            if (wLbl <= 0 | (hLbl = this.getHeight()) <= 0) {
                return;
            }
            ImageIcon imageIcon = (ImageIcon)this.getIcon();
            if (imageIcon == null) {
                return;
            }
            int wImage = imageIcon.getIconWidth();
            int hImage = imageIcon.getIconHeight();
            if (wLbl == wImage && hLbl == hImage) {
                return;
            }
            Image newImage = imageIcon.getImage().getScaledInstance(wLbl, hLbl, 1);
            this.setIcon(new ImageIcon(newImage));
        }

        private void doSetIcon(Icon icon) {
            super.setIcon(icon);
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
            this.doSetIcon(icon);
        }

        public void setRolloverIcon(Icon icon) {
            this.rolloverIcon = icon;
        }
    }
}

