/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Event;
import com.fluendo.jst.Pad;
import com.fluendo.jtiger.Renderer;
import com.fluendo.plugin.Overlay;
import com.fluendo.utils.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import java.util.Vector;

public class KateOverlay
extends Overlay {
    private Font font = null;
    private String text = null;
    private Renderer tr = new Renderer();
    private Dimension image_dimension = null;
    private Pad kateSinkPad = new Pad(2, "katesink"){

        protected boolean eventFunc(Event event) {
            switch (event.getType()) {
                case 1: 
                case 2: 
                case 4: {
                    KateOverlay.this.onFlush();
                    break;
                }
            }
            return true;
        }

        protected synchronized int chainFunc(Buffer buf) {
            KateOverlay.this.addKateEvent((com.fluendo.jkate.Event)buf.object);
            return 0;
        }
    };

    public KateOverlay() {
        this.addPad(this.kateSinkPad);
    }

    protected synchronized void addKateEvent(com.fluendo.jkate.Event ev) {
        this.tr.add(ev);
        Debug.log(4, "Kate overlay got Kate event: " + new String(ev.text));
    }

    protected synchronized void onFlush() {
        this.tr.flush();
        this.image_dimension = null;
        Debug.log(4, "Kate overlay flushing");
    }

    protected synchronized void overlay(Buffer buf) {
        buf.object = new OverlayProducer(this.component, this.tr, buf);
    }

    public String getFactoryName() {
        return "kateoverlay";
    }

    private class OverlayProducer
    implements ImageProducer,
    ImageConsumer {
        private Vector consumers = new Vector();
        private Component component;
        private Renderer tr;
        private Buffer buf;
        private Object object;

        OverlayProducer(Component c2, Renderer tr, Buffer b2) {
            this.component = c2;
            this.tr = tr;
            this.buf = b2;
            this.object = this.buf.object;
        }

        public void addConsumer(ImageConsumer ic) {
            if (!this.isConsumer(ic)) {
                this.consumers.add(ic);
            }
        }

        public boolean isConsumer(ImageConsumer ic) {
            return this.consumers.contains(ic);
        }

        public void removeConsumer(ImageConsumer ic) {
            this.consumers.remove(ic);
            ImageProducer ip = (ImageProducer)this.object;
            for (int n2 = 0; n2 < this.consumers.size(); ++n2) {
                ip.removeConsumer(ic);
            }
        }

        public void requestTopDownLeftRightResend(ImageConsumer ic) {
        }

        public void startProduction(ImageConsumer ic) {
            int ret;
            Image img = null;
            this.addConsumer(ic);
            if (KateOverlay.this.image_dimension == null) {
                img = this.getImage(this.object);
                if (img == null) {
                    this.sendError();
                    return;
                }
                KateOverlay.this.image_dimension = new Dimension(img.getWidth(null), img.getHeight(null));
            }
            if ((ret = this.tr.update(this.component, KateOverlay.this.image_dimension, (double)this.buf.timestamp / 1000000.0)) < 0) {
                Debug.log(2, "Failed to update jtiger renderer");
                this.sendOriginalImage();
                return;
            }
            if (!this.buf.duplicate && ret > 0) {
                Debug.log(4, "Video frame is not a dupe and we have nothing to overlay.");
                this.sendOriginalImage();
                return;
            }
            if (this.buf.duplicate && !this.tr.isDirty()) {
                Debug.log(4, "Video frame is a dupe and we're not dirty. Yeah.");
                this.sendOriginalImage();
                return;
            }
            if (img == null) {
                img = this.getImage(this.object);
            }
            img = this.tr.render(this.component, img);
            this.buf.duplicate = false;
            this.sendImage(img);
        }

        private Image getImage(Object object) {
            Image img;
            if (object instanceof ImageProducer) {
                img = this.component.createImage((ImageProducer)object);
            } else if (object instanceof Image) {
                img = (Image)object;
            } else {
                System.out.println(this + ": unknown buffer received " + object);
                img = null;
            }
            return img;
        }

        private void sendError() {
            Debug.log(2, "Sending image error notification");
            for (int n2 = 0; n2 < this.consumers.size(); ++n2) {
                ImageConsumer ic = (ImageConsumer)this.consumers.elementAt(n2);
                ic.imageComplete(1);
            }
        }

        private void sendOriginalImage() {
            ImageProducer ip = (ImageProducer)this.object;
            ip.startProduction(this);
        }

        private void sendImage(Image img) {
            PixelGrabber pg = new PixelGrabber(img, 0, 0, -1, -1, false);
            try {
                if (pg.grabPixels(0L)) {
                    int[] pixels = (int[])pg.getPixels();
                    if (pixels == null) {
                        Debug.log(2, "pixels are null!");
                        this.sendError();
                    } else {
                        for (int n2 = 0; n2 < this.consumers.size(); ++n2) {
                            ImageConsumer ic = (ImageConsumer)this.consumers.elementAt(n2);
                            ic.setHints(30);
                            ic.setDimensions(((KateOverlay)KateOverlay.this).image_dimension.width, ((KateOverlay)KateOverlay.this).image_dimension.height);
                            ic.setPixels(0, 0, ((KateOverlay)KateOverlay.this).image_dimension.width, ((KateOverlay)KateOverlay.this).image_dimension.height, pg.getColorModel(), pixels, 0, ((KateOverlay)KateOverlay.this).image_dimension.width);
                            ic.imageComplete(3);
                        }
                    }
                } else {
                    Debug.log(2, "Failed to grab pixels");
                    this.sendError();
                }
            }
            catch (Exception e2) {
                Debug.log(2, "Failed to grab pixels: " + e2.toString());
                this.sendError();
            }
        }

        public void imageComplete(int status) {
            for (int n2 = 0; n2 < this.consumers.size(); ++n2) {
                ((ImageConsumer)this.consumers.elementAt(n2)).imageComplete(status);
            }
        }

        public void setColorModel(ColorModel cm) {
            for (int n2 = 0; n2 < this.consumers.size(); ++n2) {
                ((ImageConsumer)this.consumers.elementAt(n2)).setColorModel(cm);
            }
        }

        public void setDimensions(int w2, int h2) {
            for (int n2 = 0; n2 < this.consumers.size(); ++n2) {
                ((ImageConsumer)this.consumers.elementAt(n2)).setDimensions(w2, h2);
            }
        }

        public void setHints(int hints) {
            for (int n2 = 0; n2 < this.consumers.size(); ++n2) {
                ((ImageConsumer)this.consumers.elementAt(n2)).setHints(hints);
            }
        }

        public void setProperties(Hashtable props) {
            for (int n2 = 0; n2 < this.consumers.size(); ++n2) {
                ((ImageConsumer)this.consumers.elementAt(n2)).setProperties(props);
            }
        }

        public void setPixels(int x2, int y2, int w2, int h2, ColorModel model, byte[] pixels, int off, int scansize) {
            for (int n2 = 0; n2 < this.consumers.size(); ++n2) {
                ((ImageConsumer)this.consumers.elementAt(n2)).setPixels(x2, y2, w2, h2, model, pixels, off, scansize);
            }
        }

        public void setPixels(int x2, int y2, int w2, int h2, ColorModel model, int[] pixels, int off, int scansize) {
            for (int n2 = 0; n2 < this.consumers.size(); ++n2) {
                ((ImageConsumer)this.consumers.elementAt(n2)).setPixels(x2, y2, w2, h2, model, pixels, off, scansize);
            }
        }
    }
}

