/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.utils.Debug;
import java.util.Vector;

public class MultipartDemux
extends Element {
    private static final String MIME = "multipart/x-mixed-replace";
    private static final String DEFAULT_BOUNDARY = "--ThisRandomString";
    private Vector streams;
    private byte[] accum;
    private int accumSize = 0;
    private int accumPos = 0;
    private int dataEnd;
    private static final int STATE_FIND_BOUNDARY = 1;
    private static final int STATE_PARSE_HEADERS = 2;
    private static final int STATE_FIND_DATA_END = 3;
    private int state = 1;
    private String boundaryString = "--ThisRandomString";
    private byte[] boundary = this.boundaryString.getBytes();
    private int boundaryLen = this.boundary.length;
    private static final byte[] headerEnd = "\n".getBytes();
    private static final int headerEndLen = headerEnd.length;
    private static final String contentType = "content-type: ";
    private static final int contentTypeLen = "content-type: ".length();
    private MultipartStream currentStream = null;
    private Pad sinkpad = new Pad(2, "sink"){

        protected boolean setCapsFunc(Caps caps) {
            String mime = caps.getMime();
            if (!mime.equals(MultipartDemux.MIME)) {
                MultipartDemux.this.postMessage(Message.newError(this, "expected \"" + mime + "\", got \"" + mime + "\""));
                return false;
            }
            String capsBoundary = caps.getFieldString("boundary", MultipartDemux.DEFAULT_BOUNDARY);
            Debug.log(3, this + " boundary string: \"" + capsBoundary + "\"");
            MultipartDemux.this.boundaryString = capsBoundary + "\n";
            MultipartDemux.access$202(MultipartDemux.this, MultipartDemux.this.boundaryString.getBytes());
            MultipartDemux.this.boundaryLen = MultipartDemux.this.boundary.length;
            return true;
        }

        private MultipartStream findStream(String mime) {
            MultipartStream stream = null;
            for (int i2 = 0; i2 < MultipartDemux.this.streams.size() && !(stream = (MultipartStream)MultipartDemux.this.streams.elementAt(i2)).mimeType.equals(mime); ++i2) {
                stream = null;
            }
            return stream;
        }

        private boolean forwardEvent(Event event) {
            for (int i2 = 0; i2 < MultipartDemux.this.streams.size(); ++i2) {
                MultipartStream stream = (MultipartStream)MultipartDemux.this.streams.elementAt(i2);
                stream.pushEvent(event);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean eventFunc(Event event) {
            switch (event.getType()) {
                case 1: {
                    this.forwardEvent(event);
                    Object object = this.streamLock;
                    synchronized (object) {
                        Debug.log(3, "synced " + this);
                        break;
                    }
                }
                case 2: 
                case 3: 
                case 4: {
                    Object object = this.streamLock;
                    synchronized (object) {
                        this.forwardEvent(event);
                        break;
                    }
                }
                default: {
                    this.forwardEvent(event);
                }
            }
            return true;
        }

        private void accumulateBuffer(Buffer buf) {
            int lastPos = MultipartDemux.this.accumSize + MultipartDemux.this.accumPos;
            if (MultipartDemux.this.accum.length < lastPos + buf.length) {
                byte[] newAcum = new byte[MultipartDemux.this.accum.length + buf.length];
                System.arraycopy(MultipartDemux.this.accum, MultipartDemux.this.accumPos, newAcum, 0, MultipartDemux.this.accumSize);
                MultipartDemux.access$802(MultipartDemux.this, newAcum);
                MultipartDemux.this.accumPos = 0;
                lastPos = MultipartDemux.this.accumSize;
            }
            System.arraycopy(buf.data, buf.offset, MultipartDemux.this.accum, lastPos, buf.length);
            MultipartDemux.this.accumSize += buf.length;
        }

        private void flushBytes(int bytes) {
            MultipartDemux.this.accumPos += bytes;
            MultipartDemux.this.accumSize -= bytes;
        }

        private int findBytes(int startPos, byte[] bytes, int bytesLen) {
            int scanPos = startPos;
            int pos = 0;
            for (int size = MultipartDemux.this.accumSize; size > bytesLen; --size) {
                if (MultipartDemux.this.accum[scanPos] == bytes[pos]) {
                    if (++pos == bytesLen) {
                        return startPos;
                    }
                } else {
                    size += pos;
                    startPos = (scanPos -= pos) + 1;
                    pos = 0;
                }
                ++scanPos;
            }
            return -1;
        }

        private boolean findBoundary() {
            int pos = this.findBytes(MultipartDemux.this.accumPos, MultipartDemux.this.boundary, MultipartDemux.this.boundaryLen);
            if (pos != -1) {
                this.flushBytes(pos - MultipartDemux.this.accumPos);
            }
            return pos != -1;
        }

        private boolean parseHeaders() {
            int headerStart = MultipartDemux.this.accumPos;
            while (true) {
                int prevHdr = headerStart;
                int pos = this.findBytes(headerStart, headerEnd, headerEndLen);
                if (pos == -1) {
                    return false;
                }
                if (pos == prevHdr) {
                    this.flushBytes(pos + 1 - MultipartDemux.this.accumPos);
                    return true;
                }
                String header = new String(MultipartDemux.this.accum, headerStart, pos - headerStart);
                if ((header = header.toLowerCase()).startsWith(MultipartDemux.contentType)) {
                    String mime = header.substring(contentTypeLen).trim();
                    MultipartDemux.this.currentStream = this.findStream(mime);
                    if (MultipartDemux.this.currentStream == null) {
                        MultipartDemux.this.currentStream = new MultipartStream(mime);
                        MultipartDemux.this.streams.addElement(MultipartDemux.this.currentStream);
                        MultipartDemux.this.addPad(MultipartDemux.this.currentStream);
                    }
                }
                headerStart = pos + 1;
            }
        }

        private boolean findDataEnd() {
            int pos = this.findBytes(MultipartDemux.this.accumPos, MultipartDemux.this.boundary, MultipartDemux.this.boundaryLen);
            if (pos != -1) {
                MultipartDemux.this.dataEnd = pos - 1;
            }
            return pos != -1;
        }

        protected int chainFunc(Buffer buf) {
            int flowRet = 0;
            this.accumulateBuffer(buf);
            buf.free();
            switch (MultipartDemux.this.state) {
                case 1: {
                    if (!this.findBoundary()) break;
                    this.flushBytes(MultipartDemux.this.boundary.length);
                    MultipartDemux.this.state = 2;
                }
                case 2: {
                    if (!this.parseHeaders()) break;
                    MultipartDemux.this.state = 3;
                }
                case 3: {
                    if (!this.findDataEnd()) break;
                    Buffer data = Buffer.create();
                    int dataSize = MultipartDemux.this.dataEnd - MultipartDemux.this.accumPos;
                    data.copyData(MultipartDemux.this.accum, MultipartDemux.this.accumPos, dataSize);
                    data.time_offset = -1L;
                    data.timestamp = -1L;
                    this.flushBytes(dataSize);
                    flowRet = MultipartDemux.this.currentStream.push(data);
                    MultipartDemux.this.state = 1;
                    break;
                }
                default: {
                    flowRet = -5;
                }
            }
            return flowRet;
        }
    };

    public String getFactoryName() {
        return "multipartdemux";
    }

    public String getMime() {
        return MIME;
    }

    public int typeFind(byte[] data, int offset, int length) {
        return -1;
    }

    public MultipartDemux() {
        this.accum = new byte[8192];
        this.streams = new Vector();
        this.addPad(this.sinkpad);
    }

    static /* synthetic */ byte[] access$202(MultipartDemux x0, byte[] x1) {
        x0.boundary = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$802(MultipartDemux x0, byte[] x1) {
        x0.accum = x1;
        return x1;
    }

    class MultipartStream
    extends Pad {
        private String mimeType;

        public MultipartStream(String mime) {
            super(1, "src_" + mime);
            this.mimeType = mime;
            this.caps = new Caps(mime);
        }

        protected boolean eventFunc(Event event) {
            return MultipartDemux.this.sinkpad.pushEvent(event);
        }
    }
}

