/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.utils.Debug;
import java.util.Enumeration;
import java.util.Vector;

public class Queue
extends Element {
    public static final int NO_LEAK = 0;
    public static final int LEAK_UPSTREAM = 1;
    public static final int LEAK_DOWNSTREAM = 2;
    private static final int DEFAULT_MAX_BUFFERS = 100;
    private static final int DEFAULT_MAX_SIZE = -1;
    private static final boolean DEFAULT_IS_BUFFER = false;
    private static final int DEFAULT_LOW_PERCENT = 10;
    private static final int DEFAULT_HIGH_PERCENT = 70;
    private static final int DEFAULT_LEAKY = 0;
    private Vector queue = new Vector();
    private int srcResult = -2;
    private int size;
    private boolean isBuffering;
    private boolean isEOS;
    private boolean headNeedsDiscont = false;
    private boolean tailNeedsDiscont = false;
    private int maxBuffers = 100;
    private int maxSize = -1;
    private boolean isBuffer = false;
    private int lowPercent = 10;
    private int highPercent = 70;
    private int leaky = 0;
    private Pad srcpad = new Pad(1, "src"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void taskFunc() {
            int res;
            Object obj;
            Vector vector = Queue.this.queue;
            synchronized (vector) {
                if (Queue.this.srcResult != 0) {
                    return;
                }
                while (Queue.this.isEmpty()) {
                    try {
                        Queue.this.queue.wait();
                        if (Queue.this.srcResult == 0) continue;
                        return;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                obj = Queue.this.queue.elementAt(Queue.this.queue.size() - 1);
                Queue.this.queue.removeElement(obj);
                Queue.this.queue.notifyAll();
            }
            if (obj instanceof Event) {
                Event event = (Event)obj;
                this.pushEvent(event);
                res = 0;
                if (event.getType() == 3) {
                    Queue.this.postMessage(Message.newStreamStatus(this, false, 0, "flow stopped, EOS"));
                    this.pauseTask();
                }
            } else {
                Buffer buf = (Buffer)obj;
                if (Queue.this.headNeedsDiscont) {
                    buf.setFlag(1, true);
                    Queue.this.headNeedsDiscont = false;
                }
                Queue.this.size -= buf.length;
                Debug.log(4, this.parent.getName() + " >>> " + buf);
                res = this.push(buf);
                if (Queue.this.maxSize == -1) {
                    Debug.log(4, this.parent.getName() + " count = " + Queue.this.queue.size() + "/" + Queue.this.maxBuffers);
                } else {
                    Debug.log(4, this.parent.getName() + " size = " + Queue.this.size + "/" + Queue.this.maxSize);
                }
            }
            vector = Queue.this.queue;
            synchronized (vector) {
                if (res != 0) {
                    Queue.this.srcResult = res;
                    if (1.isFlowFatal(res)) {
                        this.pushEvent(Event.newEOS());
                    }
                    Queue.this.postMessage(Message.newStreamStatus(this, false, res, "flow stopped"));
                    this.pauseTask();
                }
                Queue.this.updateBuffering();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean activateFunc(int mode) {
            boolean res = true;
            switch (mode) {
                case 0: {
                    Vector vector = Queue.this.queue;
                    synchronized (vector) {
                        Queue.this.clearQueue();
                        Queue.this.srcResult = -2;
                        Queue.this.queue.notifyAll();
                    }
                    if (Queue.this.isBuffer && Queue.this.isBuffering) {
                        Queue.this.isBuffering = false;
                        Queue.this.postMessage(Message.newBuffering(this, false, 0));
                    }
                    Queue.this.postMessage(Message.newStreamStatus(this, false, -2, "stopping"));
                    res = this.stopTask();
                    break;
                }
                case 1: {
                    Queue.this.isEOS = false;
                    Vector vector = Queue.this.queue;
                    synchronized (vector) {
                        Queue.this.srcResult = 0;
                        if (!Queue.this.isBuffer) {
                            Queue.this.isBuffering = false;
                        } else {
                            Queue.this.isBuffering = true;
                            Queue.this.postMessage(Message.newBuffering(this, true, 0));
                        }
                        Queue.this.postMessage(Message.newStreamStatus(this, true, 0, "activating"));
                        res = this.startTask("cortado-Queue-Stream-" + Debug.genId());
                        break;
                    }
                }
                default: {
                    Vector vector = Queue.this.queue;
                    synchronized (vector) {
                        Queue.this.srcResult = -2;
                    }
                    res = false;
                }
            }
            return res;
        }
    };
    private Pad sinkpad = new Pad(2, "sink"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean eventFunc(Event event) {
            Object object;
            int type = event.getType();
            boolean doQueue = true;
            switch (type) {
                case 1: {
                    Queue.this.srcpad.pushEvent(event);
                    object = Queue.this.queue;
                    synchronized (object) {
                        Queue.this.srcResult = -2;
                        Queue.this.queue.notifyAll();
                    }
                    object = this.streamLock;
                    synchronized (object) {
                        Debug.log(4, this + " synced");
                    }
                    Queue.this.postMessage(Message.newStreamStatus(Queue.this.srcpad, false, -2, "flush start"));
                    Queue.this.srcpad.pauseTask();
                    doQueue = false;
                    break;
                }
                case 2: {
                    Queue.this.srcpad.pushEvent(event);
                    Queue.this.isEOS = false;
                    object = Queue.this.queue;
                    synchronized (object) {
                        Queue.this.clearQueue();
                        Queue.this.srcResult = 0;
                        Queue.this.queue.notifyAll();
                    }
                    if (Queue.this.isBuffer) {
                        Queue.this.isBuffering = true;
                        Queue.this.postMessage(Message.newBuffering(this, true, 0));
                    }
                    Queue.this.postMessage(Message.newStreamStatus(Queue.this.srcpad, true, 0, "restart after flush"));
                    Queue.this.srcpad.startTask("cortado-Queue-Stream-" + Debug.genId());
                    doQueue = false;
                    break;
                }
                case 3: {
                    Queue.this.isEOS = true;
                    Debug.log(3, "got EOS: " + this);
                    if (!Queue.this.isBuffer || !Queue.this.isBuffering) break;
                    Queue.this.isBuffering = false;
                    Queue.this.postMessage(Message.newBuffering(this, Queue.this.isBuffering, 100));
                    break;
                }
            }
            if (doQueue) {
                object = Queue.this.queue;
                synchronized (object) {
                    Queue.this.queue.insertElementAt(event, 0);
                    Queue.this.queue.notifyAll();
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int chainFunc(Buffer buf) {
            Vector vector = Queue.this.queue;
            synchronized (vector) {
                if (Queue.this.srcResult != 0) {
                    buf.free();
                    return Queue.this.srcResult;
                }
                block10: while (Queue.this.isFilled()) {
                    switch (Queue.this.leaky) {
                        case 1: {
                            Queue.this.tailNeedsDiscont = true;
                            Debug.debug(this.parent.getName() + "is full, leaking buffer on upstream end");
                            buf.free();
                            Queue.this.queue.notifyAll();
                            return 0;
                        }
                        case 2: {
                            Queue.this.leakDownstream();
                            continue block10;
                        }
                        default: {
                            Debug.warn("Unknown leaky type, using default");
                        }
                        case 0: 
                    }
                    try {
                        Debug.debug(this.parent.getName() + " full, waiting...");
                        Queue.this.queue.wait();
                        if (Queue.this.srcResult == 0) continue;
                        buf.free();
                        return Queue.this.srcResult;
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                        buf.free();
                        return -2;
                    }
                }
                if (Queue.this.tailNeedsDiscont) {
                    buf.setFlag(1, true);
                    Queue.this.tailNeedsDiscont = false;
                }
                Queue.this.size += buf.length;
                Queue.this.updateBuffering();
                Debug.log(4, this.parent.getName() + " <<< " + buf);
                Queue.this.queue.insertElementAt(buf, 0);
                if (Queue.this.maxSize == -1) {
                    Debug.log(4, this.parent.getName() + " count = " + Queue.this.queue.size() + "/" + Queue.this.maxBuffers);
                } else {
                    Debug.log(4, this.parent.getName() + " size = " + Queue.this.size + "/" + Queue.this.maxSize);
                }
                Queue.this.queue.notifyAll();
            }
            return 0;
        }
    };

    private boolean isFilled() {
        if (this.maxSize != -1) {
            return this.size >= this.maxSize;
        }
        return this.queue.size() >= this.maxBuffers;
    }

    private boolean isEmpty() {
        return this.queue.size() == 0;
    }

    private void clearQueue() {
        Enumeration e2 = this.queue.elements();
        while (e2.hasMoreElements()) {
            Object obj = e2.nextElement();
            if (!(obj instanceof Buffer)) continue;
            ((Buffer)obj).free();
        }
        this.queue.setSize(0);
        this.size = 0;
        this.isBuffering = true;
    }

    private void updateBuffering() {
        if (!this.isBuffer || this.srcResult != 0) {
            return;
        }
        if (this.isEOS) {
            if (this.isBuffering) {
                this.isBuffering = false;
                this.postMessage(Message.newBuffering(this, false, 0));
            }
            return;
        }
        int percent = this.size * 100 / this.maxSize;
        if (percent > 100) {
            percent = 100;
        }
        if (this.isBuffering) {
            if (percent >= this.highPercent) {
                this.isBuffering = false;
            }
            this.postMessage(Message.newBuffering(this, this.isBuffering, percent));
        } else if (percent < this.lowPercent) {
            this.isBuffering = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leakDownstream() {
        while (this.isFilled()) {
            Vector vector = this.queue;
            synchronized (vector) {
                Object leak = this.queue.lastElement();
                if (leak == null) {
                    Debug.error("There is nothing to dequeue and the queue is still filled. This should not happen.");
                }
                this.queue.removeElementAt(this.queue.size() - 1);
                if (leak instanceof Buffer) {
                    ((Buffer)leak).free();
                }
                this.headNeedsDiscont = true;
                this.queue.notifyAll();
            }
        }
    }

    public Queue() {
        this.addPad(this.srcpad);
        this.addPad(this.sinkpad);
    }

    public String getFactoryName() {
        return "queue";
    }

    public boolean setProperty(String name, Object value) {
        if (name.equals("maxBuffers")) {
            this.maxBuffers = Integer.valueOf(value.toString());
        } else if (name.equals("maxSize")) {
            this.maxSize = Integer.valueOf(value.toString());
        } else if (name.equals("isBuffer")) {
            this.isBuffer = String.valueOf(value).equalsIgnoreCase("true");
        } else if (name.equals("lowPercent")) {
            this.lowPercent = Integer.valueOf(value.toString());
        } else if (name.equals("highPercent")) {
            this.highPercent = Integer.valueOf(value.toString());
        } else if (name.equals("leaky")) {
            this.leaky = Integer.valueOf(value.toString());
        } else {
            return false;
        }
        return true;
    }

    public Object getProperty(String name) {
        if (name.equals("maxBuffers")) {
            return new Integer(this.maxBuffers);
        }
        if (name.equals("maxSize")) {
            return new Integer(this.maxSize);
        }
        if (name.equals("isBuffer")) {
            return this.isBuffer ? "true" : "false";
        }
        if (name.equals("lowPercent")) {
            return new Integer(this.lowPercent);
        }
        if (name.equals("highPercent")) {
            return new Integer(this.highPercent);
        }
        if (name.equals("leaky")) {
            return new Integer(this.leaky);
        }
        return null;
    }
}

