/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.codecs.SmokeCodec;
import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Pad;
import com.fluendo.utils.Debug;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;

public class SmokeDec
extends Element {
    private Component component;
    private MediaTracker mediaTracker;
    private SmokeCodec smoke;
    private int width;
    private int height;
    private Pad srcPad = new Pad(1, "src"){

        protected boolean eventFunc(Event event) {
            return SmokeDec.this.sinkPad.pushEvent(event);
        }
    };
    private Pad sinkPad = new Pad(2, "sink"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean eventFunc(Event event) {
            boolean result;
            switch (event.getType()) {
                case 1: {
                    result = SmokeDec.this.srcPad.pushEvent(event);
                    Object object = this.streamLock;
                    synchronized (object) {
                        Debug.log(3, "synced " + this);
                        break;
                    }
                }
                case 2: {
                    result = SmokeDec.this.srcPad.pushEvent(event);
                    break;
                }
                default: {
                    result = SmokeDec.this.srcPad.pushEvent(event);
                }
            }
            return result;
        }

        protected int chainFunc(Buffer buf) {
            int ret;
            Image img = null;
            img = SmokeDec.this.smoke.decode(buf.data, buf.offset, buf.length);
            if (img != null) {
                if (img.getWidth(null) != SmokeDec.this.width || img.getHeight(null) != SmokeDec.this.height) {
                    SmokeDec.this.width = img.getWidth(null);
                    SmokeDec.this.height = img.getHeight(null);
                    Debug.log(3, "smoke frame: " + SmokeDec.this.width + "," + SmokeDec.this.height);
                    this.caps = new Caps("video/raw");
                    this.caps.setFieldInt("width", SmokeDec.this.width);
                    this.caps.setFieldInt("height", SmokeDec.this.height);
                    this.caps.setFieldInt("aspect_x", 1);
                    this.caps.setFieldInt("aspect_y", 1);
                }
                buf.object = img;
                buf.caps = this.caps;
                ret = SmokeDec.this.srcPad.push(buf);
            } else {
                if ((((SmokeDec)SmokeDec.this).smoke.flags & 1) != 0) {
                    Debug.log(2, "could not decode jpeg image");
                }
                buf.free();
                ret = 0;
            }
            return ret;
        }
    };

    public SmokeDec() {
        this.addPad(this.srcPad);
        this.addPad(this.sinkPad);
    }

    public boolean setProperty(String name, Object value) {
        if (!name.equals("component")) {
            return false;
        }
        this.component = (Component)value;
        this.mediaTracker = new MediaTracker(this.component);
        this.smoke = new SmokeCodec(this.component, this.mediaTracker);
        return true;
    }

    public Object getProperty(String name) {
        if (name.equals("component")) {
            return this.component;
        }
        return null;
    }

    public String getFactoryName() {
        return "smokedec";
    }

    public String getMime() {
        return "video/x-smoke";
    }

    public int typeFind(byte[] data, int offset, int length) {
        if (data[offset + 1] == 115) {
            return 10;
        }
        return -1;
    }
}

