/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.plugin;

import com.fluendo.jst.Buffer;
import com.fluendo.plugin.Overlay;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageProducer;

public class TextOverlay
extends Overlay {
    private int font_size = -1;
    private Font font = null;
    private String text = null;

    protected void overlay(Buffer buf) {
        Image img;
        if (buf.object instanceof ImageProducer) {
            img = this.component.createImage((ImageProducer)buf.object);
        } else if (buf.object instanceof Image) {
            img = (Image)buf.object;
        } else {
            System.out.println(this + ": unknown buffer received " + buf);
            return;
        }
        Dimension d2 = this.component.getSize();
        int x2 = 0;
        int y2 = 0;
        int w2 = d2.width;
        int h2 = d2.height;
        int new_font_size = w2 / 32;
        if (new_font_size < 12) {
            new_font_size = 12;
        }
        if (this.font == null || new_font_size != this.font_size) {
            this.font_size = new_font_size;
            this.font = new Font("sans", 1, this.font_size);
        }
        Graphics g2 = img.getGraphics();
        g2.drawImage(img, x2, y2, w2, h2, null);
        if (this.text != null) {
            g2.setFont(this.font);
            g2.setColor(Color.white);
            FontMetrics fm = g2.getFontMetrics();
            double tw = fm.stringWidth(this.text);
            g2.drawString(this.text, x2 + (int)(((double)w2 - tw) / 2.0), y2 + (int)((double)h2 * 0.85));
        }
        g2.dispose();
    }

    public boolean setProperty(String name, Object value) {
        if (!name.equals("text")) {
            return super.setProperty(name, value);
        }
        this.text = value.toString();
        return true;
    }

    public Object getProperty(String name) {
        if (name.equals("text")) {
            return this.text;
        }
        return super.getProperty(name);
    }

    public String getFactoryName() {
        return "textoverlay";
    }
}

