/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.utils;

public class MemUtils {
    private static final char[] bytes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static final int cmp(byte[] mem1, byte[] mem2, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            if (mem1[i2] == mem2[i2]) continue;
            if (mem1[i2] < mem2[i2]) {
                return -i2;
            }
            return i2;
        }
        return 0;
    }

    public static final void set(byte[] mem, int offset, int val, int len) {
        len += offset;
        for (int i2 = offset; i2 < len; ++i2) {
            mem[i2] = (byte)val;
        }
    }

    public static final void set(short[] mem, int offset, int val, int len) {
        len += offset;
        for (int i2 = offset; i2 < len; ++i2) {
            mem[i2] = (short)val;
        }
    }

    public static final void set(int[] mem, int offset, int val, int len) {
        len += offset;
        for (int i2 = offset; i2 < len; ++i2) {
            mem[i2] = val;
        }
    }

    public static final void set(Object[] mem, int offset, Object val, int len) {
        len += offset;
        for (int i2 = offset; i2 < len; ++i2) {
            mem[i2] = val;
        }
    }

    public static final boolean startsWith(byte[] arr, int offset, int len, byte[] pattern) {
        int i2;
        int length = pattern.length;
        if (len < length) {
            return false;
        }
        for (i2 = 0; i2 < length && arr[offset + i2] == pattern[i2]; ++i2) {
        }
        return i2 == length;
    }

    public static final void dump(byte[] mem, int start, int len) {
        StringBuffer string = new StringBuffer(50);
        StringBuffer chars = new StringBuffer(18);
        String vis = new String(mem, start, len);
        int j2 = 0;
        int i2 = 0;
        while (i2 < len) {
            int b2 = mem[i2 + start];
            if (b2 < 0) {
                b2 += 256;
            }
            if (b2 > 32 && b2 < 127) {
                chars.append(vis.charAt(i2));
            } else {
                chars.append(".");
            }
            string.append(bytes[b2 / 16]);
            string.append(bytes[b2 % 16]);
            string.append(" ");
            if (++j2 != 16 && ++i2 != len) continue;
            System.out.println("" + (i2 - j2) + "  " + string.toString() + chars.toString());
            string.setLength(0);
            chars.setLength(0);
            j2 = 0;
        }
    }
}

