/*
 * Decompiled with CFR 0.152.
 */
package pymo.dataBases;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import pymo.dataBases.DataBase;
import pymo.records.RecordReader;
import pymo.security.Constants;
import pymo.security.FilePath;
import pymo.security.Settings;
import pyware.toolkit.Utils;

public class BackupWriter {
    private static int _$20476 = 4;
    private DataBase _$2484;
    private Settings _$2752;
    private Frame _$483;

    public BackupWriter(Frame frame, Settings settings) {
        this._$2752 = settings;
        this._$483 = frame;
    }

    private String _$20477(int index) {
        String aFileName = this._$2484.getFileName();
        String aFile = this._$2752.getLine("Backups", "Path", Constants.BACKUP_DIR) + File.separator + aFileName;
        return aFile.substring(0, aFile.length() - 4) + "." + Integer.toString(index) + Constants.DATA_FILE_SUFFIX;
    }

    public void compact(DataBase db) {
        try {
            if (!db.checkIntegrity(this._$483)) {
                return;
            }
            String path = db.getFullFileName();
            int emptySpace = new RecordReader(db.getRecordManager()).calculatePercentEmpty();
            db.saveAs(path);
        }
        catch (Exception e2) {
            Utils.showErrorMessage(this._$483, e2, "Compact File Error");
        }
    }

    public void backup(DataBase db) throws IOException {
        File file1;
        this._$2484 = db;
        String lastBackup = this._$20477(_$20476);
        if (FilePath.isValid(lastBackup)) {
            File file4 = new File(lastBackup);
            file4.delete();
        }
        String file1str = "";
        String file2str = "";
        for (int i2 = _$20476; i2 > 1; --i2) {
            file1str = this._$20477(i2 - 1);
            file2str = this._$20477(i2);
            if (!FilePath.isValid(file1str)) continue;
            file1 = new File(file1str);
            File file2 = new File(file2str);
            file1.renameTo(file2);
        }
        String checkDir = FilePath.extractPath(file1str);
        file1 = new File(checkDir);
        if (!file1.isDirectory()) {
            file1.mkdirs();
        }
        db.backup(file1str);
        this.compact(db);
    }

    public void backup(DataBase[] dataBases) throws IOException {
        for (int i2 = 0; i2 < dataBases.length; ++i2) {
            this.backup(dataBases[i2]);
        }
    }
}

