/*
 * Decompiled with CFR 0.152.
 */
package pymo.descriptors;

import java.io.IOException;
import pymo.dataBases.DataBase;
import pymo.descriptors.CheckBoxDescriptor;
import pymo.descriptors.ComboBoxDescriptor;
import pymo.descriptors.DateDescriptor;
import pymo.descriptors.DescriptorList;
import pymo.descriptors.EMailAddressDescriptor;
import pymo.descriptors.IPasDescriptor;
import pymo.descriptors.LabelDescriptor;
import pymo.descriptors.ListDescriptor;
import pymo.descriptors.ListReportDescriptor;
import pymo.descriptors.MoneyDescriptor;
import pymo.descriptors.NotesDescriptor;
import pymo.descriptors.RadioDescriptor;
import pymo.descriptors.RealNumberDescriptor;
import pymo.descriptors.Report1Descriptor;
import pymo.descriptors.SearchDescriptor;
import pymo.descriptors.SortDescriptor;
import pymo.descriptors.TextDescriptor;
import pymo.descriptors.WholeNumberDescriptor;
import pymo.io.MOFileReader;
import pymo.security.Constants;

public class DescriptorReader {
    MOFileReader reader = null;
    DataBase dataBase;

    public DescriptorReader(MOFileReader reader, DataBase db) throws IOException {
        this.reader = reader;
        this.dataBase = db;
    }

    public DescriptorList readList() throws IOException {
        DescriptorList descriptors = new DescriptorList(this.dataBase);
        descriptors.removeAllElements();
        this.reader.readFirstClusterHeader();
        while (this.reader.readNextClusterHeader().compareTo(Constants.LAST_CLUSTER_MARKER) != 0) {
            if (this.reader.isClusterSignature(TextDescriptor.TEXT_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new TextDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(CheckBoxDescriptor.CHECKBOX_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new CheckBoxDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(ComboBoxDescriptor.COMBOBOX_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new ComboBoxDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(DateDescriptor.DATE_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new DateDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(MoneyDescriptor.MONEY_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new MoneyDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(NotesDescriptor.NOTES_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new NotesDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(RadioDescriptor.RADIO_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new RadioDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(RealNumberDescriptor.REAL_NUMBER_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new RealNumberDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(WholeNumberDescriptor.WHOLE_NUMBER_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new WholeNumberDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(EMailAddressDescriptor.EMAIL_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new EMailAddressDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(LabelDescriptor.LABEL_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new LabelDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(SearchDescriptor.SEARCH_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new SearchDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(SortDescriptor.SORT_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new SortDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(ListDescriptor.LIST_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new ListDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(ListReportDescriptor.LIST_REPORT_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new ListReportDescriptor(this.reader));
            }
            if (this.reader.isClusterSignature(IPasDescriptor.IPAS_DESCRIPTOR_SIGNATURE)) {
                descriptors.addDescriptor(new IPasDescriptor(this.reader));
            }
            if (!this.reader.isClusterSignature(Report1Descriptor.REPORT1_DESCRIPTOR_SIGNATURE)) continue;
            descriptors.addDescriptor(new Report1Descriptor(this.reader));
        }
        return descriptors;
    }
}

