/*
 * Decompiled with CFR 0.152.
 */
package pymo.descriptors;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jbc.grid.JbcGridTable;
import pymo.components.IPasTableComponent;
import pymo.components.MOComponent;
import pymo.dataBases.DataBase;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.descriptors.DescriptorList;
import pymo.fields.Field;
import pymo.iPasDBTools.IPasLessonDetailViewer;
import pymo.iPasDBTools.IPasMOAssignmentItem;
import pymo.iPasDBTools.IPasMOStudentTable;
import pymo.iPasDBTools.IPasMainTableCellRenderer;
import pymo.iPasDBTools.IPasPasswordPool;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;
import pymo.records.RecordList;
import pymo.security.FilePath;
import pymo.tableCellEditors.IPasMainTableCellEditor;
import pyware.iPasToolkit.interactive.AssignmentFile;
import pyware.iPasToolkit.interactive.AssignmentItem;
import pyware.iPasToolkit.interactive.AssignmentList;
import pyware.iPasToolkit.interactive.GradingScheme;
import pyware.iPasToolkit.interactive.IPasLibrarian;
import pyware.iPasToolkit.interactive.IPasStudentTable;
import pyware.iPasToolkit.interactive.IPasStudentTableRow;
import pyware.iPasToolkit.interactive.LessonList;

public class IPasDescriptor
extends AbstractFieldDescriptor {
    public static String IPAS_DESCRIPTOR_SIGNATURE = "dIPS";
    private static int _$12798 = 2;
    private static int _$12799 = 16;
    private AssignmentList _$12800 = new AssignmentList();
    private int _$12801 = 0;
    private IPasPasswordPool _$12802 = new IPasPasswordPool(FilePath.toSettings("password.pool.txt"));
    private String _$12803 = "";
    private GradingScheme _$12804 = new GradingScheme();
    private int _$12805 = 0;

    public IPasDescriptor() {
        this.setPanelID((short)2);
        this.setName("iPAS");
    }

    public IPasDescriptor(MOFileReader reader) throws IOException {
        this.read(reader);
    }

    public IPasDescriptor(MOFileReader reader, long dID) throws IOException {
        this.setID(dID);
        this.read(reader);
    }

    public void readUniqueData(MOFileReader reader) throws IOException {
        super.readUniqueData(reader);
        if (this.getReadVersion() > 1) {
            this._$12804.canTurnInPastDue = reader.readByte() == 1;
            this._$12804.gradeStyle = reader.readByte();
            this._$12804.deductPerDayPastDue = reader.readByte();
            this._$12804.meritPassScore = reader.readByte();
            this._$12804.meritPassPoints = reader.readByte();
            this._$12804.demeritPerDayPastDue = reader.readByte();
            this._$12804.useCustomTolerances = reader.readByte() == 1;
            this._$12804.toleranceType = reader.readByte();
            this._$12804.relPitch = reader.readShort();
            this._$12804.relAttack = reader.readShort();
            this._$12804.relRelease = reader.readShort();
            this._$12804.absPitch = reader.readShort();
            this._$12804.absAttack = reader.readShort();
            this._$12804.absRelease = reader.readShort();
            this._$12805 = reader.readInt();
        }
        int totItems = reader.readShort();
        for (int i2 = 0; i2 < totItems; ++i2) {
            this.addItem(new IPasMOAssignmentItem(reader));
        }
        short len = reader.readShort();
        this._$12803 = reader.readFixedString(len);
    }

    public void writeUniqueData(MOFileWriter writer) throws IOException {
        super.writeUniqueData(writer);
        if (this._$12804.canTurnInPastDue) {
            writer.writeByte(1);
        } else {
            writer.writeByte(0);
        }
        writer.writeByte(this._$12804.gradeStyle);
        writer.writeByte(this._$12804.deductPerDayPastDue);
        writer.writeByte(this._$12804.meritPassScore);
        writer.writeByte(this._$12804.meritPassPoints);
        writer.writeByte(this._$12804.demeritPerDayPastDue);
        if (this._$12804.useCustomTolerances) {
            writer.writeByte(1);
        } else {
            writer.writeByte(0);
        }
        writer.writeByte(this._$12804.toleranceType);
        writer.writeShort(new Integer(this._$12804.relPitch).shortValue());
        writer.writeShort(new Integer(this._$12804.relAttack).shortValue());
        writer.writeShort(new Integer(this._$12804.relRelease).shortValue());
        writer.writeShort(new Integer(this._$12804.absPitch).shortValue());
        writer.writeShort(new Integer(this._$12804.absAttack).shortValue());
        writer.writeShort(new Integer(this._$12804.absRelease).shortValue());
        writer.writeInt(this._$12805);
        int len = this._$12800.assignmentCount();
        writer.writeShort(new Integer(len).shortValue());
        for (int i2 = 0; i2 < len; ++i2) {
            ((IPasMOAssignmentItem)this.descriptorItemAt(i2)).write(writer);
        }
        writer.writeShort(new Integer(this._$12803.length()).shortValue());
        writer.writeFixedString(this._$12803, this._$12803.length());
    }

    public AssignmentItem descriptorItemAt(int index) {
        return this._$12800.assignmentAt(index);
    }

    public AssignmentItem findAssignment(long lessonID) {
        return this._$12800.findAssignment(lessonID);
    }

    public AssignmentList getAssignmentList() {
        return this._$12800;
    }

    public int getSize() {
        return super.getSize() + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 1 + 2 + 2 + 2 + 2 + 2 + 2 + 4 + 2 + this.getItemCount() * AssignmentItem.getSize() + 2 + this._$12803.length();
    }

    public int getItemCount() {
        return this._$12800.assignmentCount();
    }

    public void removeItems() {
        this._$12800.removeAll();
        this.setChanged();
    }

    public void addItem(IPasMOAssignmentItem item) {
        this._$12800.addAssignment(item);
        this.setChanged();
    }

    public String getSignature() {
        return IPAS_DESCRIPTOR_SIGNATURE;
    }

    public int getVersion() {
        return _$12798;
    }

    public String getName() {
        return "iPAS Lessons (Page #" + (this._$12801 + 1) + ")";
    }

    public int getDefaultColumnWidth() {
        return 350;
    }

    private int _$12828(MouseEvent e2, Rectangle cell) {
        int xPos = e2.getPoint().x - cell.x - _$12799;
        if (xPos <= 0) {
            return -2;
        }
        int index = (xPos - 4) / _$12799;
        int iconsPerPage = cell.width / 16 - 1;
        if ((index += this._$12801 * iconsPerPage) < 0 | index >= this.getItemCount() | index >= (this._$12801 + 1) * iconsPerPage) {
            return -1;
        }
        return index;
    }

    public void doCellMouseOverAt(MouseEvent e2, Rectangle cell, DataBase db) {
        AssignmentItem assignment;
        int index = this._$12828(e2, cell);
        String hint = null;
        if (index == -2) {
            hint = "Student's Overall Grade";
        } else if (index != -1 && (assignment = this._$12800.assignmentAt(index)) != null) {
            long lessonID = assignment.lessonID;
            LessonList lessonList = this.getDataBase().getDataBaseManager().getIPasLibrarian().getLessonList();
            hint = lessonList.findFullDescription(lessonID);
            if (hint.length() == 0) {
                hint = "This assigned lesson is not installed on your copy of iPAS.";
            }
        }
        db.getDataBaseManager().dispatchDataBaseStatusInfoChanged(db, hint);
    }

    public void doCellClickAt(MouseEvent e2, JbcGridTable table, DataBase db) {
        int columnIndex = table.getSelectedColumn();
        int rowIndex = table.getSelectedRow();
        Rectangle r2 = table.getCellRect(rowIndex, columnIndex, false);
        RecordList studentRecords = db.getSelectedRecords();
        Field iPASField = null;
        try {
            iPASField = studentRecords.getField(rowIndex, this.getFieldIndex());
            IPasMOStudentTable data = (IPasMOStudentTable)this.toWrapper(iPASField);
            int gradeBoxIndex = this._$12828(e2, r2);
            if (gradeBoxIndex >= 0) {
                long lessonID = this._$12800.assignmentAt((int)gradeBoxIndex).lessonID;
                String studentName = this.getFullName(studentRecords, rowIndex) + "   (ID#" + data.getIPasID() + ')';
                new IPasLessonDetailViewer(data, this.getIPasFileLibrarian(), lessonID, studentName).show();
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    public void doHeaderClickAt(MouseEvent e2, TableColumn column, DataBase db) {
        ++this._$12801;
        int iconsPerPage = column.getWidth() / 16 - 1;
        if (this._$12801 * iconsPerPage > this.getItemCount()) {
            this._$12801 = 0;
        }
    }

    public String toString(Field field) {
        byte[] data = field.getData();
        if (data.length == 0) {
            return "";
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        byte[] strArray = new byte[16];
        byteBuffer.get(strArray);
        return new String(strArray).trim();
    }

    public String extractPassword(Field field) {
        byte[] data = field.getData();
        if (data.length == 0) {
            return "";
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        byte[] strArray = new byte[16];
        byteBuffer.get(strArray);
        byteBuffer.get(strArray);
        return new String(strArray).trim();
    }

    public Object toWrapper(Field field) {
        byte[] data = field.getData();
        if (data.length == 0) {
            return new IPasMOStudentTable();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        byte[] strArray = new byte[16];
        byteBuffer.get(strArray);
        String iPasStudentID = new String(strArray).trim();
        byteBuffer.get(strArray);
        String password = new String(strArray).trim();
        IPasMOStudentTable wrapper = new IPasMOStudentTable(iPasStudentID, password);
        wrapper.mergeAssignmentList(this._$12800);
        IPasMOStudentTable studentData = new IPasMOStudentTable();
        int totalRows = byteBuffer.getShort();
        int offset = 34;
        for (int i2 = 0; i2 < totalRows; ++i2) {
            studentData.addRow(new IPasStudentTableRow(data, offset));
            offset += IPasStudentTableRow.rowByteSize();
        }
        wrapper.updateStudentInfo(studentData);
        wrapper.mergeLessonDescriptions(this.getIPasFileLibrarian().getLessonList());
        wrapper.setGradingScheme(this.getGradingScheme());
        return wrapper;
    }

    public Field toField(Object object) {
        int i2;
        IPasMOStudentTable data = (IPasMOStudentTable)object;
        int len = data.getRowCount();
        int fieldDataSize = 34 + len * IPasStudentTableRow.rowByteSize();
        ByteBuffer fieldData = ByteBuffer.allocate(fieldDataSize);
        String id = data.getIPasID();
        for (int i3 = 0; i3 < 16; ++i3) {
            if (i3 < id.length()) {
                fieldData.put((byte)id.charAt(i3));
                continue;
            }
            fieldData.put((byte)32);
        }
        String password = data.getPassword();
        for (i2 = 0; i2 < 16; ++i2) {
            if (i2 < password.length()) {
                fieldData.put((byte)password.charAt(i2));
                continue;
            }
            fieldData.put((byte)32);
        }
        fieldData.putShort((short)len);
        for (i2 = 0; i2 < len; ++i2) {
            fieldData.put(data.getRowAt(i2).toByteArray());
        }
        return new Field(fieldData.array());
    }

    public boolean isSearchable() {
        return false;
    }

    public int compare(Field field1, Field field2) {
        return this.compare(0, field1, field2);
    }

    public int compare(int modifier, Field field1, Field field2) {
        int g2;
        IPasStudentTable f1 = (IPasStudentTable)this.toWrapper(field1);
        IPasStudentTable f2 = (IPasStudentTable)this.toWrapper(field2);
        if (modifier == 1) {
            return f1.getIPasID().compareToIgnoreCase(f2.getIPasID());
        }
        int g1 = f1.recalculateOverallGrade();
        if (g1 == (g2 = f2.recalculateOverallGrade())) {
            return 0;
        }
        if (g1 < g2) {
            return -1;
        }
        return 1;
    }

    public void setInitialValue(Object initialValue) {
    }

    public Object getInitialValue() {
        return new IPasMOStudentTable();
    }

    public MOComponent makePanelComponent() {
        return new IPasTableComponent(this);
    }

    public MOComponent makeExpansionViewComponent(int ownerRecordIndex) {
        IPasTableComponent component = new IPasTableComponent(this, ownerRecordIndex);
        component.setPreferredSize(new Dimension(10, 200));
        return component;
    }

    public boolean hasExpansionView() {
        return true;
    }

    public TableCellEditor makeCellEditor() {
        return new IPasMainTableCellEditor(new JTextField());
    }

    public TableCellRenderer makeCellRenderer() {
        return new IPasMainTableCellRenderer(this);
    }

    public static IPasDescriptor aquire(DescriptorList descriptors) {
        IPasDescriptor descriptor = (IPasDescriptor)descriptors.getDescriptor(IPAS_DESCRIPTOR_SIGNATURE);
        if (descriptor == null) {
            descriptor = new IPasDescriptor();
            descriptor.setFieldIndex(descriptors.getLastFieldIndex() + 1);
            descriptors.addDescriptor(descriptor);
        }
        return descriptor;
    }

    private void _$12864(String str, DataOutputStream os) throws IOException {
        os.write((byte)str.length());
        os.write(str.getBytes());
    }

    private void _$12865(DataOutputStream os) throws IOException {
        DataBase db = this.getDataBase();
        RecordList records = db.getRecords();
        int totalStudents = records.getRecordCount();
        os.writeShort(totalStudents);
        for (int recordIndex = 0; recordIndex < totalStudents; ++recordIndex) {
            Field field = records.getField(recordIndex, this.getFieldIndex());
            IPasMOStudentTable studentData = (IPasMOStudentTable)this.toWrapper(field);
            this._$12864(studentData.getIPasID(), os);
            for (int lessonIndex = 0; lessonIndex < studentData.getRowCount(); ++lessonIndex) {
                IPasStudentTableRow item = studentData.getRowAt(lessonIndex);
                if (item.isEmpty()) continue;
                item.writeToAsnFile(os);
            }
            os.writeLong(0L);
        }
    }

    public void createAsnFile(String fullFileName, boolean useTop10) throws IOException {
        DataOutputStream os = new DataOutputStream(new FileOutputStream(fullFileName));
        AssignmentFile.writeToAsnFile(os, useTop10, this._$12804, this._$12800);
        this._$12865(os);
        os.close();
    }

    public String getNextUniqueID(String firstName, String lastName) throws Exception {
        long value = 0L;
        try {
            DataInputStream is = new DataInputStream(new FileInputStream(FilePath.toSettings("iPAS.NextID.dat")));
            value = is.readLong();
            is.close();
        }
        catch (FileNotFoundException ex2) {
            value = 0L;
        }
        catch (IOException ex3) {
            throw ex3;
        }
        DataOutputStream os = new DataOutputStream(new FileOutputStream(FilePath.toSettings("iPAS.NextID.dat")));
        os.writeLong(value + 1L);
        os.close();
        StringBuffer id = new StringBuffer();
        if (firstName.length() > 0) {
            id.append(firstName.charAt(0));
        }
        if (lastName.length() > 0) {
            id.append(lastName.charAt(0));
        }
        id.append(Long.toString(value));
        return id.toString().toUpperCase();
    }

    public String getNextPassword() {
        return this._$12802.getNext();
    }

    private String _$12872(RecordList records, int recordIndex) throws Exception {
        DataBase db = records.getDataBase();
        AbstractFieldDescriptor dFirstName = db.getDescriptors().getFieldDescriptor("~Name (First)");
        return dFirstName.toString(records.getField(recordIndex, dFirstName.getFieldIndex()));
    }

    private String _$12873(RecordList records, int recordIndex) throws Exception {
        DataBase db = records.getDataBase();
        AbstractFieldDescriptor dLastName = db.getDescriptors().getFieldDescriptor("~Name (Last)");
        return dLastName.toString(records.getField(recordIndex, dLastName.getFieldIndex()));
    }

    public String getFullName(RecordList records, int recordIndex) throws Exception {
        return this._$12872(records, recordIndex) + " " + this._$12873(records, recordIndex);
    }

    public void buildStudentIDs(DataBase db) throws Exception {
        RecordList records = db.getRecords();
        int totalStudents = records.getRecordCount();
        for (int recordIndex = 0; recordIndex < totalStudents; ++recordIndex) {
            String firstName = this._$12872(records, recordIndex);
            String lastName = this._$12873(records, recordIndex);
            Field field = records.getField(recordIndex, this.getFieldIndex());
            IPasStudentTable iPasData = (IPasStudentTable)this.toWrapper(field);
            String studentID = iPasData.getIPasID();
            if (studentID.length() != 0) continue;
            iPasData.setIPasID(this.getNextUniqueID(firstName, lastName));
            iPasData.setPassword(this._$12802.getNext());
            field = this.toField(iPasData);
            records.putField(recordIndex, this.getFieldIndex(), field);
        }
        db.save();
    }

    public IPasLibrarian getIPasFileLibrarian() {
        return this.getDataBase().getDataBaseManager().getIPasLibrarian();
    }

    public int getIconViewPage() {
        return this._$12801;
    }

    public String getAnnouncement() {
        return this._$12803;
    }

    public void setAnnouncement(String announcement) {
        this._$12803 = announcement;
        this.setChanged();
    }

    public GradingScheme getGradingScheme() {
        return this._$12804;
    }
}

