/*
 * Decompiled with CFR 0.152.
 */
package pymo.descriptors;

import java.awt.Font;
import java.io.IOException;
import java.util.Vector;
import pymo.descriptors.AbstractDescriptor;
import pymo.descriptors.DescriptorList;
import pymo.descriptors.ListDescriptorItem;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;
import pymo.security.Constants;

public class ListDescriptor
extends AbstractDescriptor {
    public static String LIST_DESCRIPTOR_SIGNATURE = "dLST";
    private static int _$15363 = 2;
    private Vector _$15364 = new Vector();
    private Font _$15365 = Constants.DEFAULT_FONT;

    public ListDescriptor() {
        this.setName("ListDescriptor");
    }

    public ListDescriptor(MOFileReader reader) throws IOException {
        this.read(reader);
    }

    public ListDescriptor(MOFileReader reader, long dID) throws IOException {
        this.setID(dID);
        this.read(reader);
    }

    public void readVersion1ExtraData(MOFileReader reader, int xtraDataSize) throws IOException {
        reader.skipBytes(3);
        int totItems = reader.readShort();
        for (int i2 = 0; i2 < totItems; ++i2) {
            long id = reader.readLong();
            short modifier = reader.readShort();
            short width = reader.readShort();
            this._$15364.add(new ListDescriptorItem(id, modifier, width));
        }
        reader.skipBytes(8);
    }

    public void readUniqueData(MOFileReader reader) throws IOException {
        if (this.getReadVersion() != 1) {
            String fontName = reader.readSmallString();
            int style = reader.readByte();
            int size = reader.readByte();
            this._$15365 = new Font(fontName, style, size);
        }
        int totItems = reader.readByte();
        for (int i2 = 0; i2 < totItems; ++i2) {
            long id = reader.readLong();
            short modifier = reader.readShort();
            short width = reader.readShort();
            this._$15364.addElement(new ListDescriptorItem(id, modifier, width));
        }
    }

    public void writeUniqueData(MOFileWriter writer) throws IOException {
        writer.writeSmallString(this._$15365.getName());
        writer.writeByte(this._$15365.getStyle());
        writer.writeByte(this._$15365.getSize());
        writer.writeByte(this._$15364.size());
        for (int i2 = 0; i2 < this._$15364.size(); ++i2) {
            ListDescriptorItem listItem = this.listItemAt(i2);
            writer.writeLong(listItem.id);
            writer.writeShort(listItem.modifier);
            writer.writeShort(listItem.width);
        }
    }

    public ListDescriptorItem listItemAt(int index) {
        return (ListDescriptorItem)this._$15364.elementAt(index);
    }

    private int _$15369() {
        return 12;
    }

    public int getVersion() {
        return _$15363;
    }

    public String getSignature() {
        return LIST_DESCRIPTOR_SIGNATURE;
    }

    public int getSize() {
        return super.getSize() + 1 + this._$15364.size() * this._$15369() + this._$15365.getName().length() + 1 + 2;
    }

    public boolean addField(long id) {
        for (int i2 = 0; i2 < this.getNumFields(); ++i2) {
            if (this.listItemAt(i2).getID() != id) continue;
            return false;
        }
        this._$15364.add(new ListDescriptorItem(id));
        this.setChanged();
        return true;
    }

    public boolean addField(long id, int width) {
        for (int i2 = 0; i2 < this.getNumFields(); ++i2) {
            if (this.listItemAt(i2).getID() != id) continue;
            return false;
        }
        ListDescriptorItem item = new ListDescriptorItem(id);
        item.width = (short)width;
        this._$15364.add(item);
        this.setChanged();
        return true;
    }

    public long getFieldID(int columnIndex) {
        return this.listItemAt((int)columnIndex).id;
    }

    public int getFieldWidth(int columnIndex) {
        return this.listItemAt((int)columnIndex).width;
    }

    public int getNumFields() {
        return this._$15364.size();
    }

    public void validateList(DescriptorList descriptors) {
        int numColumns = this.getNumFields();
        for (int i2 = numColumns - 1; i2 >= 0; --i2) {
            long id = this.getFieldID(i2);
            if (descriptors.getDescriptor(id) != null) continue;
            this._$15364.removeElementAt(i2);
            this.setChanged();
        }
    }

    public static ListDescriptor aquire(DescriptorList descriptors) {
        ListDescriptor descriptor = (ListDescriptor)descriptors.getDescriptor(LIST_DESCRIPTOR_SIGNATURE);
        if (descriptor == null) {
            descriptor = new ListDescriptor();
            descriptors.addDescriptor(descriptor);
        }
        descriptor.validateList(descriptors);
        return descriptor;
    }

    public ListDescriptorItem[] getColumnList() {
        ListDescriptorItem[] list = new ListDescriptorItem[this._$15364.size()];
        for (int i2 = 0; i2 < list.length; ++i2) {
            list[i2] = this.listItemAt(i2);
        }
        return list;
    }

    public void setColumnList(Vector list) {
        this._$15364 = list;
        this.setChanged();
    }

    public void swapColumns(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        ListDescriptorItem fromItem = this.listItemAt(fromIndex);
        ListDescriptorItem toItem = this.listItemAt(toIndex);
        this._$15364.setElementAt(fromItem, toIndex);
        this._$15364.setElementAt(toItem, fromIndex);
        this.setChanged();
    }

    public void setColumnWidth(int columnIndex, int width) {
        this.listItemAt((int)columnIndex).width = new Integer(width).shortValue();
        this.setChanged();
    }

    public Font getFont() {
        return this._$15365;
    }

    public void setFont(Font font) {
        this._$15365 = font;
        this.setChanged();
    }
}

