/*
 * Decompiled with CFR 0.152.
 */
package pymo.descriptors;

import java.io.IOException;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jbc.grid.JbcCellEditorDecimalFormat;
import jbc.grid.JbcCellRendererDecimalFormat;
import pymo.components.MOComponent;
import pymo.components.MORealNumberBox;
import pymo.descriptors.AbstractFieldDescriptor;
import pymo.fields.Field;
import pymo.io.MOFileReader;
import pymo.io.MOFileWriter;
import pymo.security.Constants;
import pyware.toolkit.Utils;

public class RealNumberDescriptor
extends AbstractFieldDescriptor {
    public static String REAL_NUMBER_DESCRIPTOR_SIGNATURE = "dREL";
    private static int _$20267 = 1;
    private double _$10383 = 0.0;
    private short _$20268 = (short)2;

    public RealNumberDescriptor() {
    }

    public RealNumberDescriptor(MOFileReader reader) throws IOException {
        this.read(reader);
    }

    public RealNumberDescriptor(MOFileReader reader, long dID) throws IOException {
        this.setID(dID);
        this.read(reader);
    }

    public void readUniqueData(MOFileReader reader) throws IOException {
        super.readUniqueData(reader);
        this._$10383 = reader.readDouble();
        this._$20268 = reader.readShort();
    }

    public void writeUniqueData(MOFileWriter writer) throws IOException {
        super.writeUniqueData(writer);
        writer.writeDouble(this._$10383);
        writer.writeShort(this._$20268);
    }

    public int getVersion() {
        return _$20267;
    }

    public String getSignature() {
        return REAL_NUMBER_DESCRIPTOR_SIGNATURE;
    }

    public int getSize() {
        return 10 + super.getSize();
    }

    public MOComponent makePanelComponent() {
        MORealNumberBox moRealNumberBox = new MORealNumberBox(this);
        moRealNumberBox.setBounds(this.getBounds());
        return moRealNumberBox;
    }

    public TableCellEditor makeCellEditor() {
        return new JbcCellEditorDecimalFormat(this.getFractionDigits());
    }

    public TableCellRenderer makeCellRenderer() {
        String pattern = "#,##0.";
        for (int i2 = 0; i2 < this.getFractionDigits(); ++i2) {
            pattern = pattern + "0";
        }
        return new JbcCellRendererDecimalFormat(pattern);
    }

    public String toString(Field field) {
        return this.toWrapper(field).toString();
    }

    private double _$20271(Field field) {
        long longBits = Utils.byteArrayToLongValue(field.getData());
        return Double.longBitsToDouble(longBits);
    }

    public Object toWrapper(Field field) {
        return new Double(this._$20271(field));
    }

    public Field toField(Object object) {
        if (String.class.isInstance(object)) {
            object = new Double((String)object);
        }
        double value = (Double)object;
        long longBits = Double.doubleToLongBits(value);
        return new Field(Utils.longValueToByteArray(longBits));
    }

    public int getSearchType() {
        return Constants.NUMERIC_SEARCH;
    }

    public int compare(Field field1, Field field2) {
        double value2;
        double value1 = this._$20271(field1);
        if (value1 == (value2 = this._$20271(field2))) {
            return 0;
        }
        if (value1 < value2) {
            return -1;
        }
        return 1;
    }

    public void setInitialValue(Object doubleWrapper) {
        this._$10383 = (Double)doubleWrapper;
        this.setChanged();
    }

    public Object getInitialValue() {
        return new Double(this._$10383);
    }

    public short getFractionDigits() {
        return this._$20268;
    }

    public void setFractionDigits(short fractionDigits) {
        this._$20268 = fractionDigits;
        this.setChanged();
    }
}

